/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.saving;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.workspace.saving.ModelSaveManager;
import org.eclipse.ui.Saveable;

public class BasicModelSaveable
extends Saveable {
    protected static final String SAVEABLE_LABEL_PREFIX = "saveableFor";
    private IModelDescriptor modelDescriptor;

    public BasicModelSaveable(IModelDescriptor modelDescriptor) {
        Assert.isNotNull((Object)modelDescriptor);
        this.modelDescriptor = modelDescriptor;
    }

    public final IModelDescriptor getModelDescriptor() {
        return this.modelDescriptor;
    }

    public boolean isDirty() {
        return ModelSaveManager.INSTANCE.isDirty(this.modelDescriptor);
    }

    public void doSave(IProgressMonitor monitor) throws CoreException {
        ModelSaveManager.INSTANCE.saveModel(this.modelDescriptor, false, monitor);
    }

    public String getName() {
        StringBuilder resourcesNames = new StringBuilder();
        resourcesNames.append(this.modelDescriptor.getRoot().getName());
        for (IResource resource : this.modelDescriptor.getReferencedRoots()) {
            resourcesNames.append(" + ");
            resourcesNames.append(resource.getName());
        }
        return resourcesNames.toString();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getToolTipText() {
        return this.modelDescriptor.getMetaModelDescriptor().getName();
    }

    public boolean equals(Object object) {
        if (object instanceof BasicModelSaveable) {
            return this.modelDescriptor.equals(((BasicModelSaveable)((Object)object)).modelDescriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.modelDescriptor.hashCode();
    }

    public String toString() {
        return "saveableFor_" + this.modelDescriptor.toString();
    }
}

