/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.navigator.Hummingbird20AbstractNavigatorItem;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.navigator.Hummingbird20NavigatorGroup;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.navigator.Hummingbird20NavigatorItem;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.part.Hummingbird20DiagramEditorPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class Hummingbird20NavigatorLinkHelper
implements ILinkHelper {
    private static IEditorInput getEditorInput(Diagram diagram) {
        Resource diagramResource = diagram.eResource();
        for (EObject nextEObject : diagramResource.getContents()) {
            if (nextEObject == diagram) {
                return new FileEditorInput(WorkspaceSynchronizer.getFile((Resource)diagramResource));
            }
            if (nextEObject instanceof Diagram) break;
        }
        URI uri = EcoreUtil.getURI((EObject)diagram);
        String editorName = String.valueOf(uri.lastSegment()) + '#' + diagram.eResource().getContents().indexOf((Object)diagram);
        URIEditorInput editorInput = new URIEditorInput(uri, editorName);
        return editorInput;
    }

    public IStructuredSelection findSelection(IEditorInput anInput) {
        IDiagramDocument document = Hummingbird20DiagramEditorPlugin.getInstance().getDocumentProvider().getDiagramDocument(anInput);
        if (document == null) {
            return StructuredSelection.EMPTY;
        }
        Diagram diagram = document.getDiagram();
        if (diagram == null || diagram.eResource() == null) {
            return StructuredSelection.EMPTY;
        }
        IFile file = WorkspaceSynchronizer.getFile((Resource)diagram.eResource());
        if (file != null) {
            Hummingbird20NavigatorItem item = new Hummingbird20NavigatorItem((View)diagram, file, false);
            return new StructuredSelection((Object)item);
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        Hummingbird20NavigatorGroup navigatorGroup;
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        if (!(aSelection.getFirstElement() instanceof Hummingbird20AbstractNavigatorItem)) {
            return;
        }
        Hummingbird20AbstractNavigatorItem abstractNavigatorItem = (Hummingbird20AbstractNavigatorItem)((Object)aSelection.getFirstElement());
        View navigatorView = null;
        if (abstractNavigatorItem instanceof Hummingbird20NavigatorItem) {
            navigatorView = ((Hummingbird20NavigatorItem)abstractNavigatorItem).getView();
        } else if (abstractNavigatorItem instanceof Hummingbird20NavigatorGroup && (navigatorGroup = (Hummingbird20NavigatorGroup)abstractNavigatorItem).getParent() instanceof Hummingbird20NavigatorItem) {
            navigatorView = ((Hummingbird20NavigatorItem)((Object)navigatorGroup.getParent())).getView();
        }
        if (navigatorView == null) {
            return;
        }
        IEditorInput editorInput = Hummingbird20NavigatorLinkHelper.getEditorInput(navigatorView.getDiagram());
        IEditorPart editor = aPage.findEditor(editorInput);
        if (editor == null) {
            return;
        }
        aPage.bringToTop((IWorkbenchPart)editor);
        if (editor instanceof DiagramEditor) {
            DiagramEditor diagramEditor = (DiagramEditor)editor;
            ResourceSet diagramEditorResourceSet = diagramEditor.getEditingDomain().getResourceSet();
            EObject selectedView = diagramEditorResourceSet.getEObject(EcoreUtil.getURI((EObject)navigatorView), true);
            if (selectedView == null) {
                return;
            }
            GraphicalViewer graphicalViewer = (GraphicalViewer)diagramEditor.getAdapter(GraphicalViewer.class);
            EditPart selectedEditPart = (EditPart)graphicalViewer.getEditPartRegistry().get(selectedView);
            if (selectedEditPart != null) {
                graphicalViewer.select(selectedEditPart);
            }
        }
    }
}

