/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.emf.serialization.generators.persistencemapping;

import com.google.common.base.Objects;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingExtendedMetaData;
import org.eclipse.sphinx.emf.serialization.generators.util.Ecore2XSDUtil;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class CreateDefaultXSDExtendedMetaData {
  protected EPackage rootModel;
  
  protected String globalEClassName;
  
  public CreateDefaultXSDExtendedMetaData(final EPackage rootModel, final String globalEClassName) {
    this.rootModel = rootModel;
    this.globalEClassName = globalEClassName;
  }
  
  public EPackage execute(final IProgressMonitor monitor) {
    monitor.subTask("Create Default XSD Extended MetaData");
    this.configure(this.rootModel);
    TreeIterator<EObject> _eAllContents = this.rootModel.eAllContents();
    final Function1<EObject, Boolean> _function = new Function1<EObject, Boolean>() {
      public Boolean apply(final EObject eObject) {
        boolean _and = false;
        if (!(eObject instanceof EStructuralFeature)) {
          _and = false;
        } else {
          int _featureKind = ExtendedMetaData.INSTANCE.getFeatureKind(((EStructuralFeature) eObject));
          boolean _equals = (ExtendedMetaData.ELEMENT_FEATURE == _featureKind);
          _and = _equals;
        }
        return Boolean.valueOf(_and);
      }
    };
    Iterator<EObject> _filter = IteratorExtensions.<EObject>filter(_eAllContents, _function);
    final Procedure1<EObject> _function_1 = new Procedure1<EObject>() {
      public void apply(final EObject feature) {
        CreateDefaultXSDExtendedMetaData.this.configureNamespace(((EStructuralFeature) feature));
      }
    };
    IteratorExtensions.<EObject>forEach(_filter, _function_1);
    return this.rootModel;
  }
  
  protected EObject doSwitch(final EObject object) {
    EObject _switchResult = null;
    boolean _matched = false;
    if (!_matched) {
      if ((object instanceof EPackage)) {
        _matched=true;
        _switchResult = this.configure(((EPackage) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EClass)) {
        _matched=true;
        _switchResult = this.configure(((EClass) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EAttribute)) {
        _matched=true;
        _switchResult = this.configure(((EAttribute) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EEnum)) {
        _matched=true;
        _switchResult = this.configure(((EEnum) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EEnumLiteral)) {
        _matched=true;
        _switchResult = this.configure(((EEnumLiteral) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EDataType)) {
        _matched=true;
        _switchResult = this.configure(((EDataType) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EReference)) {
        _matched=true;
        _switchResult = this.configure(((EReference) object));
      }
    }
    if (!_matched) {
      if ((object instanceof EStructuralFeature)) {
        _matched=true;
        _switchResult = this.configure(((EStructuralFeature) object));
      }
    }
    return _switchResult;
  }
  
  /**
   * Configures tagged values of a package.
   * 
   * @param ePackage
   * @return ePackage
   */
  protected EObject configure(final EPackage ePackage) {
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setQualified(ePackage, true);
    EList<EClassifier> _eClassifiers = ePackage.getEClassifiers();
    final Procedure1<EClassifier> _function = new Procedure1<EClassifier>() {
      public void apply(final EClassifier it) {
        CreateDefaultXSDExtendedMetaData.this.doSwitch(it);
      }
    };
    IterableExtensions.<EClassifier>forEach(_eClassifiers, _function);
    EList<EPackage> _eSubpackages = ePackage.getESubpackages();
    final Procedure1<EPackage> _function_1 = new Procedure1<EPackage>() {
      public void apply(final EPackage it) {
        CreateDefaultXSDExtendedMetaData.this.doSwitch(it);
      }
    };
    IterableExtensions.<EPackage>forEach(_eSubpackages, _function_1);
    return ePackage;
  }
  
  /**
   * Configures tagged values of a EClass
   * To be override
   * 
   * @param eClass
   * @return eClass
   */
  protected EObject configure(final EClass eClass) {
    this.configureClassifierNames(eClass);
    this.configureNamespace(eClass);
    String _name = eClass.getName();
    boolean _equals = _name.equals(this.globalEClassName);
    if (_equals) {
      XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLGlobalElement(eClass, true);
    }
    int _contentKind = XMLPersistenceMappingExtendedMetaData.INSTANCE.getContentKind(eClass);
    boolean _notEquals = (_contentKind != ExtendedMetaData.UNSPECIFIED_CONTENT);
    if (_notEquals) {
    } else {
      int kind = ExtendedMetaData.ELEMENT_ONLY_CONTENT;
      XMLPersistenceMappingExtendedMetaData.INSTANCE.setContentKind(eClass, kind);
    }
    EList<EStructuralFeature> _eStructuralFeatures = eClass.getEStructuralFeatures();
    final Procedure1<EStructuralFeature> _function = new Procedure1<EStructuralFeature>() {
      public void apply(final EStructuralFeature it) {
        CreateDefaultXSDExtendedMetaData.this.doSwitch(it);
      }
    };
    IterableExtensions.<EStructuralFeature>forEach(_eStructuralFeatures, _function);
    return eClass;
  }
  
  /**
   * Creates ExtendedMetaData for an EAttribute
   * 
   * @param eAttribute
   * @return eAttribute
   */
  protected EObject configure(final EAttribute eAttribute) {
    this.configure(((EStructuralFeature) eAttribute));
    String _xMLName = XMLPersistenceMappingExtendedMetaData.INSTANCE.getXMLName(eAttribute);
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLName(eAttribute, _xMLName);
    final boolean isAttribute = XMLPersistenceMappingExtendedMetaData.INSTANCE.isXMLAttribute(eAttribute);
    int kind = ExtendedMetaData.ELEMENT_FEATURE;
    if (isAttribute) {
      kind = ExtendedMetaData.ATTRIBUTE_FEATURE;
    }
    ExtendedMetaData.INSTANCE.setFeatureKind(eAttribute, kind);
    if ((!isAttribute)) {
    }
    return eAttribute;
  }
  
  /**
   * Configures tagged values of a EStructuralFeature
   * 
   * @param feature
   * @return feature
   */
  protected EObject configure(final EStructuralFeature feature) {
    this.configureFeatureNames(feature);
    this.configureNamespace(feature);
    this.configureXMLAttribute(feature);
    int xmlPersistenceStrategy = 0;
    boolean _or = false;
    if ((feature instanceof EAttribute)) {
      _or = true;
    } else {
      boolean _isContainment = ((EReference) feature).isContainment();
      _or = _isContainment;
    }
    final boolean isContainment = _or;
    if ((feature instanceof EAttribute)) {
      boolean _isMany = ((EAttribute)feature).isMany();
      if (_isMany) {
        boolean _and = false;
        if (!isContainment) {
          _and = false;
        } else {
          EClassifier _eType = ((EAttribute)feature).getEType();
          _and = (_eType instanceof EClass);
        }
        if (_and) {
          xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__1001__FEATURE_WRAPPER_ELEMENT__CLASSIFIER_ELEMENT;
        } else {
          xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__1000__FEATURE_WRAPPER_ELEMENT;
        }
      } else {
        boolean _and_1 = false;
        if (!isContainment) {
          _and_1 = false;
        } else {
          EClassifier _eType_1 = ((EAttribute)feature).getEType();
          _and_1 = (_eType_1 instanceof EClass);
        }
        if (_and_1) {
          EClassifier _eType_2 = ((EAttribute)feature).getEType();
          boolean _hasConcreteSubclasses = Ecore2XSDUtil.hasConcreteSubclasses(((EClass) _eType_2), this.rootModel);
          if (_hasConcreteSubclasses) {
            xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0101__FEATURE_ELEMENT__CLASSIFIER_ELEMENT;
          } else {
            xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0100__FEATURE_ELEMENT;
          }
        } else {
          xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0100__FEATURE_ELEMENT;
        }
      }
    } else {
      boolean _isContainment_1 = ((EReference) feature).isContainment();
      if (_isContainment_1) {
        boolean _isMany_1 = feature.isMany();
        if (_isMany_1) {
          xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__1000__FEATURE_WRAPPER_ELEMENT;
          EClassifier _eType_3 = feature.getEType();
          if ((_eType_3 instanceof EClass)) {
            xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__1001__FEATURE_WRAPPER_ELEMENT__CLASSIFIER_ELEMENT;
          }
        } else {
          EClassifier _eType_4 = feature.getEType();
          if ((_eType_4 instanceof EClass)) {
            EClassifier _eType_5 = feature.getEType();
            boolean _hasConcreteSubclasses_1 = Ecore2XSDUtil.hasConcreteSubclasses(((EClass) _eType_5), this.rootModel);
            if (_hasConcreteSubclasses_1) {
              xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0101__FEATURE_ELEMENT__CLASSIFIER_ELEMENT;
            } else {
              xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0100__FEATURE_ELEMENT;
            }
          } else {
            xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0100__FEATURE_ELEMENT;
          }
        }
      } else {
        boolean _isMany_2 = feature.isMany();
        if (_isMany_2) {
          xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__1100__FEATURE_WRAPPER_ELEMENT__FEATURE_ELEMENT;
        } else {
          xmlPersistenceStrategy = XMLPersistenceMappingExtendedMetaData.XML_PERSISTENCE_MAPPING_STRATEGY__0100__FEATURE_ELEMENT;
        }
      }
    }
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLPersistenceMappingStrategy(feature, xmlPersistenceStrategy);
    return feature;
  }
  
  /**
   * to be override
   */
  protected void configureFeatureNames(final EStructuralFeature feature) {
    String _singularName = Ecore2XSDUtil.getSingularName(feature);
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLName(feature, _singularName);
    String _pluralName = Ecore2XSDUtil.getPluralName(feature);
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLWrapperName(feature, _pluralName);
  }
  
  /**
   * to be override
   */
  protected void configureClassifierNames(final EClassifier classifier) {
    String _singularName = Ecore2XSDUtil.getSingularName(classifier);
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLName(classifier, _singularName);
    String _pluralName = Ecore2XSDUtil.getPluralName(classifier);
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLWrapperName(classifier, _pluralName);
  }
  
  /**
   * Configures tagged values of a primitive Datatype
   * To be override
   * 
   * @param dataType
   * @return
   */
  protected EObject configure(final EDataType dataType) {
    this.configureClassifierNames(dataType);
    return dataType;
  }
  
  /**
   * Configures tagged values of a EEnumLiteral
   * 
   * @param literal
   * @return literal
   */
  protected EObject configure(final EEnumLiteral literal) {
    return literal;
  }
  
  /**
   * Configures default tagged values of a EEnum
   * 
   * @param eEnum
   * @return eEnum
   */
  protected EObject configure(final EEnum eEnum) {
    this.configureClassifierNames(eEnum);
    EList<EEnumLiteral> _eLiterals = eEnum.getELiterals();
    final Procedure1<EEnumLiteral> _function = new Procedure1<EEnumLiteral>() {
      public void apply(final EEnumLiteral it) {
        CreateDefaultXSDExtendedMetaData.this.doSwitch(it);
      }
    };
    IterableExtensions.<EEnumLiteral>forEach(_eLiterals, _function);
    return eEnum;
  }
  
  /**
   * Creates ExtendedMetaData for an EReference
   * 
   * @param eReference
   * @return eReference
   */
  protected EObject configure(final EReference eReference) {
    this.configure(((EStructuralFeature) eReference));
    ExtendedMetaData.INSTANCE.setFeatureKind(eReference, ExtendedMetaData.ELEMENT_FEATURE);
    return eReference;
  }
  
  protected void configureNamespace(final EStructuralFeature feature) {
    final String namespace = XMLPersistenceMappingExtendedMetaData.INSTANCE.getNamespace(feature);
    boolean _equals = Objects.equal(null, namespace);
    if (_equals) {
      EClass _eContainingClass = feature.getEContainingClass();
      EPackage _ePackage = _eContainingClass.getEPackage();
      String _nsURI = _ePackage.getNsURI();
      EcoreUtil.setAnnotation(feature, ExtendedMetaData.ANNOTATION_URI, "namespace", _nsURI);
    }
  }
  
  /**
   * Sets the following tagged values of an ENamedElement
   * 
   * <ul>
   * <li>xml.name</li>
   * <li>xml.namePlural</li>
   * <li>xml.nsPrefix</li>
   * <li>xml.nsUri</li>
   * 
   * @param element
   */
  protected void configureNamespace(final ENamedElement element) {
  }
  
  protected void configureXMLAttribute(final EStructuralFeature eStructuralFeature) {
    boolean isXMLAttribute = false;
    boolean _and = false;
    int _upperBound = eStructuralFeature.getUpperBound();
    boolean _equals = Integer.valueOf(1).equals(Integer.valueOf(_upperBound));
    if (!_equals) {
      _and = false;
    } else {
      int _lowerBound = eStructuralFeature.getLowerBound();
      boolean _equals_1 = Integer.valueOf(0).equals(Integer.valueOf(_lowerBound));
      _and = _equals_1;
    }
    if (_and) {
      final EClassifier type = eStructuralFeature.getEType();
      boolean _or = false;
      if ((type instanceof EEnum)) {
        _or = true;
      } else {
        _or = (type instanceof EDataType);
      }
      if (_or) {
        isXMLAttribute = true;
      }
    }
    XMLPersistenceMappingExtendedMetaData.INSTANCE.setXMLAttribute(eStructuralFeature, isXMLAttribute);
  }
}
