/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.live.internal;

import com.google.common.base.Joiner;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.TaskingEngine;
import org.eclipse.tea.core.internal.TaskProgressExtendedTracker;
import org.eclipse.tea.core.internal.TaskingConfigurationStore;
import org.eclipse.tea.core.internal.TimeHelper;
import org.eclipse.tea.core.internal.listeners.TaskingStatusTracker;
import org.eclipse.tea.core.ui.TaskingEngineJob;
import org.eclipse.tea.core.ui.config.TaskingEclipsePreferenceStore;
import org.eclipse.tea.core.ui.live.internal.Activator;
import org.eclipse.tea.core.ui.live.internal.Refreshable;
import org.eclipse.tea.core.ui.live.internal.TreeLabelColumnProvider;
import org.eclipse.tea.core.ui.live.internal.TreeModelProvider;
import org.eclipse.tea.core.ui.live.internal.TreeProgressRenderer;
import org.eclipse.tea.core.ui.live.internal.model.VisualizationNode;
import org.eclipse.tea.core.ui.live.internal.model.VisualizationRootNode;
import org.eclipse.tea.core.ui.live.internal.model.VisualizationStatusNode;
import org.eclipse.tea.core.ui.live.internal.model.VisualizationTaskNode;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TaskingLiveView
implements Refreshable,
EventHandler {
    private static final int MAX_ELEMENTS = 10;
    private static final String CONTEXT_MENU_ID = "TaskingLiveViewContextMenu";
    private TreeViewer tree;
    private final Deque<VisualizationRootNode> nodes = new ArrayDeque<VisualizationRootNode>();
    private Clipboard clipboard;

    @PostConstruct
    public void postConstruct(Composite parent, IEventBroker broker, MPart part, EMenuService menuService) {
        this.tree = new TreeViewer(parent);
        this.tree.setContentProvider((IContentProvider)new TreeModelProvider());
        this.tree.getTree().setHeaderVisible(true);
        this.tree.setInput(this.nodes);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tree);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.tree.getControl());
        TreeViewerColumn name = new TreeViewerColumn(this.tree, 16384);
        name.getColumn().setText("Task");
        name.getColumn().setWidth(300);
        name.setLabelProvider((CellLabelProvider)new TreeLabelColumnProvider());
        TreeViewerColumn duration = new TreeViewerColumn(this.tree, 16384);
        duration.getColumn().setText("Duration");
        duration.getColumn().setWidth(80);
        duration.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof VisualizationNode) {
                    if (element instanceof VisualizationTaskNode && ((VisualizationTaskNode)element).isSkipped()) {
                        return null;
                    }
                    if (((VisualizationNode)element).isDone()) {
                        return TimeHelper.formatDuration((long)((VisualizationNode)element).getDuration());
                    }
                }
                return null;
            }
        });
        TreeViewerColumn progressText = new TreeViewerColumn(this.tree, 131072);
        progressText.getColumn().setText("Status");
        progressText.getColumn().setWidth(75);
        progressText.setLabelProvider((CellLabelProvider)new TreeProgressRenderer(this.tree.getControl().getDisplay()));
        this.clipboard = new Clipboard(this.tree.getControl().getDisplay());
        MDirectToolItem clear = MMenuFactory.INSTANCE.createDirectToolItem();
        clear.setLabel("Clear");
        clear.setObject(new Object(){

            @Execute
            public void clear() {
                TaskingLiveView.this.nodes.clear();
                TaskingLiveView.this.refresh();
            }
        });
        clear.setIconURI(this.getIconUri("removea_exc.png"));
        part.setToolbar(MMenuFactory.INSTANCE.createToolBar());
        part.getToolbar().getChildren().add(clear);
        this.tree.addDoubleClickListener(this::doubleClick);
        this.tree.addDoubleClickListener(event -> {
            Object obj;
            ITreeSelection ss;
            ISelection selection = event.getSelection();
            if (selection instanceof ITreeSelection && (ss = (ITreeSelection)selection).size() == 1 && this.tree.isExpandable(obj = ss.getFirstElement())) {
                this.tree.setExpandedState(obj, !this.tree.getExpandedState(obj));
            }
        });
        part.getMenus().clear();
        MPopupMenu ctxMenu = MMenuFactory.INSTANCE.createPopupMenu();
        ctxMenu.setElementId(CONTEXT_MENU_ID);
        MDirectMenuItem relaunch = MMenuFactory.INSTANCE.createDirectMenuItem();
        relaunch.setLabel("Re-Launch...");
        relaunch.setIconURI(this.getIconUri("skip.png"));
        relaunch.setObject(new Object(){

            @CanExecute
            public boolean can() {
                ITreeSelection sel = TaskingLiveView.this.tree.getStructuredSelection();
                if (sel.isEmpty() || sel.size() > 1) {
                    return false;
                }
                return sel.getFirstElement() instanceof VisualizationRootNode;
            }

            @Execute
            public void rerun() {
                TaskingEngine engine = TaskingEngine.withConfiguration((TaskingConfigurationStore)new TaskingEclipsePreferenceStore());
                TaskingEngineJob j = new TaskingEngineJob(engine, (Object)((VisualizationRootNode)TaskingLiveView.this.tree.getStructuredSelection().getFirstElement()).getChain());
                j.schedule();
            }
        });
        MDirectMenuItem remove = MMenuFactory.INSTANCE.createDirectMenuItem();
        remove.setLabel("Remove selected");
        remove.setIconURI(this.getIconUri("clear.png"));
        remove.setObject(new Object(){

            @CanExecute
            public boolean can() {
                ITreeSelection sel = TaskingLiveView.this.tree.getStructuredSelection();
                if (sel.isEmpty()) {
                    return false;
                }
                return sel.getFirstElement() instanceof VisualizationRootNode;
            }

            @Execute
            public void remove() {
                for (Object root : TaskingLiveView.this.tree.getStructuredSelection().toList()) {
                    TaskingLiveView.this.nodes.remove(root);
                }
                TaskingLiveView.this.refresh();
            }
        });
        MDirectMenuItem copy = MMenuFactory.INSTANCE.createDirectMenuItem();
        copy.setLabel("Copy");
        copy.setIconURI(this.getIconUri("copy_edit_co.png"));
        copy.setObject(new Object(){

            @Execute
            public void copy() {
                ArrayList<String> labels = new ArrayList<String>();
                for (Object element : TaskingLiveView.this.tree.getStructuredSelection().toList()) {
                    if (element instanceof VisualizationNode) {
                        labels.add(((VisualizationNode)element).getName());
                        continue;
                    }
                    if (!(element instanceof VisualizationStatusNode)) continue;
                    labels.add(((VisualizationStatusNode)element).getLabel());
                }
                TaskingLiveView.this.clipboard.setContents(new Object[]{Joiner.on((char)'\n').join(labels)}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
        ctxMenu.getChildren().add(relaunch);
        ctxMenu.getChildren().add(remove);
        ctxMenu.getChildren().add(copy);
        part.getMenus().add(ctxMenu);
        menuService.registerContextMenu((Object)this.tree.getControl(), CONTEXT_MENU_ID);
        broker.subscribe("org/eclipse/tea/*", null, (EventHandler)this, true);
    }

    private void doubleClick(DoubleClickEvent event) {
        VisualizationStatusNode sn;
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        if (sel.isEmpty() || sel.size() > 1) {
            return;
        }
        Object clicked = sel.getFirstElement();
        if (clicked instanceof VisualizationStatusNode && (sn = (VisualizationStatusNode)clicked).getMarker() != null) {
            TaskingLiveView.openMarkerInEditor(sn.getMarker());
        }
    }

    public static void openMarkerInEditor(IMarker marker) {
        IEditorInput input;
        IFile file;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = page.getActiveEditor();
        if (editor != null && (file = ResourceUtil.getFile((IEditorInput)(input = editor.getEditorInput()))) != null && marker.getResource().equals((Object)file) && OpenStrategy.activateOnOpen()) {
            page.activate((IWorkbenchPart)editor);
        }
        if (marker != null && marker.getResource() instanceof IFile) {
            try {
                IDE.openEditor((IWorkbenchPage)page, (IMarker)marker, (boolean)OpenStrategy.activateOnOpen());
            }
            catch (PartInitException e) {
                Activator.log((IStatus)new Status(4, "org.eclipse.tea.core.ui.live", "Cannot open Editor for marker", (Throwable)e));
            }
        }
    }

    private String getIconUri(String icon) {
        return "platform:/plugin/org.eclipse.tea.core.ui.live/resources/" + icon;
    }

    private VisualizationRootNode nodeFor(TaskExecutionContext tec) {
        return this.nodes.stream().filter(o -> o.getTaskExecutionContext() == tec).findFirst().orElse(null);
    }

    public void handleEvent(Event event) {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (!(data instanceof IEclipseContext)) {
            return;
        }
        IEclipseContext eventContext = (IEclipseContext)data;
        VisualizationRootNode node = this.nodeFor((TaskExecutionContext)eventContext.get(TaskExecutionContext.class));
        if (!event.getTopic().equals("org/eclipse/tea/BeginTaskChain") && node == null) {
            return;
        }
        switch (event.getTopic()) {
            case "org/eclipse/tea/BeginTaskChain": {
                if (node != null) {
                    node.prepareRetry();
                }
                eventContext.set(Refreshable.class, (Object)this);
                this.nodes.addFirst((VisualizationRootNode)ContextInjectionFactory.make(VisualizationRootNode.class, (IEclipseContext)eventContext));
                while (this.nodes.size() > 10) {
                    this.nodes.removeLast();
                }
                break;
            }
            case "org/eclipse/tea/FinishTaskChain": {
                node.done();
                break;
            }
            case "org/eclipse/tea/BeginTask": {
                node.getNodeFor(eventContext.get("org.eclipse.tea.core.task")).begin((TaskProgressExtendedTracker)eventContext.get(TaskProgressExtendedTracker.class));
                break;
            }
            case "org/eclipse/tea/FinishTask": {
                node.getNodeFor(eventContext.get("org.eclipse.tea.core.task")).done((TaskProgressExtendedTracker)eventContext.get(TaskProgressExtendedTracker.class), (TaskExecutionContext)eventContext.get(TaskExecutionContext.class), (TaskingStatusTracker)eventContext.get(TaskingStatusTracker.class));
            }
        }
        this.refresh();
        switch (event.getTopic()) {
            case "org/eclipse/tea/BeginTaskChain": 
            case "org/eclipse/tea/FinishTaskChain": {
                this.tree.getControl().getDisplay().asyncExec(() -> {
                    this.tree.collapseAll();
                    this.tree.setExpandedElements(this.nodes.stream().filter(e -> e.isActive()).toArray());
                });
            }
        }
    }

    @Override
    public void refresh() {
        this.tree.getControl().getDisplay().asyncExec(() -> this.tree.refresh(true));
    }

    @Focus
    public void onFocus() {
        this.tree.getControl().setFocus();
    }

    @PreDestroy
    public void dispose() {
        this.clipboard.dispose();
    }
}

