/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.live.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tea.core.MarkerStatus;

public class VisualizationStatusNode {
    private final IStatus status;
    private final List<VisualizationStatusNode> children = new ArrayList<VisualizationStatusNode>();

    public VisualizationStatusNode(IStatus status) {
        this.status = status;
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus s = iStatusArray[n2];
                if (s.getSeverity() > 0) {
                    this.children.add(new VisualizationStatusNode(s));
                }
                ++n2;
            }
            this.children.sort((a, b) -> {
                int x = b.getServerity() - a.getServerity();
                if (x != 0) {
                    return x;
                }
                return a.getLabel().compareTo(b.getLabel());
            });
        }
    }

    public String getLabel() {
        String message = this.status.getMessage();
        if (this.status.getException() != null) {
            return String.valueOf(message) + " (" + this.status.getException() + ")";
        }
        if (message == null || message.isEmpty()) {
            return this.status.toString();
        }
        return message;
    }

    public int getServerity() {
        return this.status.getSeverity();
    }

    public List<VisualizationStatusNode> getChildren() {
        return this.children;
    }

    public IMarker getMarker() {
        if (this.status instanceof MarkerStatus) {
            return ((MarkerStatus)this.status).getMarker();
        }
        return null;
    }
}

