/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.dom;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.actf.util.dom.TreeWalkerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.html.HTMLTitleElement;
import org.w3c.dom.traversal.NodeFilter;

public class DomPrintUtil {
    public static final String UTF8 = "UTF8";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String EMPTY_STR = "";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String AMP = "&";
    private static final String QUAT = "\"";
    private static final String SINGLE_QUAT = "'";
    private static final String ESC_LT = "&lt;";
    private static final String ESC_GT = "&gt;";
    private static final String ESC_AMP = "&amp;";
    private Document document;
    private int whatToShow = -1;
    private NodeFilter nodeFilter = null;
    private boolean entityReferenceExpansion = false;
    private boolean indent = true;
    private boolean escapeTagBracket = false;
    private AttributeFilter attrFilter = null;

    public DomPrintUtil(Document document) {
        this.document = document;
    }

    private String getXMLString(String string) {
        return string.replaceAll(AMP, ESC_AMP).replaceAll(LT, ESC_LT).replaceAll(GT, ESC_GT);
    }

    private String getAttributeString(Element element, Node node) {
        if (this.attrFilter == null || this.attrFilter.acceptNode(element, node)) {
            String string = this.getXMLString(node.getNodeValue());
            String string2 = QUAT;
            if (string.contains(QUAT)) {
                string2 = SINGLE_QUAT;
            }
            return " " + node.getNodeName() + "=" + string2 + string + string2;
        }
        return EMPTY_STR;
    }

    private boolean checkNewLine(Node node) {
        if (this.indent && node.hasChildNodes()) {
            short s = node.getFirstChild().getNodeType();
            return s != 3 && s != 4;
        }
        return false;
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer(8192);
        TreeWalkerImpl treeWalkerImpl = new TreeWalkerImpl(this.document, this.whatToShow, this.nodeFilter, this.entityReferenceExpansion);
        String string = this.escapeTagBracket ? ESC_LT : LT;
        String string2 = this.escapeTagBracket ? ESC_GT : GT;
        String string3 = this.indent ? LINE_SEP : EMPTY_STR;
        Object object = treeWalkerImpl.nextNode();
        boolean bl = false;
        String string4 = EMPTY_STR;
        block8: while (object != null) {
            Object object2;
            short s = object.getNodeType();
            switch (s) {
                case 1: {
                    String string5;
                    Object object3;
                    if (bl) {
                        stringBuffer.append(string3);
                    }
                    stringBuffer.append(String.valueOf(string4) + string + object.getNodeName());
                    object2 = object.getAttributes();
                    int n = object2.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        object3 = object2.item(n2);
                        string5 = object3.getNodeValue();
                        if (string5 != null) {
                            stringBuffer.append(this.getAttributeString((Element)object, (Node)object3));
                        }
                        ++n2;
                    }
                    if (object instanceof HTMLTitleElement && !object.hasChildNodes()) {
                        stringBuffer.append(String.valueOf(string2) + ((HTMLTitleElement)object).getText());
                        bl = true;
                        break;
                    }
                    if (this.checkNewLine((Node)object)) {
                        stringBuffer.append(String.valueOf(string2) + string3);
                        bl = false;
                        break;
                    }
                    stringBuffer.append(string2);
                    bl = true;
                    break;
                }
                case 3: {
                    if (!bl) {
                        stringBuffer.append(string4);
                    }
                    stringBuffer.append(this.getXMLString(object.getNodeValue()));
                    bl = true;
                    break;
                }
                case 8: {
                    String string6 = this.escapeTagBracket ? this.getXMLString(object.getNodeValue()) : object.getNodeValue();
                    stringBuffer.append(String.valueOf(string3) + string4 + string + "!--" + string6 + "--" + string2 + string3);
                    bl = false;
                    break;
                }
                case 4: {
                    stringBuffer.append(String.valueOf(string3) + string4 + string + "!CDATA[" + object.getNodeValue() + "]]" + string3);
                    break;
                }
                case 10: {
                    String string5;
                    Object object3;
                    if (object instanceof DocumentType) {
                        object3 = (DocumentType)object;
                        string5 = object3.getPublicId();
                        String string7 = object3.getSystemId();
                        if (string5 != null && string5.length() > 0) {
                            if (string7 != null && string7.length() > 0) {
                                stringBuffer.append(String.valueOf(string) + "!DOCTYPE " + object3.getName() + " PUBLIC \"" + string5 + " \"" + string7 + "\">" + string3);
                                break;
                            }
                            stringBuffer.append(String.valueOf(string) + "!DOCTYPE " + object3.getName() + " PUBLIC \"" + string5 + "\">" + string3);
                            break;
                        }
                        stringBuffer.append(String.valueOf(string) + "!DOCTYPE " + object3.getName() + " SYSTEM \"" + object3.getSystemId() + "\">" + string3);
                        break;
                    }
                    System.out.println("Document Type node does not implement DocumentType: " + object);
                    break;
                }
                case 7: {
                    if (!(object instanceof ProcessingInstruction)) break;
                    Object object3 = ((ProcessingInstruction)object).getData();
                    if (((String)object3).startsWith("?")) {
                        stringBuffer.append(string);
                    } else {
                        stringBuffer.append(String.valueOf(string) + "?");
                    }
                    if (((String)object3).endsWith("?")) {
                        stringBuffer.append(String.valueOf(object3) + GT + LINE_SEP);
                        break;
                    }
                    stringBuffer.append(String.valueOf(object3) + "?>" + LINE_SEP);
                    break;
                }
                default: {
                    System.out.println(String.valueOf(object.getNodeType()) + " : " + object.getNodeName());
                }
            }
            object2 = treeWalkerImpl.firstChild();
            if (object2 != null) {
                if (this.indent && s == 1) {
                    string4 = String.valueOf(string4) + " ";
                }
                object = object2;
                continue;
            }
            if (object.getNodeType() == 1) {
                stringBuffer.append(String.valueOf(string) + "/" + object.getNodeName() + string2 + string3);
                bl = false;
            }
            if ((object2 = treeWalkerImpl.nextSibling()) != null) {
                object = object2;
                continue;
            }
            object = null;
            object2 = treeWalkerImpl.parentNode();
            while (object2 != null) {
                if (object2.getNodeType() == 1) {
                    if (this.indent) {
                        if (string4.length() > 0) {
                            string4 = string4.substring(1);
                        } else {
                            System.err.println("indent: " + object2.getNodeName() + " " + object2);
                        }
                    }
                    stringBuffer.append(String.valueOf(string3) + string4 + string + "/" + object2.getNodeName() + string2 + string3);
                    bl = false;
                }
                if ((object2 = treeWalkerImpl.nextSibling()) != null) {
                    object = object2;
                    continue block8;
                }
                object2 = treeWalkerImpl.parentNode();
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toXMLString();
    }

    public void setWhatToShow(int n) {
        this.whatToShow = n;
    }

    public void setNodeFilter(NodeFilter nodeFilter) {
        this.nodeFilter = nodeFilter;
    }

    public void setEntityReferenceExpansion(boolean bl) {
        this.entityReferenceExpansion = bl;
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
    }

    public void setEscapeTagBracket(boolean bl) {
        this.escapeTagBracket = bl;
    }

    public void setAttrFilter(AttributeFilter attributeFilter) {
        this.attrFilter = attributeFilter;
    }

    public void writeToFile(String string) throws IOException {
        this.writeToFile(new File(string), UTF8);
    }

    public void writeToFile(File file) throws IOException {
        this.writeToFile(file, UTF8);
    }

    public void writeToFile(String string, String string2) throws IOException {
        this.writeToFile(new File(string), string2);
    }

    public void writeToFile(File file, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string));
        printWriter.println(this.toXMLString());
        printWriter.flush();
        printWriter.close();
    }

    public static interface AttributeFilter {
        public boolean acceptNode(Element var1, Node var2);
    }
}

