/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;

public class BER {
    public static final int BER_ENCODE_CER = 1;
    public static final int BER_ENCODE_DER = 2;
    private static final ASN_Tag[] TitanInteger_tag_ = new ASN_Tag[]{new ASN_Tag(ASN_TagClass.ASN_TAG_UNIV, 2)};
    public static final ASN_BERdescriptor TitanInteger_Ber_ = new ASN_BERdescriptor(1, TitanInteger_tag_);
    private static final ASN_Tag[] TitanOctetString_tag_ = new ASN_Tag[]{new ASN_Tag(ASN_TagClass.ASN_TAG_UNIV, 4)};
    public static final ASN_BERdescriptor TitanOctetString_Ber_ = new ASN_BERdescriptor(1, TitanOctetString_tag_);
    private static final ASN_Tag[] TitanObjectDescriptor_tag_ = new ASN_Tag[]{new ASN_Tag(ASN_TagClass.ASN_TAG_UNIV, 7)};
    public static final ASN_BERdescriptor TitanObjectDescriptor_Ber_ = new ASN_BERdescriptor(1, TitanObjectDescriptor_tag_);
    private static final ASN_Tag[] TitanExternal_tag_ = new ASN_Tag[]{new ASN_Tag(ASN_TagClass.ASN_TAG_UNIV, 8)};
    public static final ASN_BERdescriptor TitanExternal_Ber_ = new ASN_BERdescriptor(1, TitanExternal_tag_);
    private static final ASN_Tag[] TitanEnumerated_tag_ = new ASN_Tag[]{new ASN_Tag(ASN_TagClass.ASN_TAG_UNIV, 10)};
    public static final ASN_BERdescriptor TitanEnumerated_Ber_ = new ASN_BERdescriptor(1, TitanEnumerated_tag_);
    private static final ASN_Tag[] TitanEmbedded_PDV_tag_ = new ASN_Tag[]{new ASN_Tag(ASN_TagClass.ASN_TAG_UNIV, 11)};
    public static final ASN_BERdescriptor TitanEmbedded_PDV_Ber_ = new ASN_BERdescriptor(1, TitanEmbedded_PDV_tag_);
    private static final ASN_Tag[] Sequence_tag_ = new ASN_Tag[]{new ASN_Tag(ASN_TagClass.ASN_TAG_UNIV, 16)};
    public static final ASN_BERdescriptor Sequence_Ber_ = new ASN_BERdescriptor(1, Sequence_tag_);
    private static final ASN_Tag[] Set_tag_ = new ASN_Tag[]{new ASN_Tag(ASN_TagClass.ASN_TAG_UNIV, 17)};
    public static final ASN_BERdescriptor Set_Ber_ = new ASN_BERdescriptor(1, Set_tag_);
    public static final ASN_BERdescriptor Choice_Ber_ = new ASN_BERdescriptor(0, null);
    private static final ASN_Tag[] TitanCharacter_String_tag_ = new ASN_Tag[]{new ASN_Tag(ASN_TagClass.ASN_TAG_UNIV, 29)};
    public static final ASN_BERdescriptor TitanCharacter_String_Ber_ = new ASN_BERdescriptor(1, TitanCharacter_String_tag_);

    private BER() {
    }

    public static final class ASN_BER_TLV {
        public boolean isConstructed;
        public boolean isLenDefinite;
        public boolean isLenShort;
        public boolean isTagComplete;
        public boolean isComplete;
        public boolean isVTlvsSelected;
        public ASN_TagClass tagclass;
        public int tagnumber;
        public int Tlen;
        public int Llen;
        public byte[] Tstr;
        public byte[] Lstr;
        public int Vlen;
        public byte[] Vstr;
        public int n_tlvs;
        public ASN_BER_TLV[] tlvs;

        public ASN_BER_TLV() {
            this.isConstructed = false;
            this.isLenDefinite = false;
            this.isLenShort = false;
            this.isTagComplete = false;
            this.isComplete = false;
            this.isVTlvsSelected = false;
            this.tagclass = ASN_TagClass.ASN_TAG_UNIV;
            this.tagnumber = 0;
            this.Tlen = 0;
            this.Llen = 0;
            this.Tstr = new byte[0];
            this.Lstr = new byte[0];
            this.Vlen = 0;
            this.Vstr = new byte[0];
            this.n_tlvs = 0;
            this.tlvs = new ASN_BER_TLV[0];
        }

        public ASN_BER_TLV(int vlen, byte[] vstr) {
            this.isConstructed = false;
            this.isLenDefinite = false;
            this.isLenShort = false;
            this.isTagComplete = false;
            this.isComplete = false;
            this.isVTlvsSelected = false;
            this.tagclass = ASN_TagClass.ASN_TAG_UNIV;
            this.tagnumber = 0;
            this.Tlen = 0;
            this.Llen = 0;
            this.Tstr = new byte[0];
            this.Lstr = new byte[0];
            this.Vlen = vlen;
            this.Vstr = new byte[this.Vlen];
            this.Vstr = vstr;
            this.n_tlvs = 0;
            this.tlvs = new ASN_BER_TLV[0];
        }

        public ASN_BER_TLV(ASN_BER_TLV tlv) {
            this.isConstructed = true;
            this.isLenDefinite = false;
            this.isLenShort = false;
            this.isTagComplete = false;
            this.isComplete = false;
            this.isVTlvsSelected = true;
            this.tagclass = ASN_TagClass.ASN_TAG_UNIV;
            this.tagnumber = 0;
            this.Tlen = 0;
            this.Llen = 0;
            this.Tstr = new byte[0];
            this.Lstr = new byte[0];
            this.Vlen = 0;
            this.Vstr = new byte[0];
            if (tlv == null) {
                this.n_tlvs = 0;
                this.tlvs = new ASN_BER_TLV[0];
            } else {
                this.n_tlvs = 1;
                this.tlvs = new ASN_BER_TLV[this.n_tlvs];
                this.tlvs[0] = tlv;
            }
        }

        public void put_to_buf(TTCN_Buffer buf) {
            buf.put_s(this.Tstr);
            buf.put_s(this.Lstr);
            if (this.isVTlvsSelected) {
                for (int i = 0; i < this.n_tlvs; ++i) {
                    this.tlvs[i].put_to_buf(buf);
                }
            } else {
                buf.put_s(this.Vstr);
            }
        }

        private int minBitsNeeded(int num) {
            if (num == 0) {
                return 1;
            }
            int n = 0;
            for (int tmp = num; tmp != 0; tmp /= 2) {
                ++n;
            }
            return n;
        }

        public void chk_constructedFlag(boolean expectedFlag) {
            if (this.Tlen > 0 && this.isConstructed != expectedFlag) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid 'constructed' flag (must be %sset).", expectedFlag ? "" : "un");
            }
        }

        public void add_TLV(ASN_BER_TLV p_tlv) {
            if (!this.isConstructed && !this.isVTlvsSelected) {
                TTCN_EncDec_ErrorContext.error_internal("ASN_BER_TLV_t::add_TLV() invoked for a non-constructed TLV.", new Object[0]);
            }
            ++this.n_tlvs;
            ASN_BER_TLV[] tempTLVs = this.tlvs;
            this.tlvs = new ASN_BER_TLV[this.n_tlvs];
            if (this.n_tlvs > 1) {
                for (int i = 0; i < this.n_tlvs - 1; ++i) {
                    this.tlvs[i] = tempTLVs[i];
                }
            }
            this.tlvs[this.n_tlvs - 1] = p_tlv;
        }

        public void add_UNIV0_TLV() {
            ASN_BER_TLV newTlv = new ASN_BER_TLV();
            newTlv.setLenDefinite(true);
            newTlv.setLenShort(true);
            newTlv.setTlen(1);
            byte[] newTstr = new byte[]{0};
            newTlv.setTstr(newTstr);
            newTlv.setLlen(1);
            byte[] newLstr = new byte[]{0};
            newTlv.setLstr(newLstr);
            this.add_TLV(newTlv);
        }

        public void add_TL(int p_coding, ASN_TagClass p_tagclass, int p_tagnumber) {
            this.tagclass = p_tagclass;
            this.tagnumber = p_tagnumber;
            if (p_coding == 1 && this.isConstructed) {
                this.isLenDefinite = false;
                this.add_UNIV0_TLV();
            } else {
                this.isLenDefinite = true;
            }
            if (this.isLenDefinite) {
                this.Llen = 0;
                this.Tlen = 0;
                this.Vlen = this.Vstr.length;
                if (this.Vlen > 127) {
                    this.isLenShort = false;
                    this.Llen = 1 + (this.minBitsNeeded(this.Vlen) + 7) / 8;
                } else {
                    this.isLenShort = true;
                    this.Llen = 1;
                }
            } else {
                this.Llen = 1;
            }
            this.Lstr = new byte[this.Llen];
            if (this.isLenDefinite) {
                if (this.isLenShort) {
                    this.Lstr[0] = (byte)this.Vlen;
                } else {
                    int i = this.Llen - 1;
                    this.Lstr[0] = (byte)(i & 0x7F | 0x80);
                    int tmp = this.Vlen;
                    while (i > 0) {
                        this.Lstr[i] = (byte)(tmp & 0xFF);
                        --i;
                        tmp >>>= 8;
                    }
                }
            } else {
                this.Lstr[0] = -128;
            }
            this.Tlen = this.tagnumber > 30 ? 1 + (this.minBitsNeeded(this.tagnumber) + 6) / 7 : 1;
            this.Tstr = new byte[this.Tlen];
            switch (this.tagclass) {
                case ASN_TAG_UNIV: {
                    this.Tstr[0] = 0;
                    break;
                }
                case ASN_TAG_APPL: {
                    this.Tstr[0] = 64;
                    break;
                }
                case ASN_TAG_CONT: {
                    this.Tstr[0] = -128;
                    break;
                }
                case ASN_TAG_PRIV: {
                    this.Tstr[0] = -64;
                    break;
                }
                default: {
                    TTCN_EncDec_ErrorContext.error_internal("Unhandled case or undefined tagclass.", new Object[0]);
                }
            }
            if (this.isConstructed) {
                this.Tstr[0] = (byte)(this.Tstr[0] | 0x20);
            }
            if (this.tagnumber < 30) {
                this.Tstr[0] = (byte)(this.Tstr[0] | (byte)this.tagnumber);
            } else {
                this.Tstr[0] = (byte)(this.Tstr[0] | 0x1F);
                int tmp = this.tagnumber;
                int i = this.Tlen - 1;
                while (i > 0) {
                    this.Tstr[i] = (byte)(tmp & 0x7F | 0x80);
                    --i;
                    tmp >>>= 7;
                }
                int n = this.Tlen - 1;
                this.Tstr[n] = (byte)(this.Tstr[n] & 0x7F);
            }
            this.isComplete = true;
            this.isTagComplete = true;
        }

        public ASN_BER_TLV ASN_BER_V2TLV(Base_Type.TTCN_Typedescriptor p_td, int p_coding) {
            if (p_td.ber.number_of_tags == 0) {
                return this;
            }
            ASN_BER_TLV tlv2 = this.tagclass != ASN_TagClass.ASN_TAG_UNIV || this.tagnumber != 0 ? new ASN_BER_TLV() : this;
            ASN_BERdescriptor ber = p_td.ber;
            for (int i = 0; i < ber.number_of_tags; ++i) {
                ASN_Tag tag = ber.tags[i];
                tlv2.add_TL(p_coding, tag.tagclass, tag.tagnumber);
                if (i == ber.number_of_tags - 1) continue;
                tlv2 = new ASN_BER_TLV(tlv2);
            }
            return tlv2;
        }

        public boolean ASN_BER_str2TLV(int p_len_s, byte[] p_str, int L_form) {
            int i;
            this.isConstructed = false;
            this.isLenDefinite = true;
            this.isLenShort = true;
            this.isTagComplete = false;
            this.isComplete = false;
            this.isVTlvsSelected = false;
            this.tagclass = ASN_TagClass.ASN_TAG_UNIV;
            this.tagnumber = 0;
            this.Tlen = 0;
            this.Llen = 0;
            this.Vlen = 0;
            this.Tstr = new byte[0];
            this.Lstr = new byte[0];
            this.Vstr = new byte[0];
            this.n_tlvs = 0;
            this.tlvs = new ASN_BER_TLV[0];
            if (p_len_s == 0) {
                return this.incomplete(this, p_len_s);
            }
            int c = p_str[0];
            switch ((c & 0xC0) >> 6) {
                case 0: {
                    this.tagclass = ASN_TagClass.ASN_TAG_UNIV;
                    break;
                }
                case 1: {
                    this.tagclass = ASN_TagClass.ASN_TAG_APPL;
                    break;
                }
                case 2: {
                    this.tagclass = ASN_TagClass.ASN_TAG_CONT;
                    break;
                }
                case 3: {
                    this.tagclass = ASN_TagClass.ASN_TAG_PRIV;
                }
            }
            if ((c & 0x20) > 0) {
                this.isConstructed = true;
            }
            byte c2 = (byte)(c & 0x1F);
            int currentPos = 0;
            if (c2 != 31) {
                this.tagnumber = c2;
            } else {
                this.tagnumber = 0;
                boolean doIt = true;
                boolean err_repr = false;
                while (doIt) {
                    if (++currentPos >= p_len_s) {
                        return this.incomplete(this, p_len_s);
                    }
                    c = p_str[currentPos];
                    if (!err_repr) {
                        int ASN_Tagnumber_7msb = 0x7F000000;
                        if ((this.tagnumber & ASN_Tagnumber_7msb) != 0) {
                            err_repr = true;
                            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_REPR, "Tag number is too big", new Object[0]);
                            this.tagnumber = 0;
                        } else {
                            this.tagnumber <<= 7;
                            this.tagnumber |= c & 0x7F;
                        }
                    }
                    if ((c & 0x80) != 0) continue;
                    doIt = false;
                }
            }
            this.isTagComplete = true;
            this.Tlen = ++currentPos;
            this.Tstr = new byte[this.Tlen];
            for (i = 0; i < this.Tlen; ++i) {
                this.Tstr[i] = p_str[i];
            }
            if (currentPos >= p_len_s) {
                return this.incomplete(this, p_len_s);
            }
            this.isLenDefinite = true;
            this.isLenShort = false;
            c = p_str[currentPos];
            if ((c & 0x80) == 0) {
                this.Llen = 1;
                this.Vlen = c;
                this.isLenShort = true;
                this.Lstr = new byte[this.Llen];
                this.Lstr[0] = (byte)this.Vlen;
                if ((L_form & 1) == 0) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_FORM, "Short length form is not acceptable.", new Object[0]);
                }
            } else if (c == 128) {
                this.Llen = 1;
                this.isLenDefinite = false;
                if ((L_form & 4) == 0) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_FORM, "Indefinite length form is not acceptable.", new Object[0]);
                }
            } else if (c == 255) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Error in L: In the long form, the value 0xFF shall not be used (see X.690 clause 8.1.3.5.c)).", new Object[0]);
            } else {
                if ((L_form & 2) == 0) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_FORM, "Long length form is not acceptable.", new Object[0]);
                }
                this.Llen = (c & 0x7F) + 1;
                this.Lstr = new byte[this.Llen];
                for (i = this.Tlen; i < this.Tlen + this.Llen; ++i) {
                    this.Lstr[i - this.Tlen] = p_str[i];
                }
                if (this.Tlen + this.Llen > p_len_s) {
                    this.Llen = p_len_s - this.Tlen;
                    return this.incomplete(this, p_len_s);
                }
                this.Vlen = 0;
                boolean err_repr = false;
                for (int i2 = this.Llen - 1; i2 > 0; --i2) {
                    if (!err_repr) {
                        int size_8msb = -16777216;
                        if ((this.Vlen & size_8msb) != 0) {
                            err_repr = true;
                            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_REPR, "In long form L: Length of V is too big.", new Object[0]);
                            this.Vlen = -1;
                        } else {
                            this.Vlen <<= 8;
                        }
                    }
                    ++currentPos;
                    if (err_repr) continue;
                    c = p_str[currentPos];
                    this.Vlen |= c;
                }
            }
            ++currentPos;
            if (this.isLenDefinite) {
                if (this.Vlen > p_len_s - this.Tlen - this.Llen) {
                    return this.incomplete(this, p_len_s);
                }
            } else {
                if (!this.isConstructed) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "A sender can use the indefinite form only if the encoding is constructed (see X.690 clause 8.1.3.2.a).", new Object[0]);
                }
                ASN_BER_TLV tmpTlv = new ASN_BER_TLV();
                boolean doit = true;
                while (doit) {
                    if (!tmpTlv.ASN_BER_str2TLV(p_len_s - currentPos, this.subArray(p_str, currentPos, p_len_s), 7)) {
                        return this.incomplete(this, p_len_s);
                    }
                    int tmp_len = tmpTlv.getTlen() + tmpTlv.getLlen() + tmpTlv.getVlen();
                    currentPos += tmp_len;
                    this.Vlen += tmp_len;
                    if (tmpTlv.getTagclass() != ASN_TagClass.ASN_TAG_UNIV || tmpTlv.getTagnumber() != 0) continue;
                    doit = false;
                }
            }
            this.Vstr = new byte[this.Vlen];
            for (int i3 = currentPos; i3 < p_str.length; ++i3) {
                this.Vstr[i3 - currentPos] = p_str[i3];
            }
            this.isComplete = true;
            return true;
        }

        private boolean incomplete(ASN_BER_TLV tlv, int p_len_s) {
            return false;
        }

        public byte[] subArray(byte[] str, int from, int to) {
            byte[] sub = new byte[to - from + 1];
            System.arraycopy(str, from, sub, 0, sub.length);
            return sub;
        }

        public boolean isConstructed() {
            return this.isConstructed;
        }

        public void setConstructed(boolean isConstructed) {
            this.isConstructed = isConstructed;
        }

        public boolean isLenDefinite() {
            return this.isLenDefinite;
        }

        public void setLenDefinite(boolean isLenDefinite) {
            this.isLenDefinite = isLenDefinite;
        }

        public boolean isLenShort() {
            return this.isLenShort;
        }

        public void setLenShort(boolean isLenShort) {
            this.isLenShort = isLenShort;
        }

        public boolean isTagComplete() {
            return this.isTagComplete;
        }

        public void setTagComplete(boolean isTagComplete) {
            this.isTagComplete = isTagComplete;
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        public void setComplete(boolean isComplete) {
            this.isComplete = isComplete;
        }

        public ASN_TagClass getTagclass() {
            return this.tagclass;
        }

        public void setTagclass(ASN_TagClass tagclass) {
            this.tagclass = tagclass;
        }

        public int getTagnumber() {
            return this.tagnumber;
        }

        public void setTagnumber(int tagnumber) {
            this.tagnumber = tagnumber;
        }

        public int getTlen() {
            return this.Tlen;
        }

        public void setTlen(int tlen) {
            this.Tlen = tlen;
        }

        public int getLlen() {
            return this.Llen;
        }

        public void setLlen(int llen) {
            this.Llen = llen;
        }

        public byte[] getTstr() {
            return this.Tstr;
        }

        public void setTstr(byte[] tstr) {
            this.Tstr = tstr;
        }

        public byte[] getLstr() {
            return this.Lstr;
        }

        public void setLstr(byte[] lstr) {
            this.Lstr = lstr;
        }

        public int getVlen() {
            return this.Vlen;
        }

        public void setVlen(int vlen) {
            this.Vlen = vlen;
        }

        public byte[] getVstr() {
            return this.Vstr;
        }

        public void setVstr(byte[] vstr) {
            this.Vstr = vstr;
        }

        public int getN_tlvs() {
            return this.n_tlvs;
        }

        public void setN_tlvs(int n_tlvs) {
            this.n_tlvs = n_tlvs;
        }

        public ASN_BER_TLV[] getTlvs() {
            return this.tlvs;
        }

        public void setTlvs(ASN_BER_TLV[] tlvs) {
            this.tlvs = tlvs;
        }

        public boolean isVTlvsSelected() {
            return this.isVTlvsSelected;
        }

        public void setVTlvsSelected(boolean isVTlvsSelected) {
            this.isVTlvsSelected = isVTlvsSelected;
        }
    }

    public static final class ASN_BERdescriptor {
        public int number_of_tags;
        public ASN_Tag[] tags;

        public ASN_BERdescriptor(int number_of_tags, ASN_Tag[] tags) {
            this.number_of_tags = number_of_tags;
            this.tags = tags;
        }

        public String printTags() {
            if (this.number_of_tags == 0) {
                return "<no tags>";
            }
            String s = "";
            for (int i = this.number_of_tags; i > 0; --i) {
                s = s + this.tags[i - 1].print();
                if (i == 1) continue;
                s = s + " ";
            }
            return s;
        }
    }

    public static final class ASN_Tag {
        public ASN_TagClass tagclass;
        public int tagnumber;

        public ASN_Tag(ASN_TagClass tagclass, int tagnumber) {
            this.tagclass = tagclass;
            this.tagnumber = tagnumber;
        }

        public String print() {
            String prefix = null;
            switch (this.tagclass) {
                case ASN_TAG_UNDEF: {
                    prefix = "<UNDEF> ";
                    break;
                }
                case ASN_TAG_UNIV: {
                    prefix = "UNIVERSAL ";
                    break;
                }
                case ASN_TAG_APPL: {
                    prefix = "APPLICATION ";
                    break;
                }
                case ASN_TAG_CONT: {
                    prefix = "";
                    break;
                }
                case ASN_TAG_PRIV: {
                    prefix = "PRIVATE ";
                    break;
                }
                default: {
                    prefix = "<ERROR> ";
                }
            }
            return prefix + Integer.toString(this.tagnumber);
        }
    }

    public static enum ASN_TagClass {
        ASN_TAG_UNDEF,
        ASN_TAG_UNIV,
        ASN_TAG_APPL,
        ASN_TAG_CONT,
        ASN_TAG_PRIV;

    }
}

