/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.BER;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.RAW;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanBoolean
extends Base_Type {
    private static final BER.ASN_Tag[] TitanBoolean_tag_ = new BER.ASN_Tag[]{new BER.ASN_Tag(BER.ASN_TagClass.ASN_TAG_UNIV, 1)};
    public static final BER.ASN_BERdescriptor TitanBoolean_Ber_ = new BER.ASN_BERdescriptor(1, TitanBoolean_tag_);
    public static final RAW.TTCN_RAWdescriptor TitanBoolean_raw_ = new RAW.TTCN_RAWdescriptor(1, RAW.raw_sign_t.SG_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.ext_bit_t.EXT_BIT_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.top_bit_order_t.TOP_BIT_INHERITED, 0, 0, 0, 8, 0, null, -1, TitanCharString.CharCoding.UNKNOWN, null, false);
    public static final JSON.TTCN_JSONdescriptor TitanBoolean_json_ = new JSON.TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, JSON.json_string_escaping.ESCAPE_AS_SHORT);
    public static final Base_Type.TTCN_Typedescriptor TitanBoolean_descr_ = new Base_Type.TTCN_Typedescriptor("BOOLEAN", TitanBoolean_Ber_, TitanBoolean_raw_, TitanBoolean_json_, null);
    private Boolean boolean_value;

    public TitanBoolean() {
    }

    public TitanBoolean(Boolean otherValue) {
        this.boolean_value = otherValue;
    }

    public TitanBoolean(TitanBoolean otherValue) {
        otherValue.must_bound("Copying an unbound boolean value.");
        this.boolean_value = otherValue.boolean_value;
    }

    public Boolean get_value() {
        this.must_bound("Using the value of an unbound boolean variable.");
        return this.boolean_value;
    }

    public void set_value(Boolean other_value) {
        this.boolean_value = other_value;
    }

    public TitanBoolean operator_assign(boolean otherValue) {
        this.boolean_value = otherValue;
        return this;
    }

    public TitanBoolean operator_assign(TitanBoolean otherValue) {
        otherValue.must_bound("Assignment of an unbound boolean value.");
        if (otherValue != this) {
            this.boolean_value = otherValue.boolean_value;
        }
        return this;
    }

    @Override
    public TitanBoolean operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanBoolean) {
            return this.operator_assign((TitanBoolean)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to boolean", otherValue));
    }

    @Override
    public boolean is_bound() {
        return this.boolean_value != null;
    }

    @Override
    public boolean is_present() {
        return this.is_bound();
    }

    @Override
    public boolean is_value() {
        return this.boolean_value != null;
    }

    public boolean or(boolean other_value) {
        this.must_bound("The left operand of or operator is an unbound boolean value.");
        return this.boolean_value != false || other_value;
    }

    public boolean or(TitanBoolean other_value) {
        this.must_bound("The left operand of or operator is an unbound boolean value.");
        other_value.must_bound("The right operand of or operator is an unbound boolean value.");
        return this.boolean_value != false || other_value.boolean_value != false;
    }

    public boolean and(boolean other_value) {
        this.must_bound("The left operand of and operator is an unbound boolean value.");
        return this.boolean_value != false && other_value;
    }

    public boolean and(TitanBoolean other_value) {
        this.must_bound("The left operand of and operator is an unbound boolean value.");
        other_value.must_bound("The right operand of and operator is an unbound boolean value.");
        return this.boolean_value != false && other_value.boolean_value != false;
    }

    public boolean xor(boolean other_value) {
        this.must_bound("The left operand of xor operator is an unbound boolean value.");
        return this.boolean_value != other_value;
    }

    public boolean xor(TitanBoolean other_value) {
        this.must_bound("The left operand of xor operator is an unbound boolean value.");
        other_value.must_bound("The right operand of xor operator is an unbound boolean value.");
        return this.boolean_value.booleanValue() != other_value.boolean_value.booleanValue();
    }

    public boolean not() {
        this.must_bound("The operand of not operator is an unbound boolean value.");
        return this.boolean_value == false;
    }

    public boolean operator_equals(TitanBoolean otherValue) {
        this.must_bound("The left operand of comparison is an unbound boolean value.");
        otherValue.must_bound("The right operand of comparison is an unbound boolean value.");
        return this.boolean_value.equals(otherValue.boolean_value);
    }

    public boolean operator_equals(boolean otherValue) {
        this.must_bound("The left operand of comparison is an unbound boolean value.");
        return this.boolean_value == otherValue;
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanBoolean) {
            return this.operator_equals((TitanBoolean)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to boolean", otherValue));
    }

    public boolean operator_not_equals(boolean otherValue) {
        this.must_bound("The left operand of comparison is an unbound boolean value.");
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanBoolean otherValue) {
        return !this.operator_equals(otherValue);
    }

    @Override
    public void clean_up() {
        this.boolean_value = null;
    }

    public String toString() {
        if (this.boolean_value == null) {
            return "<unbound>";
        }
        return this.boolean_value.toString();
    }

    @Override
    public void log() {
        if (this.boolean_value != null) {
            TTCN_Logger.log_event_str(this.boolean_value.toString());
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue(), "boolean value");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        if (param.get_type() != Param_Types.Module_Parameter.type_t.MP_Boolean) {
            param.type_error("boolean value");
        }
        this.boolean_value = param.get_boolean();
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.is_bound()) {
            return new Param_Types.Module_Param_Unbound();
        }
        return new Param_Types.Module_Param_Boolean(this.boolean_value);
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.must_bound("Text encoder: Encoding an unbound boolean value.");
        text_buf.push_int(this.boolean_value != false ? 1 : 0);
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        int int_value = text_buf.pull_int().get_int();
        switch (int_value) {
            case 0: {
                this.boolean_value = false;
                break;
            }
            case 1: {
                this.boolean_value = true;
                break;
            }
            default: {
                throw new TtcnError(MessageFormat.format("Text decoder: An invalid boolean value ({0}) was received.", int_value));
            }
        }
    }

    public static boolean get_native(boolean value) {
        return value;
    }

    public static boolean get_native(TitanBoolean value) {
        return value.get_value();
    }

    public static boolean and(boolean bool_value, TitanBoolean other_value) {
        if (!bool_value) {
            return false;
        }
        other_value.must_bound("The right operand of and operator is an unbound boolean value.");
        return other_value.boolean_value;
    }

    public static boolean or(boolean bool_value, TitanBoolean other_value) {
        if (bool_value) {
            return true;
        }
        other_value.must_bound("The right operand of or operator is an unbound boolean value.");
        return other_value.boolean_value;
    }

    public static boolean xor(boolean bool_value, TitanBoolean other_value) {
        other_value.must_bound("The right operand of xor operator is an unbound boolean value.");
        return bool_value != other_value.boolean_value;
    }

    public static boolean operator_equals(boolean boolValue, TitanBoolean otherValue) {
        otherValue.must_bound("The right operand of comparison is an unbound boolean value.");
        return boolValue == otherValue.boolean_value;
    }

    public static boolean operator_not_equals(boolean boolValue, TitanBoolean otherValue) {
        otherValue.must_bound("The right operand of comparison is an unbound boolean value.");
        return new TitanBoolean(boolValue).operator_not_equals(otherValue.boolean_value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    RAW.RAW_enc_tr_pos tree_position = new RAW.RAW_enc_tr_pos(0, null);
                    RAW.RAW_enc_tree root = new RAW.RAW_enc_tree(true, null, tree_position, 1, p_td.raw);
                    this.RAW_encode(p_td, root);
                    root.put_to_buf(p_buf);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-decoding type '%s': ", p_td.name);
                try {
                    TTCN_EncDec.raw_order_t order;
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    TTCN_EncDec.raw_order_t raw_order_t2 = order = p_td.raw.top_bit_order == RAW.top_bit_order_t.TOP_BIT_LEFT ? TTCN_EncDec.raw_order_t.ORDER_LSB : TTCN_EncDec.raw_order_t.ORDER_MSB;
                    if (this.RAW_decode(p_td, p_buf, p_buf.get_len() * 8, order) >= 0) break;
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_ANY, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type `{0}''", p_td.name));
            }
        }
    }

    @Override
    public int RAW_encode(Base_Type.TTCN_Typedescriptor p_td, RAW.RAW_enc_tree myleaf) {
        byte[] bc;
        int tmp;
        int loc_length = p_td.raw.fieldlength != 0 ? p_td.raw.fieldlength : 1;
        int length = (loc_length + 7) / 8;
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound value.", new Object[0]);
            tmp = 0;
        } else {
            int n = tmp = this.boolean_value != false ? -1 : 0;
        }
        if (length > 4) {
            myleaf.data_array = bc = new byte[length];
        } else {
            bc = myleaf.data_array;
        }
        for (int i = 0; i < bc.length; ++i) {
            bc[i] = tmp;
        }
        if (this.boolean_value.booleanValue() && loc_length % 8 != 0) {
            int n = length - 1;
            bc[n] = (byte)(bc[n] & RAW.BitMaskTable[loc_length % 8]);
        }
        myleaf.coding_par.csn1lh = p_td.raw.csn1lh;
        myleaf.length = loc_length;
        return myleaf.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean first_call, RAW.RAW_Force_Omit force_omit) {
        int prepaddlength = buff.increase_pos_padd(p_td.raw.prepadding);
        limit -= prepaddlength;
        int decode_length = p_td.raw.fieldlength > 0 ? p_td.raw.fieldlength : 1;
        TTCN_EncDec_ErrorContext errorcontext = new TTCN_EncDec_ErrorContext();
        try {
            int nof_unread_bits;
            if (decode_length > limit) {
                if (no_err) {
                    int n = -TTCN_EncDec.error_type.ET_LEN_ERR.ordinal();
                    return n;
                }
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There is not enough bits in the buffer to decode type %s (needed: %d, found: %d).", p_td.name, decode_length, limit);
                decode_length = limit;
            }
            if (decode_length > (nof_unread_bits = buff.unread_len_bit())) {
                if (no_err) {
                    int n = -TTCN_EncDec.error_type.ET_INCOMPL_MSG.ordinal();
                    return n;
                }
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "There is not enough bits in the buffer to decode type %s (needed: %d, found: %d).", p_td.name, decode_length, nof_unread_bits);
                decode_length = nof_unread_bits;
            }
            if (decode_length < 0) {
                int n = -1;
                return n;
            }
            if (decode_length == 0) {
                this.boolean_value = false;
            } else {
                boolean orders;
                RAW.RAW_coding_par cp = new RAW.RAW_coding_par();
                boolean bl = orders = p_td.raw.bitorderinoctet == TTCN_EncDec.raw_order_t.ORDER_MSB;
                if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                    orders = !orders;
                }
                cp.bitorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
                boolean bl2 = orders = p_td.raw.byteorder == TTCN_EncDec.raw_order_t.ORDER_MSB;
                if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                    orders = !orders;
                }
                cp.byteorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
                cp.fieldorder = p_td.raw.fieldorder;
                cp.hexorder = TTCN_EncDec.raw_order_t.ORDER_LSB;
                cp.csn1lh = p_td.raw.csn1lh;
                int length = (decode_length + 7) / 8;
                byte[] data = new byte[length];
                buff.get_b(decode_length, data, cp, top_bit_ord);
                if (decode_length % 8 != 0) {
                    int n = length - 1;
                    data[n] = (byte)(data[n] & RAW.BitMaskTable[decode_length % 8]);
                }
                char ch = '\u0000';
                for (int i = 0; i < length; ++i) {
                    ch = (char)(ch | data[i]);
                }
                this.boolean_value = ch != '\u0000';
            }
        }
        finally {
            errorcontext.leave_context();
        }
        return (decode_length += buff.increase_pos_padd(p_td.raw.padding)) + prepaddlength;
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound boolean value.", new Object[0]);
            return -1;
        }
        return p_tok.put_next_token(this.boolean_value != false ? JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_TRUE : JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_FALSE, null);
    }

    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        if (p_td.json.getActualDefaultValue() != null && 0 == p_tok.get_buffer_length()) {
            this.operator_assign(p_td.json.getActualDefaultValue());
            return 0;
        }
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
        int dec_len = p_tok.get_next_token(token, null, null);
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ERROR == token.get()) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Failed to extract valid token, invalid JSON format%s", "");
            }
            return -2;
        }
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_TRUE == token.get()) {
            this.boolean_value = true;
        } else if (JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_FALSE == token.get()) {
            this.boolean_value = false;
        } else {
            return -1;
        }
        return dec_len;
    }
}

