/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanComponent;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanComponent_template
extends Base_Template {
    public static final TitanComponent_template any_compref = new TitanComponent_template(Base_Template.template_sel.ANY_VALUE);
    private int single_value;
    private ArrayList<TitanComponent_template> value_list;

    public TitanComponent_template() {
    }

    public TitanComponent_template(Base_Template.template_sel otherValue) {
        super(otherValue);
        TitanComponent_template.check_single_selection(otherValue);
    }

    public TitanComponent_template(int otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = otherValue;
    }

    public TitanComponent_template(TitanComponent otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound component reference.");
        this.single_value = otherValue.componentValue;
    }

    public TitanComponent_template(Optional<TitanComponent> otherValue) {
        switch (otherValue.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
                this.single_value = otherValue.constGet().componentValue;
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Creating a component reference template from an unbound optional field.");
            }
        }
    }

    public TitanComponent_template(TitanComponent_template otherValue) {
        this.copy_template(otherValue);
    }

    @Override
    public void clean_up() {
        switch (this.template_selection) {
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list.clear();
                this.value_list = null;
                break;
            }
        }
        this.template_selection = Base_Template.template_sel.UNINITIALIZED_TEMPLATE;
    }

    private void copy_template(TitanComponent_template otherValue) {
        switch (otherValue.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = otherValue.single_value;
                break;
            }
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list = new ArrayList(otherValue.value_list.size());
                for (int i = 0; i < otherValue.value_list.size(); ++i) {
                    TitanComponent_template temp = new TitanComponent_template(otherValue.value_list.get(i));
                    this.value_list.add(temp);
                }
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported component reference template.");
            }
        }
        this.set_selection(otherValue);
    }

    @Override
    public TitanComponent_template operator_assign(Base_Template.template_sel otherValue) {
        TitanComponent_template.check_single_selection(otherValue);
        this.clean_up();
        this.set_selection(otherValue);
        return this;
    }

    @Override
    public TitanComponent_template operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanComponent) {
            return this.operator_assign((TitanComponent)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to component reference", otherValue));
    }

    @Override
    public TitanComponent_template operator_assign(Base_Template otherValue) {
        if (otherValue instanceof TitanComponent_template) {
            return this.operator_assign((TitanComponent_template)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to component reference template", otherValue));
    }

    @Override
    public void log_match(Base_Type match_value, boolean legacy) {
        if (match_value instanceof TitanComponent) {
            this.log_match((TitanComponent)match_value, legacy);
            return;
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to component", match_value));
    }

    public TitanComponent_template operator_assign(int otherValue) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = otherValue;
        return this;
    }

    public TitanComponent_template operator_assign(TitanComponent otherValue) {
        otherValue.must_bound("Assignment of an unbound component reference to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = otherValue.componentValue;
        return this;
    }

    public TitanComponent_template operator_assign(TitanComponent_template otherValue) {
        if (otherValue != this) {
            this.clean_up();
            this.copy_template(otherValue);
        }
        return this;
    }

    @Override
    public boolean match(Base_Type otherValue, boolean legacy) {
        if (otherValue instanceof TitanComponent) {
            return this.match((TitanComponent)otherValue, legacy);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to charstring", otherValue));
    }

    public boolean match(TitanComponent otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(TitanComponent otherValue, boolean legacy) {
        otherValue.must_bound("Matching an unbound component reference with a template.");
        return this.match(otherValue.componentValue, legacy);
    }

    public boolean match(int otherValue, boolean legacy) {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                return this.single_value == otherValue;
            }
            case OMIT_VALUE: {
                return false;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (!this.value_list.get(i).match(otherValue, legacy)) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
        }
        throw new TtcnError("Matching with an uninitialized/unsupported component reference template.");
    }

    @Override
    public TitanComponent valueof() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Performing a valueof or send operation on a non-specific component reference template.");
        }
        return new TitanComponent(this.single_value);
    }

    @Override
    public boolean match_omit(boolean legacy) {
        if (this.is_ifPresent) {
            return true;
        }
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                if (legacy) {
                    for (int i = 0; i < this.value_list.size(); ++i) {
                        if (!this.value_list.get(i).match_omit()) continue;
                        return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                    }
                    return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void set_type(Base_Template.template_sel template_type, int list_length) {
        if (template_type != Base_Template.template_sel.VALUE_LIST && template_type != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Setting an invalid list type for a component reference template.");
        }
        this.clean_up();
        this.set_selection(template_type);
        this.value_list = new ArrayList(list_length);
        for (int i = 0; i < list_length; ++i) {
            this.value_list.add(new TitanComponent_template());
        }
    }

    @Override
    public int n_list_elem() {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list component reference template.");
        }
        return this.value_list.size();
    }

    @Override
    public TitanComponent_template list_item(int list_index) {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list component reference template.");
        }
        if (list_index >= this.value_list.size()) {
            throw new TtcnError("Index overflow in a component reference value list template.");
        }
        return this.value_list.get(list_index);
    }

    @Override
    public void log() {
        block0 : switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                switch (this.single_value) {
                    case 0: {
                        TTCN_Logger.log_event_str("null");
                        break block0;
                    }
                    case 1: {
                        TTCN_Logger.log_event_str("mtc");
                        break block0;
                    }
                    case 2: {
                        TTCN_Logger.log_event_str("system");
                        break block0;
                    }
                }
                TTCN_Logger.log_event("%d", this.single_value);
                break;
            }
            case COMPLEMENTED_LIST: {
                TTCN_Logger.log_event_str("complement");
            }
            case VALUE_LIST: {
                TTCN_Logger.log_char('(');
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (i > 0) {
                        TTCN_Logger.log_event_str(", ");
                    }
                    this.value_list.get(i).log();
                }
                TTCN_Logger.log_char(')');
                break;
            }
            default: {
                this.log_generic();
            }
        }
        this.log_ifpresent();
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_TEMPLATE.getValue(), "component reference (integer or null) template");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        switch (param.get_type()) {
            case MP_Omit: {
                this.operator_assign(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case MP_Any: {
                this.operator_assign(Base_Template.template_sel.ANY_VALUE);
                break;
            }
            case MP_AnyOrNone: {
                this.operator_assign(Base_Template.template_sel.ANY_OR_OMIT);
                break;
            }
            case MP_List_Template: 
            case MP_ComplementList_Template: {
                TitanComponent_template temp = new TitanComponent_template();
                temp.set_type(param.get_type() == Param_Types.Module_Parameter.type_t.MP_List_Template ? Base_Template.template_sel.VALUE_LIST : Base_Template.template_sel.COMPLEMENTED_LIST, param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    temp.list_item(i).set_param(param.get_elem(i));
                }
                this.operator_assign(temp);
                break;
            }
            case MP_Integer: {
                this.operator_assign(param.get_integer());
                break;
            }
            case MP_Ttcn_Null: {
                this.operator_assign(0);
                break;
            }
            case MP_Ttcn_mtc: {
                this.operator_assign(1);
                break;
            }
            case MP_Ttcn_system: {
                this.operator_assign(2);
                break;
            }
            default: {
                param.type_error("component reference (integer or null) template");
            }
        }
        this.is_ifPresent = param.get_ifpresent();
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        Param_Types.Module_Parameter mp = null;
        block0 : switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                mp = new Param_Types.Module_Param_Unbound();
                break;
            }
            case OMIT_VALUE: {
                mp = new Param_Types.Module_Param_Omit();
                break;
            }
            case ANY_VALUE: {
                mp = new Param_Types.Module_Param_Any();
                break;
            }
            case ANY_OR_OMIT: {
                mp = new Param_Types.Module_Param_AnyOrNone();
                break;
            }
            case SPECIFIC_VALUE: {
                switch (this.single_value) {
                    case 0: {
                        mp = new Param_Types.Module_Param_Ttcn_Null();
                        break block0;
                    }
                    case 1: {
                        mp = new Param_Types.Module_Param_Ttcn_mtc();
                        break block0;
                    }
                    case 2: {
                        mp = new Param_Types.Module_Param_Ttcn_system();
                        break block0;
                    }
                }
                mp = new Param_Types.Module_Param_Integer(new TitanInteger(this.single_value));
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                mp = this.template_selection == Base_Template.template_sel.VALUE_LIST ? new Param_Types.Module_Param_List_Template() : new Param_Types.Module_Param_ComplementList_Template();
                for (int i = 0; i < this.value_list.size(); ++i) {
                    mp.add_elem(this.value_list.get(i).get_param(param_name));
                }
                break;
            }
            default: {
                throw new TtcnError("Referencing an uninitialized/unsupported component reference template.");
            }
        }
        if (this.is_ifPresent) {
            mp.set_ifpresent();
        }
        return mp;
    }

    public void log_match(TitanComponent match_value, boolean legacy) {
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity() && TTCN_Logger.get_logmatch_buffer_len() != 0) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event_str(" := ");
        }
        match_value.log();
        TTCN_Logger.log_event_str(" with ");
        this.log();
        if (this.match(match_value)) {
            TTCN_Logger.log_event_str(" matched");
        } else {
            TTCN_Logger.log_event_str(" unmatched");
        }
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.encode_text_base(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                text_buf.push_int(this.single_value);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                text_buf.push_int(this.value_list.size());
                for (int i = 0; i < this.value_list.size(); ++i) {
                    this.value_list.get(i).encode_text(text_buf);
                }
                break;
            }
            default: {
                throw new TtcnError("Text encoder: Encoding an uninitialized/unsupported component reference template.");
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.decode_text_base(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value = text_buf.pull_int().get_int();
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                int size = text_buf.pull_int().get_int();
                this.value_list = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    TitanComponent_template temp = new TitanComponent_template();
                    temp.decode_text(text_buf);
                    this.value_list.add(temp);
                }
                break;
            }
            default: {
                throw new TtcnError("Text decoder: An unknown/unsupported selection was received for a component reference template.");
            }
        }
    }

    @Override
    public void check_restriction(Base_Template.template_res restriction, String name, boolean legacy) {
        if (this.template_selection == Base_Template.template_sel.UNINITIALIZED_TEMPLATE) {
            return;
        }
        switch (name != null && restriction == Base_Template.template_res.TR_VALUE ? Base_Template.template_res.TR_OMIT : restriction) {
            case TR_VALUE: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_OMIT: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.OMIT_VALUE && this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_PRESENT: {
                if (this.match_omit(legacy)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new TtcnError(MessageFormat.format("Restriction `{0}'' on template of type {1} violated.", TitanComponent_template.get_res_name(restriction), name == null ? "component reference" : name));
    }
}

