/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core.cfgparser;

public class CfgPreprocessorUtils {
    static String get_macro_id_from_ref(String str) {
        if (str != null && str.charAt(0) == '$' && str.charAt(1) == '{') {
            StringBuilder sb = new StringBuilder();
            int i = 2;
            char charat_i = str.charAt(i);
            while (charat_i == ' ' || charat_i == '\t') {
                charat_i = str.charAt(++i);
            }
            if (charat_i >= 'A' && charat_i <= 'Z' || charat_i >= 'a' && charat_i <= 'z') {
                do {
                    sb.append(charat_i);
                } while ((charat_i = str.charAt(++i)) >= 'A' && charat_i <= 'Z' || charat_i >= 'a' && charat_i <= 'z' || charat_i >= '0' && charat_i <= '9' || str.charAt(i) == '_');
                if (charat_i != ' ' && charat_i != '\t' && charat_i != ',' && charat_i != '}') {
                    return null;
                }
            }
            return sb.toString();
        }
        return null;
    }

    static boolean string_is_int(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return false;
        }
        int_state state = int_state.INITIAL;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (state) {
                case INITIAL: {
                    if (c == '+' || c == '-') {
                        state = int_state.FIRST;
                        break;
                    }
                    if (c == '0') {
                        state = int_state.ZERO;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        state = int_state.MORE;
                        break;
                    }
                    state = int_state.ERR;
                    break;
                }
                case FIRST: {
                    if (c == '0') {
                        state = int_state.ZERO;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        state = int_state.MORE;
                        break;
                    }
                    state = int_state.ERR;
                    break;
                }
                case ZERO: {
                    if (c >= '0' && c <= '9') {
                        state = int_state.MORE;
                        break;
                    }
                    state = int_state.ERR;
                    break;
                }
                case MORE: {
                    if (c >= '0' && c <= '9') break;
                    state = int_state.ERR;
                }
            }
            if (state != int_state.ERR) continue;
            return false;
        }
        return state == int_state.ZERO || state == int_state.MORE;
    }

    static boolean string_is_float(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return false;
        }
        float_state state = float_state.INITIAL;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (state) {
                case INITIAL: {
                    if (c == '+' || c == '-') {
                        state = float_state.FIRST_M;
                        break;
                    }
                    if (c == '0') {
                        state = float_state.ZERO_M;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        state = float_state.MORE_M;
                        break;
                    }
                    state = float_state.ERR;
                    break;
                }
                case FIRST_M: {
                    if (c == '0') {
                        state = float_state.ZERO_M;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        state = float_state.MORE_M;
                        break;
                    }
                    state = float_state.ERR;
                    break;
                }
                case ZERO_M: {
                    if (c == '.') {
                        state = float_state.FIRST_F;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        state = float_state.INITIAL_E;
                        break;
                    }
                    if (c >= '0' && c <= '9') {
                        state = float_state.MORE_M;
                        break;
                    }
                    state = float_state.ERR;
                    break;
                }
                case MORE_M: {
                    if (c == '.') {
                        state = float_state.FIRST_F;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        state = float_state.INITIAL_E;
                        break;
                    }
                    if (c >= '0' && c <= '9') break;
                    state = float_state.ERR;
                    break;
                }
                case FIRST_F: {
                    if (c >= '0' && c <= '9') {
                        state = float_state.MORE_F;
                        break;
                    }
                    state = float_state.ERR;
                    break;
                }
                case MORE_F: {
                    if (c == 'E' || c == 'e') {
                        state = float_state.INITIAL_E;
                        break;
                    }
                    if (c >= '0' && c <= '9') break;
                    state = float_state.ERR;
                    break;
                }
                case INITIAL_E: {
                    if (c == '+' || c == '-') {
                        state = float_state.FIRST_E;
                        break;
                    }
                    if (c == '0') {
                        state = float_state.ZERO_E;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        state = float_state.MORE_E;
                        break;
                    }
                    state = float_state.ERR;
                    break;
                }
                case FIRST_E: {
                    if (c == '0') {
                        state = float_state.ZERO_E;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        state = float_state.MORE_E;
                        break;
                    }
                    state = float_state.ERR;
                    break;
                }
                case ZERO_E: {
                    if (c >= '0' && c <= '9') {
                        state = float_state.MORE_E;
                        break;
                    }
                    state = float_state.ERR;
                    break;
                }
                case MORE_E: {
                    if (c >= '0' && c <= '9') break;
                    state = float_state.ERR;
                }
            }
            if (state != float_state.ERR) continue;
            return false;
        }
        return state == float_state.MORE_F || state == float_state.ZERO_E || state == float_state.MORE_E || state == float_state.ZERO_M || state == float_state.MORE_M;
    }

    static boolean string_is_id(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return false;
        }
        char first_char = str.charAt(0);
        if (!(first_char >= 'a' && first_char <= 'z' || first_char >= 'A' && first_char <= 'Z')) {
            return false;
        }
        boolean has_hyphen = false;
        boolean has_underscore = false;
        for (int i = 1; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            if (c == '_') {
                if (has_hyphen) {
                    return false;
                }
                has_underscore = true;
                continue;
            }
            if (c == '-') {
                if (has_underscore || str.charAt(i - 1) == '-' || i == len - 1 || first_char < 'a' || first_char > 'z') {
                    return false;
                }
                has_hyphen = true;
                continue;
            }
            return false;
        }
        return true;
    }

    static boolean string_is_bstr(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '0' || c == '1') continue;
            return false;
        }
        return true;
    }

    static boolean string_is_hstr(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            return false;
        }
        return true;
    }

    static boolean string_is_ostr(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return false;
        }
        if (len % 2 != 0) {
            return false;
        }
        return CfgPreprocessorUtils.string_is_hstr(str);
    }

    static boolean string_is_hostname(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return false;
        }
        string_state state = string_state.INITIAL;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                state = string_state.ALPHANUM;
                continue;
            }
            if (c == '.') {
                if (state == string_state.ALPHANUM) {
                    state = string_state.DOT;
                    continue;
                }
                return false;
            }
            if (c == ':') {
                if (state == string_state.INITIAL || state == string_state.ALPHANUM || state == string_state.COLON) {
                    state = string_state.COLON;
                    continue;
                }
                return false;
            }
            if (c == '%') {
                if (state == string_state.ALPHANUM) {
                    state = string_state.PERCENT;
                    continue;
                }
                return false;
            }
            if (c == '-' || c == '_') {
                if (state == string_state.INITIAL || state == string_state.DOT || state == string_state.COLON || state == string_state.PERCENT) {
                    return false;
                }
                state = string_state.DASH;
                continue;
            }
            return false;
        }
        return state == string_state.ALPHANUM || state == string_state.DOT;
    }

    public static boolean string_is_bool(String typedMacroValue) {
        if ("true".equals(typedMacroValue)) {
            return true;
        }
        return "false".equals(typedMacroValue);
    }

    private static enum string_state {
        INITIAL,
        ALPHANUM,
        DOT,
        DASH,
        COLON,
        PERCENT;

    }

    private static enum float_state {
        INITIAL,
        FIRST_M,
        ZERO_M,
        MORE_M,
        FIRST_F,
        MORE_F,
        INITIAL_E,
        FIRST_E,
        ZERO_E,
        MORE_E,
        ERR;

    }

    private static enum int_state {
        INITIAL,
        FIRST,
        ZERO,
        MORE,
        ERR;

    }
}

