/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.tuple.primitive;

import org.eclipse.collections.api.tuple.primitive.ByteDoublePair;

public class ByteDoublePairImpl
implements ByteDoublePair {
    private static final long serialVersionUID = 1L;
    private final byte one;
    private final double two;

    ByteDoublePairImpl(byte newOne, double newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    @Override
    public byte getOne() {
        return this.one;
    }

    @Override
    public double getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteDoublePair)) {
            return false;
        }
        ByteDoublePair that = (ByteDoublePair)o;
        return this.one == that.getOne() && Double.compare(this.two, that.getTwo()) == 0;
    }

    public int hashCode() {
        return 29 * this.one + (int)(Double.doubleToLongBits(this.two) ^ Double.doubleToLongBits(this.two) >>> 32);
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    @Override
    public int compareTo(ByteDoublePair that) {
        int i = this.one - that.getOne();
        if (i != 0) {
            return i;
        }
        return Double.compare(this.two, that.getTwo());
    }
}

