/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.properties;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.titan.common.logging.ErrorReporter;

public final class PropertyStore
extends PreferenceStore {
    private final IResource resource;
    private final IPreferenceStore workbenchStore;
    private final String pageId;
    private boolean inserting = false;

    public PropertyStore(IResource resource, IPreferenceStore workbenchStore, String pageId) {
        this.resource = resource;
        this.workbenchStore = workbenchStore;
        this.pageId = pageId;
    }

    public void save() throws IOException {
        this.writeProperties();
    }

    public void save(OutputStream out, String header) throws IOException {
        this.writeProperties();
    }

    private void writeProperties() {
        String[] preferences;
        for (String name : preferences = super.preferenceNames()) {
            try {
                this.setProperty(name, this.getString(name));
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
    }

    private void setProperty(String name, String value) throws CoreException {
        this.resource.setPersistentProperty(new QualifiedName(this.pageId, name), value);
    }

    public boolean getDefaultBoolean(String name) {
        return this.workbenchStore.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.workbenchStore.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.workbenchStore.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.workbenchStore.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.workbenchStore.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.workbenchStore.getDefaultString(name);
    }

    public boolean getBoolean(String name) {
        this.insertValue(name);
        return super.getBoolean(name);
    }

    public double getDouble(String name) {
        this.insertValue(name);
        return super.getDouble(name);
    }

    public float getFloat(String name) {
        this.insertValue(name);
        return super.getFloat(name);
    }

    public int getInt(String name) {
        this.insertValue(name);
        return super.getInt(name);
    }

    public long getLong(String name) {
        this.insertValue(name);
        return super.getLong(name);
    }

    public String getString(String name) {
        this.insertValue(name);
        return super.getString(name);
    }

    private synchronized void insertValue(String name) {
        if (this.inserting) {
            return;
        }
        if (super.contains(name)) {
            return;
        }
        this.inserting = true;
        String prop = null;
        try {
            prop = this.getProperty(name);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        if (prop == null) {
            prop = this.workbenchStore.getString(name);
        }
        if (prop != null) {
            this.setValue(name, prop);
        }
        this.inserting = false;
    }

    private String getProperty(String name) throws CoreException {
        return this.resource.getPersistentProperty(new QualifiedName(this.pageId, name));
    }

    public boolean contains(String name) {
        return this.workbenchStore.contains(name);
    }

    public void setToDefault(String name) {
        this.setValue(name, this.getDefaultString(name));
    }

    public boolean isDefault(String name) {
        String defaultValue = this.getDefaultString(name);
        if (defaultValue == null) {
            return false;
        }
        return defaultValue.equals(this.getString(name));
    }
}

