/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.actions.ExtractTestCasesAction;
import org.eclipse.titan.log.viewer.console.ConsoleWriter;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.utils.SelectionUtils;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExtractTestCasesMenuAction
extends AbstractHandler
implements IActionDelegate {
    private ISelection selection;

    private void run(ISelection selection) {
        if (selection == null) {
            return;
        }
        if (!SelectionUtils.isSelectionALogFile(selection)) {
            return;
        }
        final IFile logFile = SelectionUtils.selectionToIFile(selection);
        try {
            Object temp = logFile.getSessionProperty(Constants.EXTRACTION_RUNNING);
            if (temp != null && ((Boolean)temp).booleanValue()) {
                return;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        WorkspaceJob op = new WorkspaceJob("Testcase extraction from logfile " + logFile.getProjectRelativePath().toString()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                final ExtractTestCasesAction extractTestCasesAction = new ExtractTestCasesAction(logFile);
                try {
                    final long start = System.currentTimeMillis();
                    extractTestCasesAction.run(monitor);
                    final long stop = System.currentTimeMillis();
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            int numTestCases = extractTestCasesAction.getTestCases().size();
                            String projectName = logFile.getProject().getName();
                            ConsoleWriter.getInstance().writeToConsole(Messages.getString("ExtractTestCasesAction.3") + numTestCases + Messages.getString("ExtractTestCasesAction.1") + logFile.getName() + Messages.getString("ExtractTestCasesAction.2") + (double)(stop - start) / 1000.0 + Messages.getString("ExtractTestCasesAction.4"), projectName);
                            ConsoleWriter.getInstance().writeToConsole("", projectName);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                    TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenWithLogViewer.2") + e.getTargetException().getMessage()));
                }
                catch (InterruptedException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                    TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenWithLogViewer.3") + e.getMessage()));
                }
                return Status.OK_STATUS;
            }
        };
        op.setPriority(30);
        op.setUser(true);
        op.setRule((ISchedulingRule)logFile.getProject());
        op.schedule();
    }

    public void run(IAction action) {
        this.run(this.selection);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.run(this.selection);
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.selection = (IStructuredSelection)selection;
        this.setEnabled(SelectionUtils.isSelectionALogFile(this.selection));
    }
}

