/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.log.merge;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.log.merge.LogRecord;
import org.eclipse.titan.common.log.merge.TimestampFormat;
import org.eclipse.titan.common.logging.ErrorReporter;

final class MergeAble
implements Closeable {
    private static final Pattern UNIFIEDPATTERN = Pattern.compile("(\\d\\d\\d\\d/\\w*/\\d\\d )?(\\d\\d:\\d\\d:\\d)?\\d\\.\\d\\d\\d\\d\\d\\d");
    private final IFile file;
    private final BufferedReader reader;
    private final boolean fast;
    private StringBuilder unprocessedPart = new StringBuilder(65536);
    private String line;
    private LogRecord actualRecord = null;
    private boolean hasMore = true;
    private TimestampFormat selfFormat;
    private boolean erroneous = false;
    private String componentID = "";

    public MergeAble(IFile file, BufferedReader reader, boolean fast) {
        this.file = file;
        this.reader = reader;
        this.fast = fast;
        this.componentID = this.getComponentID(file.getName());
        try {
            this.line = reader.readLine();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace("Read problem while processing file:" + file.getName(), e);
            this.erroneous = true;
            return;
        }
        this.unprocessedPart.append(this.line).append('\n');
        Matcher m = UNIFIEDPATTERN.matcher(this.unprocessedPart);
        if (m.find()) {
            String timestamp = this.unprocessedPart.substring(m.start(), m.end());
            if (TimestampFormat.DATETIME_FORMAT.getPattern().matcher(timestamp).matches()) {
                this.selfFormat = TimestampFormat.DATETIME_FORMAT;
            } else if (TimestampFormat.TIME_FORMAT.getPattern().matcher(timestamp).matches()) {
                this.selfFormat = TimestampFormat.TIME_FORMAT;
            } else if (TimestampFormat.SECOND_FORMAT.getPattern().matcher(timestamp).matches()) {
                this.selfFormat = TimestampFormat.SECOND_FORMAT;
            } else {
                ErrorReporter.logError("Could not recognise the timestamp in the file '" + file.getLocation().toOSString() + "'");
                this.erroneous = true;
                return;
            }
            this.next();
        } else {
            ErrorReporter.logError("Could not find the timestamp in the file '" + file.getLocation().toOSString() + "'");
            this.erroneous = true;
            this.hasMore = false;
        }
    }

    private String getComponentID(String fileName) {
        int idStart = 0;
        int idEnd = fileName.length() - 1;
        int dashLoc = fileName.lastIndexOf(45);
        if (dashLoc == -1) {
            int temp = fileName.lastIndexOf(46);
            if (temp != -1) {
                idEnd = temp;
            }
            if ((temp = fileName.lastIndexOf(46, idEnd - 1)) != -1) {
                idStart = temp + 1;
            }
        } else {
            idStart = dashLoc + 1;
            int temp = fileName.indexOf(46, dashLoc);
            if (temp != -1) {
                idEnd = temp;
            }
        }
        return fileName.substring(idStart, idEnd);
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace("Problem while closing " + this.file.getLocationURI(), e);
            this.erroneous = true;
        }
        this.hasMore = false;
    }

    public TimestampFormat getTimestampFormat() {
        return this.selfFormat;
    }

    public boolean hasNext() {
        return this.hasMore;
    }

    public boolean isErroneous() {
        return this.erroneous;
    }

    public void next() {
        if (!this.hasMore) {
            return;
        }
        if (this.unprocessedPart.length() == 0) {
            this.hasMore = false;
            return;
        }
        Matcher m = this.selfFormat.getPattern().matcher(this.unprocessedPart);
        if (!m.find()) {
            ErrorReporter.logError("Could not find the timestamp in the file '" + this.file.getLocation().toOSString() + "'");
            this.erroneous = true;
            this.hasMore = false;
            return;
        }
        String timestamp = this.unprocessedPart.substring(m.start(), m.end());
        this.processLines(m, timestamp);
    }

    private void processLines(Matcher m, String timestamp) {
        int end;
        String text = null;
        boolean found = false;
        int n = end = this.fast ? this.unprocessedPart.length() : m.end();
        if (m.find(end)) {
            found = true;
            this.hasMore = true;
            text = this.unprocessedPart.substring(0, m.start());
            this.unprocessedPart.delete(0, m.start());
        }
        while (this.line != null && !found) {
            this.readLine();
            if (this.line == null) {
                text = this.unprocessedPart.toString();
                continue;
            }
            this.unprocessedPart.append(this.line).append('\n');
            if (m.find(end)) {
                found = true;
                this.hasMore = true;
                text = this.unprocessedPart.substring(0, m.start());
                this.unprocessedPart.delete(0, m.start());
                continue;
            }
            end = this.fast ? this.unprocessedPart.length() : this.unprocessedPart.length() - this.selfFormat.getFormatSize();
        }
        if (!found && this.unprocessedPart.length() > 0) {
            text = this.unprocessedPart.toString();
            this.unprocessedPart = new StringBuilder();
        }
        this.actualRecord = new LogRecord(timestamp, text);
    }

    private void readLine() {
        try {
            this.line = this.reader.readLine();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace("Problem while reading " + this.file.getLocationURI(), e);
            this.erroneous = true;
            this.line = null;
        }
    }

    public void remove() {
    }

    public LogRecord getActualRecord() {
        return this.actualRecord;
    }

    public String getComponentID() {
        return this.componentID;
    }

    public void setComponentID(String componentID) {
        this.componentID = componentID;
    }

    public IFile getFile() {
        return this.file;
    }
}

