/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers;

public class CharstringExtractor {
    private static final String INVALID_ESCAPE_SEQUENCE = "Invalid escape sequence: ";
    private boolean mErroneous = false;
    private final String mExtractedString;
    private String mErrorMessage;

    public CharstringExtractor(String aTtcnCharstring, boolean removeQuotes) {
        if (aTtcnCharstring == null) {
            this.mExtractedString = null;
        } else {
            String withoutQuotes = removeQuotes ? aTtcnCharstring.replaceAll("^\"|\"$", "") : aTtcnCharstring;
            this.mExtractedString = this.extractString(withoutQuotes);
        }
    }

    public CharstringExtractor(String aTtcnCharstring) {
        this(aTtcnCharstring, true);
    }

    public String getExtractedString() {
        return this.mExtractedString;
    }

    public boolean isErroneous() {
        return this.mErroneous;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    private String extractString(String aTtcnCharstring) {
        if (aTtcnCharstring.equals("\"\"")) {
            return aTtcnCharstring;
        }
        int slength = aTtcnCharstring.length();
        int pointer = 0;
        StringBuilder sb = new StringBuilder();
        while (pointer < slength) {
            if (pointer + 1 < slength && aTtcnCharstring.substring(pointer, pointer + 2).equals("\"\"")) {
                sb.append('\"');
                pointer += 2;
                continue;
            }
            if (pointer + 1 < slength) {
                char c1 = aTtcnCharstring.charAt(pointer);
                if (c1 == '\\') {
                    char c2;
                    if ((c2 = aTtcnCharstring.charAt(++pointer)) == '\'' || c2 == '\"' || c2 == '?' || c2 == '\\') {
                        sb.append(c2);
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'a') {
                        sb.append('\u0007');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'b') {
                        sb.append('\b');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'f') {
                        sb.append('\f');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'n') {
                        sb.append('\n');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'r') {
                        sb.append('\r');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 't') {
                        sb.append('\t');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'v') {
                        sb.append('\u000b');
                        ++pointer;
                        continue;
                    }
                    if (c2 == '\n') {
                        sb.append('\n');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'x') {
                        if (++pointer >= slength) {
                            this.mErrorMessage = "Invalid escape sequence: '\\x'";
                            this.mErroneous = true;
                            return null;
                        }
                        int hexStart = pointer;
                        if (!CharstringExtractor.isHexDigit(aTtcnCharstring.charAt(pointer))) {
                            this.mErrorMessage = "Invalid escape sequence: '\\x" + aTtcnCharstring.charAt(hexStart) + "'";
                            this.mErroneous = true;
                            return null;
                        }
                        if (++pointer < slength && CharstringExtractor.isHexDigit(aTtcnCharstring.charAt(pointer))) {
                            ++pointer;
                        }
                        sb.append((char)Integer.parseInt(aTtcnCharstring.substring(hexStart, pointer), 16));
                        continue;
                    }
                    if (CharstringExtractor.isOctDigit(c2)) {
                        int octStart = pointer++;
                        while (pointer < slength && pointer - octStart < 3 && CharstringExtractor.isOctDigit(aTtcnCharstring.charAt(pointer))) {
                            ++pointer;
                        }
                        int octInt = Integer.parseInt(aTtcnCharstring.substring(octStart, pointer), 8);
                        if (octInt > 255) {
                            this.mErrorMessage = "Invalid escape sequence: '\\" + aTtcnCharstring.substring(octStart, pointer) + "'";
                            this.mErroneous = true;
                            return null;
                        }
                        sb.append((char)octInt);
                        continue;
                    }
                    sb.append('\\');
                    sb.append(c2);
                    ++pointer;
                    continue;
                }
                sb.append(c1);
                ++pointer;
                continue;
            }
            sb.append(aTtcnCharstring.charAt(pointer));
            ++pointer;
        }
        return sb.toString();
    }

    private static boolean isHexDigit(char aChar) {
        return aChar >= '0' && aChar <= '9' || aChar >= 'a' && aChar <= 'f' || aChar >= 'A' && aChar <= 'F';
    }

    private static boolean isOctDigit(char aChar) {
        return aChar >= '0' && aChar <= '7';
    }
}

