/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class Utils {
    private static final String SOURCE_DIR = "src";

    private Utils() {
    }

    public static TTCN3Editor getActiveEditor() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editor instanceof TTCN3Editor)) {
            return null;
        }
        return (TTCN3Editor)editor;
    }

    public static IFile getSelectedFileInEditor(String refactoringName) {
        TTCN3Editor targetEditor = Utils.getActiveEditor();
        if (targetEditor == null) {
            ErrorReporter.logError((String)("Utils.getSelectedFileInEditor(): No TTCN3Editor available, during refactoring: " + refactoringName));
            return null;
        }
        return Utils.extractFile((IEditorPart)targetEditor, refactoringName);
    }

    private static IFile extractFile(IEditorPart editor, String refactoringName) {
        IEditorInput input = editor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            TITANDebugConsole.println((String[])new String[]{"Utils.extractFile() during refactoring " + refactoringName + ": IEditorInput is not an IFileEditorInput. "});
            return null;
        }
        return ((IFileEditorInput)input).getFile();
    }

    public static void updateASTForProjectActiveInEditor(String refactoringName) {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart == null || !(editorPart instanceof TTCN3Editor)) {
            TITANDebugConsole.println((String[])new String[]{"Utils.updateASTForProjectActiveInEditor() during refactoring " + refactoringName + ": Only for TTCN3 editors!"});
            return;
        }
        TTCN3Editor editor = (TTCN3Editor)editorPart;
        IFile selFile = Utils.extractFile((IEditorPart)editor, refactoringName);
        if (selFile == null) {
            return;
        }
        IProject selProject = selFile.getProject();
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)selProject);
        WorkspaceJob job = projectSourceParser.reportOutdating(selFile);
        if (job == null) {
            TITANDebugConsole.println((String[])new String[]{"Utils.updateASTForProjectActiveInEditor() during refactoring " + refactoringName + ": WorkspaceJob to report outdating could not be created for project: " + selProject});
            return;
        }
        try {
            job.join();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return;
        }
        job = projectSourceParser.analyzeAll();
        if (job == null) {
            TITANDebugConsole.println((String[])new String[]{"Utils.updateASTForProjectActiveInEditor() during refactoring " + refactoringName + ": WorkspaceJob to reanalyze project could not be created for project: " + selProject});
            return;
        }
        try {
            job.join();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return;
        }
    }

    public static void updateASTBeforeRefactoring(Set<IProject> projsToUpdate, String name) {
        UpdateASTOp updateAST = new UpdateASTOp(projsToUpdate, name);
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(null);
        try {
            pmd.run(true, true, (IRunnableWithProgress)updateAST);
        }
        catch (InvocationTargetException ite) {
            ErrorReporter.logExceptionStackTrace((String)("Utils.updateASTBeforeRefactoring(): Error while updating AST before using the refactoring: " + name), (Throwable)ite);
        }
        catch (InterruptedException ie) {
            ErrorReporter.logExceptionStackTrace((String)("Utils.updateASTBeforeRefactoring(): Error while updating AST before using the refactoring: " + name), (Throwable)ie);
            return;
        }
    }

    public static void updateASTAfterRefactoring(RefactoringWizard wiz, Object[] affectedObjects, String refactoringName) {
        if (wiz.getChange() == null || wiz.getChange().getAffectedObjects() == null) {
            return;
        }
        if (wiz.getChange().getAffectedObjects().length != 0) {
            return;
        }
        if (affectedObjects == null) {
            return;
        }
        HashMap affectedProjects = new HashMap();
        for (Object o : affectedObjects) {
            if (o instanceof IFile) {
                IFile f = (IFile)o;
                IProject pr = f.getProject();
                GlobalParser.getProjectSourceParser((IProject)pr).reportOutdating(f);
                List fs = (List)affectedProjects.get(pr);
                if (fs == null) {
                    ArrayList<IFile> newFs = new ArrayList<IFile>();
                    newFs.add(f);
                    affectedProjects.put(pr, newFs);
                    continue;
                }
                fs.add(f);
                continue;
            }
            ErrorReporter.logWarning((String)("Utils.updateASTAfterRefactoring(): " + refactoringName + " -> An affected object is not an IFile " + o));
        }
        for (Map.Entry entry : affectedProjects.entrySet()) {
            IProject pr = (IProject)entry.getKey();
            List fs = (List)entry.getValue();
            ProjectSourceParser psp = GlobalParser.getProjectSourceParser((IProject)pr);
            for (IFile f : fs) {
                psp.reportOutdating(f);
            }
            psp.analyzeAll();
        }
    }

    public static Set<IProject> findAllProjectsInSelection(IStructuredSelection ssel) {
        HashSet<IProject> projs = new HashSet<IProject>();
        if (ssel == null) {
            return projs;
        }
        for (Object o : ssel) {
            if (!(o instanceof IResource)) continue;
            if (o instanceof IProject) {
                projs.add((IProject)o);
                continue;
            }
            IResource res = (IResource)o;
            projs.add(res.getProject());
        }
        return projs;
    }

    public static String createLocationString(IVisitableNode node) {
        if (node == null) {
            return "<null node>";
        }
        if (!(node instanceof ILocateableNode)) {
            return "<no location info>";
        }
        StringBuilder sb = new StringBuilder();
        ILocateableNode lnode = (ILocateableNode)node;
        Location location = lnode.getLocation();
        sb.append(' ').append(location.getOffset()).append('-').append(location.getEndOffset());
        sb.append(" in file ").append(location.getFile().getName()).append(':');
        sb.append(location.getLine()).append(' ');
        return sb.toString();
    }

    public static boolean createProject(final IProjectDescription description, final IProject projectHandle) throws CoreException {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                projectHandle.create(description, null);
                projectHandle.open(128, null);
                projectHandle.refreshLocal(1, null);
                String sourceFolder = Utils.SOURCE_DIR;
                IFolder folder = projectHandle.getFolder(sourceFolder);
                if (!folder.exists()) {
                    try {
                        folder.create(true, true, null);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    }
                }
                projectHandle.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateMakefile"), "true");
                projectHandle.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "TTCN3preprocessor"), "cpp");
                projectHandle.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "C/C++ compiler"), "g++");
            }
        };
        try {
            op.run(null);
        }
        catch (InterruptedException e) {
            ErrorReporter.logError((String)("Project creation was interupted: " + description.getName()));
            return false;
        }
        catch (InvocationTargetException e) {
            ErrorReporter.logError((String)("Project creation was unsuccessful: " + description.getName()));
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return false;
        }
        return true;
    }

    public static class DebugVisitor
    extends ASTVisitor {
        private String prefix = "";

        public int visit(IVisitableNode node) {
            this.prefix = this.prefix + "    ";
            TITANDebugConsole.print((String)(this.prefix + node.getClass() + "; " + node));
            if (node instanceof ILocateableNode) {
                ILocateableNode ln = (ILocateableNode)node;
                TITANDebugConsole.print((String)(" loc: " + ln.getLocation().getOffset() + "-" + ln.getLocation().getEndOffset()));
                if (node instanceof Definition) {
                    Definition d = (Definition)ln;
                    TITANDebugConsole.print((String)(", cummloc: " + d.getCumulativeDefinitionLocation().getOffset() + "-" + d.getCumulativeDefinitionLocation().getEndOffset()));
                }
            }
            TITANDebugConsole.println((String[])new String[0]);
            return 3;
        }

        public int leave(IVisitableNode node) {
            this.prefix = this.prefix.substring(4);
            return 3;
        }
    }

    public static class ResourceVisitor
    implements IResourceVisitor {
        private final List<IFile> files = new ArrayList<IFile>();

        private ResourceVisitor() {
        }

        private List<IFile> getFiles() {
            return this.files;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                this.files.add((IFile)resource);
                return false;
            }
            return true;
        }
    }

    private static class UpdateASTOp
    implements IRunnableWithProgress {
        private final Set<IProject> toUpdate;
        private final String name;

        public UpdateASTOp(Set<IProject> toUpdate, String name) {
            this.toUpdate = toUpdate;
            this.name = name;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (this.toUpdate == null) {
                return;
            }
            monitor.beginTask(this.name, this.toUpdate.size());
            for (IProject proj : this.toUpdate) {
                monitor.subTask("Waiting for semantic analysis on project " + proj.getName());
                ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)proj);
                WorkspaceJob job = projectSourceParser.analyzeAll();
                if (job == null) {
                    TITANDebugConsole.println((String[])new String[]{"Utils.updateASTOp: WorkspaceJob to analyze project could not be created for project " + proj.getName() + ", during the refactoring: " + this.name});
                    return;
                }
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    TITANDebugConsole.println((String[])new String[]{"Utils.updateASTOp: Error during semantic analysis of the project: " + proj.getName() + ", during the refactoring: " + this.name});
                    return;
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                monitor.worked(1);
            }
        }
    }
}

