/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.definition;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.definition.ExtractDefinitionRefactoring;
import org.eclipse.titanium.refactoring.definition.ExtractDefinitionWizard;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

public class ExtractDefinitionAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Utils.updateASTForProjectActiveInEditor("ExtractDefinition");
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection sel = selectionService.getSelection();
        if (sel == null) {
            return null;
        }
        if (!(sel instanceof TextSelection)) {
            ErrorReporter.logError((String)"ExtractDefinitionAction: Selection is not a TextSelection!");
            return null;
        }
        ExtractDefinitionRefactoring refactoring = new ExtractDefinitionRefactoring();
        Definition selectedDef = refactoring.getSelection();
        if (selectedDef == null) {
            ErrorReporter.logError((String)"ExtractDefinitionAction: Selected definition is null.");
            return null;
        }
        ExtractDefinitionWizard wiz = new ExtractDefinitionWizard(selectedDef.getIdentifier().getName());
        TextSelection textSelection = (TextSelection)sel;
        StructuredSelection ssel = new StructuredSelection((Object)textSelection);
        wiz.init(PlatformUI.getWorkbench(), (IStructuredSelection)ssel);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wiz);
        dialog.open();
        IProject newProj = wiz.getProject();
        if (newProj == null) {
            ErrorReporter.logError((String)"ExtractDefinitionAction: Wizard returned a null project. ");
            return null;
        }
        refactoring.setTargetProject(newProj);
        IProject sourceProj = refactoring.getSourceProject();
        ProjectFileHandler pfh = new ProjectFileHandler(sourceProj);
        if (pfh.projectFileExists()) {
            IFile settingsFile = sourceProj.getFile("/.TITAN_properties");
            IFile settingsCopy = newProj.getFile("/.TITAN_properties");
            try {
                if (settingsCopy.exists()) {
                    settingsCopy.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                settingsFile.copy(settingsCopy.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                ErrorReporter.logError((String)"ExtractDefinitionAction: Copying project settings to new project failed.");
            }
        }
        refactoring.perform();
        WorkspaceJob job = GlobalParser.getProjectSourceParser((IProject)newProj).analyzeAll();
        if (job != null) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        return null;
    }
}

