/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.expandvaluelistnotation;

import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

class ChangeCreator {
    private final IFile selectedFile;
    private Change change;

    ChangeCreator(IFile selectedFile) {
        this.selectedFile = selectedFile;
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.selectedFile == null) {
            return;
        }
        this.change = this.createFileChange(this.selectedFile);
    }

    private Change createFileChange(IFile toVisit) {
        if (toVisit == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)toVisit.getProject());
        Module module = sourceParser.containedModule(toVisit);
        if (module == null) {
            return null;
        }
        DefinitionVisitor vis = new DefinitionVisitor();
        module.accept((ASTVisitor)vis);
        NavigableSet nodes = vis.getLocations();
        if (nodes.isEmpty()) {
            return null;
        }
        TextFileChange tfc = new TextFileChange(toVisit.getName(), toVisit);
        MultiTextEdit rootEdit = new MultiTextEdit();
        tfc.setEdit((TextEdit)rootEdit);
        for (ILocateableNode node : nodes) {
            NamedValue namedValue;
            SequenceOf_Value seqOfValues = (SequenceOf_Value)node;
            if (seqOfValues.getMyGovernor() == null) continue;
            Sequence_Value converted = Sequence_Value.convert((CompilationTimeStamp)CompilationTimeStamp.getBaseTimestamp(), (SequenceOf_Value)seqOfValues);
            if (seqOfValues.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) continue;
            for (int i = 0; i < converted.getNofComponents() && (namedValue = converted.getSeqValueByIndex(i)) != null; ++i) {
                rootEdit.addChild((TextEdit)new InsertEdit(namedValue.getValue().getLocation().getOffset(), namedValue.getName().getTtcnName() + " := "));
            }
        }
        if (!rootEdit.hasChildren()) {
            return null;
        }
        return tfc;
    }

    private static class LocationComparator
    implements Comparator<ILocateableNode> {
        private LocationComparator() {
        }

        @Override
        public int compare(ILocateableNode arg0, ILocateableNode arg1) {
            int o1;
            IResource f1;
            IResource f0 = arg0.getLocation().getFile();
            if (!f0.equals((Object)(f1 = arg1.getLocation().getFile()))) {
                return f0.getFullPath().toString().compareTo(f1.getFullPath().toString());
            }
            int o0 = arg0.getLocation().getOffset();
            return o0 < (o1 = arg1.getLocation().getOffset()) ? -1 : (o0 == o1 ? 0 : 1);
        }
    }

    private static class DefinitionVisitor
    extends ASTVisitor {
        private final NavigableSet<ILocateableNode> locations = new TreeSet<ILocateableNode>(new LocationComparator());

        DefinitionVisitor() {
        }

        private NavigableSet<ILocateableNode> getLocations() {
            return this.locations;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof SequenceOf_Value) {
                this.locations.add((ILocateableNode)((SequenceOf_Value)node));
            }
            return 3;
        }
    }
}

