/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.function;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.titanium.refactoring.function.IModelProvider;
import org.eclipse.titanium.refactoring.function.ParamTableItem;

public class ExtractToFunctionWizardParamsPage
extends UserInputWizardPage {
    private TableViewer tableViewer;
    private final IModelProvider<ParamTableItem> modelProvider;

    public ExtractToFunctionWizardParamsPage(String name, IModelProvider<ParamTableItem> modelProvider) {
        super(name);
        this.modelProvider = modelProvider;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)composite);
        this.setControl((Control)composite);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Label searchLabel = new Label(composite, 0);
        searchLabel.setText("Specify new function parameter names: ");
        this.tableViewer = new TableViewer(composite, 68098);
        this.createColumns(composite);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.modelProvider.getItems());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.tableViewer.getControl().setLayoutData((Object)gridData);
    }

    private void createColumns(Composite parent) {
        String[] titles = new String[]{"Passing type", "Typename", "Name"};
        int[] bounds = new int[]{100, 200, 280};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ParamTableItem p = (ParamTableItem)element;
                return p.getPassType();
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ParamTableItem p = (ParamTableItem)element;
                return p.getType();
            }
        });
        col = this.createTableViewerColumn(titles[2], bounds[2]);
        col.setEditingSupport((EditingSupport)new NameEditingSupport(col.getViewer()));
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ParamTableItem p = (ParamTableItem)element;
                return p.getName();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    private class NameEditingSupport
    extends EditingSupport {
        private final TextCellEditor cellEditor;

        public NameEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.cellEditor = new TextCellEditor((Composite)ExtractToFunctionWizardParamsPage.this.tableViewer.getTable());
            viewer.setCellEditors(new CellEditor[]{this.cellEditor});
        }

        protected CellEditor getCellEditor(Object element) {
            ParamTableItem pti = (ParamTableItem)element;
            this.cellEditor.setValue((Object)pti.getName());
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            ParamTableItem pti = (ParamTableItem)element;
            return pti.getName();
        }

        protected void setValue(Object element, Object value) {
            if (!(value instanceof String)) {
                return;
            }
            ParamTableItem pti = (ParamTableItem)element;
            pti.setName((String)value);
            this.getViewer().update(element, null);
        }
    }
}

