/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.function;

import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.Alt_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.DoWhile_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.For_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Interleave_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Return_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.While_Statement;
import org.eclipse.titanium.refactoring.function.StatementList;

class ReturnVisitor
extends ASTVisitor {
    private ReturnCertainty certainty = ReturnCertainty.NO;

    ReturnVisitor() {
    }

    public ReturnCertainty getCertainty() {
        return this.certainty;
    }

    public int visit(IVisitableNode node) {
        if (node instanceof Return_Statement) {
            this.certainty = ReturnCertainty.YES;
            return 2;
        }
        if (node instanceof StatementBlock || node instanceof StatementList) {
            StatementBlockVisitor blockVis = new StatementBlockVisitor();
            node.accept((ASTVisitor)blockVis);
            this.certainty = blockVis.getCertainty();
            return 1;
        }
        if (node instanceof While_Statement || node instanceof DoWhile_Statement || node instanceof For_Statement) {
            BranchMerger branchMerger = new BranchMerger();
            node.accept((ASTVisitor)branchMerger);
            this.certainty = branchMerger.getCertainty().or(ReturnCertainty.NO);
            return 1;
        }
        if (node instanceof If_Statement) {
            If_Statement ifs = (If_Statement)node;
            BranchMerger branchMerger = new BranchMerger();
            node.accept((ASTVisitor)branchMerger);
            this.certainty = ifs.getStatementBlock() != null ? branchMerger.getCertainty() : branchMerger.getCertainty().or(ReturnCertainty.NO);
            return 1;
        }
        if (node instanceof Alt_Statement) {
            AltGuards ags = ((Alt_Statement)node).getAltGuards();
            BranchMerger branchMerger = new BranchMerger();
            ags.accept((ASTVisitor)branchMerger);
            this.certainty = ags.hasElse() ? branchMerger.getCertainty() : branchMerger.getCertainty().or(ReturnCertainty.NO);
            return 1;
        }
        if (node instanceof Interleave_Statement) {
            BranchMerger branchMerger = new BranchMerger();
            node.accept((ASTVisitor)branchMerger);
            this.certainty = branchMerger.getCertainty().or(ReturnCertainty.NO);
            return 1;
        }
        if (node instanceof StatementBlock_Statement) {
            BranchMerger branchMerger = new BranchMerger();
            node.accept((ASTVisitor)branchMerger);
            this.certainty = branchMerger.getCertainty();
            return 1;
        }
        if (node instanceof SelectCase_Statement) {
            BranchMerger branchMerger = new BranchMerger();
            node.accept((ASTVisitor)branchMerger);
            this.certainty = branchMerger.getCertainty();
            return 1;
        }
        return 2;
    }

    private class BranchMerger
    extends ASTVisitor {
        private ReturnCertainty blockCertainty = ReturnCertainty.NO;
        private boolean foundAnyBlocksBefore = false;

        private BranchMerger() {
        }

        private ReturnCertainty getCertainty() {
            return this.blockCertainty;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof StatementBlock) {
                StatementBlockVisitor sbVis = new StatementBlockVisitor();
                node.accept((ASTVisitor)sbVis);
                if (!this.foundAnyBlocksBefore) {
                    this.foundAnyBlocksBefore = true;
                    this.blockCertainty = sbVis.getCertainty();
                } else {
                    this.blockCertainty = this.blockCertainty.or(sbVis.getCertainty());
                }
                return 1;
            }
            return 3;
        }
    }

    private class StatementBlockVisitor
    extends ASTVisitor {
        private ReturnCertainty blockCertainty = ReturnCertainty.NO;

        private StatementBlockVisitor() {
        }

        private ReturnCertainty getCertainty() {
            return this.blockCertainty;
        }

        public int visit(IVisitableNode node) {
            block3: {
                block2: {
                    if (!(node instanceof StatementBlock)) break block2;
                    StatementBlock sb = (StatementBlock)node;
                    for (int i = 0; i < sb.getSize(); ++i) {
                        Statement s = sb.getStatementByIndex(i);
                        ReturnVisitor sVis = new ReturnVisitor();
                        s.accept((ASTVisitor)sVis);
                        ReturnCertainty rc = sVis.getCertainty();
                        this.blockCertainty = this.blockCertainty.and(rc);
                        if (this.blockCertainty != ReturnCertainty.YES) continue;
                        return 2;
                    }
                    break block3;
                }
                if (!(node instanceof StatementList)) break block3;
                StatementList sl = (StatementList)node;
                for (int i = 0; i < sl.getSize(); ++i) {
                    Statement s = sl.getStatementByIndex(i);
                    ReturnVisitor sVis = new ReturnVisitor();
                    s.accept((ASTVisitor)sVis);
                    ReturnCertainty rc = sVis.getCertainty();
                    this.blockCertainty = this.blockCertainty.and(rc);
                    if (this.blockCertainty != ReturnCertainty.YES) continue;
                    return 2;
                }
            }
            return 2;
        }
    }

    static enum ReturnCertainty {
        NO,
        MAYBE,
        YES;


        ReturnCertainty or(ReturnCertainty other) {
            if (this == YES && other == YES) {
                return YES;
            }
            if (this == NO && other == NO) {
                return NO;
            }
            return MAYBE;
        }

        ReturnCertainty and(ReturnCertainty other) {
            if (this == YES || other == YES) {
                return YES;
            }
            if (this == NO && other == NO) {
                return NO;
            }
            return MAYBE;
        }
    }
}

