/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.insertfield;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

class SelectionFinder {
    private static final String ERR_MSG_NO_SELECTION = "No selection was found! ";
    private IProject sourceProj;
    private Definition selection;

    SelectionFinder() {
    }

    public IProject getSourceProj() {
        return this.sourceProj;
    }

    public Definition getSelection() {
        return this.selection;
    }

    public void perform() {
        this.selection = this.findSelection();
    }

    private Definition findSelection() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null || !(editor instanceof TTCN3Editor)) {
            return null;
        }
        TTCN3Editor targetEditor = (TTCN3Editor)editor;
        IResource selectedRes = this.extractResource((IEditorPart)targetEditor);
        if (!(selectedRes instanceof IFile)) {
            ErrorReporter.logError((String)("SelectionFinder.findSelection(): Selected resource `" + selectedRes.getName() + "' is not a file."));
            return null;
        }
        IFile selectedFile = (IFile)selectedRes;
        this.sourceProj = selectedFile.getProject();
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)this.sourceProj);
        Module selectedModule = projectSourceParser.containedModule(selectedFile);
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        TextSelection textSelection = this.extractSelection(selectionService.getSelection());
        int selectionOffset = textSelection.getOffset() + textSelection.getLength();
        SelectionFinderVisitor selVisitor = new SelectionFinderVisitor(selectionOffset);
        selectedModule.accept((ASTVisitor)selVisitor);
        Definition selectedDef = selVisitor.getSelection();
        if (selectedDef == null) {
            ErrorReporter.logWarning((String)"SelectionFinder.findSelection(): Visitor did not find a definition in the selection.");
            IStatusLineManager statusLineManager = targetEditor.getEditorSite().getActionBars().getStatusLineManager();
            statusLineManager.setErrorMessage(ERR_MSG_NO_SELECTION);
            return null;
        }
        return selectedDef;
    }

    private IResource extractResource(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)input).getFile();
    }

    private TextSelection extractSelection(ISelection sel) {
        if (!(sel instanceof TextSelection)) {
            ErrorReporter.logError((String)"Selection is not a TextSelection.");
            return null;
        }
        return (TextSelection)sel;
    }

    private static class SelectionFinderVisitor
    extends ASTVisitor {
        private Definition def;
        private final int offset;

        SelectionFinderVisitor(int selectionOffset) {
            this.offset = selectionOffset;
        }

        private Definition getSelection() {
            return this.def;
        }

        public int visit(IVisitableNode node) {
            if (!(node instanceof ILocateableNode)) {
                return 3;
            }
            Location loc = ((ILocateableNode)node).getLocation();
            if (loc == null) {
                return 2;
            }
            if (!loc.containsOffset(this.offset)) {
                return 1;
            }
            if (node instanceof Definition) {
                this.def = (Definition)node;
            }
            return 3;
        }
    }
}

