/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.modulepar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;

public class SelectionFinder {
    private final IProject project;
    private Set<Def_ModulePar> modulePars;

    public SelectionFinder(IProject project) {
        this.project = project;
    }

    public Set<Def_ModulePar> getModulePars() {
        return this.modulePars;
    }

    public void perform() {
        this.modulePars = new HashSet<Def_ModulePar>();
        Collection modules = GlobalParser.getProjectSourceParser((IProject)this.project).getModules();
        for (Module m : modules) {
            ModuleParFinder vis = new ModuleParFinder();
            m.accept((ASTVisitor)vis);
            this.modulePars.addAll(vis.getModulePars());
        }
    }

    public String createModuleParListForSaving() {
        if (this.modulePars == null || this.modulePars.isEmpty()) {
            return "<empty>";
        }
        ArrayList<ModuleParListRecord> records = new ArrayList<ModuleParListRecord>();
        for (Def_ModulePar def : this.modulePars) {
            IResource f = def.getLocation().getFile();
            if (!(f instanceof IFile)) {
                ErrorReporter.logError((String)("ExtractModulePar/SelectionFinder: IResource `" + f.getName() + "' is not an IFile."));
                continue;
            }
            Identifier id = def.getIdentifier();
            Type t = def.getType(CompilationTimeStamp.getBaseTimestamp());
            records.add(new ModuleParListRecord(def.getMyScope().getModuleScope().getIdentifier().getDisplayName(), id.getDisplayName(), t.getTypename()));
        }
        Collections.sort(records);
        StringBuilder sb = new StringBuilder();
        for (ModuleParListRecord rec : records) {
            sb.append(rec.toString()).append('\n');
        }
        return sb.toString();
    }

    private class ModuleParFinder
    extends ASTVisitor {
        private final Set<Def_ModulePar> modulePars = new HashSet<Def_ModulePar>();

        private ModuleParFinder() {
        }

        public Set<Def_ModulePar> getModulePars() {
            return this.modulePars;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Def_ModulePar) {
                this.modulePars.add((Def_ModulePar)node);
                return 1;
            }
            return 3;
        }
    }

    private static class ModuleParListRecord
    implements Comparable<ModuleParListRecord> {
        private final String moduleName;
        private final String id;
        private final String typeId;

        public ModuleParListRecord(String moduleName, String id, String typeId) {
            this.moduleName = moduleName;
            this.id = id;
            this.typeId = typeId;
        }

        @Override
        public int compareTo(ModuleParListRecord arg0) {
            int cmp = this.moduleName.compareTo(arg0.moduleName);
            if (cmp != 0) {
                return cmp;
            }
            return this.id.compareTo(arg0.id);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ModuleParListRecord)) {
                return false;
            }
            ModuleParListRecord other = (ModuleParListRecord)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName));
        }

        public String toString() {
            return this.moduleName + "." + this.id + ": " + this.typeId;
        }
    }
}

