/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.movefunction;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionRefactoring;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionWizard;

public class MoveFunctionActionFromEditor
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Utils.updateASTForProjectActiveInEditor("Move function");
        Activator.getDefault().pauseHandlingResourceChanges();
        TTCN3Editor targetEditor = Utils.getActiveEditor();
        if (targetEditor == null) {
            return null;
        }
        IFile selectedFile = Utils.getSelectedFileInEditor("Move function");
        if (selectedFile == null) {
            return null;
        }
        StructuredSelection structSelection = new StructuredSelection((Object)selectedFile);
        MoveFunctionRefactoring refactoring = new MoveFunctionRefactoring((IStructuredSelection)structSelection, new MoveFunctionRefactoring.MoveFunctionSettings());
        MoveFunctionWizard wiz = new MoveFunctionWizard(refactoring);
        RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wiz);
        try {
            operation.run(targetEditor.getEditorSite().getShell(), "");
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            ErrorReporter.logError((String)"MoveFunctionActionFromEditor: Error while performing refactoring change! ");
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        Activator.getDefault().resumeHandlingResourceChanges();
        IProject project = selectedFile.getProject();
        GlobalParser.getProjectSourceParser((IProject)project).reportOutdating(selectedFile);
        GlobalParser.getProjectSourceParser((IProject)project).analyzeAll();
        return null;
    }
}

