/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.organize;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.organize.OrganizeImportsRefactoring;
import org.eclipse.titanium.refactoring.organize.OrganizeImportsWizard;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class OrganizeImportsFromBrowser
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.performOrganizeImport();
        return null;
    }

    public void run(IAction action) {
        this.performOrganizeImport();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private void performOrganizeImport() {
        TTCN3Editor targetEditor = Utils.getActiveEditor();
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        Set<IProject> projsToUpdate = Utils.findAllProjectsInSelection(structSelection);
        Utils.updateASTBeforeRefactoring(projsToUpdate, "OrganizeImports");
        Activator.getDefault().pauseHandlingResourceChanges();
        OrganizeImportsRefactoring refactoring = new OrganizeImportsRefactoring(structSelection);
        OrganizeImportsWizard wiz = new OrganizeImportsWizard(refactoring);
        RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wiz);
        try {
            operation.run(targetEditor == null ? null : targetEditor.getEditorSite().getShell(), "");
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            ErrorReporter.logError((String)"OrganizeImportsFromBrowser: Error while performing refactoring change! ");
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        Activator.getDefault().resumeHandlingResourceChanges();
        Utils.updateASTAfterRefactoring(wiz, refactoring.getAffectedObjects(), refactoring.getName());
    }
}

