/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.scope;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.scope.MinimizeScopeRefactoring;
import org.eclipse.titanium.refactoring.scope.MinimizeScopeWizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

public class MinimizeScopeActionFromEditor
extends AbstractHandler {
    private static final String ERR_MSG_NO_SELECTION = "Move the cursor into a function or testcase body! ";
    private Definition selection;

    public Definition getSelection() {
        return this.selection;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Utils.updateASTForProjectActiveInEditor("MinimizeScope");
        Activator.getDefault().pauseHandlingResourceChanges();
        TTCN3Editor targetEditor = Utils.getActiveEditor();
        if (targetEditor == null) {
            return null;
        }
        this.selection = this.findSelection();
        if (this.selection == null) {
            return null;
        }
        IResource selectedRes = this.selection.getLocation().getFile();
        if (!(selectedRes instanceof IFile)) {
            ErrorReporter.logError((String)("MinimizeScopeActionFromEditor.execute(): Selected resource `" + selectedRes.getName() + "' is not a file."));
            return null;
        }
        IFile selectedFile = (IFile)selectedRes;
        MinimizeScopeRefactoring refactoring = new MinimizeScopeRefactoring(this.selection, null);
        MinimizeScopeWizard wiz = new MinimizeScopeWizard(refactoring);
        RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wiz);
        try {
            operation.run(targetEditor.getEditorSite().getShell(), "");
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            ErrorReporter.logError((String)"MinimizeScopeActionFromEditor: Error while performing refactoring change! ");
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        Activator.getDefault().resumeHandlingResourceChanges();
        IProject project = selectedFile.getProject();
        GlobalParser.getProjectSourceParser((IProject)project).reportOutdating(selectedFile);
        GlobalParser.getProjectSourceParser((IProject)project).analyzeAll();
        return null;
    }

    private Definition findSelection() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null || !(editor instanceof TTCN3Editor)) {
            return null;
        }
        TTCN3Editor targetEditor = (TTCN3Editor)editor;
        IStatusLineManager statusLineManager = targetEditor.getEditorSite().getActionBars().getStatusLineManager();
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        TextSelection textSelection = this.extractSelection(selectionService.getSelection());
        IResource selectedRes = this.extractResource((IEditorPart)targetEditor);
        if (!(selectedRes instanceof IFile)) {
            ErrorReporter.logError((String)("SelectionFinder.findSelection(): Selected resource `" + selectedRes.getName() + "' is not a file."));
            return null;
        }
        IFile selectedFile = (IFile)selectedRes;
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)selectedFile.getProject());
        Module selectedModule = projectSourceParser.containedModule(selectedFile);
        int selectionOffset = textSelection.getOffset() + textSelection.getLength();
        SelectionFinderVisitor selVisitor = new SelectionFinderVisitor(selectionOffset);
        selectedModule.accept((ASTVisitor)selVisitor);
        Definition selectedDef = selVisitor.getSelection();
        if (selectedDef == null) {
            ErrorReporter.logWarning((String)"SelectionFinder.findSelection(): Visitor did not find a definition in the selection.");
            statusLineManager.setErrorMessage(ERR_MSG_NO_SELECTION);
            return null;
        }
        return selectedDef;
    }

    private TextSelection extractSelection(ISelection sel) {
        if (!(sel instanceof TextSelection)) {
            ErrorReporter.logError((String)"ContextLoggingActionFromEditor.extractSelection(): selection is not a TextSelection");
            return null;
        }
        return (TextSelection)sel;
    }

    private IResource extractResource(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)input).getFile();
    }

    private static class SelectionFinderVisitor
    extends ASTVisitor {
        private Definition def;
        private final int offset;

        SelectionFinderVisitor(int selectionOffset) {
            this.offset = selectionOffset;
        }

        private Definition getSelection() {
            return this.def;
        }

        public int visit(IVisitableNode node) {
            Reference ref;
            Assignment as;
            if (!(node instanceof ILocateableNode)) {
                return 3;
            }
            Location loc = ((ILocateableNode)node).getLocation();
            if (loc == null) {
                return 2;
            }
            if (!loc.containsOffset(this.offset)) {
                return 1;
            }
            if (node instanceof Definition) {
                this.def = SelectionFinderVisitor.isGoodType(node) ? (Definition)node : null;
            }
            if (node instanceof Undefined_LowerIdentifier_Value) {
                ((Undefined_LowerIdentifier_Value)node).getAsReference();
                return 3;
            }
            if (node instanceof Reference && (as = (ref = (Reference)node).getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false)) instanceof Definition) {
                this.def = SelectionFinderVisitor.isGoodType((IVisitableNode)as) ? (Definition)as : null;
            }
            return 3;
        }

        private static boolean isGoodType(IVisitableNode node) {
            return node instanceof Def_Function || node instanceof Def_Testcase;
        }
    }
}

