/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.scope.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titanium.refactoring.scope.nodes.Reference;
import org.eclipse.titanium.refactoring.scope.nodes.StatementNode;

public class Variable {
    public final Definition definition;
    public final StatementNode declaration;
    public final List<Reference> references;
    public final boolean isParameter;

    public Variable(Definition definition, StatementNode declaration, boolean isParameter) {
        this.definition = definition;
        this.declaration = declaration;
        this.isParameter = isParameter;
        this.references = new ArrayList<Reference>();
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public StatementNode getDeclaration() {
        return this.declaration;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public void addReference(StatementNode st, boolean leftHandSideRef) {
        if (!this.references.isEmpty() && this.references.get(this.references.size() - 1).getRef().equals(st)) {
            if (leftHandSideRef) {
                this.references.get(this.references.size() - 1).setLeftHandSide();
            }
            return;
        }
        this.references.add(new Reference(st, leftHandSideRef));
    }

    public void removeReference(StatementNode st) {
        ListIterator<Reference> it = this.references.listIterator();
        while (it.hasNext()) {
            if (!it.next().getRef().equals(st)) continue;
            it.remove();
            return;
        }
        String fname = this.definition.getLocation().getFile().toString();
        ErrorReporter.logError((String)("Variable.removeReference(): Could not remove reference for variable: " + this.toString() + "; in file " + fname));
    }

    public String toString() {
        return this.definition == null ? "null" : this.definition.getIdentifier().toString();
    }

    public String toStringRecursive(boolean includeRefs, int prefixLen) {
        String prefix = new String(new char[prefixLen]).replace('\u0000', ' ');
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("VAR: ").append(this.definition == null ? "null" : this.definition.getIdentifier().toString());
        if (includeRefs) {
            sb.append('\n').append(prefix).append("  refs:\n");
            for (Reference r : this.references) {
                sb.append(" LHS:" + r.isLeftHandSide() + " " + r.getRef().toStringRecursive(false, 8)).append('\n');
            }
        }
        return sb.toString();
    }
}

