/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.JsonAST;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.UnionGenerator;
import org.eclipse.titan.designer.AST.TTCN3.values.Choice_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;

public final class ASN1_Choice_Type
extends ASN1_Set_Seq_Choice_BaseType {
    private static final String MISSINGALTERNATIVE = "CHOICE type must have at least one alternative";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for union type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for union type `{0}''";
    private static final String ONEFIELDEXPECTED = "A template for union type must contain exactly one selected field";
    private static final String REFERENCETONONEXISTENTFIELD = "Reference to non-existent field `{0}'' in union template for type `{1}''";
    private static final String CHOICEEXPECTED = "CHOICE value was expected for type `{0}''";
    private static final String UNIONEXPECTED = "Union value was expected for type `{0}''";
    private static final String NONEXISTENTCHOICE = "Reference to a non-existent alternative `{0}'' in CHOICE value for type `{1}''";
    private static final String NONEXISTENTUNION = "Reference to a non-existent field `{0}'' in union value for type `{1}''";
    private static final String NOCOMPATIBLEFIELD = "union/CHOICE type `{0}'' doesn''t have any field compatible with `{1}''";
    private static final String NOTCOMPATIBLEUNION = "union/CHOICE types are compatible only with other union/CHOICE types";

    public ASN1_Choice_Type(Block aBlock) {
        this.mBlock = aBlock;
        this.setLocation(new Location(aBlock.getLocation()));
    }

    @Override
    public IASN1Type newInstance() {
        return new ASN1_Choice_Type(this.mBlock);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ASN1_CHOICE;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_TTCN3_CHOICE;
    }

    @Override
    public int getNofComponents() {
        if (null == this.components) {
            this.parseBlockChoice();
        }
        return this.components.getNofComps();
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (null == info || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ASN1_CHOICE: {
                ASN1_Choice_Type temporalType = (ASN1_Choice_Type)temp;
                if (this == temporalType) {
                    return true;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (null == lChain) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (null == rChain) {
                    rChain = info.getChain();
                    rChain.add(temporalType);
                }
                int size = this.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    int size2 = temporalType.getNofComponents();
                    for (int j = 0; j < size2; ++j) {
                        CompField temporalCompField = temporalType.getComponentByIndex(j);
                        IType tempTypeCompFieldType = temporalCompField.getType().getTypeRefdLast(timestamp);
                        if (!cf.getIdentifier().getDisplayName().equals(temporalCompField.getIdentifier().getDisplayName())) continue;
                        lChain.markState();
                        rChain.markState();
                        lChain.add(cfType);
                        rChain.add(tempTypeCompFieldType);
                        if (cfType.equals(tempTypeCompFieldType) || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeCompFieldType, info, lChain, rChain)) {
                            info.setNeedsConversion(true);
                            lChain.previousState();
                            rChain.previousState();
                            return true;
                        }
                        lChain.previousState();
                        rChain.previousState();
                    }
                }
                info.setErrorStr(MessageFormat.format(NOCOMPATIBLEFIELD, temp.getTypename(), this.getTypename()));
                return false;
            }
            case TYPE_TTCN3_CHOICE: {
                TTCN3_Choice_Type temporalType = (TTCN3_Choice_Type)temp;
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(temporalType);
                }
                int size = this.getNofComponents();
                for (int i = 0; i < size; ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    IType compFieldType = cf.getType().getTypeRefdLast(timestamp);
                    int size2 = temporalType.getNofComponents();
                    for (int j = 0; j < size2; ++j) {
                        CompField temporalCompField = temporalType.getComponentByIndex(j);
                        IType tempTypeCompFieldType = temporalCompField.getType().getTypeRefdLast(timestamp);
                        if (!cf.getIdentifier().getDisplayName().equals(temporalCompField.getIdentifier().getDisplayName())) continue;
                        lChain.markState();
                        rChain.markState();
                        lChain.add(compFieldType);
                        rChain.add(tempTypeCompFieldType);
                        if (compFieldType.equals(tempTypeCompFieldType) || lChain.hasRecursion() && rChain.hasRecursion() || compFieldType.isCompatible(timestamp, tempTypeCompFieldType, info, lChain, rChain)) {
                            info.setNeedsConversion(true);
                            lChain.previousState();
                            rChain.previousState();
                            return true;
                        }
                        lChain.previousState();
                        rChain.previousState();
                    }
                }
                info.setErrorStr(MessageFormat.format(NOCOMPATIBLEFIELD, temp.getTypename(), this.getTypename()));
                return false;
            }
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: 
            case TYPE_ASN1_SET: 
            case TYPE_TTCN3_SET: 
            case TYPE_SET_OF: 
            case TYPE_ANYTYPE: {
                info.setErrorStr(NOTCOMPATIBLEUNION);
                return false;
            }
        }
        return false;
    }

    @Override
    public String getOutlineIcon() {
        return "asn1_choice.gif";
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("choice");
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        Type type;
        if (this.components == null) {
            return;
        }
        if (referenceChain.add(this) && this.components.getNofComps() == 1 && (type = this.components.getCompByIndex(0).getType()) != null) {
            referenceChain.markState();
            type.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Module module;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.components != null && this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            return;
        }
        this.isErroneous = false;
        if (this.components == null) {
            this.parseBlockChoice();
        }
        if (this.isErroneous || this.components == null) {
            return;
        }
        this.components.check(timestamp);
        if (this.components.getNofComps() <= 0 && this.location != null) {
            this.location.reportSemanticError(MISSINGALTERNATIVE);
            this.setIsErroneous(true);
        }
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                if (value.isAsn()) {
                    value.getLocation().reportSemanticError(MessageFormat.format(CHOICEEXPECTED, this.getFullName()));
                    value.setIsErroneous(true);
                    break;
                }
                if ((last = last.setValuetype(timestamp, IValue.Value_type.CHOICE_VALUE)).getIsErroneous(timestamp)) break;
                selfReference = this.checkThisValueChoice(timestamp, (Choice_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed);
                break;
            }
            case CHOICE_VALUE: {
                selfReference = this.checkThisValueChoice(timestamp, (Choice_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                if (value.isAsn()) {
                    value.getLocation().reportSemanticError(MessageFormat.format(CHOICEEXPECTED, this.getFullName()));
                    value.setIsErroneous(true);
                } else {
                    value.getLocation().reportSemanticError(MessageFormat.format(UNIONEXPECTED, this.getFullName()));
                    value.setIsErroneous(true);
                }
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    private boolean checkThisValueChoice(CompilationTimeStamp timestamp, Choice_Value value, Assignment lhs, Expected_Value_type expectedValue, boolean incompleteAllowed) {
        boolean selfReference = false;
        Identifier name = value.getName();
        if (!this.hasComponentWithName(name)) {
            if (value.isAsn()) {
                value.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTCHOICE, name.getDisplayName(), this.getFullName()));
                value.setIsErroneous(true);
            } else {
                value.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTUNION, name.getDisplayName(), this.getFullName()));
                value.setIsErroneous(true);
            }
            value.setLastTimeChecked(timestamp);
            return selfReference;
        }
        IValue alternativeValue = value.getValue();
        if (alternativeValue == null) {
            return selfReference;
        }
        Type alternativeType = this.getComponentByName(name).getType();
        alternativeValue.setMyGovernor(alternativeType);
        alternativeValue = alternativeType.checkThisValueRef(timestamp, alternativeValue);
        selfReference = alternativeType.checkThisValue(timestamp, alternativeValue, lhs, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, false, false));
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = false;
        if (ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST.equals((Object)template.getTemplatetype())) {
            Named_Template_List namedTemplateList = (Named_Template_List)template;
            int nofTemplates = namedTemplateList.getNofTemplates();
            if (nofTemplates != 1) {
                template.getLocation().reportSemanticError(ONEFIELDEXPECTED);
                template.setIsErroneous(true);
            }
            for (int i = 0; i < nofTemplates; ++i) {
                NamedTemplate namedTemplate = namedTemplateList.getTemplateByIndex(i);
                Identifier name = namedTemplate.getName();
                CompField field = this.components.getCompByName(name);
                if (field == null) {
                    namedTemplate.getLocation().reportSemanticError(MessageFormat.format(REFERENCETONONEXISTENTFIELD, name.getDisplayName(), this.getFullName()));
                    continue;
                }
                Type fieldType = field.getType();
                if (fieldType == null || fieldType.getIsErroneous(timestamp)) continue;
                ITTCN3Template namedTemplateTemplate = namedTemplate.getTemplate();
                namedTemplateTemplate.setMyGovernor(fieldType);
                namedTemplateTemplate = fieldType.checkThisTemplateRef(timestamp, namedTemplateTemplate);
                ITTCN3Template.Completeness_type completeness = namedTemplateList.getCompletenessConditionChoice(timestamp, isModified, name);
                selfReference |= namedTemplateTemplate.checkThisTemplateGeneric(timestamp, fieldType, ITTCN3Template.Completeness_type.MAY_INCOMPLETE.equals((Object)completeness), false, false, true, implicitOmit, lhs);
            }
        } else {
            template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
            template.setIsErroneous(true);
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(MessageFormat.format(LENGTHRESTRICTIONNOTALLOWED, this.getTypename()));
            template.setIsErroneous(true);
        }
        return selfReference;
    }

    public void parseBlockChoice() {
        if (null == this.mBlock) {
            return;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return;
        }
        this.components = parser.pr_special_AlternativeTypeLists().list;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            this.components = null;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
        }
        if (this.components == null) {
            this.isErroneous = true;
            return;
        }
        this.components.setFullNameParent(this);
        this.components.setMyScope(this.getMyScope());
        this.components.setMyType(this);
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        this.checkJson(timestamp);
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        refChain.markState();
        for (int i = 0; i < this.getNofComponents(); ++i) {
            CompField cf = this.getComponentByIndex(i);
            cf.getType().checkCodingAttributes(timestamp, refChain);
        }
        refChain.previousState();
    }

    @Override
    public void forceJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null) {
            this.jsonAttribute = new JsonAST();
        }
    }

    @Override
    public void checkJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null && !this.hasEncodeAttribute("JSON")) {
            return;
        }
        for (int i = 0; i < this.getNofComponents(); ++i) {
            Type fieldType = this.getComponentByIndex(i).getType();
            fieldType.forceJson(timestamp);
        }
        if (this.jsonAttribute == null) {
            return;
        }
        if (this.jsonAttribute.omit_as_null && !this.isOptionalField()) {
            this.getLocation().reportSemanticError("Invalid attribute, 'omit as null' requires optional field of a record or set.");
        }
        if (this.jsonAttribute.as_value) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as value' is only allowed for unions, the anytype, or records or sets with one field");
        }
        if (this.jsonAttribute.alias != null) {
            IType parent = this.getParentType();
            if (parent == null) {
                this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
            } else {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        break;
                    }
                    default: {
                        this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
                    }
                }
            }
            if (parent != null && parent.getJsonAttribute() != null && parent.getJsonAttribute().as_value) {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Seq_Choice_BaseType)parent).getNofComponents() != 1) break;
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                }
            }
        }
        if (this.jsonAttribute.parsed_default_value != null) {
            this.checkJsonDefault(timestamp);
        }
        if (this.jsonAttribute.metainfo_unbound && (this.getParentType() == null || this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SEQUENCE && this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SET)) {
            this.getLocation().reportSemanticError("Invalid attribute 'metainfo for unbound', requires record, set, record of, set of, array or field of a record or set");
        }
        if (this.jsonAttribute.as_number) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as number' is only allowed for enumerated types");
        }
        if (this.jsonAttribute.as_map) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires record of or set of");
        }
        if (this.jsonAttribute.enum_texts.size() > 0) {
            this.getLocation().reportSemanticError("Invalid attribute, 'text ... as ...' requires an enumerated type");
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.components.getCompByName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return null;
                }
                Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
                return compField.getType().getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData).concat("_template");
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        String baseName = this.getGenNameTypeName(aData, source);
        return baseName + "." + this.getGenNameOwn();
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_raw_";
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_json_";
    }

    @Override
    public String getGenNameBerDescriptor(JavaGenData aData, StringBuilder source) {
        return "CHOICE_ber_";
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        CompField compField;
        int i;
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        if (this.components == null) {
            return;
        }
        String genName = this.getGenNameOwn();
        String displayName = this.getFullName();
        StringBuilder localTypeDescriptor = new StringBuilder();
        HashMap<String, String> attributeRegistry = new HashMap<String, String>();
        this.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
        this.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
        StringBuilder localCodingHandler = new StringBuilder();
        this.generateCodeForCodingHandlers(aData, source, localCodingHandler);
        boolean hasJson = this.getGenerateCoderFunctions(IType.MessageEncoding_type.JSON);
        ArrayList<UnionGenerator.FieldInfo> fieldInfos = new ArrayList<UnionGenerator.FieldInfo>();
        boolean hasOptional = false;
        for (i = 0; i < this.components.getNofComps(); ++i) {
            compField = this.components.getCompByIndex(i);
            Type cfType = compField.getType();
            switch (cfType.getTypetype()) {
                case TYPE_ASN1_CHOICE: 
                case TYPE_ASN1_SEQUENCE: 
                case TYPE_SEQUENCE_OF: 
                case TYPE_ASN1_SET: 
                case TYPE_SET_OF: 
                case TYPE_ASN1_ENUMERATED: {
                    if (cfType.generatesOwnClass(aData, source)) break;
                    cfType.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                    cfType.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                    cfType.generateCodeForCodingHandlers(aData, source, localCodingHandler);
                    break;
                }
                default: {
                    cfType.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                    cfType.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                    cfType.generateCodeForCodingHandlers(aData, source, localCodingHandler);
                }
            }
            String jsonAlias = cfType.getJsonAttribute() != null ? cfType.getJsonAttribute().alias : null;
            int JsonValueType = hasJson ? cfType.getJsonValueType() : 0;
            UnionGenerator.FieldInfo fi = new UnionGenerator.FieldInfo(cfType.getGenNameValue(aData, source), cfType.getGenNameTemplate(aData, source), compField.getIdentifier().getName(), compField.getIdentifier().getDisplayName(), cfType.getGenNameTypeDescriptor(aData, source), jsonAlias, JsonValueType);
            hasOptional |= compField.isOptional();
            fieldInfos.add(fi);
        }
        for (i = 0; i < this.components.getNofComps(); ++i) {
            compField = this.components.getCompByIndex(i);
            StringBuilder tempSource = aData.getCodeForType(compField.getType().getGenNameOwn());
            compField.getType().generateCode(aData, tempSource);
        }
        boolean jsonAsValue = this.jsonAttribute != null ? this.jsonAttribute.as_value : false;
        boolean hasRaw = this.getGenerateCoderFunctions(IType.MessageEncoding_type.RAW);
        UnionGenerator.generateValueClass(aData, source, genName, displayName, fieldInfos, hasOptional, hasRaw, null, hasJson, false, jsonAsValue, localTypeDescriptor, localCodingHandler);
        UnionGenerator.generateTemplateClass(aData, source, genName, displayName, fieldInfos, hasOptional);
    }

    @Override
    public boolean isPresentAnyvalueEmbeddedField(ExpressionStruct expression, List<ISubReference> subreferences, int beginIndex) {
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return true;
        }
        return beginIndex >= subreferences.size();
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        ISubReference subReference;
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return;
        }
        if (subReferenceIndex >= subreferences.size()) {
            return;
        }
        StringBuilder closingBrackets = new StringBuilder();
        if (isTemplate) {
            boolean anyvalueReturnValue = true;
            if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                anyvalueReturnValue = this.isPresentAnyvalueEmbeddedField(expression, subreferences, subReferenceIndex);
            } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION || optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                anyvalueReturnValue = false;
            }
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", externalId));
            expression.expression.append("case UNINITIALIZED_TEMPLATE:\n");
            expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
            expression.expression.append("break;\n");
            expression.expression.append("case ANY_VALUE:\n");
            expression.expression.append(MessageFormat.format("{0} = {1};\n", globalId, anyvalueReturnValue ? "true" : "false"));
            expression.expression.append("break;\n");
            expression.expression.append("case SPECIFIC_VALUE:{\n");
            closingBrackets.append("break;}\n");
            closingBrackets.append("default:\n");
            closingBrackets.append(MessageFormat.format("{0} = false;\n", globalId));
            closingBrackets.append("break;\n");
            closingBrackets.append("}\n");
            closingBrackets.append("}\n");
        }
        if (!((subReference = subreferences.get(subReferenceIndex)) instanceof FieldSubReference)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return;
        }
        String valueTypeGenName = this.getGenNameValue(aData, expression.expression);
        String currentTypeGenName = isTemplate ? this.getGenNameTemplate(aData, expression.expression) : valueTypeGenName;
        Identifier fieldId = ((FieldSubReference)subReference).getId();
        expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
        expression.expression.append(MessageFormat.format("{0} = {1}.ischosen({2}.union_selection_type.ALT_{3});\n", globalId, externalId, valueTypeGenName, FieldSubReference.getJavaGetterName(fieldId.getName())));
        expression.expression.append("}\n");
        CompField compField = this.getComponentByName(fieldId);
        Type nextType = compField.getType();
        String nextTypeGenName = isTemplate ? nextType.getGenNameTemplate(aData, expression.expression) : nextType.getGenNameValue(aData, expression.expression);
        expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
        closingBrackets.insert(0, "}\n");
        String temporalId = aData.getTemporaryVariableName();
        String temporalId2 = aData.getTemporaryVariableName();
        expression.expression.append(MessageFormat.format("final {0} {1} = new {0}({2});\n", currentTypeGenName, temporalId, externalId));
        expression.expression.append(MessageFormat.format("final {0} {1} = {2}.get_field_{3}();\n", nextTypeGenName, temporalId2, temporalId, FieldSubReference.getJavaGetterName(fieldId.getName())));
        if (optype == Expression_Value.Operation_type.ISBOUND_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
        } else if (optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_value();\n", globalId, temporalId2));
        } else if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_present({2});\n", globalId, temporalId2, isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
        } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
            if (subReferenceIndex == subreferences.size() - 1) {
                expression.expression.append(MessageFormat.format("if ({0}) '{'\n", globalId));
                expression.expression.append(MessageFormat.format("{0} = {1}.ischosen({2});\n", globalId, temporalId2, field));
                expression.expression.append("}\n");
            }
        }
        nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId2, isTemplate, optype, field, targetScope);
        expression.expression.append((CharSequence)closingBrackets);
    }

    @Override
    public String generateConversion(JavaGenData aData, IType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        IType refdType = fromType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (refdType == null || this == refdType) {
            return fromName;
        }
        switch (refdType.getTypetype()) {
            case TYPE_TTCN3_CHOICE: {
                TTCN3_Choice_Type realFromType = (TTCN3_Choice_Type)refdType;
                return this.generateConversionTTCNChoiceToASNChoice(aData, realFromType, fromName, forValue, expression);
            }
            case TYPE_ASN1_CHOICE: {
                ASN1_Choice_Type realFromType = (ASN1_Choice_Type)refdType;
                return this.generateConversionASNChoiceToASNChoice(aData, realFromType, fromName, forValue, expression);
            }
        }
        expression.expression.append(MessageFormat.format("//FIXME conversion from {0} to {1} is not needed or nor supported yet\n", fromType.getTypename(), this.getTypename()));
        return fromName;
    }

    protected String generateConversionTTCNChoiceToASNChoice(JavaGenData aData, TTCN3_Choice_Type fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            conversionFunctionBody.append("\t\tif(!from.is_bound()) {\n");
            conversionFunctionBody.append("\t\t\treturn false;\n");
            conversionFunctionBody.append("\t\t}\n");
            conversionFunctionBody.append("\t\tswitch (from.get_selection()) {\n");
            for (int i = 0; i < fromType.getNofComponents(); ++i) {
                CompField fromComp = fromType.getComponentByIndex(i);
                Identifier fromFieldName = fromComp.getIdentifier();
                IType fromFieldType = fromComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                for (int j = 0; j < this.getNofComponents(); ++j) {
                    CompField toComp = this.getComponentByIndex(j);
                    Identifier toFieldName = toComp.getIdentifier();
                    IType toFieldType = toComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                    if (!fromFieldName.equals(toFieldName) || !fromFieldType.isCompatible(CompilationTimeStamp.getBaseTimestamp(), toFieldType, null, null, null)) continue;
                    conversionFunctionBody.append(MessageFormat.format("\t\tcase ALT_{0}: '{'\n", fromFieldName.getName()));
                    String tempId2 = aData.getTemporaryVariableName();
                    String fromFieldTypeName = forValue ? fromFieldType.getGenNameValue(aData, conversionFunctionBody) : fromFieldType.getGenNameTemplate(aData, conversionFunctionBody);
                    conversionFunctionBody.append(MessageFormat.format("\t\t\tfinal {0} {1} = from.constGet_field_{2}();\n", fromFieldTypeName, tempId2, fromFieldName.getName()));
                    conversionFunctionBody.append(MessageFormat.format("\t\t\tif ({0}.is_bound()) '{'\n", tempId2));
                    ExpressionStruct tempExpression = new ExpressionStruct();
                    String tempId3 = toFieldType.generateConversion(aData, fromFieldType, tempId2, forValue, tempExpression);
                    tempExpression.openMergeExpression(conversionFunctionBody);
                    conversionFunctionBody.append(MessageFormat.format("\t\t\t\tto.get_field_{0}().operator_assign({1});\n", toFieldName.getName(), tempId3));
                    conversionFunctionBody.append("\t\t\t}\n");
                    conversionFunctionBody.append("\t\t\tbreak;\n");
                    conversionFunctionBody.append("\t\t}\n");
                }
            }
            conversionFunctionBody.append("\t\tdefault:\n");
            conversionFunctionBody.append("\t\t\treturn false;\n");
            conversionFunctionBody.append("\t\t}\n");
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }

    protected String generateConversionASNChoiceToASNChoice(JavaGenData aData, ASN1_Choice_Type fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            conversionFunctionBody.append("\t\tif(!from.is_bound()) {\n");
            conversionFunctionBody.append("\t\t\treturn false;\n");
            conversionFunctionBody.append("\t\t}\n");
            conversionFunctionBody.append("\t\tswitch (from.get_selection()) {\n");
            for (int i = 0; i < fromType.getNofComponents(); ++i) {
                CompField fromComp = fromType.getComponentByIndex(i);
                Identifier fromFieldName = fromComp.getIdentifier();
                IType fromFieldType = fromComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                for (int j = 0; j < this.getNofComponents(); ++j) {
                    CompField toComp = this.getComponentByIndex(j);
                    Identifier toFieldName = toComp.getIdentifier();
                    IType toFieldType = toComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                    if (!fromFieldName.equals(toFieldName) || !fromFieldType.isCompatible(CompilationTimeStamp.getBaseTimestamp(), toFieldType, null, null, null)) continue;
                    conversionFunctionBody.append(MessageFormat.format("\t\tcase ALT_{0}: '{'\n", fromFieldName.getName()));
                    String tempId2 = aData.getTemporaryVariableName();
                    String fromFieldTypeName = forValue ? fromFieldType.getGenNameValue(aData, conversionFunctionBody) : fromFieldType.getGenNameTemplate(aData, conversionFunctionBody);
                    conversionFunctionBody.append(MessageFormat.format("\t\t\tfinal {0} {1} = from.constGet_field_{2}();\n", fromFieldTypeName, tempId2, fromFieldName.getName()));
                    conversionFunctionBody.append(MessageFormat.format("\t\t\tif ({0}.is_bound()) '{'\n", tempId2));
                    ExpressionStruct tempExpression = new ExpressionStruct();
                    String tempId3 = toFieldType.generateConversion(aData, fromFieldType, tempId2, forValue, tempExpression);
                    tempExpression.openMergeExpression(conversionFunctionBody);
                    conversionFunctionBody.append(MessageFormat.format("\t\t\t\tto.get_field_{0}().operator_assign({1});\n", toFieldName.getName(), tempId3));
                    conversionFunctionBody.append("\t\t\t}\n");
                    conversionFunctionBody.append("\t\t\tbreak;\n");
                    conversionFunctionBody.append("\t\t}\n");
                }
            }
            conversionFunctionBody.append("\t\tdefault:\n");
            conversionFunctionBody.append("\t\t\treturn false;\n");
            conversionFunctionBody.append("\t\t}\n");
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }
}

