/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawAST;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;

public class JsonAST {
    public boolean omit_as_null;
    public String alias;
    public boolean as_value;
    public String parsed_default_value;
    public Location defaultLocation;
    public IValue default_value;
    public List<JsonSchemaExtension> schema_extensions;
    public boolean metainfo_unbound;
    public boolean as_number;
    public List<RawAST.rawAST_single_tag> tag_list;
    public boolean as_map;
    public boolean use_null;
    public List<JsonEnumText> enum_texts;
    public json_type_indicator type_indicator;
    public json_string_escaping string_escaping;

    public JsonAST() {
        this.init_JsonAST();
    }

    public JsonAST(JsonAST value) {
        if (value != null) {
            this.omit_as_null = value.omit_as_null;
            this.alias = value.alias;
            this.as_value = value.as_value;
            this.parsed_default_value = value.parsed_default_value;
            this.metainfo_unbound = value.metainfo_unbound;
            this.as_number = value.as_number;
            this.tag_list = value.tag_list != null ? new ArrayList<RawAST.rawAST_single_tag>(value.tag_list) : null;
            this.as_map = value.as_map;
            this.enum_texts = new ArrayList<JsonEnumText>(value.enum_texts);
            this.schema_extensions = new ArrayList<JsonSchemaExtension>(value.schema_extensions);
            this.use_null = value.use_null;
            this.type_indicator = value.type_indicator;
            this.string_escaping = value.string_escaping;
        } else {
            this.init_JsonAST();
        }
    }

    private void init_JsonAST() {
        this.omit_as_null = false;
        this.alias = null;
        this.as_value = false;
        this.parsed_default_value = null;
        this.metainfo_unbound = false;
        this.as_number = false;
        this.tag_list = null;
        this.as_map = false;
        this.enum_texts = new ArrayList<JsonEnumText>();
        this.schema_extensions = new ArrayList<JsonSchemaExtension>();
        this.use_null = false;
        this.type_indicator = json_type_indicator.JSON_NO_TYPE;
        this.string_escaping = json_string_escaping.ESCAPING_UNSET;
    }

    public boolean empty() {
        return !this.omit_as_null && this.alias == null && !this.as_value && this.parsed_default_value == null && !this.metainfo_unbound && !this.as_number && this.tag_list == null && !this.as_map && this.enum_texts.size() == 0 && !this.use_null && this.type_indicator != json_type_indicator.JSON_OBJECT && this.type_indicator != json_type_indicator.JSON_OBJECT_MEMBER && this.type_indicator != json_type_indicator.JSON_LITERAL && (this.string_escaping == json_string_escaping.ESCAPING_UNSET || this.string_escaping == json_string_escaping.ESCAPE_AS_SHORT);
    }

    public String get_type_str() {
        switch (this.type_indicator) {
            case JSON_NO_TYPE: {
                return "<none>";
            }
            case JSON_NUMBER: {
                return "JSON:number";
            }
            case JSON_INTEGER: {
                return "JSON:integer";
            }
            case JSON_STRING: {
                return "JSON:string";
            }
            case JSON_ARRAY: {
                return "JSON:array";
            }
            case JSON_OBJECT: {
                return "JSON:object";
            }
            case JSON_OBJECT_MEMBER: {
                return "JSON:objectMember";
            }
            case JSON_LITERAL: {
                return "JSON:literal";
            }
        }
        ErrorReporter.INTERNAL_ERROR((String)"JsonAST.get_type_str");
        return null;
    }

    public String get_escaping_str() {
        switch (this.string_escaping) {
            case ESCAPE_AS_SHORT: {
                return "escape as short";
            }
            case ESCAPE_AS_USI: {
                return "escape as usi";
            }
            case ESCAPE_AS_TRANSPARENT: {
                return "escape as transparent";
            }
        }
        ErrorReporter.INTERNAL_ERROR((String)"JsonAST.get_escaping_str");
        return null;
    }

    public String get_escaping_gen_str() {
        switch (this.string_escaping) {
            case ESCAPE_AS_SHORT: 
            case ESCAPING_UNSET: {
                return "ESCAPE_AS_SHORT";
            }
            case ESCAPE_AS_USI: {
                return "ESCAPE_AS_USI";
            }
            case ESCAPE_AS_TRANSPARENT: {
                return "ESCAPE_AS_TRANSPARENT";
            }
        }
        ErrorReporter.INTERNAL_ERROR((String)"JsonAST.get_escaping_gen_str");
        return null;
    }

    public void print_JsonAST() {
        int i;
        TITANDebugConsole.print("\n\rOmit encoding: ");
        if (this.omit_as_null) {
            TITANDebugConsole.print("as null value\n\r");
        } else {
            TITANDebugConsole.print("skip field\n\r");
        }
        if (this.alias != null) {
            TITANDebugConsole.print(MessageFormat.format("Name as {0}\n\r", this.alias));
        }
        if (this.as_value) {
            TITANDebugConsole.print("Encoding unions as JSON value\n\r");
        }
        if (this.parsed_default_value != null) {
            TITANDebugConsole.print(MessageFormat.format("Parsed default value: {0}\n\r", this.parsed_default_value));
        }
        if (this.as_number) {
            TITANDebugConsole.print("Encoding enumerated values as numbers\n\r");
        }
        if (0 != this.schema_extensions.size()) {
            TITANDebugConsole.print("Extensions:");
            for (i = 0; i < this.schema_extensions.size(); ++i) {
                TITANDebugConsole.print(MessageFormat.format(" \"{0}\" : \"{1}\"", this.schema_extensions.get((int)i).key, this.schema_extensions.get((int)i).value));
            }
        }
        if (this.metainfo_unbound) {
            TITANDebugConsole.print("Metainfo for unbound field(s)\n\r");
        }
        if (this.tag_list != null) {
            TITANDebugConsole.print("Chosen union fields:\n\r");
            TITANDebugConsole.print(MessageFormat.format("  Number of rules: {0}\n\r", this.tag_list.size()));
            for (i = 0; i < this.tag_list.size(); ++i) {
                TITANDebugConsole.print(MessageFormat.format("  Rule #{0}:\n\r", i));
                TITANDebugConsole.print(MessageFormat.format("    Chosen field: {0}\n\r", this.tag_list.get((int)i).fieldName != null ? this.tag_list.get((int)i).fieldName : "omit"));
                TITANDebugConsole.print(MessageFormat.format("    Number of conditions: {0}\n\r", this.tag_list.get((int)i).keyList.size()));
                for (int j = 0; j < this.tag_list.get((int)i).keyList.size(); ++j) {
                    TITANDebugConsole.print(MessageFormat.format("    Condition #{0}:\n\r", j));
                    TITANDebugConsole.print(MessageFormat.format("      Value: {0}\n\r", this.tag_list.get((int)i).keyList.get((int)j).value));
                    TITANDebugConsole.print("      Field: ");
                    for (int k = 0; k < this.tag_list.get((int)i).keyList.get((int)j).keyField.names.size(); ++k) {
                        if (k != 0) {
                            TITANDebugConsole.print(".");
                        }
                        TITANDebugConsole.print(this.tag_list.get((int)i).keyList.get((int)j).keyField.names.get(k).getName());
                    }
                    TITANDebugConsole.print("\n\r");
                }
            }
            TITANDebugConsole.print(MessageFormat.format("Type: {0}\n\r", this.get_type_str()));
            if (this.string_escaping != json_string_escaping.ESCAPING_UNSET) {
                TITANDebugConsole.print(MessageFormat.format("{0}\n\r", this.get_escaping_str()));
            }
        }
        if (this.as_map) {
            TITANDebugConsole.print("Encoding elements into a map of key-value pairs.\n\r");
        }
        if (0 != this.enum_texts.size()) {
            TITANDebugConsole.print("Enum texts:");
            for (i = 0; i < this.enum_texts.size(); ++i) {
                TITANDebugConsole.print(MessageFormat.format(" '{0}' -> '{1}'", this.enum_texts.get((int)i).from, this.enum_texts.get((int)i).to));
            }
            TITANDebugConsole.print("\n\r");
        }
    }

    public static enum json_string_escaping {
        ESCAPING_UNSET,
        ESCAPE_AS_SHORT,
        ESCAPE_AS_USI,
        ESCAPE_AS_TRANSPARENT;

    }

    public static enum json_type_indicator {
        JSON_NO_TYPE,
        JSON_NUMBER,
        JSON_INTEGER,
        JSON_STRING,
        JSON_ARRAY,
        JSON_OBJECT,
        JSON_OBJECT_MEMBER,
        JSON_LITERAL;

    }

    public static class JsonEnumText {
        public String from;
        public String to;
        public int index;

        public JsonEnumText(String p_from, String p_to) {
            this.from = p_from;
            this.to = p_to;
        }
    }

    public class JsonSchemaExtension {
        public String key;
        public String value;

        private void init(String p_key, String p_value) {
            this.key = p_key;
            this.value = p_value;
        }

        public JsonSchemaExtension(JsonSchemaExtension x) {
            this.init(x.key, x.value);
        }

        public JsonSchemaExtension(String p_key, String p_value) {
            this.init(p_key, p_value);
        }
    }
}

