/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public final class Def_Port
extends Definition {
    private static final String FULLNAMEPART1 = ".<type>";
    private static final String FULLNAMEPART2 = ".<dimensions>";
    public static final String PORTEXPECTED = "Port type expected";
    public static final String TYPEEXPECTED = "Type reference expected";
    private static final String KIND = "port definition";
    private final Reference portTypeReference;
    private Port_Type portType = null;
    private final ArrayDimensions dimensions;

    public Def_Port(Identifier identifier, Reference portTypeReference, ArrayDimensions dimensions) {
        super(identifier);
        this.portTypeReference = portTypeReference;
        this.dimensions = dimensions;
        if (portTypeReference != null) {
            portTypeReference.setFullNameParent(this);
        }
        if (dimensions != null) {
            dimensions.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_PORT;
    }

    public static String getKind() {
        return KIND;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.dimensions != null) {
            this.dimensions.setMyScope(scope);
        }
        if (this.portTypeReference != null) {
            this.portTypeReference.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portTypeReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.dimensions == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    public ArrayDimensions getDimensions() {
        return this.dimensions;
    }

    @Override
    public String getAssignmentName() {
        return "port";
    }

    @Override
    public String getOutlineIcon() {
        return "port.gif";
    }

    @Override
    public Port_Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.portType;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isUsed = false;
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionGlobalPort", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.portTypeReference == null) {
            return;
        }
        Assignment assignment = this.portTypeReference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return;
        }
        if (Assignment.Assignment_type.A_TYPE.semanticallyEquals(assignment.getAssignmentType()) && assignment.getType(timestamp) != null) {
            IType type = assignment.getType(timestamp);
            if ((type = type.getTypeRefdLast(timestamp)) != null && !type.getIsErroneous(timestamp)) {
                switch (type.getTypetype()) {
                    case TYPE_PORT: {
                        this.portType = (Port_Type)type;
                        break;
                    }
                    case TYPE_REFERENCED: {
                        break;
                    }
                    default: {
                        this.portTypeReference.getLocation().reportSemanticError(PORTEXPECTED);
                    }
                }
            }
        } else {
            this.portTypeReference.getLocation().reportSemanticError(TYPEEXPECTED);
        }
        if (this.dimensions != null) {
            this.dimensions.check(timestamp);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkIdentical(CompilationTimeStamp timestamp, Definition definition) {
        this.check(timestamp);
        definition.check(timestamp);
        if (!Assignment.Assignment_type.A_PORT.semanticallyEquals(definition.getAssignmentType())) {
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a port, but the definition inherited from component type `{1}'' is a {2}", this.identifier.getDisplayName(), definition.getMyScope().getFullName(), definition.getAssignmentName()));
            return false;
        }
        Def_Port otherPort = (Def_Port)definition;
        if (!this.portType.isIdentical(timestamp, otherPort.portType)) {
            String mesage = MessageFormat.format("Local port `{0}'' has type `{1}'', but the port inherited from component type `{2}'' has type `{3}''", this.identifier.getDisplayName(), this.portType.getTypename(), otherPort.getMyScope().getFullName(), otherPort.portType.getTypename());
            this.portTypeReference.getLocation().reportSemanticError(mesage);
            return false;
        }
        if (this.dimensions != null) {
            if (otherPort.dimensions != null) {
                if (this.dimensions.isIdenticial(timestamp, otherPort.dimensions)) return true;
                this.location.reportSemanticError(MessageFormat.format("Local port `{0}'' and the port inherited from component type `{1}'' have different array dimensions", this.identifier.getDisplayName(), otherPort.getMyScope().getFullName()));
                return false;
            }
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a port array, but the definition inherited from component type `{1}'' is a single port", this.identifier.getDisplayName(), otherPort.getMyScope().getFullName()));
            return false;
        }
        if (otherPort.dimensions == null) return true;
        this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a single port, but the definition inherited from component type `{1}'' is a port array", this.identifier.getDisplayName(), otherPort.getMyScope().getFullName()));
        return false;
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            super.addProposal(propCollector, index);
        } else if (subrefs.size() > index + 1 && this.portType != null && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.portType.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > index && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && this.portType != null) {
                this.portType.addDeclaration(declarationCollector, index + 1);
            } else if (subrefs.size() == index + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(index).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0 && this.identifier != null) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.portTypeReference != null) {
                this.portTypeReference.updateSyntax(reparser, false);
                reparser.updateLocation(this.portTypeReference.getLocation());
            }
            if (this.dimensions != null) {
                this.dimensions.updateSyntax(reparser, false);
            }
            if (this.withAttributesPath != null) {
                this.withAttributesPath.updateSyntax(reparser, false);
                reparser.updateLocation(this.withAttributesPath.getLocation());
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.portTypeReference != null) {
            this.portTypeReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portTypeReference.getLocation());
        }
        if (this.dimensions != null) {
            this.dimensions.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.portTypeReference != null) {
            this.portTypeReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.dimensions != null) {
            this.dimensions.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.portTypeReference != null && !this.portTypeReference.accept(v)) {
            return false;
        }
        return this.dimensions == null || this.dimensions.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        String genName = this.getGenName();
        StringBuilder sb = aData.getSrc();
        StringBuilder source = new StringBuilder();
        if (!this.isLocal()) {
            source.append("public static ");
        }
        if (this.getMyScope() instanceof ComponentTypeBody) {
            if (this.dimensions == null) {
                String portClassName = this.portType.getClassName(aData, source);
                source.append(MessageFormat.format("ThreadLocal<{0}> {1} = new ThreadLocal<{0}>() '{'\n", portClassName, genName));
                source.append("@Override\n");
                source.append(MessageFormat.format("protected {0} initialValue() '{'\n", portClassName));
                source.append(MessageFormat.format("return new {0}(\"{1}\");\n", portClassName, this.identifier.getDisplayName()));
                source.append("}\n");
                source.append("};\n");
            } else {
                StringBuilder tempSb = new StringBuilder();
                String typeGenName = this.portType.generateCodePort(aData, tempSb, this.dimensions);
                aData.getCodeForType(typeGenName).append((CharSequence)tempSb);
                source.append(MessageFormat.format("ThreadLocal<{0}> {1} = new ThreadLocal<{0}>() '{'\n", typeGenName, genName));
                source.append("@Override\n");
                source.append(MessageFormat.format("protected {0} initialValue() '{'\n", typeGenName));
                source.append(MessageFormat.format("final {0} temp = new {0}();\n", typeGenName));
                source.append(MessageFormat.format("final String port_name = \"{0}\";\n", this.identifier.getDisplayName()));
                source.append(MessageFormat.format("temp.set_name(port_name);\n", genName));
                source.append("return temp;\n");
                source.append("}\n");
                source.append("};\n");
                StringBuilder preInit = aData.getPreInit();
                preInit.append("{\n");
                preInit.append(MessageFormat.format("final String port_name = \"{0}\";\n", this.identifier.getDisplayName()));
                preInit.append(MessageFormat.format("{0}.get().set_name(port_name);\n", genName));
                preInit.append("}\n");
            }
            sb.append((CharSequence)source);
            aData.getInitComp().append(MessageFormat.format("{0}.get().activate_port(false);\n", genName));
        } else {
            if (this.dimensions == null) {
                String portClassName = this.portType.getClassName(aData, source);
                source.append(MessageFormat.format("{0} {1} = new {0}(\"{2}\");\n", portClassName, genName, this.identifier.getDisplayName()));
            } else {
                StringBuilder tempSb = new StringBuilder();
                String typeGenName = this.portType.generateCodePort(aData, tempSb, this.dimensions);
                aData.getCodeForType(typeGenName).append((CharSequence)tempSb);
                source.append(MessageFormat.format("{0} {1} = new {0}();\n", typeGenName, genName));
                StringBuilder preInit = aData.getPreInit();
                preInit.append("{\n");
                preInit.append(MessageFormat.format("final String port_name = \"{0}\";\n", this.identifier.getDisplayName()));
                preInit.append(MessageFormat.format("{0}.set_name(port_name);\n", genName));
                preInit.append("}\n");
            }
            sb.append((CharSequence)source);
            aData.getInitComp().append(MessageFormat.format("{0}.activate_port(false);\n", genName));
        }
    }

    @Override
    public void generateCodeInitComp(JavaGenData aData, StringBuilder initComp, Definition definition) {
        initComp.append(definition.getGenNameFromScope(aData, initComp, ""));
        initComp.append(".activate_port(false);\n");
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        Port_Type assType = this.getType(this.getLastTimeChecked());
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addText("port ");
        this.hoverContent.addStyledText(assType != null ? assType.getTypename() : "<?>").addStyledText(" ").addStyledText(this.getFullName(), 1);
        this.hoverContent.closeHeader();
        if (this.hasDocumentComment()) {
            dc.addDescsContent(this.hoverContent);
            dc.addMembersContent(this.hoverContent);
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append("\n").append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }
}

