/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.TTCN3.IAppendableSyntax;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FriendModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.PeekSource;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserUtilities;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;
import org.eclipse.ui.IEditorPart;

public final class Group
extends ASTNode
implements IOutlineElement,
ILocateableNode,
IAppendableSyntax,
ICommentable,
IReferencingElement {
    private final List<Definition> definitions;
    private final List<Group> groups;
    private final List<ImportModule> importedModules;
    private final List<FriendModule> friendModules;
    private CompilationTimeStamp lastCompilationTimeStamp;
    private CompilationTimeStamp lastUniquenessCheckTimeStamp;
    private Identifier identifier;
    private WithAttributesPath withAttributesPath = null;
    private Location location;
    private Location innerLocation;
    private Location commentLocation = null;
    private DocumentComment documentComment = null;
    protected Ttcn3HoverContent hoverContent = new Ttcn3HoverContent();
    private Group parentGroup;
    public static final String DUPLICATEGROUPFIRST = "Duplicate group definition with name `{0}'' was first defined here";
    public static final String DUPLICATEGROUPREPEATED = "Duplicate group definition with name `{0}'' was defined here again";
    public static final String GROUPCLASHGROUP = "Group name `{0}'' clashes with a definition";
    public static final String GROUPCLASHDEFINITION = "Definition of `{0}'' is here";

    public Group(Identifier identifier) {
        this.identifier = identifier;
        this.definitions = new CopyOnWriteArrayList<Definition>();
        this.groups = new ArrayList<Group>();
        this.importedModules = new CopyOnWriteArrayList<ImportModule>();
        this.friendModules = new CopyOnWriteArrayList<FriendModule>();
    }

    public final CompilationTimeStamp getLastTimeChecked() {
        return this.lastCompilationTimeStamp;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setInnerLocation(Location location) {
        this.innerLocation = location;
    }

    @Override
    public Location getCommentLocation() {
        return this.commentLocation;
    }

    public void setCommentLocation(Location commentLocation) {
        this.commentLocation = commentLocation;
    }

    public void setParentGroup(Group parentGroup) {
        this.parentGroup = parentGroup;
    }

    public Group getParentGroup() {
        return this.parentGroup;
    }

    public TTCN3Module getModule() {
        Group temp = this;
        while (temp.parentGroup != null) {
            temp = temp.parentGroup;
        }
        return (TTCN3Module)((Definitions)temp.getNameParent()).getParentScope();
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (Group group : this.groups) {
            if (group != child) continue;
            Identifier tempIdentifier = group.getIdentifier();
            return builder.append(".").append(tempIdentifier.getDisplayName());
        }
        return builder;
    }

    public void addImportedModule(ImportModule impmod) {
        if (impmod != null && impmod.getIdentifier() != null && impmod.getIdentifier().getLocation() != null) {
            impmod.setParentGroup(this);
            this.importedModules.add(impmod);
        }
    }

    public void addImportedModules(List<ImportModule> importModuleList) {
        if (importModuleList != null) {
            ArrayList<ImportModule> safeToAdd = new ArrayList<ImportModule>(importModuleList.size());
            for (ImportModule importModule : importModuleList) {
                if (importModule == null || importModule.getIdentifier() == null || importModule.getIdentifier().getLocation() == null) continue;
                safeToAdd.add(importModule);
                importModule.setParentGroup(this);
            }
            this.importedModules.addAll(safeToAdd);
        }
    }

    public void addFriendModule(FriendModule friendModule) {
        if (friendModule != null) {
            friendModule.setParentGroup(this);
            this.friendModules.add(friendModule);
        }
    }

    public void addFriendModules(List<FriendModule> friendModuleList) {
        if (friendModuleList != null) {
            ArrayList<FriendModule> safeToAdd = new ArrayList<FriendModule>(friendModuleList.size());
            for (FriendModule friendModule : friendModuleList) {
                if (friendModule == null) continue;
                safeToAdd.add(friendModule);
                friendModule.setParentGroup(this);
            }
            this.friendModules.addAll(safeToAdd);
        }
    }

    public void addDefinitions(List<Definition> definitionList) {
        if (definitionList != null) {
            ArrayList<Definition> safeToAdd = new ArrayList<Definition>(definitionList.size());
            for (Definition definition : definitionList) {
                if (definition == null || definition.getIdentifier() == null || definition.getIdentifier().getLocation() == null) continue;
                definition.setParentGroup(this);
                safeToAdd.add(definition);
            }
            this.definitions.addAll(safeToAdd);
        }
    }

    public void addGroup(Group group) {
        if (group != null && group.getIdentifier() != null && group.getIdentifier().getLocation() != null) {
            this.groups.add(group);
            group.setFullNameParent(this);
            group.setParentGroup(this);
        }
    }

    public void addDeclaration(DeclarationCollector declarationCollector) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() == 1 && this.identifier.getName().equals(subrefs.get(0).getId().getName())) {
            declarationCollector.addDeclaration(this);
        }
    }

    public void setWithAttributes(MultipleWithAttributes attributes) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        if (attributes != null) {
            this.withAttributesPath.setWithAttributes(attributes);
        }
    }

    public WithAttributesPath getAttributePath() {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        return this.withAttributesPath;
    }

    public void setAttributeParentPath(WithAttributesPath parent) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        this.withAttributesPath.setAttributeParent(parent);
    }

    @Override
    public Object[] getOutlineChildren() {
        ArrayList<Object> outlineElements = new ArrayList<Object>();
        if (!this.importedModules.isEmpty()) {
            outlineElements.add(this.importedModules);
        }
        if (!this.friendModules.isEmpty()) {
            outlineElements.add(this.friendModules);
        }
        int from = 0;
        for (Definition definition : this.definitions) {
            for (int j = from; j < this.groups.size(); ++j) {
                Group grp = this.groups.get(j);
                if (definition.getLocation().getLine() < grp.getLocation().getLine()) continue;
                outlineElements.add(grp);
                ++from;
            }
            outlineElements.add(definition);
        }
        if (from < this.groups.size()) {
            for (int i = from; i < this.groups.size(); ++i) {
                outlineElements.add(this.groups.get(i));
            }
        }
        return outlineElements.toArray();
    }

    @Override
    public String getOutlineText() {
        return "";
    }

    @Override
    public String getOutlineIcon() {
        return "outline_group.gif";
    }

    @Override
    public int category() {
        return 0;
    }

    private void checkUniqueness(CompilationTimeStamp timestamp) {
        if (this.lastUniquenessCheckTimeStamp != null && !this.lastUniquenessCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        HashMap<String, Definition> definitionMap = new HashMap<String, Definition>(this.definitions.size());
        HashMap<String, Group> groupMap = new HashMap<String, Group>(this.groups.size());
        for (Definition def : this.definitions) {
            String defName = def.getIdentifier().getName();
            if (definitionMap.containsKey(defName)) continue;
            definitionMap.put(defName, def);
        }
        for (Group group : this.groups) {
            String groupName = group.getIdentifier().getName();
            if (groupMap.containsKey(groupName)) {
                ((Group)groupMap.get(groupName)).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATEGROUPFIRST, groupName));
                group.getIdentifier().getLocation().reportSemanticError(MessageFormat.format(DUPLICATEGROUPREPEATED, groupName));
            } else {
                groupMap.put(groupName, group);
            }
            if (!definitionMap.containsKey(groupName)) continue;
            group.getIdentifier().getLocation().reportSemanticError(MessageFormat.format(GROUPCLASHGROUP, groupName));
            ((Definition)definitionMap.get(groupName)).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format(GROUPCLASHDEFINITION, groupName));
        }
        this.lastUniquenessCheckTimeStamp = timestamp;
    }

    public void markMarkersForRemoval(CompilationTimeStamp timestamp) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        MarkerHandler.markAllSemanticMarkersForRemoval(this.getCommentLocation());
        MarkerHandler.markAllSemanticMarkersForRemoval(this.getIdentifier());
        MarkerHandler.markAllSemanticMarkersForRemoval(this.withAttributesPath);
        for (Group innerGroup : this.groups) {
            innerGroup.markMarkersForRemoval(timestamp);
        }
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        this.lastCompilationTimeStamp = timestamp;
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionGroup", this.identifier, "group");
        NamingConventionHelper.checkNameContents(this.identifier, this.getModule().getIdentifier(), "group");
        this.checkUniqueness(timestamp);
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        for (Group group : this.groups) {
            group.check(timestamp);
        }
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            result.add(175);
            return result;
        }
        return null;
    }

    @Override
    public List<Integer> getPossiblePrefixTokens() {
        if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
            ArrayList<Integer> result = new ArrayList<Integer>(2);
            result.add(124);
            result.add(126);
            return result;
        }
        return new ArrayList<Integer>(0);
    }

    private int reparseIdentifier(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                Ttcn3Reparser.Pr_reparse_IdentifierContext root = parser.pr_reparse_Identifier();
                ParserUtilities.logParseTree((ParseTree)root, parser);
                Group.this.identifier = root.identifier;
            }
        });
    }

    private int reparseOptionalWithStatement(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                Ttcn3Reparser.Pr_reparser_optionalWithStatementContext root = parser.pr_reparser_optionalWithStatement();
                ParserUtilities.logParseTree((ParseTree)root, parser);
                MultipleWithAttributes attributes = root.attributes;
                Ttcn3Reparser.Pr_EndOfFileContext rootEof = parser.pr_EndOfFile();
                ParserUtilities.logParseTree((ParseTree)rootEof, parser);
                if (parser.isErrorListEmpty()) {
                    Group.this.withAttributesPath.setWithAttributes(attributes);
                    if (attributes != null) {
                        Group.this.getLocation().setEndOffset(attributes.getLocation().getEndOffset());
                    }
                }
            }
        });
    }

    private int reparseModuleDefinitionsList(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                ArrayList<Definition> allDefinitions = new ArrayList<Definition>();
                ArrayList<Definition> localDefinitions = new ArrayList<Definition>();
                ArrayList<Group> localGroups = new ArrayList<Group>();
                ArrayList<ImportModule> allImports = new ArrayList<ImportModule>();
                ArrayList<ImportModule> localImports = new ArrayList<ImportModule>();
                ArrayList<FriendModule> allFriends = new ArrayList<FriendModule>();
                ArrayList<FriendModule> localFriends = new ArrayList<FriendModule>();
                TTCN3Module temp = Group.this.getModule();
                parser.setModule(temp);
                Ttcn3Reparser.Pr_reparse_ModuleDefinitionsListContext root = parser.pr_reparse_ModuleDefinitionsList(null, allDefinitions, localDefinitions, localGroups, allImports, localImports, allFriends, localFriends, null);
                ParserUtilities.logParseTree((ParseTree)root, parser);
                if (parser.isErrorListEmpty()) {
                    temp.addDefinitions(allDefinitions);
                    for (ImportModule impmod : allImports) {
                        temp.addImportedModule(impmod);
                    }
                    temp.addFriendModules(allFriends);
                    Group.this.addDefinitions(localDefinitions);
                    Group.this.addImportedModules(localImports);
                    for (Group group : localGroups) {
                        Group.this.addGroup(group);
                    }
                    Group.this.addFriendModules(localFriends);
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateSyntax(TTCN3ReparseUpdater reparser, List<ImportModule> allImportedModules, List<Definition> allDefinitions, List<FriendModule> allFriends) throws ReParseException {
        int i;
        List<Integer> temp;
        boolean isBeingExtended;
        IVisitableNode temp2;
        int i2;
        int result = 0;
        Location tempLocation = this.identifier.getLocation();
        if (reparser.isDamaged(tempLocation)) {
            if (!reparser.envelopsDamage(tempLocation) && !reparser.isExtending(tempLocation)) throw new ReParseException();
            reparser.extendDamagedRegion(tempLocation);
            result = this.reparseIdentifier(reparser);
            if (result != 0) {
                throw new ReParseException(result);
            }
        } else {
            reparser.updateLocation(tempLocation);
        }
        if (reparser.isDamaged(this.innerLocation) && !reparser.envelopsDamage(this.innerLocation)) {
            throw new ReParseException();
        }
        boolean enveloped = false;
        int nofDamaged = 0;
        int leftBoundary = this.innerLocation.getOffset();
        int rightBoundary = this.innerLocation.getEndOffset();
        int damageOffset = reparser.getDamageStart();
        IVisitableNode lastAppendableBeforeChange = null;
        Object lastPrependableBeforeChange = null;
        int size = this.groups.size();
        for (i2 = 0; i2 < size && !enveloped; ++i2) {
            temp2 = this.groups.get(i2);
            tempLocation = ((Group)temp2).getLocation();
            if (reparser.envelopsDamage(tempLocation)) {
                enveloped = true;
                leftBoundary = tempLocation.getOffset();
                rightBoundary = tempLocation.getEndOffset();
                continue;
            }
            if (reparser.isDamaged(tempLocation)) {
                ++nofDamaged;
                continue;
            }
            if (tempLocation.getEndOffset() < damageOffset && tempLocation.getEndOffset() > leftBoundary) {
                leftBoundary = tempLocation.getEndOffset();
                lastAppendableBeforeChange = temp2;
            }
            if (tempLocation.getOffset() < damageOffset || tempLocation.getOffset() >= rightBoundary) continue;
            rightBoundary = tempLocation.getOffset();
            lastPrependableBeforeChange = temp2;
        }
        size = this.importedModules.size();
        for (i2 = 0; i2 < size && !enveloped; ++i2) {
            temp2 = this.importedModules.get(i2);
            tempLocation = ((ImportModule)temp2).getLocation();
            if (reparser.envelopsDamage(tempLocation)) {
                enveloped = true;
                leftBoundary = tempLocation.getOffset();
                rightBoundary = tempLocation.getEndOffset();
                continue;
            }
            if (reparser.isDamaged(tempLocation)) {
                ++nofDamaged;
                continue;
            }
            if (tempLocation.getEndOffset() < damageOffset && tempLocation.getEndOffset() > leftBoundary) {
                leftBoundary = tempLocation.getEndOffset();
                lastAppendableBeforeChange = temp2;
            }
            if (tempLocation.getOffset() < damageOffset || tempLocation.getOffset() >= rightBoundary) continue;
            rightBoundary = tempLocation.getOffset();
            lastPrependableBeforeChange = temp2;
        }
        size = this.friendModules.size();
        for (i2 = 0; i2 < size && !enveloped; ++i2) {
            temp2 = this.friendModules.get(i2);
            tempLocation = ((FriendModule)temp2).getLocation();
            if (reparser.envelopsDamage(tempLocation)) {
                enveloped = true;
                leftBoundary = tempLocation.getOffset();
                rightBoundary = tempLocation.getEndOffset();
                continue;
            }
            if (reparser.isDamaged(tempLocation)) {
                ++nofDamaged;
                continue;
            }
            if (tempLocation.getEndOffset() < damageOffset && tempLocation.getEndOffset() > leftBoundary) {
                leftBoundary = tempLocation.getEndOffset();
                lastAppendableBeforeChange = temp2;
            }
            if (tempLocation.getOffset() < damageOffset || tempLocation.getOffset() >= rightBoundary) continue;
            rightBoundary = tempLocation.getOffset();
            lastPrependableBeforeChange = temp2;
        }
        size = this.definitions.size();
        for (i2 = 0; i2 < size && !enveloped; ++i2) {
            Location tempCommentLocation;
            temp2 = this.definitions.get(i2);
            tempLocation = ((Assignment)temp2).getLocation();
            if (reparser.envelopsDamage(tempLocation)) {
                enveloped = true;
                leftBoundary = tempLocation.getOffset();
                rightBoundary = tempLocation.getEndOffset();
            } else if (reparser.isDamaged(tempLocation)) {
                ++nofDamaged;
                if (reparser.getDamageStart() == tempLocation.getEndOffset()) {
                    lastAppendableBeforeChange = temp2;
                } else if (reparser.getDamageEnd() == tempLocation.getOffset()) {
                    lastPrependableBeforeChange = temp2;
                }
            } else {
                if (tempLocation.getEndOffset() < damageOffset && tempLocation.getEndOffset() > leftBoundary) {
                    leftBoundary = tempLocation.getEndOffset();
                    lastAppendableBeforeChange = temp2;
                }
                if (tempLocation.getOffset() >= damageOffset && tempLocation.getOffset() < rightBoundary) {
                    rightBoundary = tempLocation.getOffset();
                    lastPrependableBeforeChange = temp2;
                }
            }
            if (!((Definition)temp2).hasDocumentComment() || (tempCommentLocation = ((Definition)temp2).getDocumentComment().getLocation()) == null || !reparser.isDamaged(tempCommentLocation)) continue;
            rightBoundary = tempCommentLocation.getOffset();
            lastPrependableBeforeChange = temp2;
        }
        if (!enveloped && reparser.envelopsDamage(this.location)) {
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        if (lastAppendableBeforeChange != null && (isBeingExtended = reparser.startsWithFollow(lastAppendableBeforeChange.getPossibleExtensionStarterTokens()))) {
            leftBoundary = lastAppendableBeforeChange.getLocation().getOffset();
            ++nofDamaged;
            enveloped = false;
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        if (lastPrependableBeforeChange != null && (temp = lastPrependableBeforeChange.getPossiblePrefixTokens()) != null && reparser.endsWithToken(temp)) {
            rightBoundary = lastPrependableBeforeChange.getLocation().getEndOffset();
            ++nofDamaged;
            enveloped = false;
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
        }
        if (nofDamaged != 0) {
            this.removeStuffInRange(reparser, allImportedModules, allDefinitions, this.friendModules);
        }
        for (i = 0; i < this.groups.size(); ++i) {
            Group temp3 = this.groups.get(i);
            tempLocation = temp3.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            try {
                temp3.updateSyntax(reparser, allImportedModules, allDefinitions, this.friendModules);
                continue;
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.groups.remove(i);
                    --i;
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                e.decreaseDepth();
                throw e;
            }
        }
        for (i = 0; i < this.importedModules.size(); ++i) {
            ImportModule temp4 = this.importedModules.get(i);
            tempLocation = temp4.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            try {
                temp4.updateSyntax(reparser, enveloped && reparser.envelopsDamage(tempLocation));
                continue;
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.importedModules.remove(i);
                    --i;
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                e.decreaseDepth();
                throw e;
            }
        }
        for (i = 0; i < this.friendModules.size(); ++i) {
            FriendModule temp5 = this.friendModules.get(i);
            tempLocation = temp5.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            try {
                temp5.updateSyntax(reparser, enveloped && reparser.envelopsDamage(tempLocation));
                continue;
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.friendModules.remove(i);
                    --i;
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                e.decreaseDepth();
                throw e;
            }
        }
        for (Definition temp6 : this.definitions) {
            tempLocation = temp6.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            try {
                boolean isDamaged = enveloped && reparser.envelopsDamage(tempLocation);
                temp6.updateSyntax(reparser, isDamaged);
                if (reparser.getNameChanged()) {
                    this.lastUniquenessCheckTimeStamp = null;
                    reparser.setNameChanged(false);
                }
                if (!isDamaged) continue;
                temp6.checkRoot();
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.definitions.remove(temp6);
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                e.decreaseDepth();
                throw e;
            }
        }
        if (result == 1) {
            this.removeStuffInRange(reparser, allImportedModules, allDefinitions, this.friendModules);
        }
        for (Group temp7 : this.groups) {
            tempLocation = temp7.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            reparser.updateLocation(tempLocation);
        }
        for (ImportModule temp8 : this.importedModules) {
            tempLocation = temp8.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            reparser.updateLocation(tempLocation);
        }
        for (FriendModule temp9 : this.friendModules) {
            tempLocation = temp9.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            reparser.updateLocation(tempLocation);
        }
        for (Definition temp10 : this.definitions) {
            tempLocation = temp10.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            reparser.updateLocation(tempLocation);
        }
        if (this.withAttributesPath != null && reparser.isAffected(this.withAttributesPath.getLocation())) {
            if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                reparser.extendDamagedRegion(this.withAttributesPath.getLocation());
                result = this.reparseOptionalWithStatement(reparser);
                if (result == 0) return;
                throw new ReParseException(result);
            }
            this.withAttributesPath.updateSyntax(reparser, reparser.envelopsDamage(this.withAttributesPath.getLocation()));
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
        if (!enveloped && reparser.envelopsDamage(this.innerLocation)) {
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            result = this.reparseModuleDefinitionsList(reparser);
        }
        reparser.updateLocation(this.innerLocation);
        if (result <= 1) return;
        throw new ReParseException(result - 1);
    }

    private void removeStuffInRange(TTCN3ReparseUpdater reparser, List<ImportModule> allImportedModules, List<Definition> allDefinitions, List<FriendModule> allFriends) {
        for (int i = this.groups.size() - 1; i >= 0; --i) {
            Group temp = this.groups.get(i);
            if (!reparser.isDamaged(temp.getLocation())) continue;
            reparser.extendDamagedRegion(temp.getLocation());
            this.groups.remove(i);
        }
        ArrayList<ImportModule> importsToBeRemoved = new ArrayList<ImportModule>();
        for (ImportModule importModule : this.importedModules) {
            if (!reparser.isDamaged(importModule.getLocation())) continue;
            reparser.extendDamagedRegion(importModule.getLocation());
            importsToBeRemoved.add(importModule);
        }
        this.importedModules.removeAll(importsToBeRemoved);
        importsToBeRemoved.clear();
        for (ImportModule importModule : allImportedModules) {
            if (!reparser.isDamaged(importModule.getLocation())) continue;
            reparser.extendDamagedRegion(importModule.getLocation());
            importsToBeRemoved.add(importModule);
        }
        allImportedModules.removeAll(importsToBeRemoved);
        ArrayList<FriendModule> frendsToBeRemoved = new ArrayList<FriendModule>();
        for (FriendModule temp : this.friendModules) {
            if (!reparser.isDamaged(temp.getLocation())) continue;
            reparser.extendDamagedRegion(temp.getLocation());
            frendsToBeRemoved.add(temp);
        }
        this.friendModules.removeAll(frendsToBeRemoved);
        frendsToBeRemoved.clear();
        for (FriendModule temp : allFriends) {
            if (!reparser.isDamaged(temp.getLocation())) continue;
            reparser.extendDamagedRegion(temp.getLocation());
            frendsToBeRemoved.add(temp);
        }
        allFriends.removeAll(frendsToBeRemoved);
        ArrayList<Definition> arrayList = new ArrayList<Definition>();
        for (Definition temp : this.definitions) {
            if (!reparser.isDamaged(temp.getLocation())) continue;
            reparser.extendDamagedRegion(temp.getLocation());
            arrayList.add(temp);
        }
        this.definitions.removeAll(arrayList);
        arrayList.clear();
        for (Definition temp : allDefinitions) {
            if (!reparser.isDamaged(temp.getLocation())) continue;
            reparser.extendDamagedRegion(temp.getLocation());
            arrayList.add(temp);
        }
        allDefinitions.removeAll(arrayList);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.identifier != null && !this.identifier.accept(v)) {
            return false;
        }
        if (this.importedModules != null) {
            for (ImportModule im : this.importedModules) {
                if (im.accept(v)) continue;
                return false;
            }
        }
        if (this.friendModules != null) {
            for (FriendModule fm : this.friendModules) {
                if (fm.accept(v)) continue;
                return false;
            }
        }
        if (this.definitions != null) {
            for (Definition def : this.definitions) {
                if (def.accept(v)) continue;
                return false;
            }
        }
        if (this.groups != null) {
            for (Group group : this.groups) {
                if (group.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    public void postCheck() {
        boolean isDocCheckEnabled;
        if (this.hasDocumentComment() && (isDocCheckEnabled = Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.titan.designer.enableDocumentCommentOnTheFlyCheck"))) {
            this.parseDocumentComment();
        }
        if (this.definitions != null) {
            for (Definition def : this.definitions) {
                def.postCheck();
            }
        }
        if (this.groups != null) {
            for (Group group : this.groups) {
                group.postCheck();
            }
        }
    }

    @Override
    public DocumentComment getDocumentComment() {
        return this.documentComment;
    }

    @Override
    public boolean hasDocumentComment() {
        return this.documentComment != null;
    }

    @Override
    public DocumentComment parseDocumentComment() {
        if (this.documentComment != null) {
            this.documentComment.parseComment();
        }
        return this.documentComment;
    }

    @Override
    public void setDocumentComment(DocumentComment docComment) {
        this.documentComment = docComment;
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        this.hoverContent = new Ttcn3HoverContent();
        if (editor != null) {
            PeekSource.addStyledSource(PeekSource.getPeekSource(editor, this.getLocation()), this.hoverContent);
        }
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addText("group ");
        this.hoverContent.addStyledText(this.getFullName(), 1);
        this.hoverContent.closeHeader();
        if (this.hasDocumentComment()) {
            DocumentComment dc = this.parseDocumentComment();
            dc.addDescsContent(this.hoverContent);
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append("\n").append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }

    @Override
    public Declaration getDeclaration() {
        return Declaration.createInstance(this);
    }
}

