/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.Value_Assignment;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.statements.InternalLogArgument;
import org.eclipse.titan.designer.AST.TTCN3.statements.Macro_InternalLogArgument;
import org.eclipse.titan.designer.AST.TTCN3.statements.Match_InternalLogArgument;
import org.eclipse.titan.designer.AST.TTCN3.statements.Reference_InternalLogArgument;
import org.eclipse.titan.designer.AST.TTCN3.statements.String_InternalLogArgument;
import org.eclipse.titan.designer.AST.TTCN3.statements.TemplateInstance_InternalLogArgument;
import org.eclipse.titan.designer.AST.TTCN3.statements.Value_InternalLogArgument;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Macro_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.MatchExpression;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class LogArgument
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private final TemplateInstance templateInstance;
    private InternalLogArgument internalLogArgument;
    private Location location = NULL_Location.INSTANCE;
    private boolean isErroneous;
    private CompilationTimeStamp lastTimeChecked;

    public LogArgument(TemplateInstance templateInstance) {
        this.templateInstance = templateInstance;
        if (templateInstance != null) {
            templateInstance.setFullNameParent(this);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance != null) {
            this.templateInstance.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.templateInstance != null) {
            this.templateInstance.setCodeSection(codeSection);
        }
        if (this.internalLogArgument != null) {
            this.internalLogArgument.setCodeSection(codeSection);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public InternalLogArgument getRealArgument() {
        return this.internalLogArgument;
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.templateInstance == null) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isErroneous = false;
        ITTCN3Template template = this.templateInstance.getTemplateBody();
        template.setMyGovernor(null);
        template = template.setLoweridToReference(timestamp);
        if (template.getIsErroneous(timestamp)) {
            this.isErroneous = true;
            return;
        }
        if (this.templateInstance.getType() == null && this.templateInstance.getDerivedReference() == null && template.isValue(timestamp)) {
            IValue value = template.getValue();
            IType gov = template.getMyGovernor();
            if (gov != null) {
                value.setMyGovernor(gov);
            }
            this.checkValue(timestamp, value);
        } else {
            IType governor = this.templateInstance.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
            if (governor == null) {
                governor = template.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
            }
            if (governor == null) {
                if (!template.getIsErroneous(timestamp)) {
                    this.getLocation().reportSemanticError("Cannot determine the type of the argument");
                }
                this.isErroneous = true;
            } else {
                this.internalLogArgument = new TemplateInstance_InternalLogArgument(this.templateInstance);
                this.templateInstance.check(timestamp, governor);
            }
        }
    }

    private void checkValue(CompilationTimeStamp timestamp, IValue value) {
        IValue temp = value.setLoweridToReference(timestamp);
        switch (temp.getValuetype()) {
            case CHARSTRING_VALUE: {
                this.internalLogArgument = new String_InternalLogArgument(((Charstring_Value)temp).getValue());
                break;
            }
            case REFERENCED_VALUE: {
                Reference reference = ((Referenced_Value)temp).getReference();
                this.internalLogArgument = new Reference_InternalLogArgument(reference);
                this.checkReference(timestamp, reference);
                return;
            }
            case EXPRESSION_VALUE: {
                Expression_Value castedValue = (Expression_Value)temp;
                if (Expression_Value.Operation_type.MATCH_OPERATION.equals((Object)castedValue.getOperationType())) {
                    this.internalLogArgument = new Match_InternalLogArgument((MatchExpression)castedValue);
                    break;
                }
                this.internalLogArgument = new Value_InternalLogArgument(temp);
                break;
            }
            case MACRO_VALUE: {
                this.internalLogArgument = new Macro_InternalLogArgument((Macro_Value)temp);
                break;
            }
            default: {
                this.internalLogArgument = new Value_InternalLogArgument(temp);
            }
        }
        IType governor = temp.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        if (governor == null) {
            this.getLocation().reportSemanticError("Cannot determine the type of the argument");
            this.isErroneous = true;
            return;
        }
        temp.setMyGovernor(governor);
        governor.checkThisValue(timestamp, temp, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_TEMPLATE, false, false, true, false, false));
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        if (InternalLogArgument.ArgumentType.Value.equals((Object)this.internalLogArgument.getArgumentType()) && !temp.isUnfoldable(timestamp)) {
            IValue last = temp.getValueRefdLast(timestamp, chain);
            if (IValue.Value_type.CHARSTRING_VALUE.equals((Object)last.getValuetype())) {
                this.internalLogArgument = new String_InternalLogArgument(((Charstring_Value)last).getValue());
            }
        } else if (InternalLogArgument.ArgumentType.Macro.equals((Object)this.internalLogArgument.getArgumentType())) {
            IValue last = temp.getValueRefdLast(timestamp, chain);
            switch (last.getValuetype()) {
                case CHARSTRING_VALUE: {
                    this.internalLogArgument = new String_InternalLogArgument(((Charstring_Value)last).getValue());
                    break;
                }
                case MACRO_VALUE: {
                    break;
                }
                default: {
                    this.internalLogArgument = new Value_InternalLogArgument(temp);
                }
            }
        }
        chain.release();
    }

    private void checkReference(CompilationTimeStamp timestamp, Reference reference) {
        if (reference == null) {
            return;
        }
        Assignment assignment = reference.getRefdAssignment(timestamp, true);
        if (assignment == null || assignment.getIsErroneous()) {
            return;
        }
        switch (assignment.getAssignmentType()) {
            case A_FUNCTION_RVAL: 
            case A_FUNCTION_RTEMP: 
            case A_EXT_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RTEMP: {
                reference.getMyScope().checkRunsOnScope(timestamp, assignment, (ILocateableNode)reference, "call");
                IType assingmentType = assignment.getType(timestamp);
                if (assingmentType == null) break;
                assingmentType.getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                break;
            }
            case A_CONST: {
                IType assingmentType = assignment.getType(timestamp);
                if (assingmentType == null || assingmentType.getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false) == null) break;
                ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                if (assignment instanceof Def_Const) {
                    ((Def_Const)assignment).getValue().getReferencedSubValue(timestamp, reference, 1, chain);
                } else {
                    ((Value_Assignment)assignment).getValue().getReferencedSubValue(timestamp, reference, 1, chain);
                }
                chain.release();
                break;
            }
            case A_TEMPLATE: {
                IType assingmentType = assignment.getType(timestamp);
                if (assingmentType == null || assingmentType.getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false) == null) break;
                ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                ((Def_Template)assignment).getTemplate(timestamp).getReferencedSubTemplate(timestamp, reference, chain, false);
                chain.release();
                break;
            }
            case A_MODULEPAR_TEMPLATE: {
                IType assingmentType = assignment.getType(timestamp);
                if (assingmentType == null) break;
                assingmentType.getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                break;
            }
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_VAR: 
            case A_VAR_TEMPLATE: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                IType assingmentType = assignment.getType(timestamp);
                if (assingmentType == null) break;
                assingmentType.getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                break;
            }
            case A_PORT: {
                ArrayDimensions dimensions = ((Def_Port)assignment).getDimensions();
                if (dimensions != null) {
                    dimensions.checkIndices(timestamp, reference, assignment.getAssignmentName(), true, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                    break;
                }
                if (reference.getSubreferences().size() <= 1) break;
                this.getLocation().reportSemanticError(MessageFormat.format("Reference to single {0} cannot have field or array sub-references", assignment.getDescription()));
                this.isErroneous = true;
                break;
            }
            case A_TIMER: {
                ArrayDimensions dimensions = ((Def_Timer)assignment).getDimensions();
                if (dimensions != null) {
                    dimensions.checkIndices(timestamp, reference, assignment.getAssignmentName(), true, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                    break;
                }
                if (reference.getSubreferences().size() <= 1) break;
                this.getLocation().reportSemanticError(MessageFormat.format("Reference to single {0} cannot have field or array sub-references", assignment.getDescription()));
                this.isErroneous = true;
                break;
            }
            case A_PAR_TIMER: 
            case A_PAR_PORT: {
                if (reference.getSubreferences().size() <= 1) break;
                this.getLocation().reportSemanticError(MessageFormat.format("Reference to {0} cannot have field or array sub-references", assignment.getDescription()));
                this.isErroneous = true;
                break;
            }
            case A_FUNCTION: 
            case A_EXT_FUNCTION: {
                this.getLocation().reportSemanticError(MessageFormat.format("Reference to a value, template, timer or port was ecpected instead of a call of {0}, which does not have a return type", assignment.getDescription()));
                this.isErroneous = true;
                break;
            }
            default: {
                this.getLocation().reportSemanticError(MessageFormat.format("Reference to a value, template, timer or port was expected instead of {0}", assignment.getDescription()));
                this.isErroneous = true;
            }
        }
    }

    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.internalLogArgument == null || this.isErroneous) {
            return;
        }
        this.internalLogArgument.checkRecursions(timestamp, referenceChain);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance != null) {
            this.templateInstance.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance == null) {
            return;
        }
        this.templateInstance.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.templateInstance == null || this.templateInstance.accept(v);
    }

    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        if (this.internalLogArgument != null) {
            this.internalLogArgument.generateCode(aData, expression);
        }
        source.append((CharSequence)expression.preamble);
        source.append((CharSequence)expression.expression);
        source.append(";\n");
    }

    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression) {
        if (this.internalLogArgument != null) {
            this.internalLogArgument.generateCode(aData, expression);
        }
    }
}

