/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Parameter_Assignment
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private final Reference reference;
    private final Identifier identifier;
    private final Value encoding;
    private boolean is_decoded;
    private IType declarationType;
    private Location location = NULL_Location.INSTANCE;

    public Parameter_Assignment(Reference reference, Identifier identifier) {
        this.reference = reference;
        this.identifier = identifier;
        this.encoding = null;
        this.declarationType = null;
        if (reference != null) {
            reference.setFullNameParent(this);
        }
    }

    public Parameter_Assignment(Reference reference, Identifier identifier, Value string_encoding) {
        this.reference = reference;
        this.identifier = identifier;
        this.encoding = string_encoding;
        this.is_decoded = true;
        this.declarationType = null;
        if (reference != null) {
            reference.setFullNameParent(this);
        }
        if (this.encoding != null) {
            this.encoding.setFullNameParent(this);
        }
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Reference getReference() {
        return this.reference;
    }

    public boolean isDecoded() {
        return this.is_decoded;
    }

    public Value getStringEncoding() {
        return this.encoding;
    }

    public void setDeclarationType(IType declarationType) {
        this.declarationType = declarationType;
    }

    public IType getDeclarationType() {
        return this.declarationType;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.encoding == child) {
            return builder.append(".<string_encoding>");
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
        if (this.encoding != null) {
            this.encoding.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.reference != null) {
            this.reference.setCodeSection(codeSection);
        }
        if (this.encoding != null) {
            this.encoding.setCodeSection(codeSection);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        this.reference.updateSyntax(reparser, isDamaged);
        reparser.updateLocation(this.reference.getLocation());
        if (this.encoding != null) {
            this.encoding.updateSyntax(reparser, isDamaged);
            reparser.updateLocation(this.encoding.getLocation());
        }
        reparser.updateLocation(this.identifier.getLocation());
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.reference != null) {
            this.reference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.identifier != null) {
            // empty if block
        }
        if (this.encoding != null) {
            this.encoding.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.reference != null && !this.reference.accept(v)) {
            return false;
        }
        if (this.encoding != null && !this.encoding.accept(v)) {
            return false;
        }
        return this.identifier == null || this.identifier.accept(v);
    }
}

