/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectClassCase;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class SelectClassCases
extends ASTNode
implements IIncrementallyUpdateable {
    private final List<SelectClassCase> select_class_cases = new ArrayList<SelectClassCase>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectClassCase(SelectClassCase selectCase) {
        List<SelectClassCase> list = this.select_class_cases;
        synchronized (list) {
            this.select_class_cases.add(selectCase);
        }
        selectCase.setFullNameParent(this);
    }

    @Override
    public void setMyScope(Scope scope) {
        for (SelectClassCase select_class_case : this.select_class_cases) {
            select_class_case.setMyScope(scope);
        }
    }

    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        for (SelectClassCase scc : this.select_class_cases) {
            scc.setMyStatementBlock(statementBlock, index);
        }
    }

    public void setMyDefinition(Definition definition) {
        for (SelectClassCase scc : this.select_class_cases) {
            scc.setMyDefinition(definition);
        }
    }

    public void setMyAltguards(AltGuards altGuards) {
        for (SelectClassCase scc : this.select_class_cases) {
            scc.setMyAltguards(altGuards);
        }
    }

    public void setMyLaicStmt(AltGuards pAltGuards, Statement pLoopStmt) {
        for (SelectClassCase scc : this.select_class_cases) {
            scc.getStatementBlock().setMyLaicStmt(pAltGuards, pLoopStmt);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.select_class_cases == null) {
            return;
        }
        for (SelectClassCase sc : this.select_class_cases) {
            sc.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (SelectClassCase sc : this.select_class_cases) {
            sc.updateSyntax(reparser, false);
            reparser.updateLocation(sc.getLocation());
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.select_class_cases != null) {
            for (SelectClassCase sc : this.select_class_cases) {
                if (sc.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    public void check(CompilationTimeStamp timestamp, Class_Type refClass) {
        boolean unrechable = false;
        for (SelectClassCase sc : this.select_class_cases) {
            unrechable = sc.check(timestamp, refClass, unrechable);
        }
    }

    public void postCheck() {
        for (SelectClassCase sc : this.select_class_cases) {
            sc.postCheck();
        }
    }

    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        StatementBlock.ReturnStatus_type retval = StatementBlock.ReturnStatus_type.RS_MAYBE;
        boolean hasElse = false;
        for (SelectClassCase scc : this.select_class_cases) {
            switch (scc.getStatementBlock().hasReturn(timestamp)) {
                case RS_NO: {
                    if (retval == StatementBlock.ReturnStatus_type.RS_YES) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    retval = StatementBlock.ReturnStatus_type.RS_NO;
                    break;
                }
                case RS_YES: {
                    if (retval == StatementBlock.ReturnStatus_type.RS_NO) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    retval = StatementBlock.ReturnStatus_type.RS_YES;
                    break;
                }
                default: {
                    return StatementBlock.ReturnStatus_type.RS_MAYBE;
                }
            }
            if (scc.getType() != null) continue;
            hasElse = true;
            break;
        }
        if (!hasElse && retval == StatementBlock.ReturnStatus_type.RS_YES) {
            return StatementBlock.ReturnStatus_type.RS_MAYBE;
        }
        return retval;
    }
}

