/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.PortScope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeSet;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Send_Statement
extends Statement {
    private static final String SENDONPORT = "Message-based operation `send'' is not applicable to a procedure-based port of type `{0}''";
    private static final String UNKNOWNOUTGOINGMESSAGE = "Cannot determine the type of the outgoing message";
    private static final String TYPENOTPRESENT = "Message type `{0}'' is not present on the outgoing list of port type `{1}''";
    private static final String TYPEISAMBIGUOUS = "Type of the message is amiguous: `{0}'' is compatible with more than one outgoing message types of port type `{1}''";
    private static final String NOOUTGOINGMESSAGETYPES = "Port type `{0}'' does not have any outgoing message types";
    private static final String SENDPARAMETERSIGNATURE = "The type of send parameter is signature `{0}'' which cannot be a message type";
    private static final String SENDPARAMETERPORT = "The type of send parameter is port type `{0}'' which can not be a message type";
    private static final String SENDPARAMETERDEFAULT = "The type of send parameter is the `default'' type, which cannot be a message type";
    private static final String FULLNAMEPART1 = ".portreference";
    private static final String FULLNAMEPART2 = ".sendparameter";
    private static final String FULLNAMEPART3 = ".to";
    private static final String FULLNAMEPART4 = ".redirectTimestamp";
    private static final String STATEMENT_NAME = "send";
    private final Reference portReference;
    private final boolean translate;
    private final TemplateInstance parameter;
    private final IValue toClause;
    private final Reference redirectTimestamp;

    public Send_Statement(Reference portReference, TemplateInstance parameter, IValue toClause, Reference redirectTimestamp, boolean translate) {
        this.portReference = portReference;
        this.translate = translate;
        this.parameter = parameter;
        this.toClause = toClause;
        this.redirectTimestamp = redirectTimestamp;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (parameter != null) {
            parameter.setFullNameParent(this);
        }
        if (toClause != null) {
            toClause.setFullNameParent(this);
        }
        if (redirectTimestamp != null) {
            redirectTimestamp.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_SEND;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.parameter == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.toClause == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.toClause == child) {
            return builder.append(FULLNAMEPART4);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null && !this.translate) {
            this.portReference.setMyScope(scope);
        }
        if (this.parameter != null) {
            this.parameter.setMyScope(scope);
        }
        if (this.toClause != null) {
            this.toClause.setMyScope(scope);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.portReference != null && !this.translate) {
            this.portReference.setCodeSection(codeSection);
        }
        if (this.parameter != null) {
            this.parameter.setCodeSection(codeSection);
        }
        if (this.toClause != null) {
            this.toClause.setCodeSection(codeSection);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setCodeSection(codeSection);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void check(CompilationTimeStamp timestamp) {
        Port_Type portType;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.translate) {
            PortScope ps = this.myStatementBlock.getScopePort();
            if (ps == null) {
                this.getLocation().reportSemanticError("Cannot determine the type of the port: Missing port clause on the function.");
                this.lastTimeChecked = timestamp;
                return;
            }
            portType = ps.getPortType();
        } else {
            portType = Port_Utility.checkPortReference(timestamp, this, this.portReference, false);
        }
        if (this.parameter == null) {
            this.lastTimeChecked = timestamp;
            return;
        }
        IType messageType = null;
        boolean messageTypeDetermined = false;
        if (portType != null) {
            portType.check(timestamp);
            PortTypeBody portTypeBody = portType.getPortBody();
            TypeSet outMessages = portTypeBody.getOutMessage();
            if (PortTypeBody.OperationModes.OP_Procedure.equals((Object)portTypeBody.getOperationMode())) {
                this.portReference.getLocation().reportSemanticError(MessageFormat.format(SENDONPORT, portType.getTypename()));
            } else if (outMessages != null) {
                if (outMessages.getNofTypes() == 1) {
                    messageType = outMessages.getTypeByIndex(0);
                } else {
                    messageType = Port_Utility.getOutgoingType(timestamp, this.parameter);
                    if (messageType == null) {
                        this.parameter.getLocation().reportSemanticError(UNKNOWNOUTGOINGMESSAGE);
                    } else {
                        int nofCompatibleTypes = outMessages.getNofCompatibleTypes(timestamp, messageType);
                        if (nofCompatibleTypes == 0) {
                            this.parameter.getLocation().reportSemanticError(MessageFormat.format(TYPENOTPRESENT, messageType.getTypename(), portType.getTypename()));
                        } else if (nofCompatibleTypes > 1) {
                            this.parameter.getLocation().reportSemanticError(MessageFormat.format(TYPEISAMBIGUOUS, messageType.getTypename(), portType.getTypename()));
                        }
                    }
                }
                messageTypeDetermined = true;
            } else {
                this.portReference.getLocation().reportSemanticError(MessageFormat.format(NOOUTGOINGMESSAGETYPES, portType.getTypename()));
            }
        }
        if (!messageTypeDetermined) {
            messageType = Port_Utility.getOutgoingType(timestamp, this.parameter);
        }
        if (messageType != null) {
            this.parameter.check(timestamp, messageType);
            messageType = messageType.getTypeRefdLast(timestamp);
            switch (messageType.getTypetype()) {
                case TYPE_SIGNATURE: {
                    this.parameter.getLocation().reportSemanticError(MessageFormat.format(SENDPARAMETERSIGNATURE, messageType.getTypename()));
                    break;
                }
                case TYPE_PORT: {
                    this.parameter.getLocation().reportSemanticError(MessageFormat.format(SENDPARAMETERPORT, messageType.getTypename()));
                    break;
                }
                case TYPE_DEFAULT: {
                    this.parameter.getLocation().reportSemanticError(MessageFormat.format(SENDPARAMETERDEFAULT, messageType.getTypename()));
                    break;
                }
            }
            this.parameter.getTemplateBody().checkSpecificValue(timestamp, false);
        }
        Port_Utility.checkToClause(timestamp, this, portType, this.toClause);
        Port_Utility.checkTimestampRedirect(timestamp, portType, this.redirectTimestamp);
        this.lastTimeChecked = timestamp;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.toClause != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(162);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.parameter != null) {
            this.parameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.parameter.getLocation());
        }
        if (this.toClause instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.toClause)).updateSyntax(reparser, false);
            reparser.updateLocation(this.toClause.getLocation());
        } else if (this.toClause != null) {
            throw new ReParseException();
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectTimestamp.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parameter != null) {
            this.parameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.toClause != null) {
            this.toClause.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.parameter != null && !this.parameter.accept(v)) {
            return false;
        }
        if (this.toClause != null && !this.toClause.accept(v)) {
            return false;
        }
        return this.redirectTimestamp == null || this.redirectTimestamp.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        if (!this.translate) {
            this.portReference.generateCode(aData, expression);
            expression.expression.append(".send(");
        } else {
            expression.expression.append("send(");
        }
        TTCN3Template templateBody = this.parameter.getTemplateBody();
        if (this.parameter.getDerivedReference() == null && ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)templateBody.getTemplatetype()) && ((SpecificValue_Template)templateBody).isValue(CompilationTimeStamp.getBaseTimestamp())) {
            IValue value = ((SpecificValue_Template)templateBody).getValue();
            value.generateCodeExpressionMandatory(aData, expression, true);
        } else {
            this.parameter.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
        }
        if (this.toClause != null) {
            expression.expression.append(", ");
            this.toClause.generateCodeExpression(aData, expression, true);
        }
        expression.expression.append(", ");
        if (this.redirectTimestamp == null) {
            expression.expression.append("null");
        } else {
            this.redirectTimestamp.generateCode(aData, expression);
        }
        expression.expression.append(")");
        expression.mergeExpression(source);
    }
}

