/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Start_Component_Statement
extends Statement {
    private static final String TEMPLATERETURN = "Function `{0}'' returns a template of type `{1}'', which cannot be retrieved when the test component terminates";
    private static final String COMPONENTTYPEMISMATCH = "Component type mismatch: The component reference is of type `{0}'', but {1} runs on `{2}''";
    private static final String REFERENCETOFUNCTIONWASEXPECTED = "Reference to a function was expected in the argument instead of {0}";
    private static final String RETURNWITHOUTDONE = "Return type of {0} is `{1}'', which does not have the `done'' extension attibute. When the test component terminates the returnes value cannot be retrived with a `done'' operation";
    private static final String FULLNAMEPART1 = ".componentreference";
    private static final String FULLNAMEPART2 = ".functionreference";
    private static final String STATEMENT_NAME = "start test component";
    private final IValue componentReference;
    private final Reference functionInstanceReference;

    public Start_Component_Statement(IValue componentReference, Reference functionInstanceReference) {
        this.componentReference = componentReference;
        this.functionInstanceReference = functionInstanceReference;
        if (componentReference != null) {
            componentReference.setFullNameParent(this);
        }
        if (functionInstanceReference != null) {
            functionInstanceReference.setFullNameParent(this);
        }
    }

    public Reference getFunctionInstanceReference() {
        return this.functionInstanceReference;
    }

    public IValue getComponent() {
        return this.componentReference;
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_START_COMPONENT;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.componentReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.functionInstanceReference == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.componentReference != null) {
            this.componentReference.setMyScope(scope);
        }
        if (this.functionInstanceReference != null) {
            this.functionInstanceReference.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.componentReference != null) {
            this.componentReference.setCodeSection(codeSection);
        }
        if (this.functionInstanceReference != null) {
            this.functionInstanceReference.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        IType componentType = Port_Utility.checkComponentReference(timestamp, this, this.componentReference, false, false, false);
        Assignment assignment = this.functionInstanceReference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return;
        }
        switch (assignment.getAssignmentType()) {
            case A_FUNCTION: 
            case A_FUNCTION_RTEMP: 
            case A_FUNCTION_RVAL: {
                break;
            }
            default: {
                this.functionInstanceReference.getLocation().reportSemanticError(MessageFormat.format(REFERENCETOFUNCTIONWASEXPECTED, assignment.getDescription()));
                return;
            }
        }
        Def_Function function = (Def_Function)assignment;
        if (!function.checkStartable(timestamp, this.getLocation())) {
            return;
        }
        Component_Type runsOnType = function.getRunsOnType(timestamp);
        if (componentType == null || runsOnType == null) {
            return;
        }
        if (!runsOnType.isCompatible(timestamp, componentType, null, null, null)) {
            this.componentReference.getLocation().reportSemanticError(MessageFormat.format(COMPONENTTYPEMISMATCH, componentType.getTypename(), function.getDescription(), runsOnType.getTypename()));
        }
        switch (function.getAssignmentType()) {
            case A_FUNCTION_RTEMP: {
                this.functionInstanceReference.getLocation().reportSemanticWarning(MessageFormat.format(TEMPLATERETURN, function.getFullName(), function.getType(timestamp).getTypename()));
                break;
            }
            case A_FUNCTION_RVAL: {
                IType type = function.getType(timestamp);
                boolean returnTypeCorrect = false;
                while (!returnTypeCorrect) {
                    if (type.hasDoneAttribute()) {
                        returnTypeCorrect = true;
                        break;
                    }
                    if (!(type instanceof IReferencingType)) break;
                    ReferenceChain refChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    IType refd = ((IReferencingType)((Object)type)).getTypeRefd(timestamp, refChain);
                    refChain.release();
                    if (type == refd) break;
                    type = refd;
                }
                if (returnTypeCorrect) break;
                String message = MessageFormat.format(RETURNWITHOUTDONE, function.getDescription(), function.getType(timestamp).getTypename());
                this.functionInstanceReference.getLocation().reportSemanticWarning(message);
                break;
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (!(this.componentReference instanceof IIncrementallyUpdateable)) {
            throw new ReParseException();
        }
        ((IIncrementallyUpdateable)((Object)this.componentReference)).updateSyntax(reparser, false);
        reparser.updateLocation(this.componentReference.getLocation());
        if (this.functionInstanceReference != null) {
            this.functionInstanceReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.functionInstanceReference.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentReference != null) {
            this.componentReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.functionInstanceReference != null) {
            this.functionInstanceReference.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentReference != null && !this.componentReference.accept(v)) {
            return false;
        }
        return this.functionInstanceReference == null || this.functionInstanceReference.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        Assignment func = this.functionInstanceReference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
        Def_Function function = (Def_Function)func;
        expression.expression.append(MessageFormat.format("{0}(", func.getGenNameFromScope(aData, source, "start_")));
        this.componentReference.generateCodeExpression(aData, expression, false);
        FormalParameterList formalParameterList = function.getFormalParameterList();
        if (formalParameterList.getNofParameters() > 0) {
            expression.expression.append(',');
            ISubReference subReference = this.functionInstanceReference.getSubreferences().get(0);
            ((ParameterisedSubReference)subReference).getActualParameters().generateCodeNoAlias(aData, expression, formalParameterList);
        }
        expression.expression.append(')');
        expression.mergeExpression(source);
    }
}

