/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Start_Timer_Statement
extends Statement {
    private static final String TIMERREFERENCEEXPECTED = "Reference to a timer or timer parameter was expected instead of {0}";
    private static final String INVALIDSUBREFERENCES = "Reference to {0} cannot have field or array sub-references";
    private static final String FLOATEXPECTED = "float operand was expected";
    private static final String NEGATIVEDURATION = "The timer duration is negative: `{0}''";
    private static final String INFINITYDURATION = "The timer duration is `{0}''";
    private static final String MISSINGDEFAULTDURATION = "Missing duration: {0} does not have default duration";
    private static final String FULLNAMEPART1 = ".timerreference";
    private static final String FULLNAMEPART2 = ".timervalue";
    private static final String STATEMENT_NAME = "start timer";
    private final Reference timerReference;
    private final IValue timerValue;

    public Start_Timer_Statement(Reference timerReference, IValue value) {
        this.timerReference = timerReference;
        this.timerValue = value;
        if (timerReference != null) {
            timerReference.setFullNameParent(this);
        }
        if (this.timerValue != null) {
            this.timerValue.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_START_TIMER;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.timerReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.timerValue == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.timerReference != null) {
            this.timerReference.setMyScope(scope);
        }
        if (this.timerValue != null) {
            this.timerValue.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.timerReference != null) {
            this.timerReference.setCodeSection(codeSection);
        }
        if (this.timerValue != null) {
            this.timerValue.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        Start_Timer_Statement.checkTimerReference(timestamp, this.timerReference, false);
        if (this.timerValue == null) {
            Def_Timer defTimer;
            Assignment assignment = this.timerReference.getRefdAssignment(timestamp, true);
            if (assignment != null && Assignment.Assignment_type.A_TIMER.semanticallyEquals(assignment.getAssignmentType()) && !(defTimer = (Def_Timer)assignment).hasDefaultDuration(timestamp, this.timerReference)) {
                this.location.reportSemanticError(MessageFormat.format(MISSINGDEFAULTDURATION, assignment.getDescription()));
            }
        } else {
            this.timerValue.setLoweridToReference(timestamp);
            IType.Type_type temporalType = this.timerValue.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            switch (temporalType) {
                case TYPE_REAL: {
                    IValue last = this.timerValue.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
                    if (!last.isUnfoldable(timestamp)) {
                        Real_Value real = (Real_Value)last;
                        double val = real.getValue();
                        if (val < 0.0) {
                            this.timerValue.getLocation().reportSemanticError(MessageFormat.format(NEGATIVEDURATION, real));
                        } else if (real.isPositiveInfinity()) {
                            this.timerValue.getLocation().reportSemanticError(MessageFormat.format(INFINITYDURATION, real.createStringRepresentation()));
                        }
                    }
                    return;
                }
                case TYPE_UNDEFINED: {
                    return;
                }
            }
            this.timerValue.getLocation().reportSemanticError(FLOATEXPECTED);
            return;
        }
    }

    public static void checkTimerReference(CompilationTimeStamp timestamp, Reference reference, boolean anyFrom) {
        if (reference == null) {
            return;
        }
        Assignment assignment = reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return;
        }
        switch (assignment.getAssignmentType()) {
            case A_TIMER: {
                ArrayDimensions dimensions = ((Def_Timer)assignment).getDimensions();
                if (dimensions != null) {
                    dimensions.checkIndices(timestamp, reference, "timer", false, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, anyFrom);
                    break;
                }
                if (reference.getSubreferences().size() <= 1) break;
                reference.getLocation().reportSemanticError(MessageFormat.format("Reference to a single {0} cannot have field or array sub-references", assignment.getDescription()));
                break;
            }
            case A_PAR_TIMER: {
                if (reference.getSubreferences().size() <= 1) break;
                reference.getLocation().reportSemanticError(MessageFormat.format(INVALIDSUBREFERENCES, assignment.getDescription()));
                break;
            }
            default: {
                reference.getLocation().reportSemanticError(MessageFormat.format(TIMERREFERENCEEXPECTED, assignment.getDescription()));
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.timerReference != null) {
            this.timerReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.timerReference.getLocation());
        }
        if (this.timerValue instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.timerValue)).updateSyntax(reparser, false);
            reparser.updateLocation(this.timerValue.getLocation());
        } else if (this.timerValue != null) {
            throw new ReParseException();
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.timerReference != null) {
            this.timerReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.timerValue != null) {
            this.timerValue.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.timerReference != null && !this.timerReference.accept(v)) {
            return false;
        }
        return this.timerValue == null || this.timerValue.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        this.timerReference.generateCode(aData, expression);
        expression.expression.append(".start(");
        if (this.timerValue != null) {
            this.timerValue.generateCodeExpressionMandatory(aData, expression, false);
        }
        expression.expression.append(")");
        expression.mergeExpression(source);
    }
}

