/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class DecodeMatch_template
extends TTCN3Template {
    final Value stringEncoding;
    final TemplateInstance target;

    public DecodeMatch_template(Value stringEncoding, TemplateInstance target) {
        this.stringEncoding = stringEncoding;
        this.target = target;
        if (stringEncoding != null) {
            stringEncoding.setFullNameParent(this);
        }
        if (target != null) {
            target.setFullNameParent(this);
        }
    }

    public Value getStringEncoding() {
        return this.stringEncoding;
    }

    public TemplateInstance getDecodeTarget() {
        return this.target;
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.DECODE_MATCH;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous decode match";
        }
        return "decode match";
    }

    @Override
    public String createStringRepresentation() {
        if (this.target == null) {
            return "<erroneous template>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("decmatch ");
        if (this.stringEncoding != null) {
            builder.append('(');
            builder.append(this.stringEncoding.createStringRepresentation());
            builder.append(')');
        }
        builder.append(this.target.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE).getTypename());
        builder.append(": ");
        this.target.getTemplateBody().createStringRepresentation();
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.stringEncoding == child) {
            return builder.append(".<string_encoding>");
        }
        if (this.target == child) {
            return builder.append(".<decoding_target>");
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.stringEncoding != null) {
            this.stringEncoding.setMyScope(scope);
        }
        if (this.target != null) {
            this.target.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.stringEncoding != null) {
            this.stringEncoding.setCodeSection(codeSection);
        }
        if (this.target != null) {
            this.target.setCodeSection(codeSection);
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.setCodeSection(codeSection);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.target != null) {
            this.target.checkRecursions(timestamp, referenceChain);
        }
    }

    @Override
    public boolean checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit, Assignment lhs) {
        boolean selfRef = type.checkThisTemplate(timestamp, this, isModified, implicitOmit, lhs);
        this.checkLengthRestriction(timestamp, type);
        if (!allowOmit && this.isIfpresent) {
            this.location.reportSemanticError("`ifpresent' is not allowed here");
        }
        if (subCheck) {
            type.checkThisTemplateSubtype(timestamp, this);
        }
        return selfRef;
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.target != null) {
            return this.target.getTemplateBody().checkExpressionSelfReferenceTemplate(timestamp, lhs);
        }
        return false;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value expected instead of a decode match");
    }

    public boolean checkThisTemplateString(CompilationTimeStamp timestamp, IType type, boolean implicitOmit, Assignment lhs) {
        TTCN3Template targetBody = this.target.getTemplateBody();
        targetBody.setLoweridToReference(timestamp);
        IType targetType = this.target.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        if (targetType == null) {
            this.target.getLocation().reportSemanticError("Type of template instance cannot be determined");
            return false;
        }
        targetType.check(timestamp);
        if (this.target.getType() != null && targetType instanceof IReferencingType) {
            targetType = targetType.getTypeRefdLast(timestamp);
        }
        targetBody.setMyGovernor(targetType);
        boolean selfReference = targetBody.checkThisTemplateGeneric(timestamp, targetType, this.target.getDerivedReference() != null, false, true, true, implicitOmit, lhs);
        targetType.checkCoding(timestamp, false, this.getMyScope().getModuleScope(), false, this.target.getLocation());
        if (this.stringEncoding != null) {
            if (type.getTypetype() != IType.Type_type.TYPE_UCHARSTRING) {
                this.stringEncoding.getLocation().reportSemanticError("The encoding format parameter is only available to universal charstring templates");
                return selfReference;
            }
            selfReference |= this.stringEncoding.checkStringEncoding(timestamp, lhs);
        }
        return selfReference;
    }

    @Override
    public boolean needsTemporaryReference() {
        return true;
    }

    @Override
    public boolean hasSingleExpression() {
        return false;
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        aData.addBuiltinTypeImport("IDecode_Match");
        aData.addBuiltinTypeImport("TTCN_Buffer");
        aData.addBuiltinTypeImport("TitanOctetString");
        aData.addCommonLibraryImport("TtcnError");
        aData.addCommonLibraryImport("TTCN_Logger");
        aData.addBuiltinTypeImport("Base_Type.TTCN_Typedescriptor");
        aData.addBuiltinTypeImport("Base_Template.template_sel");
        String tempVariableName = aData.getTemporaryVariableName();
        IType targetType = this.target.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        String targetTypeName = targetType.getGenNameValue(aData, source);
        String targetTemplateName = targetType.getGenNameTemplate(aData, source);
        source.append(MessageFormat.format("class dec_match_{0} implements IDecode_Match '{'\n", tempVariableName));
        source.append(MessageFormat.format("{0} target;\n", targetTemplateName));
        source.append(MessageFormat.format("{0} dec_val;\n", targetTypeName));
        source.append(MessageFormat.format("public dec_match_{0}(final {1} target) '{'\n", tempVariableName, targetTemplateName));
        source.append("this.target = target;\n");
        source.append("}\n");
        source.append("@Override\n");
        source.append("public boolean match(final TTCN_Buffer buffer) {\n");
        source.append(MessageFormat.format("dec_val = new {0}();\n", targetTypeName));
        source.append("boolean ret_val;\n");
        source.append("TitanOctetString os = new TitanOctetString();\n");
        source.append("buffer.get_string(os);\n");
        source.append(MessageFormat.format("if ({0}_decoder(os, dec_val, {1}_default_coding) != 0) '{'\n", targetType.getGenNameCoder(aData, source, this.myScope), targetType.getGenNameDefaultCoding(aData, source, this.myScope)));
        source.append("TtcnError.TtcnWarning(\"Decoded content matching failed, because the data could not be decoded.\");\n");
        source.append("ret_val = false;\n");
        source.append("} else if (os.lengthof().operator_not_equals(0)) {\n");
        source.append("TtcnError.TtcnWarning(MessageFormat.format(\"Decoded content matching failed, because the buffer was not empty after decoding. Remaining octets: {0}.\", os.lengthof().get_int()));\n");
        source.append("ret_val = false;\n");
        source.append("} else {\n");
        source.append("ret_val = target.match(dec_val, true);\n");
        source.append("}\n");
        source.append("if (!ret_val) {\n");
        source.append("dec_val = null;\n");
        source.append("}\n");
        source.append("return ret_val;\n");
        source.append("}\n");
        source.append("@Override\n");
        source.append("public void log() {\n");
        source.append(MessageFormat.format("TTCN_Logger.log_event_str(\"{0}: \");\n", targetTypeName));
        source.append("target.log();\n");
        source.append("}\n");
        source.append("@Override\n");
        source.append("public Object get_dec_res() {\n");
        source.append("return dec_val;\n");
        source.append("}\n");
        source.append("@Override\n");
        source.append("public TTCN_Typedescriptor get_type_descr() {\n");
        source.append(MessageFormat.format("return {0}_descr_;\n", targetType.getGenNameTypeDescriptor(aData, source)));
        source.append("}\n");
        source.append("};\n");
        source.append(MessageFormat.format("{0}.set_type(template_sel.DECODE_MATCH, 0);\n", name));
        source.append("{\n");
        String target_tempID = aData.getTemporaryVariableName();
        if (this.target.getDerivedReference() == null) {
            source.append(MessageFormat.format("final {0} {1} = new {0}();\n", targetTemplateName, target_tempID));
        } else {
            ExpressionStruct referencedExpression = new ExpressionStruct();
            this.target.getDerivedReference().generateCode(aData, referencedExpression);
            if (referencedExpression.preamble.length() > 0) {
                source.append((CharSequence)referencedExpression.preamble);
            }
            source.append(MessageFormat.format("final {0} {1} = new {0}({2});\n", targetTemplateName, target_tempID, referencedExpression.expression));
            if (referencedExpression.postamble.length() > 0) {
                source.append((CharSequence)referencedExpression.postamble);
            }
        }
        this.target.getTemplateBody().generateCodeInit(aData, source, target_tempID);
        ExpressionStruct codingExpression = new ExpressionStruct();
        if (this.stringEncoding != null) {
            this.stringEncoding.generateCodeExpression(aData, codingExpression, true);
            if (codingExpression.preamble.length() > 0) {
                source.append((CharSequence)codingExpression.preamble);
            }
        }
        source.append(MessageFormat.format("{0}.set_decmatch(new dec_match_{1}({2})", name, tempVariableName, target_tempID));
        if (codingExpression.expression.length() > 0) {
            source.append(", ").append((CharSequence)codingExpression.expression);
        }
        source.append(");\n");
        if (codingExpression.postamble.length() > 0) {
            source.append((CharSequence)codingExpression.postamble);
        }
        source.append("}\n");
    }

    @Override
    public void setMyDefinition(Definition definition) {
        if (this.target != null) {
            this.target.getTemplateBody().setMyDefinition(definition);
        }
    }
}

