/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ValueRange
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART1 = ".<lower_boundary>";
    private static final String FULLNAMEPART2 = ".<lower_boundary>";
    private final Value min;
    private final boolean minExclusive;
    private final Value max;
    private final boolean maxExclusive;
    private IType.Type_type typeType;

    public ValueRange(Value min, boolean minExclusive, Value max, boolean maxExclusive) {
        this.min = min;
        this.minExclusive = minExclusive;
        this.max = max;
        this.maxExclusive = maxExclusive;
        if (min != null) {
            min.setFullNameParent(this);
        }
        if (max != null) {
            max.setFullNameParent(this);
        }
    }

    public Value getMin() {
        return this.min;
    }

    public boolean isMinExclusive() {
        return this.minExclusive;
    }

    public Value getMax() {
        return this.max;
    }

    public boolean isMaxExclusive() {
        return this.maxExclusive;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.min != null) {
            this.min.setMyScope(scope);
        }
        if (this.max != null) {
            this.max.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.min != null) {
            this.min.setCodeSection(codeSection);
        }
        if (this.max != null) {
            this.max.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.min == child) {
            return builder.append(".<lower_boundary>");
        }
        if (this.max == child) {
            return builder.append(".<lower_boundary>");
        }
        return builder;
    }

    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        if (this.min == null) {
            builder.append("-infinity");
        } else {
            builder.append(this.min.createStringRepresentation());
        }
        builder.append(" .. ");
        if (this.max == null) {
            builder.append("infinity");
        } else {
            builder.append(this.max.createStringRepresentation());
        }
        builder.append(')');
        return builder.toString();
    }

    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IType type;
        if (this.min != null && (type = this.min.getExpressionGovernor(timestamp, expectedValue)) != null) {
            return type;
        }
        if (this.max != null && (type = this.max.getExpressionGovernor(timestamp, expectedValue)) != null) {
            return type;
        }
        return null;
    }

    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IType.Type_type type;
        if (this.min != null && !IType.Type_type.TYPE_UNDEFINED.equals((Object)(type = this.min.getExpressionReturntype(timestamp, expectedValue)))) {
            return type;
        }
        if (this.max != null && !IType.Type_type.TYPE_UNDEFINED.equals((Object)(type = this.max.getExpressionReturntype(timestamp, expectedValue)))) {
            return type;
        }
        return IType.Type_type.TYPE_UNDEFINED;
    }

    public boolean checkExpressionSelfReferenceValue(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.min != null && this.min.checkExpressionSelfReferenceValue(timestamp, lhs)) {
            return true;
        }
        return this.max != null && this.max.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.min != null) {
            this.min.updateSyntax(reparser, false);
            reparser.updateLocation(this.min.getLocation());
        }
        if (this.max != null) {
            this.max.updateSyntax(reparser, false);
            reparser.updateLocation(this.max.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.min != null) {
            this.min.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.max != null) {
            this.max.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.min != null && !this.min.accept(v)) {
            return false;
        }
        return this.max == null || this.max.accept(v);
    }

    public void setTypeType(IType.Type_type typeType) {
        this.typeType = typeType;
    }

    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.min != null) {
            this.min.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.max != null) {
            this.max.reArrangeInitCode(aData, source, usageModule);
        }
    }

    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        IValue last;
        ReferenceChain chain;
        aData.addBuiltinTypeImport("Base_Template.template_sel");
        ExpressionStruct expression = new ExpressionStruct();
        StringBuilder initStatement = new StringBuilder();
        initStatement.append(name);
        initStatement.append(".set_type( template_sel.VALUE_RANGE );\n");
        if (this.min != null) {
            chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            last = this.min.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), chain);
            chain.release();
            if (!last.getValuetype().equals((Object)IValue.Value_type.REAL_VALUE) || ((Real_Value)last).getValue() != Double.NEGATIVE_INFINITY) {
                last.generateCodeExpression(aData, expression, false);
                initStatement.append(name);
                initStatement.append(".set_min( ");
                initStatement.append((CharSequence)expression.expression);
                initStatement.append(" );\n");
            }
        }
        if (this.minExclusive) {
            switch (this.typeType) {
                case TYPE_INTEGER: 
                case TYPE_REAL: 
                case TYPE_CHARSTRING: 
                case TYPE_UCHARSTRING: {
                    initStatement.append(name);
                    initStatement.append(".set_min_exclusive(true);\n");
                    break;
                }
                default: {
                    ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while processing lower bound `" + this.getFullName() + "''"));
                }
            }
        }
        if (this.max != null) {
            chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            last = this.max.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), chain);
            chain.release();
            if (!last.getValuetype().equals((Object)IValue.Value_type.REAL_VALUE) || ((Real_Value)last).getValue() != Double.POSITIVE_INFINITY) {
                expression.expression = new StringBuilder();
                last.generateCodeExpression(aData, expression, false);
                initStatement.append(name);
                initStatement.append(".set_max( ");
                initStatement.append((CharSequence)expression.expression);
                initStatement.append(" );\n");
            }
        }
        if (this.maxExclusive) {
            switch (this.typeType) {
                case TYPE_INTEGER: 
                case TYPE_REAL: 
                case TYPE_CHARSTRING: 
                case TYPE_UCHARSTRING: {
                    initStatement.append(name);
                    initStatement.append(".set_max_exclusive(true);\n");
                    break;
                }
                default: {
                    ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while processing upper bound `" + this.getFullName() + "''"));
                }
            }
        }
        if (expression.preamble.length() > 0 || expression.postamble.length() > 0) {
            source.append("{\n");
            source.append((CharSequence)expression.preamble);
            source.append((CharSequence)initStatement);
            source.append((CharSequence)expression.postamble);
            source.append("}\n");
        } else {
            source.append((CharSequence)initStatement);
        }
    }
}

