/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.JsonAST;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawAST;
import org.eclipse.titan.designer.AST.TTCN3.templates.SingleLenghtRestriction;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.Length_ParsedSubType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.ParsedSubType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public abstract class AbstractOfType
extends ASN1Type {
    public static final String INCOMPLETEPRESENTERROR = "Not used symbol `-' is not allowed in this context";
    private static final String FULLNAMEPART = ".oftype";
    private final IType ofType;
    private boolean componentInternal;
    private boolean insideCanHaveCoding = false;

    public AbstractOfType(IType ofType) {
        this.ofType = ofType;
        if (ofType != null) {
            ofType.setOwnertype(IType.TypeOwner_type.OT_RECORD_OF, this);
            ofType.setFullNameParent(this);
        }
        this.componentInternal = false;
    }

    public IType getOfType() {
        return this.ofType;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.ofType == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.ofType != null) {
            this.ofType.setMyScope(scope);
        }
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    public boolean isSubtypeCompatible(CompilationTimeStamp timestamp, IType other) {
        long nofComponents;
        if (this.subType == null || other == null) {
            return true;
        }
        switch (other.getTypetype()) {
            case TYPE_ASN1_SEQUENCE: {
                nofComponents = ((ASN1_Sequence_Type)other).getNofComponents();
                break;
            }
            case TYPE_TTCN3_SEQUENCE: {
                nofComponents = ((TTCN3_Sequence_Type)other).getNofComponents();
                break;
            }
            case TYPE_ASN1_SET: {
                nofComponents = ((ASN1_Set_Type)other).getNofComponents();
                break;
            }
            case TYPE_TTCN3_SET: {
                nofComponents = ((TTCN3_Set_Type)other).getNofComponents();
                break;
            }
            case TYPE_SEQUENCE_OF: 
            case TYPE_SET_OF: {
                if (other.getSubtype() == null) {
                    return true;
                }
                return this.subType.isCompatible(timestamp, other.getSubtype());
            }
            case TYPE_ARRAY: {
                ArrayDimension dimension = ((Array_Type)other).getDimension();
                if (dimension.getIsErroneous(timestamp)) {
                    return false;
                }
                nofComponents = dimension.getSize();
                break;
            }
            default: {
                return false;
            }
        }
        ArrayList<ParsedSubType> tempRestrictions = new ArrayList<ParsedSubType>(1);
        Integer_Value length = new Integer_Value(nofComponents);
        tempRestrictions.add(new Length_ParsedSubType(new SingleLenghtRestriction(length)));
        SubType tempSubtype = new SubType(this.getSubtypeType(), this, tempRestrictions, null);
        tempSubtype.check(timestamp);
        return this.subType.isCompatible(timestamp, tempSubtype);
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public boolean isComponentInternal(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.componentInternal;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Module module;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.myScope != null && null != this.lastTimeChecked && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            this.lastTimeChecked = timestamp;
            return;
        }
        this.lastTimeChecked = timestamp;
        this.componentInternal = false;
        this.isErroneous = false;
        this.initAttributes(timestamp);
        if (this.ofType == null) {
            this.setIsErroneous(true);
        } else {
            this.ofType.setGenName(this.getGenNameOwn(), "0");
            this.ofType.setParentType(this);
            this.ofType.check(timestamp);
            if (!this.isAsn()) {
                this.ofType.checkEmbedded(timestamp, this.ofType.getLocation(), true, "embedded into another type");
            }
            this.componentInternal = this.ofType.isComponentInternal(timestamp);
        }
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        this.checkSubtypeRestrictions(timestamp);
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
        if (typeSet.contains(this)) {
            return;
        }
        if (this.ofType != null && this.ofType.isComponentInternal(timestamp)) {
            typeSet.add(this);
            this.ofType.checkComponentInternal(timestamp, typeSet, operation);
            typeSet.remove(this);
        }
    }

    public boolean checkThisValueSetOf(CompilationTimeStamp timestamp, SetOf_Value value, Assignment lhs, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean implicitOmit, boolean strElem) {
        boolean selfReference = false;
        if (value.isIndexed()) {
            boolean checkHoles = Expected_Value_type.EXPECTED_CONSTANT.equals((Object)expectedValue);
            BigInteger maxIndex = BigInteger.valueOf(-1L);
            HashMap<BigInteger, Integer> indexMap = new HashMap<BigInteger, Integer>(value.getNofComponents());
            int size = value.getNofComponents();
            for (int i = 0; i < size; ++i) {
                IValue component = value.getValueByIndex(i);
                Value index = value.getIndexByIndex(i);
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                IValue indexLast = index.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                if (indexLast.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)indexLast.getValuetype())) {
                    checkHoles = false;
                } else {
                    BigInteger tempIndex = ((Integer_Value)indexLast).getValueValue();
                    if (tempIndex.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
                        index.getLocation().reportSemanticError(MessageFormat.format("A integer value less than `{0}'' was expected for indexing type `{1}'' instead of `{2}''", Integer.MAX_VALUE, this.getTypename(), tempIndex));
                        checkHoles = false;
                    } else if (tempIndex.compareTo(BigInteger.ZERO) == -1) {
                        index.getLocation().reportSemanticError(MessageFormat.format("A non-negative integer value was expected for indexing type `{0}'' instead of `{1}''", this.getTypename(), tempIndex));
                        checkHoles = false;
                    } else if (indexMap.containsKey(tempIndex)) {
                        index.getLocation().reportSemanticError(MessageFormat.format("Duplicate index value `{0}'' for components {1} and {2}", tempIndex, indexMap.get(tempIndex), i + 1));
                        checkHoles = false;
                    } else {
                        indexMap.put(tempIndex, i + 1);
                        if (maxIndex.compareTo(tempIndex) == -1) {
                            maxIndex = tempIndex;
                        }
                    }
                }
                component.setMyGovernor(this.getOfType());
                IValue tempValue2 = this.getOfType().checkThisValueRef(timestamp, component);
                selfReference |= this.getOfType().checkThisValue(timestamp, tempValue2, lhs, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, implicitOmit, strElem));
            }
            if (checkHoles && maxIndex.compareTo(BigInteger.valueOf(indexMap.size() - 1)) != 0) {
                value.getLocation().reportSemanticError("It's not allowed to create hole(s) in constant values");
            }
        } else {
            int size = value.getNofComponents();
            for (int i = 0; i < size; ++i) {
                IValue component = value.getValueByIndex(i);
                component.setMyGovernor(this.getOfType());
                if (IValue.Value_type.NOTUSED_VALUE.equals((Object)component.getValuetype())) {
                    if (incompleteAllowed) continue;
                    component.getLocation().reportSemanticWarning(INCOMPLETEPRESENTERROR);
                    continue;
                }
                IValue tempValue2 = this.getOfType().checkThisValueRef(timestamp, component);
                selfReference |= this.getOfType().checkThisValue(timestamp, tempValue2, lhs, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, implicitOmit, strElem));
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (this.insideCanHaveCoding) {
            return true;
        }
        this.insideCanHaveCoding = true;
        for (int i = 0; i < this.codingTable.size(); ++i) {
            IType.Coding_Type tempCodingType = (IType.Coding_Type)this.codingTable.get(i);
            if (!tempCodingType.builtIn || !tempCodingType.builtInCoding.equals((Object)coding)) continue;
            this.insideCanHaveCoding = false;
            return true;
        }
        IType refdLast = this.ofType.getTypeRefdLast(timestamp);
        boolean result = refdLast.canHaveCoding(timestamp, coding);
        this.insideCanHaveCoding = false;
        return result;
    }

    @Override
    public void setGenerateCoderFunctions(CompilationTimeStamp timestamp, IType.MessageEncoding_type encodingType) {
        switch (encodingType) {
            case RAW: 
            case JSON: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.getGenerateCoderFunctions(encodingType)) {
            return;
        }
        this.codersToGenerate.add(encodingType);
        this.getOfType().getTypeRefdLast(timestamp).setGenerateCoderFunctions(timestamp, encodingType);
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        int restrictionLength;
        if (this.subType != null && (restrictionLength = this.subType.get_length_restriction()) != -1) {
            if (this.rawAttribute == null) {
                this.rawAttribute = new RawAST(this.getDefaultRawFieldLength());
            }
            this.rawAttribute.length_restriction = restrictionLength;
            this.ofType.forceRaw(timestamp);
            if (this.rawAttribute.fieldlength == 0 && this.rawAttribute.length_restriction != -1) {
                this.rawAttribute.fieldlength = this.rawAttribute.length_restriction;
                this.rawAttribute.length_restriction = -1;
            }
            if (this.rawAttribute.length_restriction != -1 && this.rawAttribute.length_restriction != this.rawAttribute.fieldlength) {
                this.getLocation().reportSemanticError(MessageFormat.format("Invalid length specified in parameter FIELDLENGTH for type `{0}''. The FIELDLENGTH must be equal to specified length restriction", this.getFullName()));
            }
        }
        this.checkJson(timestamp);
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        refChain.markState();
        this.ofType.checkCodingAttributes(timestamp, refChain);
        refChain.previousState();
    }

    @Override
    public void checkJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null && !this.hasEncodeAttribute("JSON")) {
            return;
        }
        this.ofType.forceJson(timestamp);
        if (this.jsonAttribute == null) {
            return;
        }
        if (this.jsonAttribute.omit_as_null && !this.isOptionalField()) {
            this.getLocation().reportSemanticError("Invalid attribute, 'omit as null' requires optional field of a record or set.");
        }
        if (this.jsonAttribute.as_value) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as value' is only allowed for unions, the anytype, or records or sets with one field");
        }
        if (this.jsonAttribute.alias != null) {
            IType parent = this.getParentType();
            if (parent == null) {
                this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
            } else {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: 
                    case TYPE_TTCN3_CHOICE: {
                        break;
                    }
                    default: {
                        this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
                    }
                }
            }
            if (parent != null && parent.getJsonAttribute() != null && parent.getJsonAttribute().as_value) {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Seq_Choice_BaseType)parent).getNofComponents() != 1) break;
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                }
            }
        }
        if (this.jsonAttribute.parsed_default_value != null) {
            this.checkJsonDefault(timestamp);
        }
        if (this.jsonAttribute.as_number) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as number' is only allowed for enumerated types");
        }
        if (this.jsonAttribute.as_map) {
            IType ofTypeLast = this.ofType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            if (ofTypeLast.getTypetype() == IType.Type_type.TYPE_TTCN3_SEQUENCE && ((TTCN3_Sequence_Type)ofTypeLast).getNofComponents() == 2) {
                Type keyType = ((TTCN3_Sequence_Type)ofTypeLast).getComponentByIndex(0).getType();
                if (keyType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetype() != IType.Type_type.TYPE_UCHARSTRING) {
                    this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires the element type's first field to be a universal charstring");
                }
                if (keyType.isOptionalField()) {
                    this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires the element type's first field to be mandatory");
                }
                ofTypeLast.setJsonAttributes(new JsonAST(this.jsonAttribute));
            } else if (ofTypeLast.getTypetype() == IType.Type_type.TYPE_TTCN3_SET || ((TTCN3_Set_Type)ofTypeLast).getNofComponents() == 2) {
                Type keyType = ((TTCN3_Set_Type)ofTypeLast).getComponentByIndex(0).getType();
                if (keyType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetype() != IType.Type_type.TYPE_UCHARSTRING) {
                    this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires the element type's first field to be a universal charstring");
                }
                if (keyType.isOptionalField()) {
                    this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires the element type's first field to be mandatory");
                }
                ofTypeLast.setJsonAttributes(new JsonAST(this.jsonAttribute));
            } else {
                this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires the element type to be a record or set with 2 fields");
            }
        }
        if (this.jsonAttribute.enum_texts.size() > 0) {
            this.getLocation().reportSemanticError("Invalid attribute, 'text ... as ...' requires an enumerated type");
        }
    }

    @Override
    public void getTypesWithNoCodingTable(CompilationTimeStamp timestamp, ArrayList<IType> typeList, boolean onlyOwnTable) {
        if (typeList.contains(this)) {
            return;
        }
        if (onlyOwnTable && this.codingTable.isEmpty() || !onlyOwnTable && this.getTypeWithCodingTable(timestamp, false) == null) {
            typeList.add(this);
        }
        this.ofType.getTypesWithNoCodingTable(timestamp, typeList, onlyOwnTable);
    }

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        int fieldIndex;
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        if (subreference.getReferenceType() != ISubReference.Subreference_type.arraySubReference) {
            ErrorReporter.INTERNAL_ERROR();
            return false;
        }
        Value indexValue = ((ArraySubReference)subreference).getValue();
        if (indexValue == null) {
            ErrorReporter.INTERNAL_ERROR();
            return false;
        }
        IValue last = indexValue.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_CONSTANT, null);
        if (last == null) {
            ErrorReporter.INTERNAL_ERROR();
            return false;
        }
        if (last.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_CONSTANT) != IType.Type_type.TYPE_INTEGER) {
            return false;
        }
        if (!IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype())) {
            return false;
        }
        Integer_Value lastInteger = (Integer_Value)last;
        if (lastInteger.isNative()) {
            fieldIndex = (int)lastInteger.getValue();
            if (fieldIndex < 0) {
                return false;
            }
        } else {
            return false;
        }
        subrefsArray.add(fieldIndex);
        typeArray.add(this);
        if (this.ofType == null) {
            ErrorReporter.INTERNAL_ERROR();
            return false;
        }
        return this.ofType.getSubrefsAsArray(timestamp, reference, actualSubReference + 1, subrefsArray, typeArray);
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value indexValue = ((ArraySubReference)subreference).getValue();
                if (indexValue != null) {
                    indexValue.setLoweridToReference(timestamp);
                    IType.Type_type tempType = indexValue.getExpressionReturntype(timestamp, expectedIndex);
                    switch (tempType) {
                        case TYPE_INTEGER: {
                            IValue last = indexValue.getValueRefdLast(timestamp, expectedIndex, refChain);
                            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype())) break;
                            Integer_Value lastInteger = (Integer_Value)last;
                            if (lastInteger.isNative()) {
                                long temp = lastInteger.getValue();
                                if (temp >= 0L) break;
                                indexValue.getLocation().reportSemanticError(MessageFormat.format("A non-negative integer value was expected as index instead of `{0}''", temp));
                                indexValue.setIsErroneous(true);
                                break;
                            }
                            indexValue.getLocation().reportSemanticError(MessageFormat.format("Integer value `{0}'' is too big for indexing type `{1}''", lastInteger.getValueValue(), this.getTypename()));
                            indexValue.setIsErroneous(true);
                            break;
                        }
                        case TYPE_UNDEFINED: {
                            indexValue.setIsErroneous(true);
                            break;
                        }
                        default: {
                            indexValue.getLocation().reportSemanticError("The index should be an integer value");
                            indexValue.setIsErroneous(true);
                        }
                    }
                }
                if (this.getOfType() != null) {
                    return this.getOfType().getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
                }
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean getFieldTypesAsArray(Reference reference, int actualSubReference, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        if (subreference.getReferenceType() != ISubReference.Subreference_type.arraySubReference) {
            return false;
        }
        typeArray.add(this);
        if (this.ofType == null) {
            return false;
        }
        return this.ofType.getFieldTypesAsArray(reference, actualSubReference + 1, typeArray);
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() < i) {
            return;
        }
        if (subreferences.size() == i) {
            ISubReference subreference = subreferences.get(i - 1);
            if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
                String candidate = ((FieldSubReference)subreference).getId().getDisplayName();
                propCollector.addTemplateProposal(candidate, new Template(candidate + "[index]", candidate + " with index", propCollector.getContextIdentifier(), candidate + "[${index}]", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            }
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.arraySubReference.equals((Object)subreference.getReferenceType()) && subreferences.size() > i + 1 && this.ofType != null) {
            this.ofType.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.arraySubReference.equals((Object)subreference.getReferenceType()) && subreferences.size() > i + 1 && this.ofType != null) {
            this.ofType.addDeclaration(declarationCollector, i + 1);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean handled = false;
            if (this.ofType instanceof IIncrementallyUpdateable && reparser.envelopsDamage(this.ofType.getLocation())) {
                ((IIncrementallyUpdateable)((Object)this.ofType)).updateSyntax(reparser, true);
                reparser.updateLocation(this.ofType.getLocation());
                handled = true;
            }
            if (this.subType != null) {
                this.subType.updateSyntax(reparser, false);
                handled = true;
            }
            if (handled) {
                return;
            }
            throw new ReParseException();
        }
        if (this.ofType instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.ofType)).updateSyntax(reparser, false);
            reparser.updateLocation(this.ofType.getLocation());
        } else if (this.ofType != null) {
            throw new ReParseException();
        }
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        if (this.ofType == null) {
            return;
        }
        this.ofType.getEnclosingField(offset, rf);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.ofType != null) {
            this.ofType.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.ofType == null || this.ofType.accept(v);
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        boolean isLast;
        ISubReference subReference;
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return;
        }
        if (subReferenceIndex >= subreferences.size()) {
            return;
        }
        StringBuilder closingBrackets = new StringBuilder();
        if (isTemplate) {
            boolean anyvalueReturnValue = true;
            if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                anyvalueReturnValue = this.isPresentAnyvalueEmbeddedField(expression, subreferences, subReferenceIndex);
            } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION || optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                anyvalueReturnValue = false;
            }
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", externalId));
            expression.expression.append("case UNINITIALIZED_TEMPLATE:\n");
            expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
            expression.expression.append("break;\n");
            expression.expression.append("case ANY_VALUE:\n");
            expression.expression.append(MessageFormat.format("{0} = {1};\n", globalId, anyvalueReturnValue ? "true" : "false"));
            expression.expression.append("break;\n");
            expression.expression.append("case SPECIFIC_VALUE:{\n");
            closingBrackets.append("break;}\n");
            closingBrackets.append("default:\n");
            closingBrackets.append(MessageFormat.format("{0} = false;\n", globalId));
            closingBrackets.append("break;\n");
            closingBrackets.append("}\n");
            closingBrackets.append("}\n");
        }
        if (!((subReference = subreferences.get(subReferenceIndex)) instanceof ArraySubReference)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return;
        }
        IType nextType = this.ofType;
        Value indexValue = ((ArraySubReference)subReference).getValue();
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = indexValue.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
        referenceChain.release();
        expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
        closingBrackets.insert(0, "}\n");
        String temporalIndexId = aData.getTemporaryVariableName();
        expression.expression.append(MessageFormat.format("final TitanInteger {0} = ", temporalIndexId));
        last.generateCodeExpressionMandatory(aData, expression, true);
        expression.expression.append(";\n");
        expression.expression.append(MessageFormat.format("{0} = {1}.is_greater_than_or_equal(0) && {1}.is_less_than({2}.{3});\n", globalId, temporalIndexId, externalId, isTemplate ? "n_elem()" : "size_of()"));
        expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
        closingBrackets.insert(0, "}\n");
        String temporalId = aData.getTemporaryVariableName();
        String nextTypeGenName = isTemplate ? nextType.getGenNameTemplate(aData, expression.expression) : nextType.getGenNameValue(aData, expression.expression);
        expression.expression.append(MessageFormat.format("final {0} {1} = {2}.constGet_at({3});\n", nextTypeGenName, temporalId, externalId, temporalIndexId));
        boolean bl = isLast = subReferenceIndex == subreferences.size() - 1;
        if (optype == Expression_Value.Operation_type.ISBOUND_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId));
        } else if (optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_value();\n", globalId, temporalId));
        } else if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.{2}({3});\n", globalId, temporalId, !isLast ? "is_bound" : "is_present", isLast && isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
        } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId));
            if (subReferenceIndex == subreferences.size() - 1) {
                expression.expression.append(MessageFormat.format("if ({0}) '{'\n", globalId));
                expression.expression.append(MessageFormat.format("{0} = {1}.ischosen({2});\n", globalId, temporalId, field));
                expression.expression.append("}\n");
            }
        }
        nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId, isTemplate, optype, field, targetScope);
        expression.expression.append((CharSequence)closingBrackets);
    }

    @Override
    public boolean isPresentAnyvalueEmbeddedField(ExpressionStruct expression, List<ISubReference> subreferences, int beginIndex) {
        return false;
    }
}

