/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class RefdSpec_Type
extends ASN1Type
implements IReferencingType {
    private final IType refdType;
    private boolean componentInternal;

    public RefdSpec_Type(IType type) {
        this.refdType = type;
        type.setOwnertype(IType.TypeOwner_type.OT_REF_SPEC, this);
        this.componentInternal = false;
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_REFD_SPEC;
    }

    @Override
    public IASN1Type newInstance() {
        return new RefdSpec_Type(this.refdType);
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType t1 = this.getTypeRefdLast(timestamp);
        IType t2 = otherType.getTypeRefdLast(timestamp);
        if (t1.getIsErroneous(timestamp) || t2.getIsErroneous(timestamp)) {
            return true;
        }
        return t1.isCompatible(timestamp, t2, info, null, null);
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        if (this.isErroneous || this.refdType == null || this.refdType == this) {
            return "Referenced type";
        }
        return this.refdType.getTypename();
    }

    @Override
    public String getOutlineIcon() {
        return "referenced.gif";
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        this.check(timestamp);
        if (reference.getSubreferences().size() == 1) {
            return this;
        }
        if (this.refdType != null && this != this.refdType) {
            Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
            IType temp = this.refdType.getFieldType(timestamp, reference, actualSubReference, internalExpectation, refChain, interruptIfOptional);
            if (reference.getIsErroneous(timestamp)) {
                this.setIsErroneous(true);
            }
            return temp;
        }
        return this;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.componentInternal = false;
        this.isErroneous = false;
        this.refdType.check(timestamp);
        this.componentInternal = this.refdType.isComponentInternal(timestamp);
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public IValue checkThisValueRef(CompilationTimeStamp timestamp, IValue value) {
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)value.getValuetype())) {
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IType refd = this.getTypeRefd(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (refd == null || this.equals(refd)) {
                return value;
            }
            return refd.checkThisValueRef(timestamp, value);
        }
        return value;
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = false;
        IType tempType = this.getTypeRefdLast(timestamp);
        if (tempType != this) {
            String referingModuleName;
            selfReference = tempType.checkThisValue(timestamp, value, lhs, new IType.ValueCheckingOptions(valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.omit_allowed, false, false, valueCheckingOptions.str_elem));
            Definition def = value.getDefiningAssignment();
            if (def != null && !def.referingHere.contains(referingModuleName = this.getMyScope().getModuleScope().getName())) {
                def.referingHere.add(referingModuleName);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, value);
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        this.registerUsage(template);
        boolean selfReference = false;
        IType tempType = this.getTypeRefdLast(timestamp);
        if (tempType != this) {
            selfReference = tempType.checkThisTemplate(timestamp, template, isModified, implicitOmit, lhs);
        }
        return selfReference;
    }

    @Override
    public IType getTypeRefd(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (refChain.add(this) && !this.getIsErroneous(timestamp) && this.refdType != null) {
            return this.refdType;
        }
        this.isErroneous = true;
        this.lastTimeChecked = timestamp;
        return this;
    }

    @Override
    public IType getTypeRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance("Circular reference chain: `{0}''", true) : referenceChain;
        IType t = this;
        while (t != null && t instanceof IReferencingType && !t.getIsErroneous(timestamp)) {
            t = ((IReferencingType)((Object)t)).getTypeRefd(timestamp, tempReferenceChain);
        }
        if (newChain) {
            tempReferenceChain.release();
        }
        if (t != null && t.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
        }
        return t;
    }

    @Override
    public void checkMapParameter(CompilationTimeStamp timestamp, IReferenceChain refChain, Location errorLocation) {
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        if (this.refdType != null) {
            this.refdType.checkMapParameter(timestamp, refChain, errorLocation);
        }
    }

    @Override
    public void forceJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null) {
            this.refdType.forceJson(timestamp);
        }
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.refdType != null && !this.equals(this.refdType)) {
            this.refdType.addProposal(propCollector, i);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.refdType != null && !this.equals(this.refdType)) {
            this.refdType.addDeclaration(declarationCollector, i);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.refdType != null) {
            this.refdType.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public String createStringRep_for_OpenType_AltName(CompilationTimeStamp timestamp) {
        if (this.isTagged() || this.constraints != null || this.withAttributesPath != null && this.withAttributesPath.hasAttributes(timestamp)) {
            return this.getGenNameOwn();
        }
        return this.getTypeRefdLast(timestamp).createStringRep_for_OpenType_AltName(timestamp);
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        if (this == this.refdType || this.refdType == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        return this.refdType.getGenNameValue(aData, source);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        if (this == this.refdType || this.refdType == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        return this.refdType.getGenNameTemplate(aData, source);
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.rawAttribute != null || this.jsonAttribute != null || this.hasVariantAttributes(CompilationTimeStamp.getBaseTimestamp()) || !this.isAsn() && this.hasEncodeAttribute("JSON")) {
            if (this.needsAlias()) {
                String baseName = this.getGenNameOwn(aData);
                return baseName + "." + this.getGenNameOwn();
            }
            if (this.getParentType() != null) {
                IType parentType = this.getParentType();
                if (parentType.generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
            return this.getGenNameOwn(aData);
        }
        if (this.needsAlias()) {
            String baseName = this.getGenNameOwn(aData);
            return baseName + "." + this.getGenNameOwn();
        }
        if (this.refdType != null && this.refdType != this) {
            return this.refdType.getGenNameTypeDescriptor(aData, source);
        }
        ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
        return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
    }

    @Override
    public boolean needsOwnRawDescriptor(JavaGenData aData) {
        return this.rawAttribute != null;
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        if (this == this.refdType || this.refdType == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        if (this.rawAttribute != null) {
            return this.getGenNameOwn(aData) + "_raw_";
        }
        return this.refdType.getGenNameRawDescriptor(aData, source);
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return this.jsonAttribute != null && !this.jsonAttribute.empty() || this.getOwnertype() == IType.TypeOwner_type.OT_RECORD_OF && this.getParentType().getJsonAttribute() != null && this.getParentType().getJsonAttribute().as_map;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        if (this == this.refdType || this.refdType == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        if (this.needsOwnJsonDescriptor(aData)) {
            return this.getGenNameOwn(aData) + "_json_";
        }
        return this.refdType.getGenNameJsonDescriptor(aData, source);
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return this.needsAlias();
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        IType last = this.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (this.myScope.getModuleScopeGen() == last.getMyScope().getModuleScopeGen()) {
            StringBuilder tempSource = aData.getCodeForType(last.getGenNameOwn());
            last.generateCode(aData, tempSource);
        }
        if (this.needsAlias()) {
            String ownName = this.getGenNameOwn();
            switch (last.getTypetype()) {
                case TYPE_PORT: {
                    source.append(MessageFormat.format("\tpublic static class {0} extends {1} '{' '}'\n", ownName, last.getGenNameValue(aData, source)));
                    break;
                }
                case TYPE_SIGNATURE: {
                    source.append(MessageFormat.format("\tpublic static class {0}_call extends {1}_call '{' '}'\n", ownName, last.getGenNameValue(aData, source)));
                    source.append(MessageFormat.format("\tpublic static class {0}_call_redirect extends {1}_call_redirect '{' '}'\n", ownName, last.getGenNameValue(aData, source)));
                    if (!((Signature_Type)last).isNonblocking()) {
                        source.append(MessageFormat.format("\tpublic static class {0}_reply extends {1}_reply '{' '}'\n", ownName, last.getGenNameValue(aData, source)));
                        source.append(MessageFormat.format("\tpublic static class {0}_reply_redirect extends {1}_reply_redirect '{' '}'\n", ownName, last.getGenNameValue(aData, source)));
                    }
                    if (((Signature_Type)last).getSignatureExceptions() == null) break;
                    source.append(MessageFormat.format("\tpublic static class {0}_template extends {1} '{' '}'\n", ownName, last.getGenNameTemplate(aData, source)));
                    break;
                }
                default: {
                    source.append(MessageFormat.format("\tpublic static class {0} extends {1} '{'\n", ownName, last.getGenNameValue(aData, source)));
                    StringBuilder descriptor = new StringBuilder();
                    this.generateCodeTypedescriptor(aData, source, descriptor, null);
                    this.generateCodeDefaultCoding(aData, source, descriptor);
                    this.generateCodeForCodingHandlers(aData, source, descriptor);
                    source.append((CharSequence)descriptor);
                    source.append("\t}\n");
                    source.append(MessageFormat.format("\tpublic static class {0}_template extends {1} '{' '}'\n", ownName, last.getGenNameTemplate(aData, source)));
                }
            }
        }
        if (!this.isAsn()) {
            if (this.hasDoneAttribute()) {
                this.generateCodeDone(aData, source);
            }
            if (this.subType != null) {
                this.subType.generateCode(aData, source);
            }
        }
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        if (this == this.refdType || this.refdType == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return;
        }
        this.refdType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex, globalId, externalId, isTemplate, optype, field, targetScope);
    }
}

