/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ArrayDimensions
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String ARRAYINDEXEXPECTED = "Reference to a {0} array without array index";
    private static final String INVALIDFIELDREFERENCE = "Invalid field reference `{0}'' in a {1} array";
    private static final String TOOFEWINDICES = "Too few indices in a reference to a {0} array: the array has {1} dimensions, but the reference has only {2} array {3}";
    private static final String TOOMANYINDICES = "Too many indices in a reference to a {0} array: the reference has {1} array indices, but the array has only {2} dimension{3}";
    private final List<ArrayDimension> dimensions = new ArrayList<ArrayDimension>();

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        for (int i = 0; i < this.dimensions.size(); ++i) {
            this.dimensions.get(i).setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (int i = 0; i < this.dimensions.size(); ++i) {
            if (this.dimensions.get(i) != child) continue;
            return builder.append(".").append(String.valueOf(i));
        }
        return builder;
    }

    public void add(ArrayDimension dimension) {
        if (dimension != null) {
            this.dimensions.add(dimension);
            dimension.setFullNameParent(this);
        }
    }

    public int size() {
        return this.dimensions.size();
    }

    public ArrayDimension get(int index) {
        return this.dimensions.get(index);
    }

    public void check(CompilationTimeStamp timestamp) {
        for (ArrayDimension dimension : this.dimensions) {
            dimension.check(timestamp);
        }
    }

    public boolean isIdenticial(CompilationTimeStamp timestamp, ArrayDimensions other) {
        if (this.dimensions.size() != other.dimensions.size()) {
            return false;
        }
        int size = this.dimensions.size();
        for (int i = 0; i < size; ++i) {
            if (this.dimensions.get(i).isIdentical(timestamp, other.dimensions.get(i))) continue;
            return false;
        }
        return true;
    }

    public void checkIndices(CompilationTimeStamp timestamp, Reference reference, String definitionName, boolean allowSlicing, Expected_Value_type expectedValue, boolean anyFrom) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() == 1 && !allowSlicing && !anyFrom) {
            reference.getLocation().reportSemanticError(MessageFormat.format(ARRAYINDEXEXPECTED, definitionName));
            return;
        }
        int nofSubrefs = subreferences.size() - 1;
        int nofDimensions = this.dimensions.size();
        int upperLimit = Math.min(nofSubrefs, nofDimensions);
        for (int i = 0; i < upperLimit; ++i) {
            ISubReference subreference = subreferences.get(i + 1);
            if (!ISubReference.Subreference_type.arraySubReference.equals((Object)subreference.getReferenceType())) {
                subreference.getLocation().reportSemanticError(MessageFormat.format(INVALIDFIELDREFERENCE, subreference.getId().getDisplayName(), definitionName));
                return;
            }
            this.dimensions.get(i).checkIndex(timestamp, ((ArraySubReference)subreference).getValue(), expectedValue);
        }
        if (nofSubrefs < nofDimensions) {
            if (!allowSlicing && !anyFrom) {
                reference.getLocation().reportSemanticError(MessageFormat.format(TOOFEWINDICES, definitionName, nofDimensions, nofSubrefs, nofSubrefs > 1 ? "indices" : "index"));
            }
        } else if (nofSubrefs > nofDimensions) {
            reference.getLocation().reportSemanticError(MessageFormat.format(TOOMANYINDICES, definitionName, nofDimensions, nofSubrefs, nofDimensions > 1 ? "s" : ""));
        } else if (anyFrom) {
            reference.getLocation().reportSemanticError(MessageFormat.format("Too many indices in a reference to a {0} array with the 'any from' clause : the reference has as many array indices as the array has dimensions ({1})", definitionName, nofSubrefs));
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (ArrayDimension dimension : this.dimensions) {
            dimension.updateSyntax(reparser, false);
            reparser.updateLocation(dimension.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.dimensions == null) {
            return;
        }
        for (ArrayDimension dim : this.dimensions) {
            dim.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.dimensions != null) {
            for (ArrayDimension dim : this.dimensions) {
                if (dim.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

