/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class IndexedValue
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private final ArraySubReference index;
    private final IValue value;
    private Location location;

    public IndexedValue(ArraySubReference index, IValue value) {
        this.index = index;
        this.value = value;
        this.location = NULL_Location.INSTANCE;
        if (index != null) {
            index.setFullNameParent(this);
        }
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null || this.index == null) {
            return true;
        }
        return this.value.isUnfoldable(timestamp, expectedValue, referenceChain) || this.index.getValue().isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    public ArraySubReference getIndex() {
        return this.index;
    }

    public IValue getValue() {
        return this.value;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.index != null) {
            this.index.setMyScope(scope);
        }
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.index != null) {
            this.index.getValue().setCodeSection(codeSection);
        }
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.index != null) {
            this.index.updateSyntax(reparser, false);
            reparser.updateLocation(this.index.getLocation());
        }
        if (this.value != null) {
            ((Value)this.value).updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.index != null) {
            this.index.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.index != null && !this.index.accept(v)) {
            return false;
        }
        return this.value == null || this.value.accept(v);
    }
}

