/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.BridgingNamedNode;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Referenced_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class DecvalueUnicharExpression
extends Expression_Value {
    private static final String OPERAND1_ERROR1 = "The 1st operand of the `decvalue_unichar' operation should be a universal charstring value";
    private static final String OPERAND1_ERROR2 = "Reference to `{0}'' cannot be used as the first operand of the `decvalue_unichar'' operation";
    private static final String OPERAND1_ERROR3 = "Specific value template was expected instead of `{0}''";
    private static final String OPERAND1_ERROR4 = "Reference to `{0}'' cannot be used as the first operand of the `decvalue_unichar' operation";
    private static final String OPERAND2_ERROR1 = "The 2nd operand of the `decvalue_unichar' operation is unable to hold a decoded value";
    private static final String OPERAND3_ERROR1 = "The 3rd operand of the `decvalue_unichar' operation should be a charstring value";
    private static final String OPERAND3_ERROR2 = "The 3rd operand of the `decvalue_unichar' can only be UTF-8, UTF-16, UTF-16LE, UTF-16BE, UTF-32, UTF-32LE or UTF-32BE";
    private static final String OPERAND4_ERROR1 = "The 4th operand of the `decvalue_unichar' operation should be a (universal) charstring value";
    private static final String OPERAND5_ERROR1 = "The 5th operand of the `decvalue_unichar' operation should be a (universal) charstring value";
    private final Reference reference1;
    private final Reference reference2;
    private final Value serialization;
    private final Value encodingInfo;
    private final Value dynamicEncoding;

    public DecvalueUnicharExpression(Reference reference1, Reference reference2, Value serialization, Value encodingInfo, Value dynamicEncoding) {
        this.reference1 = reference1;
        this.reference2 = reference2;
        this.serialization = serialization;
        this.encodingInfo = encodingInfo;
        this.dynamicEncoding = dynamicEncoding;
        if (reference1 != null) {
            reference1.setFullNameParent(this);
        }
        if (reference2 != null) {
            reference2.setFullNameParent(this);
        }
        if (serialization != null) {
            serialization.setFullNameParent(this);
        }
        if (encodingInfo != null) {
            encodingInfo.setFullNameParent(this);
        }
        if (dynamicEncoding != null) {
            dynamicEncoding.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.DECVALUE_UNICHAR_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        if (lhs == this.reference2.getRefdAssignment(timestamp, false)) {
            return true;
        }
        if (this.serialization != null && this.serialization.checkExpressionSelfReferenceValue(timestamp, lhs)) {
            return true;
        }
        if (this.encodingInfo != null && this.encodingInfo.checkExpressionSelfReferenceValue(timestamp, lhs)) {
            return true;
        }
        return this.dynamicEncoding != null && this.dynamicEncoding.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("decvalue_unichar(");
        builder.append(this.reference1.getDisplayName());
        builder.append(", ");
        builder.append(this.reference2.getDisplayName());
        builder.append(", ");
        builder.append(this.serialization == null ? "null" : this.serialization.createStringRepresentation());
        builder.append(", ");
        builder.append(this.encodingInfo == null ? "null" : this.encodingInfo.createStringRepresentation());
        builder.append(", ");
        builder.append(this.dynamicEncoding == null ? "null" : this.dynamicEncoding.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference1 != null) {
            this.reference1.setMyScope(scope);
        }
        if (this.reference2 != null) {
            this.reference2.setMyScope(scope);
        }
        if (this.serialization != null) {
            this.serialization.setMyScope(scope);
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.setMyScope(scope);
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.reference1 != null) {
            this.reference1.setCodeSection(codeSection);
        }
        if (this.reference2 != null) {
            this.reference2.setCodeSection(codeSection);
        }
        if (this.serialization != null) {
            this.serialization.setCodeSection(codeSection);
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.setCodeSection(codeSection);
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.reference1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.reference2 == child) {
            return builder.append(".<operand2>");
        }
        if (this.serialization == child) {
            return builder.append(".<operand3>");
        }
        if (this.encodingInfo == child) {
            return builder.append(".<operand4>");
        }
        if (this.dynamicEncoding == child) {
            return builder.append(".<operand4>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_INTEGER;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        this.checkExpressionOperand1(timestamp, expectedValue, referenceChain);
        if (this.reference1 == null) {
            this.setIsErroneous(true);
            return;
        }
        Assignment temporalAssignment = this.reference2.getRefdAssignment(timestamp, true);
        if (temporalAssignment == null) {
            this.setIsErroneous(true);
            return;
        }
        IType type = temporalAssignment.getType(timestamp).getFieldType(timestamp, this.reference2, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
        if (type == null) {
            this.setIsErroneous(true);
            return;
        }
        IType lastType = type.getTypeRefdLast(timestamp);
        switch (lastType.getTypetype()) {
            case TYPE_UNDEFINED: 
            case TYPE_NULL: 
            case TYPE_REFERENCED: 
            case TYPE_REFD_SPEC: 
            case TYPE_SELECTION: 
            case TYPE_VERDICT: 
            case TYPE_PORT: 
            case TYPE_COMPONENT: 
            case TYPE_DEFAULT: 
            case TYPE_SIGNATURE: 
            case TYPE_FUNCTION: 
            case TYPE_ALTSTEP: 
            case TYPE_TESTCASE: {
                this.reference2.getLocation().reportSemanticError(OPERAND2_ERROR1);
                this.setIsErroneous(true);
                break;
            }
        }
        boolean attributeValidationDisabled = false;
        try {
            String property = this.getLocation().getFile().getProject().getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableAttributeValidation"));
            attributeValidationDisabled = property != null && "true".equals(property);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        if (!attributeValidationDisabled) {
            type.checkCoding(timestamp, false, this.getMyScope().getModuleScope(), false, this.reference2.getLocation());
        }
        this.checkExpressionOperand3(timestamp, expectedValue, referenceChain);
        this.checkExpressionOperand4(timestamp, expectedValue, referenceChain);
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.setLoweridToReference(timestamp);
            IType.Type_type tempType = this.dynamicEncoding.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType) {
                case TYPE_CHARSTRING: 
                case TYPE_UCHARSTRING: {
                    IValue lastValue = this.dynamicEncoding.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (this.dynamicEncoding.isUnfoldable(timestamp)) break;
                    boolean errorFound = false;
                    if (IValue.Value_type.UNIVERSALCHARSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                        errorFound = ((UniversalCharstring_Value)lastValue).checkDynamicEncodingString(timestamp, type);
                    } else if (IValue.Value_type.CHARSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                        errorFound = ((Charstring_Value)lastValue).checkDynamicEncodingString(timestamp, type);
                    }
                    if (!errorFound) break;
                    this.dynamicEncoding.getLocation().reportSemanticError(MessageFormat.format("The encoding string does not match any encodings of type `{0}''", type.getTypename()));
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERAND5_ERROR1);
                    this.setIsErroneous(true);
                }
            }
        }
    }

    private void checkExpressionOperand1(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.reference1 == null) {
            this.setIsErroneous(true);
            return;
        }
        Assignment temporalAssignment = this.reference1.getRefdAssignment(timestamp, true);
        if (temporalAssignment == null) {
            this.setIsErroneous(true);
            return;
        }
        switch (temporalAssignment.getAssignmentType()) {
            case A_CONST: 
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_TEMPLATE: {
                this.reference1.getLocation().reportSemanticError(MessageFormat.format(OPERAND1_ERROR2, temporalAssignment.getAssignmentName()));
                this.setIsErroneous(true);
                break;
            }
            case A_VAR: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                break;
            }
            case A_VAR_TEMPLATE: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                Referenced_Template template = new Referenced_Template(this.reference1);
                template.setMyScope(this.getMyScope());
                template.setFullNameParent(new BridgingNamedNode(this, ".<operand>"));
                TTCN3Template last = template.getTemplateReferencedLast(timestamp);
                if (ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)last.getTemplatetype()) || last == template) break;
                this.reference1.getLocation().reportSemanticError(MessageFormat.format(OPERAND1_ERROR3, last.getTemplateTypeName()));
                this.setIsErroneous(true);
                return;
            }
            default: {
                this.reference1.getLocation().reportSemanticError(MessageFormat.format(OPERAND1_ERROR4, temporalAssignment.getAssignmentName()));
                this.setIsErroneous(true);
                return;
            }
        }
        IType temporalType = temporalAssignment.getType(timestamp).getFieldType(timestamp, this.reference1, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
        if (temporalType == null) {
            this.setIsErroneous(true);
            return;
        }
        IType.Type_type type_type = temporalType.getTypeRefdLast(timestamp).getTypetype();
        if (type_type != IType.Type_type.TYPE_UCHARSTRING) {
            if (!this.isErroneous) {
                this.location.reportSemanticError(OPERAND1_ERROR1);
                this.setIsErroneous(true);
            }
            return;
        }
    }

    private void checkExpressionOperand3(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.serialization == null) {
            return;
        }
        this.serialization.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.serialization.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_CHARSTRING: {
                String temp;
                if (this.serialization.getValuetype() != IValue.Value_type.CHARSTRING_VALUE || "UTF-8".equals(temp = ((Charstring_Value)this.serialization).getValue()) || "UTF-16".equals(temp) || "UTF-16LE".equals(temp) || "UTF-16BE".equals(temp) || "UTF-32".equals(temp) || "UTF-32LE".equals(temp) || "UTF-32BE".equals(temp)) break;
                this.location.reportSemanticError(OPERAND3_ERROR2);
                break;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                break;
            }
            default: {
                if (this.isErroneous) break;
                this.location.reportSemanticError(OPERAND3_ERROR1);
                this.setIsErroneous(true);
            }
        }
    }

    private void checkExpressionOperand4(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.encodingInfo == null) {
            return;
        }
        this.encodingInfo.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.encodingInfo.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: {
                break;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                break;
            }
            default: {
                if (this.isErroneous) break;
                this.location.reportSemanticError(OPERAND4_ERROR1);
                this.setIsErroneous(true);
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.reference1 != null) {
            this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        }
        return this.lastValue;
    }

    private void checkRecursionHelper(CompilationTimeStamp timestamp, Reference reference, IReferenceChain referenceChain) {
        Assignment assignment = reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.setIsErroneous(true);
            return;
        }
        switch (assignment.getAssignmentType()) {
            case A_CONST: 
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_VAR: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                Referenced_Value value = new Referenced_Value(reference);
                value.setMyScope(this.getMyScope());
                value.setFullNameParent(this);
                referenceChain.markState();
                value.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
                break;
            }
            case A_TEMPLATE: 
            case A_VAR_TEMPLATE: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                Referenced_Template template = new Referenced_Template(this.reference1);
                template.setMyScope(this.getMyScope());
                template.setFullNameParent(this);
                referenceChain.markState();
                template.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
                break;
            }
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            this.checkRecursionHelper(timestamp, this.reference1, referenceChain);
            this.checkRecursionHelper(timestamp, this.reference2, referenceChain);
            if (this.serialization != null) {
                referenceChain.markState();
                this.serialization.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.encodingInfo != null) {
                referenceChain.markState();
                this.encodingInfo.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.dynamicEncoding != null) {
                referenceChain.markState();
                this.dynamicEncoding.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.reference1 != null) {
            this.reference1.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference1.getLocation());
        }
        if (this.reference2 != null) {
            this.reference2.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference2.getLocation());
        }
        if (this.serialization != null) {
            this.serialization.updateSyntax(reparser, false);
            reparser.updateLocation(this.serialization.getLocation());
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.updateSyntax(reparser, false);
            reparser.updateLocation(this.encodingInfo.getLocation());
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.updateSyntax(reparser, false);
            reparser.updateLocation(this.dynamicEncoding.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.reference1 != null) {
            this.reference1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.reference2 != null) {
            this.reference2.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.serialization != null) {
            this.serialization.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.reference1 != null && !this.reference1.accept(v)) {
            return false;
        }
        if (this.reference2 != null && !this.reference2.accept(v)) {
            return false;
        }
        if (this.serialization != null && !this.serialization.accept(v)) {
            return false;
        }
        if (this.encodingInfo != null && !this.encodingInfo.accept(v)) {
            return false;
        }
        return this.dynamicEncoding == null || this.dynamicEncoding.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        ActualParameterList actualParameterList;
        List<ISubReference> subreferences;
        if (this.reference1 != null && (subreferences = this.reference1.getSubreferences()) != null && !subreferences.isEmpty() && subreferences.get(0) instanceof ParameterisedSubReference && (actualParameterList = ((ParameterisedSubReference)subreferences.get(0)).getActualParameters()) != null) {
            actualParameterList.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.reference2 != null && (subreferences = this.reference2.getSubreferences()) != null && !subreferences.isEmpty() && subreferences.get(0) instanceof ParameterisedSubReference && (actualParameterList = ((ParameterisedSubReference)subreferences.get(0)).getActualParameters()) != null) {
            actualParameterList.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.serialization != null) {
            this.serialization.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        String v3_code;
        aData.addBuiltinTypeImport("TitanOctetString");
        aData.addCommonLibraryImport("AdditionalFunctions");
        ExpressionStruct expression1 = new ExpressionStruct();
        ExpressionStruct expression2 = new ExpressionStruct();
        this.reference1.generateCode(aData, expression1);
        this.reference2.generateCode(aData, expression2);
        Assignment tempAssignment = this.reference2.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
        IType type = tempAssignment.getType(CompilationTimeStamp.getBaseTimestamp());
        IType fieldType = type.getFieldType(CompilationTimeStamp.getBaseTimestamp(), this.reference2, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
        if (expression1.preamble.length() > 0) {
            expression.preamble.append((CharSequence)expression1.preamble);
        }
        if (expression2.preamble.length() > 0) {
            expression.preamble.append((CharSequence)expression2.preamble);
        }
        if (this.serialization == null) {
            v3_code = "\"UTF-8\"";
        } else if (this.serialization.getValuetype() == IValue.Value_type.CHARSTRING_VALUE) {
            String encoding = ((Charstring_Value)this.serialization).getValue();
            v3_code = MessageFormat.format("\"{0}\"", encoding);
        } else {
            ExpressionStruct tempExpression = new ExpressionStruct();
            this.serialization.generateCodeExpressionMandatory(aData, tempExpression, true);
            String tempID = aData.getTemporaryVariableName();
            expression.preamble.append(MessageFormat.format("final TitanCharString {0} = {1};\n", tempID, tempExpression.expression));
            expression.preamble.append(MessageFormat.format("if ({0}.operator_not_equals(\"UTF-8\") && {0}.operator_not_equals(\"UTF-16\") && {0}.operator_not_equals(\"UTF-16LE\") && {0}.operator_not_equals(\"UTF-16BE\") && {0}.operator_not_equals(\"UTF-32\") && {0}.operator_not_equals(\"UTF-32LE\") && {0}.operator_not_equals(\"UTF-32BE\")) '{'\n", tempID));
            expression.preamble.append(MessageFormat.format("throw new TtcnError(MessageFormat.format(\"decvalue_unichar: Invalid encoding parameter: '{'0'}'\", {0}));\n", tempID));
            expression.preamble.append("}\n");
            v3_code = tempID;
        }
        Scope scope = this.reference2.getMyScope();
        boolean isOptional = type.fieldIsOptional(this.reference2.getSubreferences());
        ExpressionStruct expression3 = new ExpressionStruct();
        if (this.dynamicEncoding == null) {
            expression3.expression.append(MessageFormat.format("{0}_default_coding", fieldType.getGenNameDefaultCoding(aData, expression.expression, scope)));
        } else {
            this.dynamicEncoding.generateCodeExpression(aData, expression3, true);
            if (expression3.preamble.length() > 0) {
                expression.preamble.append((CharSequence)expression3.preamble);
            }
        }
        String bufferID = aData.getTemporaryVariableName();
        String returnValueID = aData.getTemporaryVariableName();
        if (fieldType.hasBuiltInEncoding()) {
            aData.addBuiltinTypeImport("TTCN_EncDec");
            expression.preamble.append("TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_WARNING);\n");
            expression.preamble.append("TTCN_EncDec.clear_error();\n");
        }
        expression.preamble.append(MessageFormat.format("TitanOctetString {0} = new TitanOctetString(AdditionalFunctions.unichar2oct({1}, {2}));\n", bufferID, expression1.expression, v3_code));
        expression.preamble.append(MessageFormat.format("TitanInteger {0} = new TitanInteger({1}_decoder({2}, {3}{4}, {5}));\n", returnValueID, fieldType.getGenNameCoder(aData, expression.expression, scope), bufferID, expression2.expression, isOptional ? ".get()" : "", expression3.expression));
        expression.preamble.append(MessageFormat.format("if ({0}.operator_equals(0)) '{'\n", returnValueID));
        expression.preamble.append(MessageFormat.format("{0}.operator_assign(AdditionalFunctions.oct2unichar({1}, {2}));\n", expression1.expression, bufferID, v3_code));
        expression.preamble.append("}\n");
        if (fieldType.hasBuiltInEncoding()) {
            expression.preamble.append("TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_DEFAULT);\n");
            expression.preamble.append("TTCN_EncDec.clear_error();\n");
        }
        expression.expression.append(returnValueID);
        if (expression1.postamble.length() > 0) {
            expression.postamble.append((CharSequence)expression1.postamble);
        }
        if (expression2.postamble.length() > 0) {
            expression.postamble.append((CharSequence)expression2.postamble);
        }
        if (expression3.postamble.length() > 0) {
            expression.postamble.append((CharSequence)expression3.postamble);
        }
    }
}

