/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class MatchExpression
extends Expression_Value {
    private final Value value;
    private final TemplateInstance templateInstance;

    public MatchExpression(Value value, TemplateInstance templateInstance) {
        this.value = value;
        this.templateInstance = templateInstance;
        if (value != null) {
            value.setFullNameParent(this);
        }
        if (templateInstance != null) {
            templateInstance.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.MATCH_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.templateInstance != null) {
            return this.templateInstance.getTemplateBody().checkExpressionSelfReferenceTemplate(timestamp, lhs);
        }
        return false;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("match(");
        builder.append(this.value.createStringRepresentation());
        builder.append(", ");
        builder.append(this.templateInstance.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.templateInstance != null) {
            this.templateInstance.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
        if (this.templateInstance != null) {
            this.templateInstance.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(".<operand1>");
        }
        if (this.templateInstance == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BOOL;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null || this.templateInstance == null) {
            this.setIsErroneous(true);
            return;
        }
        if (this.value.getIsErroneous(timestamp) || this.templateInstance.getTemplateBody().getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return;
        }
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        IType localGovernor = this.value.getExpressionGovernor(timestamp, expectedValue);
        if (localGovernor == null) {
            localGovernor = this.templateInstance.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        }
        ITTCN3Template template = this.templateInstance.getTemplateBody();
        template.setMyGovernor(null);
        if (localGovernor == null) {
            template = template.setLoweridToReference(timestamp);
            localGovernor = template.getExpressionGovernor(timestamp, internalExpectation);
        }
        if (localGovernor == null) {
            this.value.setLoweridToReference(timestamp);
            localGovernor = this.value.getExpressionGovernor(timestamp, expectedValue);
        }
        if (localGovernor == null) {
            if (!template.getIsErroneous(timestamp)) {
                this.getLocation().reportSemanticError("Cannot determine the type of arguments in `match()' operation");
            }
            this.setIsErroneous(true);
            return;
        }
        this.value.setMyGovernor(localGovernor);
        IValue temporalValue = localGovernor.checkThisValueRef(timestamp, this.value);
        localGovernor.checkThisValue(timestamp, temporalValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
        template.checkThisTemplateGeneric(timestamp, localGovernor, this.templateInstance.getDerivedReference() != null, false, false, true, false, null);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        this.value.getValueRefdLast(timestamp, expectedValue, referenceChain);
        this.templateInstance.getTemplateBody().getTemplateReferencedLast(timestamp, referenceChain);
        this.templateInstance.check(timestamp, localGovernor);
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.value != null) {
                referenceChain.markState();
                this.value.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.templateInstance != null) {
                referenceChain.markState();
                this.templateInstance.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
        if (this.templateInstance != null) {
            this.templateInstance.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.templateInstance != null) {
            this.templateInstance.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        return this.templateInstance == null || this.templateInstance.accept(v);
    }

    @Override
    public boolean returnsNative() {
        return true;
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value != null) {
            this.value.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.templateInstance != null) {
            this.templateInstance.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return this.value.canGenerateSingleExpression() && this.templateInstance.hasSingleExpression();
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        ExpressionStruct expression = new ExpressionStruct();
        expression.expression.append(name);
        expression.expression.append(".operator_assign(");
        this.generateCodeExpressionExpression(aData, expression);
        expression.expression.append(")");
        expression.mergeExpression(source);
        return source;
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        this.templateInstance.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
        expression.expression.append(".match( ");
        this.value.generateCodeExpressionMandatory(aData, expression, true);
        if (aData.getAllowOmitInValueList()) {
            expression.expression.append(", true )");
        } else {
            expression.expression.append(", false )");
        }
    }

    public void generateCodeLogMatch(JavaGenData aData, ExpressionStruct expression) {
        if (this.templateInstance.getTemplateBody().needsTemporaryReference()) {
            StringBuilder expressionBackup = expression.expression;
            expression.expression = new StringBuilder();
            this.templateInstance.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
            String tempId = aData.getTemporaryVariableName();
            IType governor = this.templateInstance.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
            expression.preamble.append(MessageFormat.format("{0} {1} = {2};\n", governor.getGenNameTemplate(aData, expression.expression), tempId, expression.expression));
            expression.expression = expressionBackup.append(tempId);
        } else {
            this.templateInstance.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
        }
        expression.expression.append(".log_match( ");
        this.value.generateCodeExpressionMandatory(aData, expression, true);
        if (aData.getAllowOmitInValueList()) {
            expression.expression.append(", true )");
        } else {
            expression.expression.append(", false )");
        }
    }
}

