/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeFactory;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.RotateRightExpression;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class RotateLeftExpression
extends Expression_Value {
    private static final String FIRSTOPERANDERROR = "The first operand of the `<@' operation should be a string, `record of', `set of' or an array value";
    private static final String SECONDOPERANDERROR = "The second operand of the `<@' operation should be an integer value";
    private static final String LARGEINTEGERSECONDOPERANDERROR = "Using a large integer value ({0}) as the second operand of the `<@'' operation is not supported";
    private final Value value1;
    private final Value value2;

    public RotateLeftExpression(Value value1, Value value2) {
        this.value1 = value1;
        this.value2 = value2;
        if (value1 != null) {
            value1.setFullNameParent(this);
        }
        if (value2 != null) {
            value2.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.ROTATELEFT_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.value1 != null && this.value1.checkExpressionSelfReferenceValue(timestamp, lhs)) {
            return true;
        }
        return this.value2 != null && this.value2.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(this.value1.createStringRepresentation());
        builder.append(" <@ ");
        builder.append(this.value2.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value1 != null) {
            this.value1.setMyScope(scope);
        }
        if (this.value2 != null) {
            this.value2.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value1 != null) {
            this.value1.setCodeSection(codeSection);
        }
        if (this.value2 != null) {
            this.value2.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.value2 == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IValue last = this.getValueRefdLast(timestamp, expectedValue, null);
        if (last == null || this.value1 == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (last.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return IType.Type_type.TYPE_UNDEFINED;
        }
        this.value1.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value1.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: 
            case TYPE_SET_OF: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: {
                return tempType;
            }
            case TYPE_UNDEFINED: {
                return tempType;
            }
        }
        this.setIsErroneous(true);
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IType type = this.getMyGovernor();
        if (type != null) {
            return type;
        }
        IValue last = this.getValueRefdLast(timestamp, expectedValue, null);
        if (last == null || this.value1 == null) {
            return null;
        }
        if (last.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return null;
        }
        this.value1.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value1.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: {
                return TypeFactory.createType(tempType);
            }
            case TYPE_SET_OF: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: {
                return this.value1.getExpressionGovernor(timestamp, expectedValue);
            }
            case TYPE_UNDEFINED: {
                return null;
            }
        }
        this.setIsErroneous(true);
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null || this.getIsErroneous(timestamp)) {
            return true;
        }
        if (this.value1.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value2.isUnfoldable(timestamp, expectedValue, referenceChain)) {
            return true;
        }
        this.value1.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value1.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: {
                return false;
            }
        }
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IValue tempValue;
        IType.Type_type tempType1 = null;
        IType.Type_type tempType2 = null;
        if (this.value1 != null) {
            this.value1.setLoweridToReference(timestamp);
            tempType1 = this.value1.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType1) {
                case TYPE_BITSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_HEXSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_OCTETSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_CHARSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_UCHARSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_SET_OF: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (IValue.Value_type.SEQUENCEOF_VALUE.equals((Object)tempValue.getValuetype())) {
                        tempValue = tempValue.setValuetype(timestamp, IValue.Value_type.SETOF_VALUE);
                    }
                    IType v1_governor = tempValue.getExpressionGovernor(timestamp, expectedValue);
                    IValue temp = v1_governor.checkThisValueRef(timestamp, tempValue);
                    v1_governor.checkThisValue(timestamp, temp, null, new IType.ValueCheckingOptions(expectedValue, false, false, true, false, false));
                    TypeCompatibilityInfo info = new TypeCompatibilityInfo(this.getMyGovernor(), v1_governor, true);
                    if (this.myGovernor != null && !this.myGovernor.isCompatible(timestamp, v1_governor, info, null, null)) {
                        if (info.getSubtypeError() == null) {
                            if (info.getErrorStr() == null) {
                                this.getLocation().reportSemanticError(MessageFormat.format("First operand of operation `<@'' is of type `{0}'', but a value of type `{1}'' was expected here", v1_governor.getTypename(), this.myGovernor.getTypename()));
                                break;
                            }
                            this.getLocation().reportSemanticError(info.getErrorStr());
                            break;
                        }
                        if (!info.getNeedsConversion()) break;
                        this.set_needs_conversion();
                        break;
                    }
                    if (!info.getNeedsConversion()) break;
                    this.set_needs_conversion();
                    break;
                }
                case TYPE_SEQUENCE_OF: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    IType v1_governor = this.value1.getExpressionGovernor(timestamp, expectedValue);
                    IValue temp = v1_governor.checkThisValueRef(timestamp, this.value1);
                    v1_governor.checkThisValue(timestamp, temp, null, new IType.ValueCheckingOptions(expectedValue, false, false, true, false, false));
                    TypeCompatibilityInfo info = new TypeCompatibilityInfo(this.getMyGovernor(), v1_governor, true);
                    if (this.myGovernor != null && !this.myGovernor.isCompatible(timestamp, v1_governor, info, null, null)) {
                        if (info.getSubtypeError() == null) {
                            String errorString = info.getErrorStringString();
                            if (errorString == null) {
                                this.getLocation().reportSemanticError(MessageFormat.format("First operand of operation `<@'' is of type `{0}'', but a value of type `{1}'' was expected here", v1_governor.getTypename(), this.myGovernor.getTypename()));
                                break;
                            }
                            this.getLocation().reportSemanticError(errorString);
                            break;
                        }
                        if (!info.getNeedsConversion()) break;
                        this.set_needs_conversion();
                        break;
                    }
                    if (!info.getNeedsConversion()) break;
                    this.set_needs_conversion();
                    break;
                }
                case TYPE_ARRAY: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (!IValue.Value_type.SEQUENCEOF_VALUE.equals((Object)tempValue.getValuetype())) break;
                    tempValue = tempValue.setValuetype(timestamp, IValue.Value_type.ARRAY_VALUE);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(FIRSTOPERANDERROR);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.value2 != null) {
            this.value2.setLoweridToReference(timestamp);
            tempType2 = this.value2.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType2) {
                case TYPE_INTEGER: {
                    tempValue = this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (!IValue.Value_type.INTEGER_VALUE.equals((Object)tempValue.getValuetype()) || this.getIsErroneous(timestamp) || ((Integer_Value)tempValue).isNative()) break;
                    this.value2.getLocation().reportSemanticError(MessageFormat.format(LARGEINTEGERSECONDOPERANDERROR, ((Integer_Value)tempValue).getValueValue()));
                    this.setIsErroneous(true);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(SECONDOPERANDERROR);
                    this.setIsErroneous(true);
                }
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value1 == null || this.value2 == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last1 = this.value1.getValueRefdLast(timestamp, referenceChain);
        IValue last2 = this.value2.getValueRefdLast(timestamp, referenceChain);
        switch (last1.getValuetype()) {
            case BITSTRING_VALUE: {
                String string = ((Bitstring_Value)last1).getValue();
                int shiftSize = ((Integer_Value)last2).intValue();
                this.lastValue = new Bitstring_Value(RotateLeftExpression.rotateLeft(string, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case HEXSTRING_VALUE: {
                String string = ((Hexstring_Value)last1).getValue();
                int shiftSize = ((Integer_Value)last2).intValue();
                this.lastValue = new Hexstring_Value(RotateLeftExpression.rotateLeft(string, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case OCTETSTRING_VALUE: {
                String string = ((Octetstring_Value)last1).getValue();
                int shiftSize = ((Integer_Value)last2).intValue() * 2;
                this.lastValue = new Octetstring_Value(RotateLeftExpression.rotateLeft(string, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case CHARSTRING_VALUE: {
                String string = ((Charstring_Value)last1).getValue();
                int shiftSize = ((Integer_Value)last2).intValue();
                this.lastValue = new Charstring_Value(RotateLeftExpression.rotateLeft(string, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case UNIVERSALCHARSTRING_VALUE: {
                UniversalCharstring string2 = ((UniversalCharstring_Value)last1).getValue();
                int shiftSize = ((Integer_Value)last2).intValue();
                this.lastValue = new UniversalCharstring_Value(RotateLeftExpression.rotateLeft(string2, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return this.lastValue;
    }

    public static String rotateLeft(String string, int rotateSize) {
        if (string.length() == 0) {
            return "";
        }
        if (rotateSize < 0) {
            return RotateRightExpression.rotateRight(string, -rotateSize);
        }
        int realAmmount = rotateSize % string.length();
        if (realAmmount == 0) {
            return string;
        }
        return string.substring(realAmmount) + string.substring(0, realAmmount);
    }

    public static UniversalCharstring rotateLeft(UniversalCharstring string, int rotateSize) {
        if (string.length() == 0) {
            return new UniversalCharstring();
        }
        if (rotateSize < 0) {
            return RotateRightExpression.rotateRight(string, -rotateSize);
        }
        int realAmmount = rotateSize % string.length();
        if (realAmmount == 0) {
            return new UniversalCharstring(string);
        }
        return string.substring(realAmmount).append(string.substring(0, realAmmount));
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.value1 != null) {
                referenceChain.markState();
                this.value1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value2 != null) {
                referenceChain.markState();
                this.value2.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value1 != null) {
            this.value1.updateSyntax(reparser, false);
            reparser.updateLocation(this.value1.getLocation());
        }
        if (this.value2 != null) {
            this.value2.updateSyntax(reparser, false);
            reparser.updateLocation(this.value2.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value1 != null) {
            this.value1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value2 != null) {
            this.value2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value1 != null && !this.value1.accept(v)) {
            return false;
        }
        return this.value2 == null || this.value2.accept(v);
    }

    public Value getValue1() {
        return this.value1;
    }

    public Value getValue2() {
        return this.value2;
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value1 != null) {
            this.value1.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.value2 != null) {
            this.value2.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return !this.get_needs_conversion() && this.value1.canGenerateSingleExpression() && this.value2.canGenerateSingleExpression();
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        if (this.get_needs_conversion()) {
            ExpressionStruct tempExpr = new ExpressionStruct();
            String tempId1 = aData.getTemporaryVariableName();
            IType myGovernor = this.getMyGovernor();
            IType v1Governor = this.value1.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            expression.preamble.append(MessageFormat.format("{0} {1} = ", v1Governor.getGenNameValue(aData, expression.preamble), tempId1));
            this.value1.generateCodeExpressionMandatory(aData, tempExpr, true);
            tempExpr.expression.append(".rotate_left( ");
            this.value2.generateCodeExpressionMandatory(aData, tempExpr, false);
            tempExpr.expression.append(" );\n");
            tempExpr.mergeExpression(expression.preamble);
            String tempId2 = myGovernor.generateConversion(aData, v1Governor, tempId1, true, expression);
            expression.expression.append(tempId2);
        } else {
            this.value1.generateCodeExpressionMandatory(aData, expression, true);
            expression.expression.append(".rotate_left( ");
            this.value2.generateCodeExpressionMandatory(aData, expression, false);
            expression.expression.append(" )");
        }
    }
}

