/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.CharstringExtractor;
import org.eclipse.titan.designer.AST.ASN1.Value_Assignment;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASN1.types.Open_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.BridgingNamedNode;
import org.eclipse.titan.designer.AST.Constraints;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.Governor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.BerAST;
import org.eclipse.titan.designer.AST.TTCN3.attributes.JsonAST;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifier;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawAST;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawASTStruct;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.AbstractOfType;
import org.eclipse.titan.designer.AST.TTCN3.types.Anytype_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.BitString_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CharString_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.OctetString_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SetOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.ParsedSubType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.Bit2OctExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.JSONDefaultAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.variantattributeparser.VariantAttributeAnalyzer;

public abstract class Type
extends Governor
implements IType,
IIncrementallyUpdateable,
IOutlineElement {
    private static final String INCOMPATIBLEVALUE = "Incompatible value: `{0}'' was expected";
    public static final String REFTOVALUEEXPECTED = "Reference to a value was expected instead of {0}";
    public static final String REFTOVALUEEXPECTED_INSTEADOFCALL = "Reference to a value was expected instead of a call of {0}, which return a template";
    private static final String TYPECOMPATWARNING = "Type compatibility between `{0}'' and `{1}''";
    private static final String PORTRETURN = "Port type `{0}'' cannot be the return type of a `{1}''";
    private static final String SIGNATURERETURN = "A value of signature `{0}'' cannot be the return type of a`{1}''";
    public static final int JSON_NONE = 0;
    public static final int JSON_NUMBER = 1;
    public static final int JSON_STRING = 2;
    public static final int JSON_BOOLEAN = 4;
    public static final int JSON_OBJECT = 8;
    public static final int JSON_ARRAY = 16;
    public static final int JSON_NULL = 32;
    public static final int JSON_ANY_VALUE = 63;
    private IType parentType = null;
    protected Constraints constraints = null;
    protected WithAttributesPath withAttributesPath = null;
    public List<IType.MessageEncoding_type> codersToGenerate = new ArrayList<IType.MessageEncoding_type>();
    public RawAST rawAttribute = null;
    public JsonAST jsonAttribute = null;
    public BerAST berAttribute = null;
    private boolean hasDone = false;
    boolean needs_any_from_done = false;
    protected List<ParsedSubType> parsedRestrictions = null;
    protected SubType subType = null;
    protected List<IType.Coding_Type> codingTable = new ArrayList<IType.Coding_Type>();
    protected IType.TypeOwner_type ownerType = IType.TypeOwner_type.OT_UNKNOWN;
    protected INamedNode owner = null;
    protected BuildTimestamp lastTimeGenerated = null;
    private BuildTimestamp lastTimeTypeDescriptorGenerated = null;
    private static String typeCompatibilitySeverity;
    protected static boolean noStructuredTypeCompatibility;

    @Override
    public ISetting.Setting_type getSettingtype() {
        return ISetting.Setting_type.S_T;
    }

    @Override
    public abstract IType.Type_type getTypetype();

    @Override
    public final IType getParentType() {
        return this.parentType;
    }

    @Override
    public final void setParentType(IType type) {
        this.parentType = type;
    }

    @Override
    public final WithAttributesPath getAttributePath() {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        return this.withAttributesPath;
    }

    @Override
    public void setAttributeParentPath(WithAttributesPath parent) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        this.withAttributesPath.setAttributeParent(parent);
    }

    @Override
    public final void clearWithAttributes() {
        if (this.withAttributesPath != null) {
            this.withAttributesPath.setWithAttributes(null);
        }
    }

    @Override
    public final void setWithAttributes(MultipleWithAttributes attributes) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        this.withAttributesPath.setWithAttributes(attributes);
    }

    public static Type getStreamType(IType.MessageEncoding_type encodingType, int streamVariant) {
        if (streamVariant == 0) {
            return new BitString_Type();
        }
        switch (encodingType) {
            case BER: 
            case PER: 
            case RAW: 
            case XER: 
            case JSON: 
            case OER: {
                return new OctetString_Type();
            }
            case TEXT: {
                if (streamVariant == 1) {
                    return new CharString_Type();
                }
                return new OctetString_Type();
            }
        }
        return null;
    }

    @Override
    public final boolean hasDoneAttribute() {
        return this.hasDone;
    }

    @Override
    public boolean isTagged() {
        return false;
    }

    @Override
    public final boolean isConstrained() {
        return this.constraints != null;
    }

    @Override
    public final void addConstraints(Constraints constraints) {
        if (constraints == null) {
            return;
        }
        this.constraints = constraints;
        constraints.setMyType(this);
        constraints.setFullNameParent(this);
    }

    @Override
    public final Constraints getConstraints() {
        return this.constraints;
    }

    @Override
    public final SubType getSubtype() {
        return this.subType;
    }

    @Override
    public final void setParsedRestrictions(List<ParsedSubType> parsedRestrictions) {
        this.parsedRestrictions = parsedRestrictions;
    }

    @Override
    public String chainedDescription() {
        return "type reference: " + this.getFullName();
    }

    @Override
    public final Location getChainLocation() {
        return this.getLocation();
    }

    @Override
    public IType getTypeRefdLast(CompilationTimeStamp timestamp) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IType result = this.getTypeRefdLast(timestamp, referenceChain);
        referenceChain.release();
        return result;
    }

    public IType getTypeRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        return this;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, boolean interruptIfOptional) {
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IType temp = this.getFieldType(timestamp, reference, actualSubReference, expectedIndex, chain, interruptIfOptional);
        chain.release();
        return temp;
    }

    @Override
    public abstract IType getFieldType(CompilationTimeStamp var1, Reference var2, int var3, Expected_Value_type var4, IReferenceChain var5, boolean var6);

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ErrorReporter.INTERNAL_ERROR((String)("Type " + this.getTypename() + " has no fields."));
        return false;
    }

    @Override
    public boolean getFieldTypesAsArray(Reference reference, int actualSubReference, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        return subreferences.size() <= actualSubReference;
    }

    public boolean isOptionalField() {
        if (this.getOwnertype() == IType.TypeOwner_type.OT_COMP_FIELD) {
            CompField myOwner = (CompField)this.getOwner();
            return myOwner != null && myOwner.isOptional();
        }
        return false;
    }

    @Override
    public boolean fieldIsOptional(List<ISubReference> subReferences) {
        if (subReferences == null || subReferences.isEmpty()) {
            return false;
        }
        ISubReference lastSubReference = subReferences.get(subReferences.size() - 1);
        if (!(lastSubReference instanceof FieldSubReference)) {
            return false;
        }
        IType type = this;
        CompField compField = null;
        for (int i = 1; i < subReferences.size(); ++i) {
            type = type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            ISubReference subreference = subReferences.get(i);
            if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
                Identifier id = ((FieldSubReference)subreference).getId();
                switch (type.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        compField = ((TTCN3_Set_Seq_Choice_BaseType)type).getComponentByName(id.getName());
                        break;
                    }
                    case TYPE_ANYTYPE: {
                        compField = ((Anytype_Type)type).getComponentByName(id.getName());
                        break;
                    }
                    case TYPE_OPENTYPE: {
                        compField = ((Open_Type)type).getComponentByName(id);
                        break;
                    }
                    case TYPE_ASN1_SEQUENCE: {
                        compField = ((ASN1_Sequence_Type)type).getComponentByName(id);
                        break;
                    }
                    case TYPE_ASN1_SET: {
                        compField = ((ASN1_Set_Type)type).getComponentByName(id);
                        break;
                    }
                    case TYPE_ASN1_CHOICE: {
                        compField = ((ASN1_Choice_Type)type).getComponentByName(id);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                if (compField == null) {
                    return false;
                }
                type = compField.getType();
            } else if (ISubReference.Subreference_type.arraySubReference.equals((Object)subreference.getReferenceType())) {
                switch (type.getTypetype()) {
                    case TYPE_SEQUENCE_OF: 
                    case TYPE_SET_OF: {
                        type = ((AbstractOfType)type).getOfType();
                        break;
                    }
                    case TYPE_ARRAY: {
                        type = ((Array_Type)type).getElementType();
                        break;
                    }
                    default: {
                        type = null;
                    }
                }
            }
            if (type != null) continue;
            return false;
        }
        return compField != null && compField.isOptional();
    }

    @Override
    public RawAST getRawAttribute() {
        return this.rawAttribute;
    }

    @Override
    public int getDefaultRawFieldLength() {
        return 0;
    }

    @Override
    public int getRawLength(BuildTimestamp timestamp) {
        return -1;
    }

    @Override
    public JsonAST getJsonAttribute() {
        return this.jsonAttribute;
    }

    @Override
    public BerAST getBerAttribute() {
        return this.berAttribute;
    }

    @Override
    public int getLengthMultiplier() {
        return 1;
    }

    @Override
    public final boolean hasRawAttributes(CompilationTimeStamp timestamp) {
        if (this.rawAttribute != null) {
            return true;
        }
        if (this.withAttributesPath == null) {
            return false;
        }
        if (this.withAttributesPath.getHadGlobalVariants()) {
            return true;
        }
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        for (int i = 0; i < realAttributes.size(); ++i) {
            if (!SingleWithAttribute.Attribute_Type.Variant_Attribute.equals((Object)realAttributes.get(i).getAttributeType())) continue;
            return true;
        }
        MultipleWithAttributes localAttributes = this.withAttributesPath.getAttributes();
        if (localAttributes == null) {
            return false;
        }
        for (int i = 0; i < localAttributes.getNofElements(); ++i) {
            SingleWithAttribute tempSingle = localAttributes.getAttribute(i);
            if (!SingleWithAttribute.Attribute_Type.Variant_Attribute.equals((Object)tempSingle.getAttributeType()) || tempSingle.getQualifiers() != null && tempSingle.getQualifiers().getNofQualifiers() != 0) continue;
            this.withAttributesPath.setHadGlobalVariants(true);
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasVariantAttributes(CompilationTimeStamp timestamp) {
        if (this.withAttributesPath == null) {
            return false;
        }
        if (this.withAttributesPath.getHadGlobalVariants()) {
            return true;
        }
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        for (int i = 0; i < realAttributes.size(); ++i) {
            if (!SingleWithAttribute.Attribute_Type.Variant_Attribute.equals((Object)realAttributes.get(i).getAttributeType())) continue;
            return true;
        }
        MultipleWithAttributes localAttributes = this.withAttributesPath.getAttributes();
        if (localAttributes == null) {
            return false;
        }
        for (int i = 0; i < localAttributes.getNofElements(); ++i) {
            SingleWithAttribute tempSingle = localAttributes.getAttribute(i);
            if (!SingleWithAttribute.Attribute_Type.Variant_Attribute.equals((Object)tempSingle.getAttributeType())) continue;
            this.withAttributesPath.setHadGlobalVariants(true);
            return true;
        }
        return false;
    }

    @Override
    public void initAttributes(CompilationTimeStamp timestamp) {
        this.hasDone = false;
        this.checkDoneAttribute(timestamp);
    }

    @Override
    public final void checkDoneAttribute(CompilationTimeStamp timestamp) {
        this.hasDone = false;
        if (this.withAttributesPath == null) {
            return;
        }
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        for (SingleWithAttribute singleAttribute : realAttributes) {
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)singleAttribute.getAttributeType()) || !"done".equals(singleAttribute.getAttributeSpecification().getSpecification())) continue;
            this.hasDone = true;
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void getTypesWithNoCodingTable(CompilationTimeStamp timestamp, ArrayList<IType> typeList, boolean onlyOwnTable) {
        if (typeList.contains(this)) {
            return;
        }
        if (onlyOwnTable && this.codingTable.isEmpty() || !onlyOwnTable && this.getTypeWithCodingTable(timestamp, false) == null) {
            typeList.add(this);
        }
    }

    public final void checkEncode(CompilationTimeStamp timestamp) {
        this.rawAttribute = null;
        this.jsonAttribute = null;
        this.berAttribute = null;
        block0 : switch (this.getTypeRefdLast(timestamp).getTypetypeTtcn3()) {
            case TYPE_TTCN3_CHOICE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_TTCN3_SET: 
            case TYPE_ANYTYPE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_SET_OF: 
            case TYPE_ARRAY: 
            case TYPE_NULL: 
            case TYPE_BOOL: 
            case TYPE_INTEGER: 
            case TYPE_REAL: 
            case TYPE_TTCN3_ENUMERATED: 
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: 
            case TYPE_OBJECTID: 
            case TYPE_VERDICT: {
                if (!this.isAsn()) {
                    WithAttributesPath globalAttributesPath;
                    WithAttributesPath attributePath = this.getAttributePath();
                    if (attributePath == null) break;
                    MultipleWithAttributes multipleWithAttributes = attributePath.getAttributes();
                    if (multipleWithAttributes != null) {
                        for (int i = 0; i < multipleWithAttributes.getNofElements(); ++i) {
                            SingleWithAttribute singleWithAttribute = multipleWithAttributes.getAttribute(i);
                            if (singleWithAttribute.getAttributeType() != SingleWithAttribute.Attribute_Type.Encode_Attribute) continue;
                            SingleWithAttribute.Attribute_Modifier_type mod = singleWithAttribute.getModifier();
                            Qualifiers qualifiers = singleWithAttribute.getQualifiers();
                            if (qualifiers != null && qualifiers.getNofQualifiers() > 0) {
                                for (int j = 0; j < qualifiers.getNofQualifiers(); ++j) {
                                    Qualifier qualifier = qualifiers.getQualifierByIndex(j);
                                    ArrayList<ISubReference> fieldsOrArrays = new ArrayList<ISubReference>();
                                    for (int k = 0; k < qualifier.getNofSubReferences(); ++k) {
                                        fieldsOrArrays.add(qualifier.getSubReferenceByIndex(k));
                                    }
                                    Reference reference = new Reference(null, fieldsOrArrays);
                                    IType type = this.getFieldType(timestamp, reference, 0, Expected_Value_type.EXPECTED_CONSTANT, false);
                                    if (type == null) continue;
                                    if (type.getMyScope() != this.myScope) {
                                        qualifier.getLocation().reportSemanticWarning("Encode attribute is ignored, because it refers to a type from a different type definition");
                                        continue;
                                    }
                                    type.addCoding(timestamp, singleWithAttribute.getAttributeSpecification().getSpecification(), mod, false);
                                }
                                continue;
                            }
                            this.addCoding(timestamp, singleWithAttribute.getAttributeSpecification().getSpecification(), mod, false);
                        }
                    }
                    if (this.ownerType != IType.TypeOwner_type.OT_TYPE_DEF) {
                        return;
                    }
                    Def_Type def = (Def_Type)this.owner;
                    Group nearest_group = def.getParentGroup();
                    if (nearest_group == null) {
                        Module myModule = this.myScope.getModuleScope();
                        globalAttributesPath = ((TTCN3Module)myModule).getAttributePath();
                    } else {
                        globalAttributesPath = nearest_group.getAttributePath();
                    }
                    if (globalAttributesPath == null) break;
                    boolean hasGlobalOverride = false;
                    boolean modifierConflict = false;
                    SingleWithAttribute.Attribute_Modifier_type firstModifier = SingleWithAttribute.Attribute_Modifier_type.MOD_NONE;
                    List<SingleWithAttribute> realAttributes = globalAttributesPath.getRealAttributes(timestamp);
                    for (int i = 0; i < realAttributes.size(); ++i) {
                        SingleWithAttribute singleWithAttribute = realAttributes.get(i);
                        if (singleWithAttribute.getAttributeType() != SingleWithAttribute.Attribute_Type.Encode_Attribute) continue;
                        SingleWithAttribute.Attribute_Modifier_type modifier = singleWithAttribute.getModifier();
                        if (i == 0) {
                            firstModifier = modifier;
                        } else if (!modifierConflict && modifier != firstModifier) {
                            modifierConflict = true;
                            singleWithAttribute.getLocation().reportSemanticError("All 'encode' attributes of a group or module must have the same modifier ('override', '@local' or none)");
                        }
                        if (modifier == SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE) {
                            hasGlobalOverride = true;
                        }
                        if (hasGlobalOverride && modifierConflict) break;
                    }
                    ArrayList<IType> typeList = new ArrayList<IType>();
                    this.getTypesWithNoCodingTable(timestamp, typeList, hasGlobalOverride);
                    if (typeList.isEmpty()) break;
                    for (int i = 0; i < realAttributes.size(); ++i) {
                        SingleWithAttribute singleWithAttribute = realAttributes.get(i);
                        if (singleWithAttribute.getAttributeType() != SingleWithAttribute.Attribute_Type.Encode_Attribute) continue;
                        for (int j = typeList.size() - 1; j >= 0; --j) {
                            typeList.get(j).addCoding(timestamp, singleWithAttribute.getAttributeSpecification().getSpecification(), SingleWithAttribute.Attribute_Modifier_type.MOD_NONE, true);
                        }
                    }
                    typeList.clear();
                    break;
                }
                switch (this.ownerType) {
                    case OT_TYPE_ASS: 
                    case OT_RECORD_OF: 
                    case OT_COMP_FIELD: 
                    case OT_SELTYPE: 
                    case OT_FIELDSETTING: {
                        this.addCoding(timestamp, "JSON", SingleWithAttribute.Attribute_Modifier_type.MOD_NONE, true);
                        this.addCoding(timestamp, "BER:2002", SingleWithAttribute.Attribute_Modifier_type.MOD_NONE, true);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void checkVariants(CompilationTimeStamp timestamp) {
        MultipleWithAttributes multipleWithAttributes;
        WithAttributesPath attributePath;
        WithAttributesPath globalAttributesPath;
        if (this.isAsn() || this.ownerType != IType.TypeOwner_type.OT_TYPE_DEF) {
            return;
        }
        Def_Type def = (Def_Type)this.owner;
        Group nearest_group = def.getParentGroup();
        if (nearest_group == null) {
            Module myModule = this.myScope.getModuleScope();
            globalAttributesPath = ((TTCN3Module)myModule).getAttributePath();
        } else {
            globalAttributesPath = nearest_group.getAttributePath();
        }
        if (globalAttributesPath != null) {
            List<SingleWithAttribute> realAttributes = globalAttributesPath.getRealAttributes(timestamp);
            for (int i = 0; i < realAttributes.size(); ++i) {
                SingleWithAttribute singleWithAttribute = realAttributes.get(i);
                if (singleWithAttribute.getAttributeType() != SingleWithAttribute.Attribute_Type.Variant_Attribute) continue;
                this.checkThisVariant(timestamp, singleWithAttribute, true);
            }
        }
        if ((attributePath = this.getAttributePath()) != null && (multipleWithAttributes = attributePath.getAttributes()) != null) {
            for (int i = 0; i < multipleWithAttributes.getNofElements(); ++i) {
                SingleWithAttribute singleWithAttribute = multipleWithAttributes.getAttribute(i);
                if (singleWithAttribute.getAttributeType() != SingleWithAttribute.Attribute_Type.Variant_Attribute) continue;
                Qualifiers qualifiers = singleWithAttribute.getQualifiers();
                if (qualifiers != null && qualifiers.getNofQualifiers() > 0) {
                    for (int j = 0; j < qualifiers.getNofQualifiers(); ++j) {
                        Qualifier qualifier = qualifiers.getQualifierByIndex(j);
                        ArrayList<ISubReference> fieldsOrArrays = new ArrayList<ISubReference>();
                        for (int k = 0; k < qualifier.getNofSubReferences(); ++k) {
                            fieldsOrArrays.add(qualifier.getSubReferenceByIndex(k));
                        }
                        Reference reference = new Reference(null, fieldsOrArrays);
                        IType type = this.getFieldType(timestamp, reference, 0, Expected_Value_type.EXPECTED_CONSTANT, false);
                        if (type == null) continue;
                        type.checkThisVariant(timestamp, singleWithAttribute, false);
                    }
                    continue;
                }
                this.checkThisVariant(timestamp, singleWithAttribute, false);
            }
        }
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        this.checkCodingAttributes(timestamp, chain);
        chain.release();
    }

    @Override
    public void checkThisVariant(CompilationTimeStamp timestamp, SingleWithAttribute singleWithAttribute, boolean global) {
        IType type = this.getTypeWithCodingTable(timestamp, false);
        if (type != null) {
            ReferenceChain referenceChain;
            IType t_refd;
            List<String> codingStrings = singleWithAttribute.getAttributeSpecification().getEncodings();
            ArrayList<IType.MessageEncoding_type> codings = new ArrayList<IType.MessageEncoding_type>();
            boolean erroneous = false;
            if (codingStrings == null) {
                if (type.getCodingTable().size() > 1) {
                    if (!global) {
                        singleWithAttribute.getLocation().reportSemanticError(MessageFormat.format("The encoding reference is mandatory for variant attributes of type  `{0}''", this.getTypename()));
                    }
                    erroneous = true;
                } else if (type.getCodingTable().get((int)0).builtIn) {
                    codings.add(type.getCodingTable().get((int)0).builtInCoding);
                } else {
                    IType.MessageEncoding_type coding = "PER".equals(type.getCodingTable().get((int)0).customCoding.name) ? IType.MessageEncoding_type.PER : IType.MessageEncoding_type.CUSTOM;
                    singleWithAttribute.getLocation().reportSemanticWarning(MessageFormat.format("Variant attributes related to `{0}'' encoding are ignored", coding.getEncodingName()));
                }
            } else {
                for (int i = 0; i < codingStrings.size(); ++i) {
                    String encodingString = codingStrings.get(i);
                    IType.MessageEncoding_type coding = Type.getEncodingType(encodingString);
                    if (!this.hasEncoding(timestamp, coding, encodingString)) {
                        erroneous = true;
                        if (global || coding != IType.MessageEncoding_type.RAW && coding != IType.MessageEncoding_type.JSON && coding != IType.MessageEncoding_type.BER) continue;
                        if (coding == IType.MessageEncoding_type.CUSTOM) {
                            singleWithAttribute.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' does not support {1} encoding", this.getTypename(), coding.getEncodingName()));
                            continue;
                        }
                        singleWithAttribute.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' does not support custom encoding `{1}''", this.getTypename(), encodingString));
                        continue;
                    }
                    if (coding != IType.MessageEncoding_type.PER && coding != IType.MessageEncoding_type.CUSTOM) {
                        codings.add(coding);
                        continue;
                    }
                    singleWithAttribute.getLocation().reportSemanticWarning(MessageFormat.format("Variant attributes related to {0} encoding are ignored", coding.getEncodingName()));
                }
            }
            boolean newRaw = false;
            boolean newJson = false;
            boolean newBer = false;
            AtomicBoolean rawFound = new AtomicBoolean(false);
            AtomicBoolean jsonFound = new AtomicBoolean(false);
            AtomicBoolean berFound = new AtomicBoolean(false);
            if (this.rawAttribute == null) {
                t_refd = this;
                while (!t_refd.getIsErroneous(timestamp) && t_refd.getRawAttribute() == null && t_refd instanceof Referenced_Type) {
                    referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    t_refd = ((Referenced_Type)t_refd).getTypeRefd(timestamp, referenceChain);
                    referenceChain.release();
                }
                this.rawAttribute = new RawAST(t_refd.getRawAttribute(), this.getDefaultRawFieldLength());
                newRaw = true;
            }
            if (this.jsonAttribute == null) {
                t_refd = this;
                while (!t_refd.getIsErroneous(timestamp) && t_refd.getJsonAttribute() == null && t_refd instanceof Referenced_Type) {
                    referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    t_refd = ((Referenced_Type)t_refd).getTypeRefd(timestamp, referenceChain);
                    referenceChain.release();
                }
                this.jsonAttribute = new JsonAST(t_refd.getJsonAttribute());
                newJson = true;
            }
            if (this.berAttribute == null) {
                this.berAttribute = new BerAST();
                newBer = true;
            }
            VariantAttributeAnalyzer.parse(this.rawAttribute, this.jsonAttribute, this.berAttribute, singleWithAttribute.getAttributeSpecification(), this.getLengthMultiplier(), rawFound, jsonFound, berFound);
            if (!rawFound.get() && newRaw) {
                this.rawAttribute = null;
            }
            if (!jsonFound.get() && newJson) {
                this.jsonAttribute = null;
            }
            if (!berFound.get() && newBer) {
                this.berAttribute = null;
            }
        }
        if (global) {
            switch (this.getTypetype()) {
                case TYPE_TTCN3_CHOICE: 
                case TYPE_TTCN3_SEQUENCE: 
                case TYPE_TTCN3_SET: {
                    for (int i = 0; i < ((TTCN3_Set_Seq_Choice_BaseType)this).getNofComponents(); ++i) {
                        ((TTCN3_Set_Seq_Choice_BaseType)this).getComponentByIndex(i).getType().checkThisVariant(timestamp, singleWithAttribute, global);
                    }
                    break;
                }
                case TYPE_ASN1_SEQUENCE: 
                case TYPE_ASN1_SET: 
                case TYPE_ASN1_CHOICE: {
                    for (int i = 0; i < ((ASN1_Set_Seq_Choice_BaseType)this).getNofComponents(); ++i) {
                        ((ASN1_Set_Seq_Choice_BaseType)this).getComponentByIndex(i).getType().checkThisVariant(timestamp, singleWithAttribute, global);
                    }
                    break;
                }
                case TYPE_ANYTYPE: {
                    for (int i = 0; i < ((Anytype_Type)this).getNofComponents(); ++i) {
                        ((Anytype_Type)this).getComponentByIndex(i).getType().checkThisVariant(timestamp, singleWithAttribute, global);
                    }
                    break;
                }
                case TYPE_OPENTYPE: {
                    for (int i = 0; i < ((Open_Type)this).getNofComponents(); ++i) {
                        ((Open_Type)this).getComponentByIndex(i).getType().checkThisVariant(timestamp, singleWithAttribute, global);
                    }
                    break;
                }
                case TYPE_ARRAY: {
                    ((Array_Type)this).getElementType().checkThisVariant(timestamp, singleWithAttribute, global);
                    break;
                }
                case TYPE_SEQUENCE_OF: {
                    ((SequenceOf_Type)this).getOfType().checkThisVariant(timestamp, singleWithAttribute, global);
                    break;
                }
                case TYPE_SET_OF: {
                    ((SetOf_Type)this).getOfType().checkThisVariant(timestamp, singleWithAttribute, global);
                    break;
                }
            }
        }
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
    }

    @Override
    public void checkCoding(CompilationTimeStamp timestamp, boolean encode, Module usageModule, boolean delayed, Location errorLocation) {
        IType type = this.getTypeWithCodingTable(timestamp, false);
        if (type == null) {
            errorLocation.reportSemanticError(MessageFormat.format("No coding rule specified for type `{0}''", this.getTypename()));
            return;
        }
        List<IType.Coding_Type> tempCodingTable = type.getCodingTable();
        for (int i = 0; i < tempCodingTable.size(); ++i) {
            IType.Coding_Type tempCoding = tempCodingTable.get(i);
            if (tempCoding.builtIn) continue;
            if (!delayed) {
                return;
            }
            HashMap<IType, IType.CoderFunction_Type> tempCoders = encode ? tempCoding.customCoding.encoders : tempCoding.customCoding.decoders;
            IType.CoderFunction_Type codingFunction = tempCoders.get(this);
            if (codingFunction == null) {
                if (type.isAsn()) continue;
                errorLocation.reportSemanticWarning(MessageFormat.format("No `{0}'' {1}coder function defined for type `{2}''", tempCoding.customCoding.name, encode ? "en" : "de", this.getTypename()));
                continue;
            }
            if (!codingFunction.conflict) continue;
            errorLocation.reportSemanticWarning(MessageFormat.format("Multiple `{0}'' {1}coder functions defined for type `{2}''", tempCoding.customCoding.name, encode ? "en" : "de", this.getTypename()));
        }
    }

    @Override
    public void forceRaw(CompilationTimeStamp timestamp) {
    }

    @Override
    public void setRawAttributes(RawAST newAttributes) {
        this.rawAttribute = newAttributes;
    }

    @Override
    public void setJsonAttributes(JsonAST newAttributes) {
        this.jsonAttribute = newAttributes;
    }

    @Override
    public void checkJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null) {
            return;
        }
        if (this.jsonAttribute.omit_as_null && !this.isOptionalField()) {
            this.getLocation().reportSemanticError("Invalid attribute, 'omit as null' requires optional field of a record or set.");
        }
        if (this.jsonAttribute.as_value) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as value' is only allowed for unions, the anytype, or records or sets with one field");
        }
        if (this.jsonAttribute.alias != null) {
            IType parent = this.getParentType();
            if (parent == null) {
                this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
            } else {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: 
                    case TYPE_ANYTYPE: {
                        break;
                    }
                    default: {
                        this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
                    }
                }
            }
            if (parent != null && parent.getJsonAttribute() != null && parent.getJsonAttribute().as_value) {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Seq_Choice_BaseType)parent).getNofComponents() != 1) break;
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                }
            }
        }
        if (this.jsonAttribute.parsed_default_value != null) {
            this.checkJsonDefault(timestamp);
        }
        if (this.jsonAttribute.metainfo_unbound) {
            if (this.getParentType() == null || this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SEQUENCE && this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SET) {
                this.getLocation().reportSemanticError("Invalid attribute 'metainfo for unbound', requires record, set, record of, set of, array or field of a record or set");
            }
            IType last = this.getTypeRefdLast(timestamp);
            IType parent = this.getParentType();
            if (IType.Type_type.TYPE_TTCN3_SEQUENCE == last.getTypetype() || IType.Type_type.TYPE_TTCN3_SET == last.getTypetype()) {
                int nof_comps = ((TTCN3_Set_Seq_Choice_BaseType)last).getNofComponents();
                if (this.jsonAttribute.as_value && nof_comps == 1) {
                    this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'metainfo for unbound' will be ignored, because the {0} is encoded without field names.", IType.Type_type.TYPE_TTCN3_SEQUENCE == last.getTypetype() ? "record" : "set"));
                } else {
                    for (int i = 0; i < nof_comps; ++i) {
                        Type comp_type = ((TTCN3_Set_Seq_Choice_BaseType)last).getComponentByIndex(i).getType();
                        if (null == comp_type.jsonAttribute) {
                            comp_type.jsonAttribute = new JsonAST();
                        }
                        comp_type.jsonAttribute.metainfo_unbound = true;
                    }
                }
            } else if (IType.Type_type.TYPE_SEQUENCE_OF != last.getTypetype() && IType.Type_type.TYPE_SET_OF != last.getTypetype() && IType.Type_type.TYPE_ARRAY != last.getTypetype() && (null == parent || IType.Type_type.TYPE_TTCN3_SEQUENCE != parent.getTypetype() && IType.Type_type.TYPE_TTCN3_SET != parent.getTypetype())) {
                this.getLocation().reportSemanticError("Invalid attribute 'metainfo for unbound', requires record, set, record of, set of, array or field of a record or set");
            }
        }
        if (this.jsonAttribute.as_number) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as number' is only allowed for enumerated types");
        }
        if (this.jsonAttribute.as_map) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires record of or set of");
        }
        if (this.jsonAttribute.enum_texts.size() > 0) {
            this.getLocation().reportSemanticError("Invalid attribute, 'text ... as ...' requires an enumerated type");
        }
    }

    @Override
    public final void checkJsonDefault(CompilationTimeStamp timestamp) {
        JSONDefaultAnalyzer refAnalyzer = new JSONDefaultAnalyzer();
        String preparedString = this.jsonAttribute.parsed_default_value.replace("\\)", ")").replaceAll("^\\\\\"|\\\\\"$", "\"\"");
        CharstringExtractor extractor = new CharstringExtractor(preparedString, true);
        String defaultValue = extractor.getExtractedString();
        IValue parsedValue = refAnalyzer.parseJSONDefaultValue(defaultValue, this.jsonAttribute.defaultLocation);
        if (parsedValue != null) {
            parsedValue.setMyGovernor(this);
            parsedValue.setMyScope(this.getMyScope());
            parsedValue.setFullNameParent(new BridgingNamedNode(this, ".<JSON default value>"));
            IType last = this.getTypeRefdLast(timestamp);
            IValue temporalValue = last.checkThisValueRef(timestamp, parsedValue);
            last.checkThisValue(timestamp, temporalValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, true, false, true, false, false));
            this.jsonAttribute.default_value = temporalValue;
        }
    }

    @Override
    public void forceJson(CompilationTimeStamp timestamp) {
    }

    @Override
    public void setBerAttributes(BerAST newAttributes) {
        this.berAttribute = newAttributes;
    }

    @Override
    public void addCoding(CompilationTimeStamp timestamp, String name, SingleWithAttribute.Attribute_Modifier_type modifier, boolean silent) {
        boolean encodeAttributeModifierConflict = false;
        IType.MessageEncoding_type builtInCoding = Type.getEncodingType(name);
        for (int i = 0; i < this.codingTable.size(); ++i) {
            String currentName;
            IType.Coding_Type tempCodingType = this.codingTable.get(i);
            if (!encodeAttributeModifierConflict && modifier != tempCodingType.modifier) {
                encodeAttributeModifierConflict = true;
                this.getLocation().reportSemanticError("All 'encode' attributes of a type must have the same modifier ('override', '@local' or none)");
            }
            String codingName = tempCodingType.builtIn ? tempCodingType.builtInCoding.getEncodingName() : tempCodingType.customCoding.name;
            String string = currentName = tempCodingType.builtIn ? builtInCoding.getEncodingName() : name;
            if (!currentName.equals(codingName)) continue;
            return;
        }
        switch (builtInCoding) {
            case PER: 
            case CUSTOM: {
                IType.Coding_Type newCoding = new IType.Coding_Type();
                newCoding.builtIn = false;
                newCoding.modifier = modifier;
                newCoding.customCoding = new IType.Coding_Type.CustomCoding_type();
                newCoding.customCoding.name = name;
                newCoding.customCoding.encoders = new HashMap();
                newCoding.customCoding.decoders = new HashMap();
                this.codingTable.add(newCoding);
                break;
            }
            default: {
                IType refdLast = this.getTypeRefdLast(timestamp);
                boolean canHaveCoding = refdLast.canHaveCoding(timestamp, builtInCoding);
                if (canHaveCoding) {
                    IType.Coding_Type newCoding = new IType.Coding_Type();
                    newCoding.builtIn = true;
                    newCoding.modifier = modifier;
                    newCoding.builtInCoding = builtInCoding;
                    this.codingTable.add(newCoding);
                    refdLast.setGenerateCoderFunctions(timestamp, builtInCoding);
                    break;
                }
                if (silent) break;
                this.getLocation().reportSemanticWarning(MessageFormat.format("Type `{0}'' cannot have {1} encoding. Encode attribute ignored.", this.getTypename(), name));
                break;
            }
        }
    }

    @Override
    public void setEncodingFunction(String codingName, Assignment functionDefinition) {
        IType t = this.getTypeWithCodingTable(CompilationTimeStamp.getBaseTimestamp(), false);
        if (t == null) {
            return;
        }
        List<IType.Coding_Type> tempCodingTable = t.getCodingTable();
        for (int i = 0; i < tempCodingTable.size(); ++i) {
            IType.Coding_Type tempCoding = tempCodingTable.get(i);
            if (tempCoding.builtIn || !tempCoding.customCoding.name.equals(codingName)) continue;
            HashMap<IType, IType.CoderFunction_Type> tempCoders = tempCoding.customCoding.encoders;
            if (tempCoders.containsKey(this) && tempCoders.get((Object)this).functionDefinition != functionDefinition) {
                tempCoders.get((Object)this).conflict = true;
            } else {
                IType.CoderFunction_Type newCoder = new IType.CoderFunction_Type();
                newCoder.functionDefinition = functionDefinition;
                newCoder.conflict = false;
                tempCoders.put(this, newCoder);
            }
            return;
        }
    }

    @Override
    public void setDecodingFunction(String codingName, Assignment functionDefinition) {
        IType t = this.getTypeWithCodingTable(CompilationTimeStamp.getBaseTimestamp(), false);
        if (t == null) {
            return;
        }
        List<IType.Coding_Type> tempCodingTable = t.getCodingTable();
        for (int i = 0; i < tempCodingTable.size(); ++i) {
            IType.Coding_Type tempCoding = tempCodingTable.get(i);
            if (tempCoding.builtIn || !tempCoding.customCoding.name.equals(codingName)) continue;
            HashMap<IType, IType.CoderFunction_Type> tempCoders = tempCoding.customCoding.decoders;
            if (tempCoders.containsKey(this) && tempCoders.get((Object)this).functionDefinition != functionDefinition) {
                tempCoders.get((Object)this).conflict = true;
            } else {
                IType.CoderFunction_Type newCoder = new IType.CoderFunction_Type();
                newCoder.functionDefinition = functionDefinition;
                newCoder.conflict = false;
                tempCoders.put(this, newCoder);
            }
            return;
        }
    }

    @Override
    public IType getTypeWithCodingTable(CompilationTimeStamp timestamp, boolean ignoreLocal) {
        int i;
        if (!ignoreLocal && !this.codingTable.isEmpty()) {
            return this;
        }
        IType parent = null;
        if (this.parentType != null && (this.ownerType == IType.TypeOwner_type.OT_COMP_FIELD || this.ownerType == IType.TypeOwner_type.OT_RECORD_OF || this.ownerType == IType.TypeOwner_type.OT_ARRAY)) {
            parent = this.parentType.getTypeWithCodingTable(timestamp, true);
        }
        if (parent != null) {
            List<IType.Coding_Type> tempCodingTable = parent.getCodingTable();
            for (i = 0; i < tempCodingTable.size(); ++i) {
                if (tempCodingTable.get((int)i).modifier != SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE) continue;
                return parent;
            }
        }
        if (ignoreLocal && !this.codingTable.isEmpty()) {
            boolean local = false;
            for (i = 0; i < this.codingTable.size(); ++i) {
                if (this.codingTable.get((int)i).modifier != SingleWithAttribute.Attribute_Modifier_type.MOD_LOCAL) continue;
                local = true;
                break;
            }
            if (!local) {
                return this;
            }
        }
        if (this instanceof Referenced_Type) {
            ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IType tempType = ((Referenced_Type)this).getTypeRefd(timestamp, chain);
            chain.release();
            if (tempType == null || tempType.getIsErroneous(timestamp)) {
                return parent;
            }
            if ((tempType = tempType.getTypeWithCodingTable(timestamp, false)) != null) {
                return tempType;
            }
        }
        return parent;
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (coding == IType.MessageEncoding_type.BER) {
            return this.hasEncoding(timestamp, IType.MessageEncoding_type.BER, null);
        }
        return false;
    }

    @Override
    public boolean hasEncoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding, String customEncoding) {
        if (coding == IType.MessageEncoding_type.UNDEFINED || coding == IType.MessageEncoding_type.CUSTOM && customEncoding == null) {
            return false;
        }
        switch (coding) {
            case BER: {
                Type type = this;
                if (type.isAsn()) {
                    return true;
                }
                switch (type.getTypetype()) {
                    case TYPE_UNRESTRICTEDSTRING: 
                    case TYPE_OBJECTCLASSFIELDTYPE: 
                    case TYPE_EXTERNAL: 
                    case TYPE_EMBEDDED_PDV: 
                    case TYPE_REFERENCED: 
                    case TYPE_REFD_SPEC: 
                    case TYPE_SELECTION: 
                    case TYPE_ADDRESS: {
                        if (type instanceof IReferencingType) {
                            ReferenceChain refChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                            IType t = ((IReferencingType)((Object)type)).getTypeRefd(timestamp, refChain);
                            refChain.release();
                            if (t == null || t == this) {
                                return false;
                            }
                        }
                        type = (Type)type.getTypeRefdLast(this.lastTimeChecked);
                        return type.hasEncoding(timestamp, coding, customEncoding);
                    }
                    case TYPE_BOOL: 
                    case TYPE_INTEGER: 
                    case TYPE_REAL: 
                    case TYPE_BITSTRING: 
                    case TYPE_OCTETSTRING: 
                    case TYPE_CHARSTRING: 
                    case TYPE_OBJECTID: {
                        return true;
                    }
                }
                return false;
            }
            case PER: 
            case XER: 
            case OER: 
            case TEXT: {
                return true;
            }
        }
        IType t = this.getTypeWithCodingTable(timestamp, false);
        if (t != null) {
            boolean builtIn = coding != IType.MessageEncoding_type.CUSTOM;
            String encodingName = builtIn ? coding.getEncodingName() : customEncoding;
            List<IType.Coding_Type> codingTable = t.getCodingTable();
            for (int i = 0; i < codingTable.size(); ++i) {
                IType.Coding_Type tempCodingType = codingTable.get(i);
                if (builtIn != tempCodingType.builtIn || (!builtIn || tempCodingType.builtInCoding != coding) && (builtIn || !tempCodingType.customCoding.name.equals(encodingName))) continue;
                return true;
            }
        }
        IType lastType = this.getTypeRefdLast(timestamp);
        if (coding == IType.MessageEncoding_type.CUSTOM) {
            return false;
        }
        switch (this.getTypetype()) {
            case TYPE_TTCN3_CHOICE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_TTCN3_SET: 
            case TYPE_ANYTYPE: 
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_ASN1_SET: 
            case TYPE_ASN1_CHOICE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_SET_OF: 
            case TYPE_ARRAY: 
            case TYPE_TTCN3_ENUMERATED: 
            case TYPE_ASN1_ENUMERATED: {
                return false;
            }
        }
        boolean canHave = lastType.canHaveCoding(timestamp, coding);
        return canHave;
    }

    @Override
    public List<IType.Coding_Type> getCodingTable() {
        return this.codingTable;
    }

    @Override
    public void checkConstructorName(String definitionName) {
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_NONE;
    }

    protected void checkSubtypeRestrictions(CompilationTimeStamp timestamp) {
        this.checkSubtypeRestrictions(timestamp, this.getSubtypeType(), null);
    }

    protected void checkSubtypeRestrictions(CompilationTimeStamp timestamp, SubType.SubType_type subtypeType, SubType parentSubtype) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        if (this.parsedRestrictions == null && parentSubtype == null) {
            return;
        }
        if (subtypeType == SubType.SubType_type.ST_NONE) {
            this.getLocation().reportSemanticError(MessageFormat.format("TTCN-3 subtype constraints are not applicable to type `{0}''", this.getTypename()));
            this.setIsErroneous(true);
            return;
        }
        this.subType = new SubType(subtypeType, this, this.parsedRestrictions, parentSubtype);
        this.subType.check(timestamp);
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
    }

    @Override
    public boolean isComponentInternal(CompilationTimeStamp timestamp) {
        return false;
    }

    @Override
    public void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
    }

    @Override
    public void checkEmbedded(CompilationTimeStamp timestamp, Location errorLocation, boolean defaultAllowed, String errorMessage) {
    }

    @Override
    public IValue checkThisValueRef(CompilationTimeStamp timestamp, IValue value) {
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)value.getValuetype())) {
            return value.setValuetype(timestamp, IValue.Value_type.REFERENCED_VALUE);
        }
        return value;
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        value.setIsErroneous(false);
        Assignment assignment = this.getDefiningAssignment();
        if (assignment != null && assignment instanceof Definition) {
            Scope scope = value.getMyScope();
            if (scope != null) {
                Module module = scope.getModuleScope();
                if (module != null) {
                    String referingModuleName = module.getName();
                    if (!((Definition)assignment).referingHere.contains(referingModuleName)) {
                        ((Definition)assignment).referingHere.add(referingModuleName);
                    }
                } else {
                    ErrorReporter.logError((String)("The value `" + value.getFullName() + "' does not appear to be in a module"));
                    value.setIsErroneous(true);
                }
            } else {
                ErrorReporter.logError((String)("The value `" + value.getFullName() + "' does not appear to be in a scope"));
                value.setIsErroneous(true);
            }
        }
        this.check(timestamp);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp) || this.getIsErroneous(timestamp)) {
            return false;
        }
        if (IValue.Value_type.OMIT_VALUE.equals((Object)last.getValuetype()) && !valueCheckingOptions.omit_allowed) {
            value.getLocation().reportSemanticError("`omit' value is not allowed in this context");
            value.setIsErroneous(true);
            return false;
        }
        boolean selfReference = false;
        switch (value.getValuetype()) {
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                ReferenceChain chain;
                if (IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) {
                    chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    selfReference = this.checkThisReferencedValue(timestamp, last, lhs, valueCheckingOptions.expected_value, chain, valueCheckingOptions.sub_check, valueCheckingOptions.str_elem);
                    chain.release();
                    return selfReference;
                }
                return false;
            }
            case REFERENCED_VALUE: {
                ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                selfReference = this.checkThisReferencedValue(timestamp, value, lhs, valueCheckingOptions.expected_value, chain, valueCheckingOptions.sub_check, valueCheckingOptions.str_elem);
                chain.release();
                return selfReference;
            }
            case EXPRESSION_VALUE: {
                IType.Type_type temporalType;
                selfReference = value.checkExpressionSelfReference(timestamp, lhs);
                if (value.isUnfoldable(timestamp, null) && !IType.Type_type.TYPE_UNDEFINED.equals((Object)(temporalType = value.getExpressionReturntype(timestamp, valueCheckingOptions.expected_value))) && !Type.isCompatible(timestamp, this.getTypetype(), temporalType, false, value.isAsn())) {
                    value.getLocation().reportSemanticError(MessageFormat.format(INCOMPATIBLEVALUE, this.getTypename()));
                    value.setIsErroneous(true);
                }
                return selfReference;
            }
            case MACRO_VALUE: {
                selfReference = value.checkExpressionSelfReference(timestamp, lhs);
                if (!value.isUnfoldable(timestamp, null)) break;
                IType.Type_type temporalType = value.getExpressionReturntype(timestamp, valueCheckingOptions.expected_value);
                if (!IType.Type_type.TYPE_UNDEFINED.equals((Object)temporalType) && !Type.isCompatible(timestamp, this.getTypetype(), temporalType, false, value.isAsn())) {
                    value.getLocation().reportSemanticError(MessageFormat.format(INCOMPATIBLEVALUE, this.getTypename()));
                    value.setIsErroneous(true);
                }
                return selfReference;
            }
        }
        return selfReference;
    }

    private boolean checkThisReferencedValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, Expected_Value_type expectedValue, IReferenceChain referenceChain, boolean subCheck, boolean strElem) {
        IType type;
        String referingModuleName;
        Reference reference = ((Referenced_Value)value).getReference();
        Assignment assignment = reference.getRefdAssignment(timestamp, true, referenceChain);
        if (assignment == null) {
            value.setIsErroneous(true);
            return false;
        }
        Assignment myAssignment = this.getDefiningAssignment();
        if (myAssignment != null && myAssignment instanceof Definition && !((Definition)myAssignment).referingHere.contains(referingModuleName = value.getMyScope().getModuleScope().getName())) {
            ((Definition)myAssignment).referingHere.add(referingModuleName);
        }
        assignment.check(timestamp);
        boolean selfReference = assignment == lhs;
        boolean isConst = false;
        boolean errorFlag = false;
        boolean checkRunsOn = false;
        IType governor = null;
        if (assignment.getIsErroneous()) {
            value.setIsErroneous(true);
        } else {
            block0 : switch (assignment.getAssignmentType()) {
                case A_CONST: {
                    isConst = true;
                    break;
                }
                case A_OBJECT: 
                case A_OS: {
                    ISetting setting = reference.getRefdSetting(timestamp);
                    if (setting == null || setting.getIsErroneous(timestamp)) {
                        value.setIsErroneous(true);
                        return selfReference;
                    }
                    if (!ISetting.Setting_type.S_V.equals((Object)setting.getSettingtype())) {
                        reference.getLocation().reportSemanticError(MessageFormat.format("This InformationFromObjects construct does not refer to a value: {0}", value.getFullName()));
                        value.setIsErroneous(true);
                        return selfReference;
                    }
                    governor = ((Value)setting).getMyGovernor();
                    if (governor == null) break;
                    isConst = true;
                    break;
                }
                case A_EXT_CONST: 
                case A_MODULEPAR: {
                    if (!Expected_Value_type.EXPECTED_CONSTANT.equals((Object)expectedValue)) break;
                    value.getLocation().reportSemanticError(MessageFormat.format("Reference to an (evaluatable) constant value was expected instead of {0}", assignment.getDescription()));
                    errorFlag = true;
                    break;
                }
                case A_VAR: 
                case A_PAR_VAL: 
                case A_PAR_VAL_IN: 
                case A_PAR_VAL_OUT: 
                case A_PAR_VAL_INOUT: {
                    switch (expectedValue) {
                        case EXPECTED_CONSTANT: {
                            value.getLocation().reportSemanticError(MessageFormat.format("Reference to a constant value was expected instead of {0}", assignment.getDescription()));
                            errorFlag = true;
                            break block0;
                        }
                        case EXPECTED_STATIC_VALUE: {
                            value.getLocation().reportSemanticError(MessageFormat.format("Reference to a static value was expected instead of {0}", assignment.getDescription()));
                            errorFlag = true;
                            break block0;
                        }
                    }
                    break;
                }
                case A_TEMPLATE: 
                case A_MODULEPAR_TEMPLATE: 
                case A_VAR_TEMPLATE: 
                case A_PAR_TEMP_IN: 
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: {
                    if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) break;
                    value.getLocation().reportSemanticError(MessageFormat.format(REFTOVALUEEXPECTED, assignment.getDescription()));
                    errorFlag = true;
                    break;
                }
                case A_FUNCTION_RVAL: {
                    String message;
                    checkRunsOn = true;
                    switch (expectedValue) {
                        case EXPECTED_CONSTANT: {
                            message = MessageFormat.format("Reference to a constant value was expected instead of the return value of {0}", assignment.getDescription());
                            value.getLocation().reportSemanticError(message);
                            errorFlag = true;
                            break block0;
                        }
                        case EXPECTED_STATIC_VALUE: {
                            message = MessageFormat.format("Reference to a static value was expected instead of the return value of {0}", assignment.getDescription());
                            value.getLocation().reportSemanticError(message);
                            errorFlag = true;
                            break block0;
                        }
                    }
                    break;
                }
                case A_EXT_FUNCTION_RVAL: {
                    String message;
                    switch (expectedValue) {
                        case EXPECTED_CONSTANT: {
                            message = MessageFormat.format("Reference to a constant value was expected instead of the return value of {0}", assignment.getDescription());
                            value.getLocation().reportSemanticError(message);
                            errorFlag = true;
                            break block0;
                        }
                        case EXPECTED_STATIC_VALUE: {
                            message = MessageFormat.format("Reference to a static value was expected instead of the return value of {0}", assignment.getDescription());
                            value.getLocation().reportSemanticError(message);
                            errorFlag = true;
                            break block0;
                        }
                    }
                    break;
                }
                case A_FUNCTION_RTEMP: {
                    checkRunsOn = true;
                    if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) break;
                    value.getLocation().reportSemanticError(MessageFormat.format(REFTOVALUEEXPECTED_INSTEADOFCALL, assignment.getDescription()));
                    errorFlag = true;
                    break;
                }
                case A_EXT_FUNCTION_RTEMP: {
                    if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) break;
                    value.getLocation().reportSemanticError(MessageFormat.format(REFTOVALUEEXPECTED_INSTEADOFCALL, assignment.getDescription()));
                    errorFlag = true;
                    break;
                }
                case A_FUNCTION: 
                case A_EXT_FUNCTION: {
                    value.getLocation().reportSemanticError(MessageFormat.format("Reference to a {0} was expected instead of a call of {1}, which does not have a return type", Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue) ? "value or template" : "value", assignment.getDescription()));
                    value.setIsErroneous(true);
                    return selfReference;
                }
                default: {
                    value.getLocation().reportSemanticError(MessageFormat.format("Reference to a {0} was expected instead of {1}", Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue) ? "value or template" : "value", assignment.getDescription()));
                    value.setIsErroneous(true);
                    return selfReference;
                }
            }
        }
        if (checkRunsOn) {
            reference.getMyScope().checkRunsOnScope(timestamp, assignment, (ILocateableNode)reference, "call");
        }
        if (governor == null && (type = assignment.getType(timestamp)) != null) {
            Referenced_Type rt;
            IType refdtype;
            if (type instanceof Referenced_Type && (refdtype = (rt = (Referenced_Type)type).getTypeRefd(timestamp, referenceChain)) instanceof Class_Type) {
                governor = ((Class_Type)refdtype).getFieldType(timestamp, reference, 1, expectedValue, referenceChain, false);
            }
            if (governor == null) {
                governor = type.getFieldType(timestamp, reference, 1, expectedValue, referenceChain, false);
            }
        }
        if (governor == null) {
            value.setIsErroneous(true);
            return selfReference;
        }
        TypeCompatibilityInfo info = new TypeCompatibilityInfo(this, governor, true);
        info.setStr1Elem(strElem);
        info.setStr2Elem(reference.refersToStringElement());
        CompatibilityLevel compatibilityLevel = this.getCompatibility(timestamp, governor, info, null, null);
        if (compatibilityLevel != CompatibilityLevel.COMPATIBLE) {
            IType type2 = this.getTypeRefdLast(timestamp, null);
            switch (type2.getTypetype()) {
                case TYPE_PORT: {
                    break;
                }
                case TYPE_SIGNATURE: {
                    if (!Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) break;
                    String message = MessageFormat.format("Type mismatch: a signature template of type `{0}'' was expected instead of `{1}''", this.getTypename(), governor.getTypename());
                    value.getLocation().reportSemanticError(message);
                    break;
                }
                case TYPE_TTCN3_CHOICE: 
                case TYPE_TTCN3_SEQUENCE: 
                case TYPE_TTCN3_SET: 
                case TYPE_ANYTYPE: 
                case TYPE_ASN1_SEQUENCE: 
                case TYPE_ASN1_SET: 
                case TYPE_ASN1_CHOICE: 
                case TYPE_SEQUENCE_OF: 
                case TYPE_SET_OF: 
                case TYPE_ARRAY: {
                    if (compatibilityLevel == CompatibilityLevel.INCOMPATIBLE_SUBTYPE) {
                        value.getLocation().reportSemanticError(info.getSubtypeError());
                        break;
                    }
                    value.getLocation().reportSemanticError(info.getErrorStringString());
                    break;
                }
                default: {
                    if (compatibilityLevel == CompatibilityLevel.INCOMPATIBLE_SUBTYPE) {
                        value.getLocation().reportSemanticError(info.getSubtypeError());
                        break;
                    }
                    String message = MessageFormat.format("Type mismatch: a {0} of type `{1}'' was expected instead of `{2}''", Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue) ? "value or template" : "value", this.getTypename(), governor.getTypename());
                    value.getLocation().reportSemanticError(message);
                }
            }
            errorFlag = true;
        } else {
            if ("warning".equals(typeCompatibilitySeverity) && info.getNeedsConversion()) {
                value.getLocation().reportSemanticWarning(MessageFormat.format(TYPECOMPATWARNING, this.getTypename(), governor.getTypename()));
            }
            if (info.getNeedsConversion()) {
                value.set_needs_conversion();
            }
        }
        if (errorFlag) {
            value.setIsErroneous(true);
            return selfReference;
        }
        IValue last = value.getValueRefdLast(timestamp, expectedValue, referenceChain);
        if (isConst && !last.getIsErroneous(timestamp) && subCheck && this.subType != null) {
            this.subType.checkThisValue(timestamp, value);
        }
        return selfReference;
    }

    @Override
    public ITTCN3Template checkThisTemplateRef(CompilationTimeStamp timestamp, ITTCN3Template t, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        switch (t.getTemplatetype()) {
            case SUPERSET_MATCH: 
            case SUBSET_MATCH: {
                IType it1 = this.getTypeRefdLast(timestamp);
                IType.Type_type tt = it1.getTypetype();
                if (IType.Type_type.TYPE_SEQUENCE_OF.equals((Object)tt) || IType.Type_type.TYPE_SET_OF.equals((Object)tt)) {
                    return t;
                }
                t.getLocation().reportSemanticError(MessageFormat.format("{0} cannot be used for type {1}", t.getTemplateTypeName(), this.getTypename()));
                t.setIsErroneous(true);
                return t;
            }
            case SPECIFIC_VALUE: {
                break;
            }
            default: {
                return t;
            }
        }
        ITTCN3Template template = t;
        IValue value = ((SpecificValue_Template)template).getSpecificValue();
        if (value == null) {
            return template;
        }
        value = this.checkThisValueRef(timestamp, value);
        block4 : switch (value.getValuetype()) {
            case REFERENCED_VALUE: {
                Assignment assignment = ((Referenced_Value)value).getReference().getRefdAssignment(timestamp, false, referenceChain);
                if (assignment == null) {
                    template.setIsErroneous(true);
                    break;
                }
                switch (assignment.getAssignmentType()) {
                    case A_VAR_TEMPLATE: {
                        if (!Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) {
                            template.getLocation().reportSemanticError(MessageFormat.format(REFTOVALUEEXPECTED, assignment.getDescription()));
                            template.setIsErroneous(true);
                        }
                        Type type = ((Def_Var_Template)assignment).getType(timestamp);
                        switch (type.getTypetype()) {
                            case TYPE_BITSTRING: 
                            case TYPE_HEXSTRING: 
                            case TYPE_OCTETSTRING: 
                            case TYPE_CHARSTRING: 
                            case TYPE_UCHARSTRING: 
                            case TYPE_BITSTRING_A: 
                            case TYPE_UTF8STRING: 
                            case TYPE_NUMERICSTRING: 
                            case TYPE_PRINTABLESTRING: 
                            case TYPE_TELETEXSTRING: 
                            case TYPE_VIDEOTEXSTRING: 
                            case TYPE_IA5STRING: 
                            case TYPE_GRAPHICSTRING: 
                            case TYPE_VISIBLESTRING: 
                            case TYPE_GENERALSTRING: 
                            case TYPE_UNIVERSALSTRING: 
                            case TYPE_BMPSTRING: 
                            case TYPE_UTCTIME: 
                            case TYPE_GENERALIZEDTIME: 
                            case TYPE_OBJECTDESCRIPTOR: {
                                ISubReference subreference;
                                List<ISubReference> subReferences = ((Referenced_Value)value).getReference().getSubreferences();
                                int nofSubreferences = subReferences.size();
                                if (nofSubreferences <= 1 || !((subreference = subReferences.get(nofSubreferences - 1)) instanceof ArraySubReference)) break;
                                template.getLocation().reportSemanticError(MessageFormat.format("Reference to {0} can not be indexed", assignment.getDescription()));
                                template.setIsErroneous(true);
                                return template;
                            }
                        }
                        return template.setTemplatetype(timestamp, ITTCN3Template.Template_type.TEMPLATE_REFD);
                    }
                    case A_CONST: {
                        IType type1 = assignment instanceof Value_Assignment ? ((Value_Assignment)assignment).getType(timestamp) : ((Def_Const)assignment).getType(timestamp);
                        switch (type1.getTypetype()) {
                            case TYPE_BITSTRING: 
                            case TYPE_HEXSTRING: 
                            case TYPE_OCTETSTRING: 
                            case TYPE_CHARSTRING: 
                            case TYPE_UCHARSTRING: 
                            case TYPE_BITSTRING_A: 
                            case TYPE_UTF8STRING: 
                            case TYPE_NUMERICSTRING: 
                            case TYPE_PRINTABLESTRING: 
                            case TYPE_TELETEXSTRING: 
                            case TYPE_VIDEOTEXSTRING: 
                            case TYPE_IA5STRING: 
                            case TYPE_GRAPHICSTRING: 
                            case TYPE_VISIBLESTRING: 
                            case TYPE_GENERALSTRING: 
                            case TYPE_UNIVERSALSTRING: 
                            case TYPE_BMPSTRING: 
                            case TYPE_UTCTIME: 
                            case TYPE_GENERALIZEDTIME: 
                            case TYPE_OBJECTDESCRIPTOR: {
                                List<ISubReference> subReferences = ((Referenced_Value)value).getReference().getSubreferences();
                                int nofSubreferences = subReferences.size();
                                if (nofSubreferences <= 1) break;
                                ISubReference subreference = subReferences.get(nofSubreferences - 1);
                                if (!(subreference instanceof ArraySubReference)) break block4;
                                template.getLocation().reportSemanticError(MessageFormat.format("Reference to {0} can not be indexed", assignment.getDescription()));
                                template.setIsErroneous(true);
                                return template;
                            }
                        }
                        break block4;
                    }
                    case A_TEMPLATE: 
                    case A_MODULEPAR_TEMPLATE: 
                    case A_PAR_TEMP_IN: 
                    case A_PAR_TEMP_OUT: 
                    case A_PAR_TEMP_INOUT: 
                    case A_FUNCTION_RTEMP: 
                    case A_EXT_FUNCTION_RTEMP: {
                        if (!Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue)) {
                            template.getLocation().reportSemanticError(MessageFormat.format(REFTOVALUEEXPECTED, assignment.getDescription()));
                            template.setIsErroneous(true);
                        }
                        return template.setTemplatetype(timestamp, ITTCN3Template.Template_type.TEMPLATE_REFD);
                    }
                }
                break;
            }
            case EXPRESSION_VALUE: {
                IType type;
                Expression_Value expression = (Expression_Value)value;
                if (!Expression_Value.Operation_type.APPLY_OPERATION.equals((Object)expression.getOperationType()) || (type = expression.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE)) == null || (type = type.getTypeRefdLast(timestamp)) == null || !IType.Type_type.TYPE_FUNCTION.equals((Object)type.getTypetype()) || !((Function_Type)type).returnsTemplate()) break;
                return template.setTemplatetype(timestamp, ITTCN3Template.Template_type.TEMPLATE_INVOKE);
            }
        }
        return template;
    }

    @Override
    public ITTCN3Template checkThisTemplateRef(CompilationTimeStamp timestamp, ITTCN3Template t) {
        return this.checkThisTemplateRef(timestamp, t, Expected_Value_type.EXPECTED_TEMPLATE, null);
    }

    protected void checkStringIndex(CompilationTimeStamp timestamp, Value indexValue, Expected_Value_type expectedIndex, IReferenceChain refChain) {
        if (indexValue != null) {
            indexValue.setLoweridToReference(timestamp);
            IType.Type_type tempType = indexValue.getExpressionReturntype(timestamp, expectedIndex);
            switch (tempType) {
                case TYPE_INTEGER: {
                    IValue last = indexValue.getValueRefdLast(timestamp, expectedIndex, refChain);
                    if (!IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype())) break;
                    Integer_Value lastInteger = (Integer_Value)last;
                    if (lastInteger.isNative()) {
                        long temp = lastInteger.getValue();
                        if (temp >= 0L) break;
                        indexValue.getLocation().reportSemanticError(MessageFormat.format("A non-negative integer value was expected as index instead of `{0}''", temp));
                        indexValue.setIsErroneous(true);
                        break;
                    }
                    indexValue.getLocation().reportSemanticError(MessageFormat.format("Integer value `{0}'' is too big for indexing type `{1}''", lastInteger.getValueValue(), this.getTypename()));
                    indexValue.setIsErroneous(true);
                    break;
                }
                case TYPE_UNDEFINED: {
                    indexValue.setIsErroneous(true);
                    break;
                }
                default: {
                    indexValue.getLocation().reportSemanticError("The index should be an integer value");
                    indexValue.setIsErroneous(true);
                }
            }
        }
    }

    protected void registerUsage(ITTCN3Template template) {
        String referingModuleName;
        Assignment assignment = this.getDefiningAssignment();
        if (assignment != null && assignment instanceof Definition && !((Definition)assignment).referingHere.contains(referingModuleName = template.getMyScope().getModuleScope().getName())) {
            ((Definition)assignment).referingHere.add(referingModuleName);
        }
    }

    @Override
    public abstract boolean checkThisTemplate(CompilationTimeStamp var1, ITTCN3Template var2, boolean var3, boolean var4, Assignment var5);

    @Override
    public final void checkThisTemplateSubtype(CompilationTimeStamp timestamp, ITTCN3Template template) {
        if (ITTCN3Template.Template_type.PERMUTATION_MATCH.equals((Object)template.getTemplatetype())) {
            return;
        }
        if (this.subType != null) {
            this.subType.checkThisTemplateGeneric(timestamp, template);
        }
    }

    @Override
    public abstract boolean isCompatible(CompilationTimeStamp var1, IType var2, TypeCompatibilityInfo var3, TypeCompatibilityInfo.Chain var4, TypeCompatibilityInfo.Chain var5);

    @Override
    public boolean isStronglyCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType thisTypeLast = this.getTypeRefdLast(timestamp);
        IType otherTypeLast = otherType.getTypeRefdLast(timestamp);
        if (thisTypeLast == null || otherTypeLast == null || thisTypeLast.getIsErroneous(timestamp) || otherTypeLast.getIsErroneous(timestamp)) {
            return true;
        }
        return thisTypeLast.getTypetype().equals((Object)otherTypeLast.getTypetype());
    }

    @Override
    public CompatibilityLevel getCompatibility(CompilationTimeStamp timestamp, IType type, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        if (info == null) {
            ErrorReporter.INTERNAL_ERROR((String)"info==null");
        }
        if (!this.isCompatible(timestamp, type, info, leftChain, rightChain)) {
            return CompatibilityLevel.INCOMPATIBLE_TYPE;
        }
        if (noStructuredTypeCompatibility) {
            return CompatibilityLevel.COMPATIBLE;
        }
        SubType otherSubType = type.getSubtype();
        if (info != null && this.subType != null && otherSubType != null) {
            if (info.getStr1Elem()) {
                if (!info.getStr2Elem() && !otherSubType.isCompatibleWithElem(timestamp)) {
                    info.setSubtypeError("Subtype mismatch: string element has no common value with subtype " + otherSubType.toString());
                    return CompatibilityLevel.INCOMPATIBLE_SUBTYPE;
                }
            } else if (info.getStr2Elem()) {
                if (!this.subType.isCompatibleWithElem(timestamp)) {
                    info.setSubtypeError("Subtype mismatch: subtype " + this.subType.toString() + " has no common value with string element");
                    return CompatibilityLevel.INCOMPATIBLE_SUBTYPE;
                }
            } else if (!this.subType.isCompatible(timestamp, otherSubType)) {
                info.setSubtypeError("Subtype mismatch: subtype " + this.subType.toString() + " has no common value with subtype " + otherSubType.toString());
                return CompatibilityLevel.INCOMPATIBLE_SUBTYPE;
            }
        }
        return CompatibilityLevel.COMPATIBLE;
    }

    @Override
    public boolean isCompatibleByPort(CompilationTimeStamp timestamp, IType otherType) {
        this.check(timestamp);
        otherType.check(timestamp);
        return false;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this.getTypetypeTtcn3().equals((Object)temp.getTypetypeTtcn3());
    }

    @Override
    public void checkMapParameter(CompilationTimeStamp timestamp, IReferenceChain refChain, Location errorLocation) {
    }

    public static IType.MessageEncoding_type getEncodingType(String encoding) {
        if ("RAW".equals(encoding)) {
            return IType.MessageEncoding_type.RAW;
        }
        if ("TEXT".equals(encoding)) {
            return IType.MessageEncoding_type.TEXT;
        }
        if ("JSON".equals(encoding)) {
            return IType.MessageEncoding_type.JSON;
        }
        if ("BER:2002".equals(encoding) || "CER:2002".equals(encoding) || "DER:2002".equals(encoding)) {
            return IType.MessageEncoding_type.BER;
        }
        if ("XML".equals(encoding) || "XER".equals(encoding)) {
            return IType.MessageEncoding_type.XER;
        }
        if ("PER".equals(encoding)) {
            return IType.MessageEncoding_type.PER;
        }
        if ("OER".equals(encoding)) {
            return IType.MessageEncoding_type.OER;
        }
        return IType.MessageEncoding_type.CUSTOM;
    }

    @Override
    public abstract String getTypename();

    @Override
    public abstract IType.Type_type getTypetypeTtcn3();

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder;
    }

    @Override
    public Identifier getIdentifier() {
        return null;
    }

    @Override
    public Object[] getOutlineChildren() {
        return new Object[0];
    }

    @Override
    public String getOutlineText() {
        return "";
    }

    @Override
    public int category() {
        return this.getTypetype().ordinal();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
    }

    public static final boolean isCompatible(CompilationTimeStamp timestamp, IType.Type_type typeType1, IType.Type_type typeType2, boolean isAsn11, boolean isAsn12) {
        if (IType.Type_type.TYPE_UNDEFINED.equals((Object)typeType1) || IType.Type_type.TYPE_UNDEFINED.equals((Object)typeType2)) {
            return true;
        }
        switch (typeType1) {
            case TYPE_SEQUENCE_OF: 
            case TYPE_SET_OF: 
            case TYPE_ARRAY: 
            case TYPE_NULL: 
            case TYPE_BOOL: 
            case TYPE_REAL: 
            case TYPE_HEXSTRING: 
            case TYPE_VERDICT: 
            case TYPE_PORT: 
            case TYPE_SIGNATURE: 
            case TYPE_DEFAULT: 
            case TYPE_COMPONENT: 
            case TYPE_FUNCTION: 
            case TYPE_ALTSTEP: 
            case TYPE_TESTCASE: {
                return typeType1.equals((Object)typeType2);
            }
            case TYPE_OCTETSTRING: {
                return IType.Type_type.TYPE_OCTETSTRING.equals((Object)typeType2) || !isAsn11 && IType.Type_type.TYPE_ANY.equals((Object)typeType2);
            }
            case TYPE_UCHARSTRING: {
                switch (typeType2) {
                    case TYPE_CHARSTRING: 
                    case TYPE_UCHARSTRING: 
                    case TYPE_UTF8STRING: 
                    case TYPE_NUMERICSTRING: 
                    case TYPE_PRINTABLESTRING: 
                    case TYPE_TELETEXSTRING: 
                    case TYPE_VIDEOTEXSTRING: 
                    case TYPE_IA5STRING: 
                    case TYPE_GRAPHICSTRING: 
                    case TYPE_VISIBLESTRING: 
                    case TYPE_GENERALSTRING: 
                    case TYPE_UNIVERSALSTRING: 
                    case TYPE_BMPSTRING: 
                    case TYPE_UTCTIME: 
                    case TYPE_GENERALIZEDTIME: 
                    case TYPE_OBJECTDESCRIPTOR: {
                        return true;
                    }
                }
                return false;
            }
            case TYPE_UTF8STRING: 
            case TYPE_UNIVERSALSTRING: 
            case TYPE_BMPSTRING: {
                switch (typeType2) {
                    case TYPE_CHARSTRING: 
                    case TYPE_UCHARSTRING: 
                    case TYPE_UTF8STRING: 
                    case TYPE_NUMERICSTRING: 
                    case TYPE_PRINTABLESTRING: 
                    case TYPE_IA5STRING: 
                    case TYPE_VISIBLESTRING: 
                    case TYPE_UNIVERSALSTRING: 
                    case TYPE_BMPSTRING: 
                    case TYPE_UTCTIME: 
                    case TYPE_GENERALIZEDTIME: {
                        return true;
                    }
                }
                return false;
            }
            case TYPE_TELETEXSTRING: 
            case TYPE_VIDEOTEXSTRING: 
            case TYPE_GRAPHICSTRING: 
            case TYPE_GENERALSTRING: 
            case TYPE_OBJECTDESCRIPTOR: {
                switch (typeType2) {
                    case TYPE_CHARSTRING: 
                    case TYPE_UCHARSTRING: 
                    case TYPE_NUMERICSTRING: 
                    case TYPE_PRINTABLESTRING: 
                    case TYPE_TELETEXSTRING: 
                    case TYPE_VIDEOTEXSTRING: 
                    case TYPE_IA5STRING: 
                    case TYPE_GRAPHICSTRING: 
                    case TYPE_VISIBLESTRING: 
                    case TYPE_GENERALSTRING: 
                    case TYPE_UTCTIME: 
                    case TYPE_GENERALIZEDTIME: 
                    case TYPE_OBJECTDESCRIPTOR: {
                        return true;
                    }
                }
                return false;
            }
            case TYPE_CHARSTRING: 
            case TYPE_NUMERICSTRING: 
            case TYPE_PRINTABLESTRING: 
            case TYPE_IA5STRING: 
            case TYPE_VISIBLESTRING: 
            case TYPE_UTCTIME: 
            case TYPE_GENERALIZEDTIME: {
                switch (typeType2) {
                    case TYPE_CHARSTRING: 
                    case TYPE_NUMERICSTRING: 
                    case TYPE_PRINTABLESTRING: 
                    case TYPE_IA5STRING: 
                    case TYPE_VISIBLESTRING: 
                    case TYPE_UTCTIME: 
                    case TYPE_GENERALIZEDTIME: {
                        return true;
                    }
                }
                return false;
            }
            case TYPE_BITSTRING: 
            case TYPE_BITSTRING_A: {
                return IType.Type_type.TYPE_BITSTRING.equals((Object)typeType2) || IType.Type_type.TYPE_BITSTRING_A.equals((Object)typeType2);
            }
            case TYPE_INTEGER: 
            case TYPE_INTEGER_A: {
                return IType.Type_type.TYPE_INTEGER.equals((Object)typeType2) || IType.Type_type.TYPE_INTEGER_A.equals((Object)typeType2);
            }
            case TYPE_OBJECTID: {
                return IType.Type_type.TYPE_OBJECTID.equals((Object)typeType2) || !isAsn11 && IType.Type_type.TYPE_ROID.equals((Object)typeType2);
            }
            case TYPE_ROID: {
                return IType.Type_type.TYPE_ROID.equals((Object)typeType2) || !isAsn12 && IType.Type_type.TYPE_OBJECTID.equals((Object)typeType2);
            }
            case TYPE_TTCN3_ENUMERATED: 
            case TYPE_ASN1_ENUMERATED: {
                return IType.Type_type.TYPE_TTCN3_ENUMERATED.equals((Object)typeType2) || IType.Type_type.TYPE_ASN1_ENUMERATED.equals((Object)typeType2);
            }
            case TYPE_TTCN3_CHOICE: 
            case TYPE_OPENTYPE: 
            case TYPE_ASN1_CHOICE: {
                return IType.Type_type.TYPE_TTCN3_CHOICE.equals((Object)typeType2) || IType.Type_type.TYPE_ASN1_CHOICE.equals((Object)typeType2) || IType.Type_type.TYPE_OPENTYPE.equals((Object)typeType2);
            }
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_ASN1_SEQUENCE: {
                return IType.Type_type.TYPE_TTCN3_SEQUENCE.equals((Object)typeType2) || IType.Type_type.TYPE_ASN1_SEQUENCE.equals((Object)typeType2);
            }
            case TYPE_TTCN3_SET: 
            case TYPE_ASN1_SET: {
                return IType.Type_type.TYPE_TTCN3_SET.equals((Object)typeType2) || IType.Type_type.TYPE_ASN1_SET.equals((Object)typeType2);
            }
            case TYPE_ANY: {
                return IType.Type_type.TYPE_ANY.equals((Object)typeType2) || IType.Type_type.TYPE_OCTETSTRING.equals((Object)typeType2);
            }
            case TYPE_OBJECTCLASSFIELDTYPE: 
            case TYPE_REFERENCED: 
            case TYPE_ADDRESS: {
                return false;
            }
            case TYPE_ANYTYPE: 
            case TYPE_CLASS: {
                return IType.Type_type.TYPE_CLASS.equals((Object)typeType2);
            }
        }
        return false;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public Assignment getDefiningAssignment() {
        if (this.getMyScope() == null) {
            return null;
        }
        Module module = this.getMyScope().getModuleScope();
        return module.getEnclosingAssignment(this.getLocation().getOffset());
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.constraints != null) {
            this.constraints.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parsedRestrictions != null) {
            for (ParsedSubType parsedSubType : this.parsedRestrictions) {
                parsedSubType.findReferences(referenceFinder, foundIdentifiers);
            }
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.constraints != null && !this.constraints.accept(v)) {
            return false;
        }
        if (this.withAttributesPath != null && !this.withAttributesPath.accept(v)) {
            return false;
        }
        if (this.parsedRestrictions != null) {
            for (ParsedSubType pst : this.parsedRestrictions) {
                if (pst.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean getGenerateCoderFunctions(IType.MessageEncoding_type encodingType) {
        for (int i = 0; i < this.codersToGenerate.size(); ++i) {
            if (encodingType != this.codersToGenerate.get(i)) continue;
            return true;
        }
        switch (this.getTypetype()) {
            case TYPE_TTCN3_CHOICE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_TTCN3_SET: 
            case TYPE_ANYTYPE: 
            case TYPE_OPENTYPE: 
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_ASN1_SET: 
            case TYPE_ASN1_CHOICE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_SET_OF: 
            case TYPE_ARRAY: 
            case TYPE_TTCN3_ENUMERATED: 
            case TYPE_ASN1_ENUMERATED: {
                return false;
            }
        }
        boolean canHave = this.canHaveCoding(CompilationTimeStamp.getBaseTimestamp(), encodingType);
        return canHave;
    }

    @Override
    public void setGenerateCoderFunctions(CompilationTimeStamp timestamp, IType.MessageEncoding_type encodingType) {
        switch (encodingType) {
            case BER: 
            case RAW: 
            case JSON: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.getGenerateCoderFunctions(encodingType)) {
            return;
        }
        this.codersToGenerate.add(encodingType);
    }

    @Override
    public abstract boolean generatesOwnClass(JavaGenData var1, StringBuilder var2);

    @Override
    public abstract void generateCode(JavaGenData var1, StringBuilder var2);

    @Override
    public void generateCodeTypedescriptor(JavaGenData aData, StringBuilder source, StringBuilder localTarget, Map<String, String> attributeRegistry) {
        String gennameJsonDescriptor;
        boolean generate_json;
        String gennameRawDescriptor;
        boolean generate_raw;
        if (this.lastTimeTypeDescriptorGenerated != null && !this.lastTimeTypeDescriptorGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeTypeDescriptorGenerated = aData.getBuildTimstamp();
        String genname = this.getGenNameOwn();
        String gennameTypeDescriptor = this.getGenNameTypeDescriptor(aData, source);
        IType last = this.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        int codingsSupported = 0;
        boolean bl = generate_raw = aData.getEnableRaw() && last.getGenerateCoderFunctions(IType.MessageEncoding_type.RAW);
        if (generate_raw && this.needsOwnRawDescriptor(aData)) {
            this.generateCodeRawDescriptor(aData, source, localTarget, attributeRegistry);
        }
        if (generate_raw) {
            gennameRawDescriptor = this.getGenNameRawDescriptor(aData, source);
            ++codingsSupported;
        } else {
            gennameRawDescriptor = "null";
        }
        boolean bl2 = generate_json = aData.getEnableJson() && last.getGenerateCoderFunctions(IType.MessageEncoding_type.JSON);
        if (generate_json && this.needsOwnJsonDescriptor(aData)) {
            this.generateCodeJsonDescriptor(aData, source, localTarget, attributeRegistry);
        }
        if (generate_json) {
            gennameJsonDescriptor = this.getGenNameJsonDescriptor(aData, source);
            ++codingsSupported;
        } else {
            gennameJsonDescriptor = "null";
        }
        aData.addBuiltinTypeImport("Base_Type.TTCN_Typedescriptor");
        String descriptorName = MessageFormat.format("{0}_descr_", genname);
        if (localTarget == null && aData.hasGlobalVariable(descriptorName)) {
            return;
        }
        StringBuilder globalVariable = new StringBuilder();
        globalVariable.append(MessageFormat.format("\t\tpublic static final TTCN_Typedescriptor {0}_descr_ = new TTCN_Typedescriptor(\"{1}\"", genname, this.getFullName()));
        if (codingsSupported > 1) {
            globalVariable.append(", null");
        }
        if (generate_raw) {
            globalVariable.append(MessageFormat.format(", {0}", gennameRawDescriptor));
        } else if (codingsSupported > 1) {
            globalVariable.append(", null");
        }
        if (generate_json) {
            globalVariable.append(MessageFormat.format(", {0}", gennameJsonDescriptor));
        } else if (codingsSupported > 1) {
            globalVariable.append(", null");
        }
        switch (last.getTypetype()) {
            case TYPE_SEQUENCE_OF: {
                StringBuilder preInit = aData.getPreInit();
                preInit.append(MessageFormat.format("{0}_descr_.oftype_descr = {1}_descr_;\n", gennameTypeDescriptor, ((SequenceOf_Type)last).getOfType().getGenNameTypeDescriptor(aData, source)));
                break;
            }
            case TYPE_SET_OF: {
                StringBuilder preInit = aData.getPreInit();
                preInit.append(MessageFormat.format("{0}_descr_.oftype_descr = {1}_descr_;\n", gennameTypeDescriptor, ((SetOf_Type)last).getOfType().getGenNameTypeDescriptor(aData, source)));
                break;
            }
        }
        globalVariable.append(");\n");
        if (localTarget == null) {
            aData.addGlobalVariable(descriptorName, globalVariable.toString());
        } else {
            localTarget.append((CharSequence)globalVariable);
        }
    }

    private void generateCodeRawDescriptor(JavaGenData aData, StringBuilder source, StringBuilder localTarget, Map<String, String> attributeRegistry) {
        boolean dummyRaw;
        aData.addBuiltinTypeImport("RAW.TTCN_RAWdescriptor");
        aData.addBuiltinTypeImport("RAW.ext_bit_t");
        aData.addBuiltinTypeImport("RAW.raw_sign_t");
        aData.addBuiltinTypeImport("RAW.top_bit_order_t");
        aData.addBuiltinTypeImport("TTCN_EncDec.raw_order_t");
        aData.addBuiltinTypeImport("TitanCharString.CharCoding");
        String genname = this.getGenNameOwn();
        String descriptorName = MessageFormat.format("{0}_raw_", genname);
        StringBuilder RAW_value = new StringBuilder();
        RAW_value.append(MessageFormat.format("new TTCN_RAWdescriptor(", genname));
        boolean bl = dummyRaw = this.rawAttribute == null;
        if (dummyRaw) {
            this.rawAttribute = new RawAST(this.getDefaultRawFieldLength());
        }
        if (this.rawAttribute.intX) {
            aData.addBuiltinTypeImport("RAW");
            RAW_value.append("RAW.RAW_INTX,");
        } else {
            RAW_value.append(this.rawAttribute.fieldlength).append(',');
        }
        if (this.rawAttribute.comp == 2) {
            RAW_value.append("raw_sign_t.SG_2COMPL,");
        } else if (this.rawAttribute.comp == 3) {
            RAW_value.append("raw_sign_t.SG_SG_BIT,");
        } else {
            RAW_value.append("raw_sign_t.SG_NO,");
        }
        if (this.rawAttribute.byteorder == 2) {
            RAW_value.append("raw_order_t.ORDER_MSB,");
        } else {
            RAW_value.append("raw_order_t.ORDER_LSB,");
        }
        if (this.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetype() == IType.Type_type.TYPE_OCTETSTRING) {
            if (this.rawAttribute.align == 2) {
                RAW_value.append("raw_order_t.ORDER_LSB,");
            } else {
                RAW_value.append("raw_order_t.ORDER_MSB,");
            }
        } else if (this.rawAttribute.align == 1) {
            RAW_value.append("raw_order_t.ORDER_MSB,");
        } else {
            RAW_value.append("raw_order_t.ORDER_LSB,");
        }
        if (this.rawAttribute.bitorderinfield == 1) {
            RAW_value.append("raw_order_t.ORDER_MSB,");
        } else {
            RAW_value.append("raw_order_t.ORDER_LSB,");
        }
        if (this.rawAttribute.bitorderinoctet == 1) {
            RAW_value.append("raw_order_t.ORDER_MSB,");
        } else {
            RAW_value.append("raw_order_t.ORDER_LSB,");
        }
        if (this.rawAttribute.extension_bit == 2) {
            RAW_value.append("ext_bit_t.EXT_BIT_YES,");
        } else if (this.rawAttribute.extension_bit == 3) {
            RAW_value.append("ext_bit_t.EXT_BIT_REVERSE,");
        } else {
            RAW_value.append("ext_bit_t.EXT_BIT_NO,");
        }
        if (this.rawAttribute.hexorder == 2) {
            RAW_value.append("raw_order_t.ORDER_MSB,");
        } else {
            RAW_value.append("raw_order_t.ORDER_LSB,");
        }
        if (this.rawAttribute.fieldorder == 1) {
            RAW_value.append("raw_order_t.ORDER_MSB,");
        } else {
            RAW_value.append("raw_order_t.ORDER_LSB,");
        }
        if (this.rawAttribute.toplevelind > 0) {
            if (this.rawAttribute.toplevel.bitorder == 2) {
                RAW_value.append("top_bit_order_t.TOP_BIT_LEFT,");
            } else {
                RAW_value.append("top_bit_order_t.TOP_BIT_RIGHT,");
            }
        } else {
            RAW_value.append("top_bit_order_t.TOP_BIT_INHERITED,");
        }
        RAW_value.append(this.rawAttribute.padding).append(',');
        RAW_value.append(this.rawAttribute.prepadding).append(',');
        RAW_value.append(this.rawAttribute.ptroffset).append(',');
        RAW_value.append(this.rawAttribute.unit).append(',');
        RAW_value.append(this.rawAttribute.padding_pattern_length).append(',');
        if (this.rawAttribute.padding_pattern_length > 0 && this.rawAttribute.padding_pattern != null) {
            RAW_value.append("new byte[] {");
            String temp = Bit2OctExpression.bit2oct(this.rawAttribute.padding_pattern);
            boolean first = true;
            for (int i = temp.length() - 1; i > 0; i -= 2) {
                if (first) {
                    first = false;
                } else {
                    RAW_value.append(", ");
                }
                RAW_value.append("(byte)0x").append(temp.charAt(i - 1)).append(temp.charAt(i));
            }
            RAW_value.append("},");
        } else {
            RAW_value.append("null,");
        }
        RAW_value.append(this.rawAttribute.length_restriction).append(',');
        if (this.rawAttribute.stringformat == CharString_Type.CharCoding.UTF_8) {
            RAW_value.append("CharCoding.UTF_8");
        } else if (this.rawAttribute.stringformat == CharString_Type.CharCoding.UTF16) {
            RAW_value.append("CharCoding.UTF16");
        } else {
            RAW_value.append("CharCoding.UNKNOWN");
        }
        RAW_value.append(',');
        if (this.rawAttribute.forceOmit.lists.size() == 0) {
            RAW_value.append(" null");
        } else {
            aData.addBuiltinTypeImport("RAW");
            String force_omit_name = MessageFormat.format("{0}_raw_force_omit", genname);
            StringBuilder globalVariables = new StringBuilder();
            globalVariables.append(MessageFormat.format("\tstatic final ArrayList<RAW.RAW_Field_List> {0}_lists = new ArrayList<RAW.RAW_Field_List>();\n", force_omit_name));
            globalVariables.append(MessageFormat.format("\tstatic final RAW.RAW_Force_Omit {0} = new RAW.RAW_Force_Omit({1}, {2}_raw_force_omit_lists);\n", force_omit_name, this.rawAttribute.forceOmit.lists.size(), genname));
            aData.addGlobalVariable(force_omit_name, globalVariables.toString());
            StringBuilder preInit = aData.getPreInit();
            for (int i = 0; i < this.rawAttribute.forceOmit.lists.size(); ++i) {
                int j;
                RawAST.rawAST_field_list fieldList = this.rawAttribute.forceOmit.lists.get(i);
                IType t = this.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                preInit.append(MessageFormat.format("{0}_lists.add(", force_omit_name));
                block6: for (j = 0; j < fieldList.names.size(); ++j) {
                    Identifier name = fieldList.names.get(j);
                    switch (t.getTypetype()) {
                        case TYPE_TTCN3_CHOICE: 
                        case TYPE_TTCN3_SEQUENCE: 
                        case TYPE_TTCN3_SET: {
                            int index = ((TTCN3_Set_Seq_Choice_BaseType)t).getComponentIndexByName(name);
                            t = ((TTCN3_Set_Seq_Choice_BaseType)t).getComponentByName(name.getName()).getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                            preInit.append(MessageFormat.format("new RAW.RAW_Field_List({0} ,", index));
                            continue block6;
                        }
                        case TYPE_ASN1_SEQUENCE: 
                        case TYPE_ASN1_SET: 
                        case TYPE_ASN1_CHOICE: {
                            int index = ((ASN1_Set_Seq_Choice_BaseType)t).getComponentIndexByName(name);
                            t = ((ASN1_Set_Seq_Choice_BaseType)t).getComponentByName(name).getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                            preInit.append(MessageFormat.format("new RAW.RAW_Field_List({0} ,", index));
                            continue block6;
                        }
                    }
                }
                preInit.append("null");
                for (j = 0; j < fieldList.names.size(); ++j) {
                    preInit.append(')');
                }
                preInit.append(");\n");
            }
            RAW_value.append(force_omit_name);
        }
        RAW_value.append(", ");
        RAW_value.append(this.rawAttribute.csn1lh ? "true" : "false");
        RAW_value.append(')');
        StringBuilder globalVariable = new StringBuilder();
        String raw_value_string = RAW_value.toString();
        if (attributeRegistry != null) {
            if (attributeRegistry.containsKey(raw_value_string)) {
                String previousName = attributeRegistry.get(raw_value_string);
                globalVariable.append(MessageFormat.format("\tpublic static final TTCN_RAWdescriptor {0}_raw_ = {1};\n", genname, previousName));
            } else {
                attributeRegistry.put(raw_value_string, MessageFormat.format("{0}_raw_", genname));
                globalVariable.append(MessageFormat.format("\tpublic static final TTCN_RAWdescriptor {0}_raw_ = {1};\n", genname, raw_value_string));
            }
        } else {
            globalVariable.append(MessageFormat.format("\tpublic static final TTCN_RAWdescriptor {0}_raw_ = {1};\n", genname, raw_value_string));
        }
        if (localTarget == null) {
            aData.addGlobalVariable(descriptorName, globalVariable.toString());
        } else {
            localTarget.append((CharSequence)globalVariable);
        }
        if (dummyRaw) {
            this.rawAttribute = null;
        }
    }

    protected void generateCodeJsonDescriptor(JavaGenData aData, StringBuilder source, StringBuilder localTarget, Map<String, String> attributeRegistry) {
        boolean as_map;
        aData.addBuiltinTypeImport("JSON.TTCN_JSONdescriptor");
        aData.addBuiltinTypeImport("JSON.json_string_escaping");
        String genname = this.getGenNameOwn();
        StringBuilder staticBlock = new StringBuilder();
        String descriptorName = MessageFormat.format("{0}_json_", genname);
        StringBuilder JSON_value = new StringBuilder();
        JSON_value.append(MessageFormat.format("new TTCN_JSONdescriptor(", genname));
        boolean bl = as_map = this.jsonAttribute != null && this.jsonAttribute.as_map || this.ownerType == IType.TypeOwner_type.OT_RECORD_OF && this.parentType.getJsonAttribute() != null && this.parentType.getJsonAttribute().as_map;
        if (this.jsonAttribute == null) {
            JSON_value.append(MessageFormat.format("false, null, false, null, false, false, {0}, 0, null, false, json_string_escaping.ESCAPE_AS_SHORT)", as_map ? "true" : "false"));
        } else {
            String enum_texts_name = null;
            JSON_value.append(this.jsonAttribute.omit_as_null).append(',');
            if (this.jsonAttribute.alias != null) {
                JSON_value.append('\"').append(this.jsonAttribute.alias).append('\"').append(',');
            } else {
                JSON_value.append("null").append(',');
            }
            JSON_value.append(this.jsonAttribute.as_value || this.jsonAttribute.tag_list != null).append(',');
            if (this.jsonAttribute.default_value == null) {
                JSON_value.append("null").append(',');
            } else {
                if (this.jsonAttribute.default_value.canGenerateSingleExpression()) {
                    ExpressionStruct expression = new ExpressionStruct();
                    this.jsonAttribute.default_value.generateCodeExpressionMandatory(aData, expression, true);
                    if (expression.preamble.length() > 0 || expression.postamble.length() > 0) {
                        JSON_value.append("null");
                    } else {
                        JSON_value.append((CharSequence)expression.expression);
                    }
                } else {
                    String typeGeneratedName = this.getGenNameValue(aData, source);
                    JSON_value.append(MessageFormat.format("new {0}()", typeGeneratedName));
                    staticBlock.append("static {\n");
                    String tempId = aData.getTemporaryVariableName();
                    staticBlock.append(MessageFormat.format("{0} {1} = ({0}){2}.getActualDefaultValue();\n", typeGeneratedName, tempId, descriptorName));
                    this.jsonAttribute.default_value.generateCodeInit(aData, staticBlock, tempId);
                    staticBlock.append("}\n");
                }
                JSON_value.append(',');
            }
            JSON_value.append(this.jsonAttribute.metainfo_unbound).append(',');
            JSON_value.append(this.jsonAttribute.as_number).append(',');
            JSON_value.append(as_map).append(',');
            JSON_value.append(this.jsonAttribute.enum_texts.size()).append(',');
            if (this.jsonAttribute.enum_texts.size() != 0) {
                aData.addBuiltinTypeImport("JSON.JsonEnumText");
                enum_texts_name = MessageFormat.format("{0}_json_enum_texts", genname);
                StringBuilder enum_texts_value = new StringBuilder();
                enum_texts_value.append(MessageFormat.format("\t\tfinal static List<JsonEnumText> {0} = new ArrayList<JsonEnumText>();\n", enum_texts_name));
                enum_texts_value.append("\t\tstatic {\n");
                for (int i = 0; i < this.jsonAttribute.enum_texts.size(); ++i) {
                    JsonAST.JsonEnumText element = this.jsonAttribute.enum_texts.get(i);
                    enum_texts_value.append(MessageFormat.format("\t\t\t{0}.add(new JsonEnumText({1}, \"{2}\"));\n", enum_texts_name, element.index, element.to));
                }
                enum_texts_value.append("\t\t}\n");
                if (localTarget == null) {
                    aData.addGlobalVariable(enum_texts_name, enum_texts_value.toString());
                } else {
                    localTarget.append((CharSequence)enum_texts_value);
                }
            }
            JSON_value.append(enum_texts_name).append(", false, json_string_escaping.ESCAPE_AS_SHORT)");
        }
        StringBuilder globalVariable = new StringBuilder();
        if (attributeRegistry != null) {
            if (attributeRegistry.containsKey(JSON_value.toString())) {
                String previousName = attributeRegistry.get(JSON_value.toString());
                globalVariable.append(MessageFormat.format("\tpublic static final TTCN_JSONdescriptor {0}_json_ = {1};\n", genname, previousName));
            } else {
                attributeRegistry.put(JSON_value.toString(), MessageFormat.format("{0}_json_", genname));
                globalVariable.append(MessageFormat.format("\tpublic static final TTCN_JSONdescriptor {0}_json_ = {1};\n", genname, JSON_value.toString()));
            }
        } else {
            globalVariable.append(MessageFormat.format("\tpublic static final TTCN_JSONdescriptor {0}_json_ = {1};\n", genname, JSON_value.toString()));
        }
        if (staticBlock.length() != 0) {
            globalVariable.append((CharSequence)staticBlock);
        }
        if (localTarget == null) {
            aData.addGlobalVariable(descriptorName, globalVariable.toString());
        } else {
            localTarget.append((CharSequence)globalVariable);
        }
    }

    protected List<RawASTStruct.rawAST_coding_taglist> convertJsonCodingAttributes(JsonAST jsonattrib, JavaGenData aData, StringBuilder source, IType lastType) {
        if (jsonattrib == null || jsonattrib.tag_list == null) {
            return null;
        }
        List<RawAST.rawAST_single_tag> tag_list = jsonattrib.tag_list;
        ArrayList<RawASTStruct.rawAST_coding_taglist> jsonChosen = new ArrayList<RawASTStruct.rawAST_coding_taglist>(tag_list.size());
        for (int c = 0; c < tag_list.size(); ++c) {
            RawAST.rawAST_single_tag curr_single_Tag = tag_list.get(c);
            RawASTStruct.rawAST_coding_taglist curr_coding_taglist = new RawASTStruct.rawAST_coding_taglist();
            int keyListSize = curr_single_Tag.keyList == null ? 0 : curr_single_Tag.keyList.size();
            curr_coding_taglist.fields = keyListSize > 0 ? new ArrayList(keyListSize) : null;
            jsonChosen.add(curr_coding_taglist);
            Identifier union_field_id = curr_single_Tag.fieldName;
            curr_coding_taglist.fieldname = union_field_id != null ? union_field_id.getName() : null;
            curr_coding_taglist.fieldnum = union_field_id != null ? ((TTCN3_Set_Seq_Choice_BaseType)lastType).getComponentIndexByName(curr_single_Tag.fieldName) : -2;
            for (int a = 0; a < keyListSize; ++a) {
                RawASTStruct.rawAST_coding_field_list key = new RawASTStruct.rawAST_coding_field_list();
                curr_coding_taglist.fields.add(key);
                key.fields = new ArrayList(curr_single_Tag.keyList.get((int)a).keyField.names.size());
                key.value = curr_single_Tag.keyList.get((int)a).value;
                ExpressionStruct expression = new ExpressionStruct();
                curr_single_Tag.keyList.get((int)a).v_value.generateCodeExpression(aData, expression, true);
                key.expression = expression;
                ExpressionStruct nativeExpression = new ExpressionStruct();
                curr_single_Tag.keyList.get((int)a).v_value.generateCodeExpression(aData, nativeExpression, false);
                key.nativeExpression = nativeExpression;
                IType t = this;
                for (int b = 0; b < curr_single_Tag.keyList.get((int)a).keyField.names.size(); ++b) {
                    Identifier curr_field_id = curr_single_Tag.keyList.get((int)a).keyField.names.get(b);
                    int current_field_index = ((TTCN3_Set_Seq_Choice_BaseType)t).getComponentIndexByName(curr_field_id);
                    CompField current_field = ((TTCN3_Set_Seq_Choice_BaseType)t).getComponentByIndex(current_field_index);
                    RawASTStruct.rawAST_coding_fields current_coding_fields = new RawASTStruct.rawAST_coding_fields();
                    current_coding_fields.nthfield = current_field_index;
                    current_coding_fields.nthfieldname = curr_field_id.getName();
                    current_coding_fields.fieldtype = t.getTypetype() == IType.Type_type.TYPE_TTCN3_CHOICE ? RawASTStruct.rawAST_coding_field_type.UNION_FIELD : (current_field.isOptional() ? RawASTStruct.rawAST_coding_field_type.OPTIONAL_FIELD : RawASTStruct.rawAST_coding_field_type.MANDATORY_FIELD);
                    Type field_type = current_field.getType();
                    current_coding_fields.type = field_type.getGenNameValue(aData, source);
                    current_coding_fields.typedesc = field_type.getGenNameTypeDescriptor(aData, source);
                    t = field_type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                    key.fields.add(current_coding_fields);
                }
            }
        }
        return jsonChosen;
    }

    @Override
    public void generateCodeDefaultCoding(JavaGenData aData, StringBuilder source, StringBuilder localTarget) {
        String genname = this.getGenNameOwn();
        IType t = this.getTypeWithCodingTable(CompilationTimeStamp.getBaseTimestamp(), false);
        if (t == null) {
            return;
        }
        String defaultCoding = "";
        List<IType.Coding_Type> tempCodingTable = t.getCodingTable();
        if (tempCodingTable.size() == 0) {
            return;
        }
        if (tempCodingTable.size() == 1) {
            IType.Coding_Type tempCodingType = tempCodingTable.get(0);
            defaultCoding = tempCodingType.builtIn ? (tempCodingType.builtInCoding == IType.MessageEncoding_type.BER ? "BER:2002" : tempCodingType.builtInCoding.getEncodingName()) : tempCodingType.customCoding.name;
        }
        aData.addBuiltinTypeImport("TitanUniversalCharString");
        String globalVariable = MessageFormat.format("\tpublic static final TitanUniversalCharString {0}_default_coding = new TitanUniversalCharString(\"{1}\");\n", genname, defaultCoding);
        if (localTarget == null) {
            aData.addGlobalVariable(MessageFormat.format("{0}_default_coding", genname), globalVariable);
        } else {
            localTarget.append(globalVariable);
        }
    }

    @Override
    public void generateCodeForCodingHandlers(JavaGenData aData, StringBuilder source, StringBuilder localTarget) {
        String genname = this.getGenNameOwn();
        IType t = this.getTypeWithCodingTable(CompilationTimeStamp.getBaseTimestamp(), false);
        if (t == null) {
            return;
        }
        List<IType.Coding_Type> tempCodingTable = t.getCodingTable();
        if (tempCodingTable.size() == 0) {
            return;
        }
        if (this.getGenNameCoder(aData, source, this.myScope).isEmpty()) {
            return;
        }
        aData.addBuiltinTypeImport("TitanOctetString");
        aData.addBuiltinTypeImport("TitanUniversalCharString");
        aData.addCommonLibraryImport("TtcnError");
        aData.addCommonLibraryImport("TTCN_Logger");
        aData.addImport("java.text.MessageFormat");
        StringBuilder encoderString = new StringBuilder();
        encoderString.append("\t/**\n");
        encoderString.append(MessageFormat.format("\t * The encoder function for type {0}.\n", this.getTypename()));
        encoderString.append("\t *\n");
        encoderString.append("\t * @param input_value\n");
        encoderString.append("\t *                the input value to encode.\n");
        encoderString.append("\t * @param output_stream\n");
        encoderString.append("\t *                the octetstring to be extend with the result of the\n");
        encoderString.append("\t *                encoding.\n");
        encoderString.append("\t * @param coding_name\n");
        encoderString.append("\t *                the name of the coding to use.\n");
        encoderString.append("\t * */\n");
        encoderString.append(MessageFormat.format("\tpublic static void {0}_encoder(final {1} input_value, final TitanOctetString output_stream, final TitanUniversalCharString coding_name) '{'\n", genname, this.getGenNameValue(aData, source)));
        StringBuilder decoderString = new StringBuilder();
        decoderString.append("\t/**\n");
        decoderString.append(MessageFormat.format("\t * The decoder function for type {0}. In case\n", this.getTypename()));
        decoderString.append("\t * of successful decoding the bits used for decoding are removed from\n");
        decoderString.append("\t * the beginning of the input_stream.\n");
        decoderString.append("\t *\n");
        decoderString.append("\t * @param input_stream\n");
        decoderString.append("\t *                the octetstring starting with the value to be decoded.\n");
        decoderString.append("\t * @param output_value\n");
        decoderString.append("\t *                the decoded value if the decoding was successful.\n");
        decoderString.append("\t * @param coding_name\n");
        decoderString.append("\t *                the name of the coding to use.\n");
        decoderString.append("\t * @return 0 if nothing could be decoded, 1 in case of success, 2 in\n");
        decoderString.append("\t *         case of error (incomplete message or length)\n");
        decoderString.append("\t * */\n");
        decoderString.append(MessageFormat.format("\tpublic static int {0}_decoder(final TitanOctetString input_stream, final {1} output_value, final TitanUniversalCharString coding_name) '{'\n", genname, this.getGenNameValue(aData, source)));
        for (int i = 0; i < tempCodingTable.size(); ++i) {
            IType.Coding_Type tempCodingType = tempCodingTable.get(i);
            if (tempCodingType.builtIn) continue;
            encoderString.append(MessageFormat.format("\t\tif (coding_name.operator_equals(\"{0}\")) '{'\n", tempCodingType.customCoding.name));
            IType.CoderFunction_Type encoderFunction = tempCodingType.customCoding.encoders.get(this);
            if (encoderFunction == null) {
                encoderString.append(MessageFormat.format("\t\t\tthrow new TtcnError(\"No `{0}'' encoding function defined for type `{1}''\");\n", tempCodingType.customCoding.name, this.getTypename()));
            } else if (encoderFunction.conflict) {
                encoderString.append(MessageFormat.format("\t\t\tthrow new TtcnError(\"Multiple `{0}'' encoding function defined for type `{1}''\");\n", tempCodingType.customCoding.name, this.getTypename()));
            } else {
                aData.addCommonLibraryImport("AdditionalFunctions");
                encoderString.append(MessageFormat.format("\t\t\toutput_stream.operator_assign(AdditionalFunctions.bit2oct({0}(input_value)));\n", encoderFunction.functionDefinition.getGenNameFromScope(aData, source, "")));
            }
            encoderString.append("\t\t}\n");
            decoderString.append(MessageFormat.format("\t\tif (coding_name.operator_equals(\"{0}\")) '{'\n", tempCodingType.customCoding.name));
            IType.CoderFunction_Type decoderFunction = tempCodingType.customCoding.decoders.get(this);
            if (decoderFunction == null) {
                decoderString.append(MessageFormat.format("\t\t\tthrow new TtcnError(\"No `{0}'' decoding function defined for type `{1}''\");\n", tempCodingType.customCoding.name, this.getTypename()));
            } else if (decoderFunction.conflict) {
                decoderString.append(MessageFormat.format("\t\t\tthrow new TtcnError(\"Multiple `{0}'' decoding function defined for type `{1}''\");\n", tempCodingType.customCoding.name, this.getTypename()));
            } else {
                aData.addCommonLibraryImport("AdditionalFunctions");
                aData.addBuiltinTypeImport("TitanBitString");
                aData.addBuiltinTypeImport("TitanInteger");
                decoderString.append("\t\t\tfinal TitanBitString bit_stream = new TitanBitString(AdditionalFunctions.oct2bit(input_stream));\n");
                decoderString.append(MessageFormat.format("\t\t\tfinal TitanInteger ret_val = {0}(bit_stream, output_value);\n", decoderFunction.functionDefinition.getGenNameFromScope(aData, source, "")));
                decoderString.append("\t\t\tinput_stream.operator_assign(AdditionalFunctions.bit2oct(bit_stream));\n");
                decoderString.append("\t\t\treturn ret_val.get_int();\n");
            }
            decoderString.append("\t\t}\n");
        }
        StringBuilder checkString = new StringBuilder();
        for (int i = 0; i < tempCodingTable.size(); ++i) {
            IType.Coding_Type tempCoding = tempCodingTable.get(i);
            if (!tempCoding.builtIn) continue;
            if (checkString.length() > 0) {
                checkString.append(" && ");
            }
            checkString.append(MessageFormat.format("codingType != TTCN_EncDec.coding_type.CT_{0}", tempCoding.builtInCoding.getEncodingName()));
        }
        if (checkString.length() > 0) {
            aData.addCommonLibraryImport("TTCN_EncDec");
            aData.addImport("java.util.concurrent.atomic.AtomicInteger");
            encoderString.append("\t\tfinal AtomicInteger extra_options = new AtomicInteger(0);\n");
            encoderString.append("\t\tfinal TTCN_EncDec.coding_type codingType = TTCN_EncDec.get_coding_from_str(coding_name, extra_options, true);\n");
            encoderString.append(MessageFormat.format("\t\tif ({0}) '{'\n", checkString));
        }
        encoderString.append("\t\tTTCN_Logger.begin_event_log2str();\n");
        encoderString.append("\t\tcoding_name.log();\n");
        encoderString.append(MessageFormat.format("\t\tthrow new TtcnError(MessageFormat.format(\"Type `{0}'' does not support '{'0'}' encoding\", TTCN_Logger.end_event_log2str()));\n", this.getTypename()));
        if (checkString.length() > 0) {
            aData.addCommonLibraryImport("TTCN_Buffer");
            encoderString.append("\t\t}\n");
            encoderString.append("\t\tfinal TTCN_Buffer ttcnBuffer = new TTCN_Buffer();\n");
            encoderString.append(MessageFormat.format("\t\tinput_value.encode({0}_descr_, ttcnBuffer, codingType, extra_options.get());\n", this.getGenNameTypeDescriptor(aData, source)));
            encoderString.append("\t\tttcnBuffer.get_string(output_stream);\n");
        }
        encoderString.append("\t}\n\n");
        if (checkString.length() > 0) {
            decoderString.append("\t\tfinal AtomicInteger extra_options = new AtomicInteger(0);\n");
            decoderString.append("\t\tfinal TTCN_EncDec.coding_type codingType = TTCN_EncDec.get_coding_from_str(coding_name, extra_options, false);\n");
            decoderString.append(MessageFormat.format("\t\tif ({0}) '{'\n", checkString));
        }
        decoderString.append("\t\tTTCN_Logger.begin_event_log2str();\n");
        decoderString.append("\t\tcoding_name.log();\n");
        decoderString.append(MessageFormat.format("\t\tthrow new TtcnError(MessageFormat.format(\"Type `{0}'' does not support '{'0'}' encoding\", TTCN_Logger.end_event_log2str()));\n", this.getTypename()));
        if (checkString.length() > 0) {
            decoderString.append("\t\t}\n");
            decoderString.append("\t\tfinal TTCN_Buffer ttcnBuffer = new TTCN_Buffer(input_stream);\n");
            decoderString.append(MessageFormat.format("\t\toutput_value.decode({0}_descr_, ttcnBuffer, codingType, extra_options.get());\n", this.getGenNameTypeDescriptor(aData, source)));
            decoderString.append("\t\tswitch (TTCN_EncDec.get_last_error_type()) {\n");
            decoderString.append("\t\tcase ET_NONE:\n");
            decoderString.append("\t\t\tttcnBuffer.cut();\n");
            decoderString.append("\t\t\tttcnBuffer.get_string(input_stream);\n");
            decoderString.append("\t\t\treturn 0;\n");
            decoderString.append("\t\tcase ET_INCOMPL_MSG:\n");
            decoderString.append("\t\tcase ET_LEN_ERR:\n");
            decoderString.append("\t\t\treturn 2;\n");
            decoderString.append("\t\tdefault:\n");
            decoderString.append("\t\t\treturn 1;\n");
            decoderString.append("\t\t}\n");
        }
        decoderString.append("\t}\n\n");
        if (localTarget == null) {
            source.append((CharSequence)encoderString);
            source.append((CharSequence)decoderString);
        } else {
            localTarget.append((CharSequence)encoderString);
            localTarget.append((CharSequence)decoderString);
        }
    }

    @Override
    public boolean hasBuiltInEncoding() {
        IType t = this.getTypeWithCodingTable(CompilationTimeStamp.getBaseTimestamp(), false);
        if (t == null) {
            return false;
        }
        List<IType.Coding_Type> codingTable = t.getCodingTable();
        for (int i = 0; i < codingTable.size(); ++i) {
            if (!codingTable.get((int)i).builtIn) continue;
            return true;
        }
        return false;
    }

    protected boolean needsAlias() {
        String name = this.getFullName();
        int firstDot = name.indexOf(46);
        return firstDot == -1 || name.indexOf(46, firstDot + 1) == -1;
    }

    @Override
    public String createStringRep_for_OpenType_AltName(CompilationTimeStamp timestamp) {
        return this.getGenNameOwn();
    }

    @Override
    public abstract String getGenNameValue(JavaGenData var1, StringBuilder var2);

    @Override
    public abstract String getGenNameTemplate(JavaGenData var1, StringBuilder var2);

    public boolean hasEncodeAttribute(String encoding_name) {
        if ("JSON".equals(encoding_name) && this.isAsn()) {
            return true;
        }
        WithAttributesPath attributePath = this.getAttributePath();
        if (attributePath != null) {
            CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();
            List<SingleWithAttribute> realAttributes = attributePath.getRealAttributes(timestamp);
            for (int i = 0; i < realAttributes.size(); ++i) {
                SingleWithAttribute singleWithAttribute = realAttributes.get(i);
                if (!SingleWithAttribute.Attribute_Type.Encode_Attribute.equals((Object)singleWithAttribute.getAttributeType()) || !singleWithAttribute.getAttributeSpecification().getSpecification().equals(encoding_name)) continue;
                return true;
            }
        }
        return (this.ownerType == IType.TypeOwner_type.OT_COMP_FIELD || this.ownerType == IType.TypeOwner_type.OT_RECORD_OF || this.ownerType == IType.TypeOwner_type.OT_ARRAY) && this.parentType != null && this.parentType.getAttributePath() != null && this.parentType.hasEncodeAttributeForType(this, encoding_name);
    }

    @Override
    public boolean hasEncodeAttributeForType(Type type, String encoding_name) {
        if (this.hasEncodeAttribute(encoding_name)) {
            return true;
        }
        MultipleWithAttributes multiWithAttributes = this.getAttributePath().getAttributes();
        if (multiWithAttributes != null) {
            for (int i = 0; i < multiWithAttributes.getNofElements(); ++i) {
                Qualifiers qualifiers;
                SingleWithAttribute singleWithAttribute = multiWithAttributes.getAttribute(i);
                if (!SingleWithAttribute.Attribute_Type.Encode_Attribute.equals((Object)singleWithAttribute.getAttributeType()) || !singleWithAttribute.getAttributeSpecification().getSpecification().equals(encoding_name) || (qualifiers = singleWithAttribute.getQualifiers()) == null) continue;
                for (int j = 0; j < qualifiers.getNofQualifiers(); ++j) {
                    Qualifier qualifier = qualifiers.getQualifierByIndex(j);
                    ArrayList<ISubReference> fieldsOrArrays = new ArrayList<ISubReference>();
                    for (int k = 0; k < qualifier.getNofSubReferences(); ++k) {
                        fieldsOrArrays.add(qualifier.getSubReferenceByIndex(k));
                    }
                    Reference reference = new Reference(null, fieldsOrArrays);
                    IType typeQualifier = this.getFieldType(CompilationTimeStamp.getBaseTimestamp(), reference, 0, Expected_Value_type.EXPECTED_CONSTANT, false);
                    if (typeQualifier != type) continue;
                    return true;
                }
            }
        }
        if ((this.ownerType == IType.TypeOwner_type.OT_COMP_FIELD || this.ownerType == IType.TypeOwner_type.OT_RECORD_OF || this.ownerType == IType.TypeOwner_type.OT_ARRAY) && this.parentType != null && this.parentType.getAttributePath() != null) {
            return this.parentType.hasEncodeAttributeForType(type, encoding_name);
        }
        return false;
    }

    @Override
    public abstract String getGenNameTypeDescriptor(JavaGenData var1, StringBuilder var2);

    @Override
    public String getGenNameCoder(JavaGenData aData, StringBuilder source, Scope scope) {
        IType t_ct = this.getTypeWithCodingTable(CompilationTimeStamp.getBaseTimestamp(), false);
        if (t_ct == null) {
            return "";
        }
        if (this.codingTable.size() > 0 || this.rawAttribute != null || this.jsonAttribute != null) {
            if (this.generatesOwnClass(aData, source)) {
                return this.getGenNameOwn(aData) + "." + this.getGenNameOwn();
            }
            if (this.getParentType() != null) {
                IType parentType = this.getParentType();
                if (parentType.generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
            return this.getGenNameOwn(aData);
        }
        List<IType.Coding_Type> ct_codingTable = ((Type)t_ct).codingTable;
        for (int i = 0; i < ct_codingTable.size(); ++i) {
            IType.Coding_Type tempCodingType = ct_codingTable.get(i);
            if (tempCodingType.builtIn || !tempCodingType.customCoding.encoders.containsKey(this) && !tempCodingType.customCoding.decoders.containsKey(this)) continue;
            if (this.generatesOwnClass(aData, source)) {
                return this.getGenNameOwn(aData) + "." + this.getGenNameOwn();
            }
            if (this.getParentType() != null) {
                IType parentType = this.getParentType();
                if (parentType.generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
            return this.getGenNameOwn(aData);
        }
        if (this instanceof IReferencingType) {
            ReferenceChain refChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IType t = ((IReferencingType)((Object)this)).getTypeRefd(CompilationTimeStamp.getBaseTimestamp(), refChain);
            refChain.release();
            if (t != null && t != this) {
                return t.getGenNameCoder(aData, source, scope);
            }
        }
        return "";
    }

    @Override
    public String getGenNameDefaultCoding(JavaGenData aData, StringBuilder source, Scope scope) {
        return this.getGenNameTypeDescriptor(aData, source);
    }

    @Override
    public boolean needsOwnRawDescriptor(JavaGenData aData) {
        ErrorReporter.INTERNAL_ERROR((String)("Trying to generate RAW for type `" + this.getFullName() + "'' that has no raw attributes"));
        return false;
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        ErrorReporter.INTERNAL_ERROR((String)("Trying to generate RAW for type `" + this.getFullName() + "'' that has no raw attributes"));
        return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return false;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        return null;
    }

    @Override
    public String getGenNameBerDescriptor(JavaGenData aData, StringBuilder source) {
        return null;
    }

    @Override
    public String getGenNameTypeName(JavaGenData aData, StringBuilder source) {
        return this.getGenNameValue(aData, source);
    }

    public void generateCodeDone(JavaGenData aData, StringBuilder source) {
        String genName = this.getGenNameValue(aData, source);
        String displayName = this.getTypename();
        aData.addImport("java.util.concurrent.atomic.AtomicReference");
        aData.addBuiltinTypeImport("Base_Template.template_sel");
        aData.addBuiltinTypeImport("TitanAlt_Status");
        aData.addCommonLibraryImport("Text_Buf");
        aData.addCommonLibraryImport("Index_Redirect");
        aData.addCommonLibraryImport("TTCN_Logger");
        aData.addCommonLibraryImport("TTCN_Runtime");
        aData.addBuiltinTypeImport("Value_Redirect_Interface");
        source.append(MessageFormat.format("\tpublic static final TitanAlt_Status done(final TitanComponent component_reference, final {0}_template value_template, final Value_Redirect_Interface value_redirect, final Index_Redirect index_redirect) '{'\n", genName));
        source.append("\t\tif (!component_reference.is_bound()) {\n");
        source.append("\t\t\tthrow new TtcnError(\"Performing a done operation on an unbound component reference.\");\n");
        source.append("\t\t}\n");
        source.append("\t\tif (value_template.get_selection() == template_sel.ANY_OR_OMIT) {\n");
        source.append("\t\t\tthrow new TtcnError(\"Done operation using '*' as matching template\");\n");
        source.append("\t\t}\n");
        source.append("\t\tfinal Text_Buf text_buf = new Text_Buf();\n");
        source.append("\t\tfinal AtomicReference<Text_Buf> text_buf_ref = new AtomicReference<Text_Buf>(text_buf);\n");
        source.append(MessageFormat.format("\t\tfinal TitanAlt_Status ret_val = TTCN_Runtime.component_done(component_reference.get_component(), \"{0}\", text_buf_ref);\n", displayName));
        source.append("\t\tif (ret_val == TitanAlt_Status.ALT_YES) {\n");
        source.append(MessageFormat.format("\t\t\tfinal {0} return_value = new {0}();\n", genName));
        source.append("\t\t\treturn_value.decode_text(text_buf_ref.get());\n");
        source.append("\t\t\tif (value_template.match(return_value)) {\n");
        source.append("\t\t\t\tif (value_redirect != null) {\n");
        source.append("\t\t\t\t\tvalue_redirect.set_values(return_value);\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PARALLEL_PTC);\n");
        source.append("\t\t\t\tTTCN_Logger.log_event_str(\"PTC with component reference \");\n");
        source.append("\t\t\t\tcomponent_reference.log();\n");
        source.append(MessageFormat.format("\t\t\t\tTTCN_Logger.log_event_str(\" is done. Return value: {0} : \");\n", displayName));
        source.append("\t\t\t\treturn_value.log();\n");
        source.append("\t\t\t\tTTCN_Logger.end_event();\n");
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_YES;\n");
        source.append("\t\t\t} else {\n");
        source.append("\t\t\t\tif (TTCN_Logger.log_this_event(TTCN_Logger.Severity.MATCHING_DONE)) {\n");
        source.append("\t\t\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.MATCHING_DONE);\n");
        source.append(MessageFormat.format("\t\t\t\t\tTTCN_Logger.log_event_str(\"Done operation with type {0} on component reference \");\n", displayName));
        source.append("\t\t\t\t\tcomponent_reference.log();\n");
        source.append("\t\t\t\t\tTTCN_Logger.log_event_str(\" failed: Return value does not match the template: \");\n");
        source.append("\t\t\t\t\tvalue_template.log_match(return_value, true);\n");
        source.append("\t\t\t\t\tTTCN_Logger.end_event();\n");
        source.append("\t\t\t\t}\n");
        source.append("\t\t\t\treturn TitanAlt_Status.ALT_NO;\n");
        source.append("\t\t\t}\n");
        source.append("\t\t} else {\n");
        source.append("\t\t\treturn ret_val;\n");
        source.append("\t\t}\n");
        source.append("\t}\n");
        if (this.needs_any_from_done) {
            source.append(MessageFormat.format("\tpublic static TitanAlt_Status done(final TitanValue_Array<TitanComponent> component_array, final {0}_template value_template, final Value_Redirect_Interface value_redirect, final Index_Redirect index_redirect) '{'\n", genName));
            source.append("\t\tif (index_redirect != null) {\n");
            source.append("\t\t\tindex_redirect.incr_pos();\n");
            source.append("\t\t}\n");
            source.append("\t\tTitanAlt_Status result = TitanAlt_Status.ALT_NO;\n");
            source.append("\t\tfor (int i = 0; i < component_array.n_elem(); i++) {\n");
            source.append("\t\t\tfinal TitanAlt_Status ret_val = done((TitanComponent)component_array.get_at(i), value_template, value_redirect, index_redirect);\n");
            source.append("\t\t\tif (ret_val == TitanAlt_Status.ALT_YES) {\n");
            source.append("\t\t\t\tif (index_redirect != null) {\n");
            source.append("\t\t\t\t\tindex_redirect.add_index(i + component_array.get_offset());\n");
            source.append("\t\t\t\t}\n");
            source.append("\t\t\t\tresult = ret_val;\n");
            source.append("\t\t\t\tbreak;\n");
            source.append("\t\t\t} else if (ret_val == TitanAlt_Status.ALT_REPEAT || (ret_val == TitanAlt_Status.ALT_MAYBE && result == TitanAlt_Status.ALT_NO)) {\n");
            source.append("\t\t\t\tresult = ret_val;\n");
            source.append("\t\t\t}\n");
            source.append("\t\t}\n");
            source.append("\t\tif (index_redirect != null) {\n");
            source.append("\t\t\tindex_redirect.decr_pos();\n");
            source.append("\t\t}\n");
            source.append("\t\treturn result;\n");
            source.append("\t}\n");
        }
    }

    @Override
    public int getJsonValueType() {
        IType t = this.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        IType.Type_type tt = t.getTypetype();
        switch (tt) {
            case TYPE_INTEGER: 
            case TYPE_INTEGER_A: {
                return 1;
            }
            case TYPE_REAL: {
                return 3;
            }
            case TYPE_BOOL: {
                return 4;
            }
            case TYPE_NULL: {
                return 32;
            }
            case TYPE_TTCN3_ENUMERATED: 
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: 
            case TYPE_OBJECTID: 
            case TYPE_VERDICT: 
            case TYPE_ASN1_ENUMERATED: 
            case TYPE_BITSTRING_A: 
            case TYPE_UTF8STRING: 
            case TYPE_NUMERICSTRING: 
            case TYPE_PRINTABLESTRING: 
            case TYPE_TELETEXSTRING: 
            case TYPE_VIDEOTEXSTRING: 
            case TYPE_IA5STRING: 
            case TYPE_GRAPHICSTRING: 
            case TYPE_VISIBLESTRING: 
            case TYPE_GENERALSTRING: 
            case TYPE_UNIVERSALSTRING: 
            case TYPE_BMPSTRING: 
            case TYPE_ROID: 
            case TYPE_ANY: {
                return 2;
            }
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_TTCN3_SET: {
                if (t instanceof TTCN3_Set_Seq_Choice_BaseType) {
                    TTCN3_Set_Seq_Choice_BaseType bt = (TTCN3_Set_Seq_Choice_BaseType)t;
                    if (bt.getNofComponents() > 1) {
                        return 8;
                    }
                    return 63;
                }
                ErrorReporter.INTERNAL_ERROR((String)("getJsonValueType(): invalid TTCN3 set or sequence type " + tt.name()));
            }
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_ASN1_SET: {
                if (t instanceof ASN1_Set_Seq_Choice_BaseType) {
                    ASN1_Set_Seq_Choice_BaseType bt = (ASN1_Set_Seq_Choice_BaseType)t;
                    if (bt.getNofComponents() > 1) {
                        return 8;
                    }
                    return 63;
                }
                ErrorReporter.INTERNAL_ERROR((String)("getJsonValueType(): invalid ASN1 set or sequence type " + tt.name()));
            }
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: 
            case TYPE_OPENTYPE: 
            case TYPE_ASN1_CHOICE: {
                return 63;
            }
            case TYPE_SEQUENCE_OF: 
            case TYPE_SET_OF: 
            case TYPE_ARRAY: {
                return 24;
            }
        }
        ErrorReporter.INTERNAL_ERROR((String)("getJsonValueType(): invalid field type " + tt.name()));
        return 0;
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return;
        }
        if (subReferenceIndex >= subreferences.size()) {
            return;
        }
        expression.expression.append("//TODO: ");
        expression.expression.append(this.getClass().getSimpleName());
        expression.expression.append(".generateCodeIspresentBound() is not be implemented yet!\n");
    }

    protected void generateCodeIspresentBound_forStrings(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        ISubReference subReference;
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return;
        }
        if (subReferenceIndex >= subreferences.size()) {
            return;
        }
        if (isTemplate) {
            expression.expression.append("//TODO: template handling in");
            expression.expression.append(this.getClass().getSimpleName());
            expression.expression.append(".generateCodeIspresentBound() is not be implemented yet!\n");
        }
        if (!((subReference = subreferences.get(subReferenceIndex)) instanceof ArraySubReference)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return;
        }
        aData.addBuiltinTypeImport("TitanInteger");
        Value indexValue = ((ArraySubReference)subReference).getValue();
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = indexValue.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
        referenceChain.release();
        String temporalIndexId = aData.getTemporaryVariableName();
        expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
        expression.expression.append(MessageFormat.format("final TitanInteger {0} = ", temporalIndexId));
        last.generateCodeExpressionMandatory(aData, expression, true);
        expression.expression.append(";\n");
        expression.expression.append(MessageFormat.format("{0} = {1}.is_greater_than_or_equal(0) && {1}.is_less_than({2}.lengthof());\n", globalId, temporalIndexId, externalId));
        String temporalId = aData.getTemporaryVariableName();
        boolean isLast = subReferenceIndex == subreferences.size() - 1;
        expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
        if (optype == Expression_Value.Operation_type.ISBOUND_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.constGet_at({2}).is_bound();\n", globalId, externalId, temporalIndexId));
        } else if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.constGet_at({2}).{3}({4});\n", globalId, externalId, temporalIndexId, !isLast ? "is_bound" : "is_present", isLast && isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
        }
        this.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId, isTemplate, optype, field, targetScope);
        expression.expression.append("}\n}\n");
    }

    @Override
    public boolean isPresentAnyvalueEmbeddedField(ExpressionStruct expression, List<ISubReference> subreferences, int beginIndex) {
        return true;
    }

    @Override
    public void setOwnertype(IType.TypeOwner_type ownerType, INamedNode owner) {
        this.ownerType = ownerType;
        this.owner = owner;
    }

    @Override
    public IType.TypeOwner_type getOwnertype() {
        return this.ownerType;
    }

    @Override
    public INamedNode getOwner() {
        return this.owner;
    }

    @Override
    public void set_needs_any_from_done() {
        this.needs_any_from_done = true;
    }

    public static String getConversionFunction(JavaGenData aData, IType from, IType to, boolean forValue, StringBuilder source) {
        String fromName = from.getGenNameValue(aData, source);
        String toName = to.getGenNameValue(aData, source);
        StringBuilder returnValue = new StringBuilder();
        returnValue.append("conv_").append(fromName.replace('.', '_')).append('_').append(toName.replace('.', '_'));
        if (!forValue) {
            returnValue.append("_t");
        }
        return returnValue.toString();
    }

    @Override
    public String generateConversion(JavaGenData aData, IType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        return fromName;
    }

    public void checkAsReturnType(CompilationTimeStamp timestamp, boolean asValue, String what) {
        IType type = this.getTypeRefdLast(timestamp);
        switch (type.getTypetype()) {
            case TYPE_PORT: {
                this.getLocation().reportSemanticError(MessageFormat.format(PORTRETURN, type.getFullName(), what));
                break;
            }
            case TYPE_SIGNATURE: {
                if (!asValue) break;
                this.getLocation().reportSemanticError(MessageFormat.format(SIGNATURERETURN, type.getFullName(), what));
                break;
            }
        }
    }

    public static String typeToSrcType(IType.Type_type type) {
        switch (type) {
            case TYPE_INTEGER: {
                return "integer";
            }
            case TYPE_CHARSTRING: {
                return "charstring";
            }
            case TYPE_BITSTRING: {
                return "bitstring";
            }
            case TYPE_REAL: {
                return "float";
            }
        }
        return "";
    }

    public static String typeToSrcTypeDefault(IType.Type_type type) {
        switch (type) {
            case TYPE_INTEGER: {
                return "0";
            }
            case TYPE_CHARSTRING: {
                return "\"\"";
            }
            case TYPE_BITSTRING: {
                return "\"00B\"";
            }
            case TYPE_REAL: {
                return "0.0";
            }
        }
        return "";
    }

    static {
        final IPreferencesService ps = Platform.getPreferencesService();
        if (ps != null) {
            typeCompatibilitySeverity = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTypeCompatibility", "warning", null);
            noStructuredTypeCompatibility = "error".equals(typeCompatibilitySeverity);
            Activator activator = Activator.getDefault();
            if (activator != null) {
                activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        String property = event.getProperty();
                        if ("org.eclipse.titan.designer.reportTypeCompatibility".equals(property)) {
                            typeCompatibilitySeverity = ps.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportTypeCompatibility", "warning", null);
                            noStructuredTypeCompatibility = "error".equals(typeCompatibilitySeverity);
                        }
                    }
                });
            }
        }
    }

    public static enum CompatibilityLevel {
        INCOMPATIBLE_TYPE,
        INCOMPATIBLE_SUBTYPE,
        COMPATIBLE;

    }
}

