/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.brokenpartsanalyzers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.IAssignmentChecker;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class AssignmentHandler
extends ASTVisitor
implements IAssignmentChecker {
    protected Assignment assignment;
    private boolean isInfected;
    private boolean isContagious;
    private final List<String> reasons;
    private final Set<String> nonContagiousReferences;
    private final Set<String> contagiousReferences;
    private final Set<String> infectedReferences;

    protected AssignmentHandler(Assignment assignment) {
        this.assignment = assignment;
        this.reasons = new ArrayList<String>();
        this.nonContagiousReferences = new HashSet<String>();
        this.contagiousReferences = new HashSet<String>();
        this.infectedReferences = new HashSet<String>();
        this.isInfected = assignment.isCheckRoot();
        this.isContagious = false;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    public boolean getIsInfected() {
        return this.isInfected;
    }

    public void setIsInfected(boolean isBroken) {
        this.isInfected = isBroken;
    }

    public boolean getIsContagious() {
        return this.isContagious;
    }

    public void setIsContagious(boolean isAbleToSpread) {
        this.isContagious = isAbleToSpread;
    }

    public void initStartParts() {
        this.setIsInfected(true);
        this.setIsContagious(true);
    }

    public void addReason(String reason) {
        this.reasons.add(reason);
    }

    public List<String> getReasons() {
        return this.reasons;
    }

    public Set<String> getNonContagiousReferences() {
        return this.nonContagiousReferences;
    }

    public boolean doNonContagiousReferencesContains(String name) {
        return this.nonContagiousReferences.contains(name);
    }

    public void addNonContagiousReferences(Collection<? extends String> references) {
        this.nonContagiousReferences.addAll(references);
    }

    public void addNonContagiousReference(String reference) {
        this.nonContagiousReferences.add(reference);
    }

    public Set<String> getContagiousReferences() {
        return this.contagiousReferences;
    }

    public boolean isContagiousReferencesContains(String name) {
        return this.contagiousReferences.contains(name);
    }

    public void addContagiousReferences(Collection<? extends String> references) {
        this.contagiousReferences.addAll(references);
    }

    public void addContagiousReference(String reference) {
        this.contagiousReferences.add(reference);
    }

    public void removeFromContagiousReferences(String reference) {
        this.contagiousReferences.remove(reference);
    }

    public Set<String> getInfectedReferences() {
        return this.infectedReferences;
    }

    public void addInfectedReferences(Collection<? extends String> references) {
        this.infectedReferences.addAll(references);
    }

    public void addInfectedReference(String reference) {
        this.infectedReferences.add(reference);
    }

    public String toString() {
        return this.assignment.getIdentifier().getDisplayName();
    }

    public boolean isVisibleIn(Module dependentModule) {
        return this.assignment.getMyScope().getModuleScope().isVisible(CompilationTimeStamp.getBaseTimestamp(), dependentModule.getIdentifier(), this.assignment);
    }

    @Override
    public void check(AssignmentHandler definitionHandler) {
        this.checkIsInfected(definitionHandler);
        this.checkIsContagious(definitionHandler);
    }

    public void checkIsInfected(AssignmentHandler other) {
        String otherName = other.getAssignment().getIdentifier().getDisplayName();
        if (other.getIsInfected() && (this.doNonContagiousReferencesContains(otherName) || this.isContagiousReferencesContains(otherName))) {
            this.addInfectedReference(otherName);
            this.setIsInfected(true);
            this.addReason("It uses " + otherName + "@" + other.getAssignment().getMyScope().getModuleScope().getIdentifier().getDisplayName() + " which is infected.");
        }
    }

    public void checkIsContagious(AssignmentHandler other) {
        String otherName = other.getAssignment().getIdentifier().getDisplayName();
        if (other.getIsInfected() && this.isContagiousReferencesContains(otherName)) {
            this.addInfectedReference(otherName);
            this.setIsContagious(true);
            this.addReason("It uses contagious reference " + otherName + "@" + other.getAssignment().getMyScope().getModuleScope().getIdentifier().getDisplayName() + " which is infected.");
        }
    }
}

