/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions;

import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.GlobalProjectStructureTracker;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.FileBuildPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressConstants;

public class EnableCodeSplittingOnFile
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        this.doEnableCodeSplittingOnFile(this.selection);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.doEnableCodeSplittingOnFile(this.selection);
        return null;
    }

    private void doEnableCodeSplittingOnFile(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)selection;
        if (structSelection.isEmpty()) {
            return;
        }
        PropertyChangerWorkspaceJob op = new PropertyChangerWorkspaceJob(structSelection);
        op.setPriority(20);
        op.setSystem(false);
        op.setUser(true);
        op.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        op.setProperty(IProgressConstants.ICON_PROPERTY, ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
    }

    private class PropertyChangerWorkspaceJob
    extends WorkspaceJob {
        private final IStructuredSelection structSelection;

        public PropertyChangerWorkspaceJob(IStructuredSelection structSelection) {
            super("Changing the code splitting enabled flag");
            this.structSelection = structSelection;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            final HashSet<IProject> projectsToRefresh = new HashSet<IProject>();
            for (Object selected : this.structSelection.toList()) {
                IFile file;
                if (!(selected instanceof IFile)) continue;
                boolean mode = FileBuildPropertyData.getPropertyValue(file = (IFile)selected, "enableCodeSplitting");
                FileBuildPropertyData.setPropertyValue(file, "enableCodeSplitting", !mode);
                projectsToRefresh.add(file.getProject());
            }
            WorkspaceJob op = new WorkspaceJob("Updating project descriptor files"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    for (IProject project : projectsToRefresh) {
                        ProjectFileHandler projectFileHandler = new ProjectFileHandler(project);
                        projectFileHandler.saveProjectSettings();
                        GlobalProjectStructureTracker.projectChanged(project);
                        PropertyNotificationManager.firePropertyChange((IResource)project);
                    }
                    return Status.OK_STATUS;
                }
            };
            op.setPriority(20);
            op.setSystem(true);
            op.setUser(false);
            op.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
            op.schedule();
            return Status.OK_STATUS;
        }
    }
}

