/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions.runconfiggenerator;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.FileUtils;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.designer.actions.runconfiggenerator.FileNameDialog;
import org.eclipse.titan.designer.actions.runconfiggenerator.GenerateRunConfigBase;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.core.TITANJavaBuilder;

public class GenerateRunConfigSingle
extends GenerateRunConfigBase {
    @Override
    protected void generateRunConfig(IFile file) throws CoreException {
        if (TITANBuilder.isBuilderEnabled(file.getProject())) {
            this.generateRunConfigSingleTitan(file);
        } else if (TITANJavaBuilder.isBuilderEnabled(file.getProject())) {
            this.generateRunConfigSingleTitanJava(file);
        }
    }

    private void generateRunConfigSingleTitan(IFile file) throws CoreException {
        ErrorReporter.parallelErrorDisplayInMessageDialog((String)("Error while generating the default launch configuration for project " + file.getProject().getName()), (String)"This feature is only available for Titan Java projects!");
    }

    private void generateRunConfigSingleTitanJava(IFile file) throws CoreException {
        if (!this.validateFile(file)) {
            return;
        }
        String projectName = file.getProject().getName();
        String projectLocation = file.getProject().getLocation().toOSString();
        String filenamePrefix = projectName;
        boolean overwrite = false;
        FileNameDialog dialog = new FileNameDialog(new Shell());
        dialog.setDefaultFileName(filenamePrefix);
        dialog.setMode(false);
        dialog.create();
        if (dialog.open() != 0) {
            return;
        }
        filenamePrefix = dialog.getFirstName();
        overwrite = dialog.getOverwrite();
        FileUtils.createDir((IFolder)file.getProject().getFolder("launch"));
        URI filename = URIUtil.toURI((String)(projectLocation + File.separator + "launch" + File.separator + filenamePrefix + "-Single.launch"));
        URI configFileNameUri = URIUtil.toURI((IPath)file.getProject().getLocation()).relativize(URIUtil.toURI((IPath)file.getLocation()));
        String content = MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<launchConfiguration type=\"org.eclipse.jdt.launching.localJavaApplication\">\n    <listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_PATHS\">\n        <listEntry value=\"/{0}/java_src/org/eclipse/titan/{0}/generated/Single_main.java\"/>\n    </listAttribute>\n    <listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_TYPES\">\n        <listEntry value=\"1\"/>\n    </listAttribute>\n    <listAttribute key=\"org.eclipse.debug.ui.favoriteGroups\">\n        <listEntry value=\"org.eclipse.debug.ui.launchGroup.run\"/>\n    </listAttribute>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_ATTR_USE_ARGFILE\" value=\"false\"/>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_SHOW_CODEDETAILS_IN_EXCEPTION_MESSAGES\" value=\"true\"/>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_USE_CLASSPATH_ONLY_JAR\" value=\"false\"/>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_USE_START_ON_FIRST_THREAD\" value=\"true\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.MAIN_TYPE\" value=\"org.eclipse.titan.{0}.generated.Single_main\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.MODULE_NAME\" value=\"{0}\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.PROGRAM_ARGUMENTS\" value=\"{1}\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.PROJECT_ATTR\" value=\"{0}\"/>\n</launchConfiguration>\r\n", projectName, configFileNameUri.getPath());
        try {
            File runConfigFile = new File(filename);
            if (overwrite) {
                FileUtils.deleteQuietly((File)runConfigFile);
            }
            if (runConfigFile.createNewFile()) {
                IOUtils.writeStringToFile((File)runConfigFile, (String)content);
                TITANConsole.println("Run configuration generated: " + runConfigFile.getAbsolutePath());
                file.getProject().refreshLocal(2, null);
            } else {
                TITANConsole.println("File generation error. Existing file was not overwritten.");
            }
        }
        catch (IOException e) {
            TITANConsole.println("An error occurred.");
        }
    }
}

