/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core.ant;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.CommentUtils;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.designer.GeneralConstants;

public final class CliScriptGenerator {
    public static final String SCRIPT_NAME = "titan_java_start";
    public static final String CMD_SCRIPT_NAME = "titan_java_start.cmd";
    public static final String SHELL_SCRIPT_NAME = "titan_java_start.sh";
    private static final String SHELL_SCRIPT_HEADER = "#!/usr/bin/env sh\n";
    private static final String SHELL_SCRIPT_TEXT = "function help() {\n\techo \"usage: titan_java_start.sh executable.jar config.cfg [-m|--mode execution_mode] [-p|--project project_name]  [-vmargs \"arguments_for_jvm\"]\"\n\techo \"  -m|--mode [hc|host_controller|mc|main_controller|p|parallel|s|single]\"\n}\n\nfunction proc_mode() {\n\tcase $mode in\n\t\thc) start_hc;;\n\t\thost_controller) start_hc;;\n\t\tmc) start_mc;;\n\t\tmain_controller) start_mc;;\n\t\tp) start_parallel;;\n\t\tparallel) start_parallel;;\n\t\ts) start_single;;\n\t\tsingle) start_single;;\n\t\t?) echo \"Unknown execution mode: $mode\"; exit 1;;\n\tesac\n}\n\nfunction start_hc() {\n\tlocaladdress=$(awk '/LocalAddress/{print $3}' ${cfg_file} | sed 's/\\r$//')\n\tif [ -z \"${localaddress}\" ]; then\n\t\techo \"LocalAddress parameter is missing from ${cfg_file}. Using default: 127.0.0.1\";\n\t\tlocaladdress=\"127.0.0.1\"\n\tfi\n\ttcpport=$(awk '/TCPPort/{print $3}' ${cfg_file} | sed 's/\\r$//')\n\tif [ -z \"${tcpport}\" ]; then\n\t\techo \"TCPPort parameter is missing from ${cfg_file}\"; echo \"Unable to continue.\"\n\t\thelp\n\t\texit 1\n\tfi\n\techo \"Starting the Host Controller...\"\n\techo \"Connecting to ${localaddress}:${tcpport}...\"\n\tjava ${vmargs} -cp ${exe_file} org.eclipse.titan.${project}.generated.Parallel_main ${localaddress} ${tcpport}\n}\n\nfunction start_mc() {\n\techo \"Starting the Main Controller...\"\n\tjava ${vmargs} -cp ${exe_file} org.eclipse.titan.runtime.core.mctr.CliMain ${cfg_file}\n}\n\nfunction start_parallel() {\n\techo \"Starting automatic execution in Parallel mode...\"\n\tif [ ! -e \"$(which ttcn3_start)\" ]; then\n\t\techo \"ttcn3_start script is not found. Automatic execution in Parallel mode is not available.\"\n\t\texit 1\n\tfi\n\tttcn3_start ${exe_file} ${cfg_file}\n}\n\nfunction start_single() {\n\techo \"Starting execution in Single mode...\"\n\tjava ${vmargs} -cp ${exe_file} org.eclipse.titan.${project}.generated.Single_main ${cfg_file}\n}\n\nif [ ! -e \"$(which java)\" ]; then\n\techo \"java is not found.\"\n\texit 1\nfi\n\nexe_file=\"\"\nproject=\"\"\nmode=\"parallel\"\nvmargs=\"-Dfile.encoding=UTF-8\"\nwhile [ -n \"$1\" ]; do\n\tcase \"$1\" in\n\t\t-h) help; exit 0;;\n\t\t--help) help; exit 0;;\n\t\t-m) \n\t\t\tif [ -n \"$2\" ]; then\n\t\t\t\tmode=$2; shift\n\t\t\telse\n\t\t\t\techo \"Execution mode option is empty. Using default: ${mode}\"\n\t\t\tfi;;\n\t\t--mode) \n\t\t\tif [ -n \"$2\" ]; then\n\t\t\t\tmode=$2; shift\n\t\t\telse\n\t\t\t\techo \"Execution mode option is empty. Using default: ${mode}\"\n\t\t\tfi;;\n\t\t-p) \n\t\t\tif [ -n \"$2\" ]; then\n\t\t\t\tproject=$2; shift\n\t\t\telse\n\t\t\t\techo \"Project name option is empty. Using default: ${project}\"\n\t\t\tfi;;\n\t\t--project)\n\t\t\tif [ -n \"$2\" ]; then\n\t\t\t\tproject=$2; shift\n\t\t\telse\n\t\t\t\techo \"Project name option is empty. Using default: ${project}\"\n\t\t\tfi;;\n\t\t-vmargs)\n\t\t\tif [ -n \"$2\" ]; then\n\t\t\t\tvmargs=$2; shift\n\t\t\telse\n\t\t\t\techo \"VM arguments option is empty. Using default: \\\"${vmargs}\\\"\"\n\t\t\tfi;;\n\t\t*) \n\t\t\tif [[ $1 =~ .*.(jar|zip) ]]; then\n\t\t\t\texe_file=$1 \n\t\t\telif [[ $1 =~ .*.(cfg) ]]; then \n\t\t\t\tcfg_file=$1\n\t\t\tfi\n\tesac\n\tshift\ndone\n\nif [ ! -e \"${exe_file}\" ]; then\n\techo \"The provided executable JAR file is not exist: ${exe_file}\"\n\texit 1\nfi\nif [ ! -e \"${cfg_file}\" ]; then\n\techo \"The provided configuration file is not exist: ${cfg_file}\"\n\texit 1\nfi\n\nproc_mode\n";

    public static String createCmdScriptContent(IProject project) {
        if (project == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(CommentUtils.getHeaderCommentsWithCopyright((String)":: ", (String)GeneralConstants.VERSION_STRING));
        return builder.toString();
    }

    public static String createShellScriptContent(IProject project) throws CoreException {
        if (project == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(SHELL_SCRIPT_HEADER).append(CommentUtils.getHeaderCommentsWithCopyrightAndLicenseAndDoNotEdit((String)"# ", (String)GeneralConstants.VERSION_STRING)).append(SHELL_SCRIPT_TEXT.replace("exe_file=\"\"\n", "exe_file=\"" + CliScriptGenerator.getJarFileName(project) + "\"\n").replace("project=\"\"\n", "project=\"" + project.getName() + "\"\n"));
        return builder.toString();
    }

    public static boolean existCmdScript(IProject project) throws CoreException {
        if (project == null) {
            return false;
        }
        String jarFolder = CliScriptGenerator.getJarFolder(project);
        if (StringUtils.isNullOrEmpty((String)jarFolder)) {
            return false;
        }
        File scriptFile = new File(jarFolder + File.separator + CMD_SCRIPT_NAME);
        return scriptFile.exists();
    }

    public static boolean existShellScript(IProject project) throws CoreException {
        if (project == null) {
            return false;
        }
        String jarFolder = CliScriptGenerator.getJarFolder(project);
        if (StringUtils.isNullOrEmpty((String)jarFolder)) {
            return false;
        }
        File scriptFile = new File(jarFolder + File.separator + SHELL_SCRIPT_NAME);
        return scriptFile.exists();
    }

    public static void generateAndStoreScripts(IProject project) {
        if (project == null) {
            return;
        }
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateStartShScript"));
            boolean shellScriptNeeded = "true".equals(temp);
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateStartBatScript"));
            boolean cmdScriptNeeded = "true".equals(temp);
            String shellScriptContent = null;
            String cmdScriptContent = null;
            if (shellScriptNeeded && !CliScriptGenerator.existShellScript(project)) {
                shellScriptContent = CliScriptGenerator.createShellScriptContent(project);
            }
            if (cmdScriptNeeded && !CliScriptGenerator.existCmdScript(project)) {
                cmdScriptContent = CliScriptGenerator.createCmdScriptContent(project);
            }
            CliScriptGenerator.storeScripts(project, shellScriptContent, cmdScriptContent);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    private static File getJarFile(IProject project) throws CoreException {
        String jarPathString = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
        if (StringUtils.isNullOrEmpty((String)jarPathString)) {
            ErrorReporter.INTERNAL_ERROR((String)"Jar file is null or empty");
            return null;
        }
        File jarFile = new File(jarPathString);
        if (!jarFile.isAbsolute()) {
            jarFile = new File(project.getLocation().toOSString() + File.separator + jarPathString);
        }
        return jarFile;
    }

    private static String getJarFileName(IProject project) throws CoreException {
        return CliScriptGenerator.getJarFile(project).getName();
    }

    private static String getJarFolder(IProject project) throws CoreException {
        return CliScriptGenerator.getJarFile(project).getParent();
    }

    public static void storeScripts(IProject project, String shellScriptContent, String cmdScriptContent) throws CoreException, IOException {
        if (project == null || shellScriptContent == null && cmdScriptContent == null) {
            return;
        }
        String jarFolderString = CliScriptGenerator.getJarFolder(project);
        File jarFolder = new File(jarFolderString);
        if (!jarFolder.exists() && !jarFolder.mkdirs()) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Folder creation error", (String)("Target folder for JAR export was not created: " + jarFolderString));
        }
        if (shellScriptContent != null) {
            File shellScriptFile = new File(jarFolderString + File.separator + SHELL_SCRIPT_NAME);
            IOUtils.writeStringToFile((File)shellScriptFile, (String)shellScriptContent);
            try {
                if (!shellScriptFile.setExecutable(true, false) && !shellScriptFile.setExecutable(true, true)) {
                    throw new SecurityException();
                }
            }
            catch (SecurityException e) {
                ErrorReporter.logWarning((String)"Setting execution permission for 'titan_java_start.sh' failed.");
            }
            project.refreshLocal(2, null);
        }
        if (cmdScriptContent != null) {
            File cmdScriptFile = new File(jarFolderString + File.separator + CMD_SCRIPT_NAME);
            IOUtils.writeStringToFile((File)cmdScriptFile, (String)cmdScriptContent);
            project.refreshLocal(2, null);
        }
    }
}

